/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.servlet;

import java.io.IOException;
import java.util.Locale;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletContext;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.ModuleDescriptorProvider;
import org.apache.hivemind.Registry;
import org.apache.hivemind.impl.DefaultClassResolver;
import org.apache.hivemind.impl.RegistryBuilder;
import org.apache.hivemind.impl.XmlModuleDescriptorProvider;
import org.apache.hivemind.servlet.ServletMessages;
import org.apache.hivemind.util.ContextResource;

public class HiveMindFilter
implements Filter {
    private static final Log LOG = LogFactory.getLog((Class)(class$org$apache$hivemind$servlet$HiveMindFilter == null ? (class$org$apache$hivemind$servlet$HiveMindFilter = HiveMindFilter.class$("org.apache.hivemind.servlet.HiveMindFilter")) : class$org$apache$hivemind$servlet$HiveMindFilter));
    static final String REQUEST_KEY = "org.apache.hivemind.RequestRegistry";
    static final String REBUILD_REQUEST_KEY = "org.apache.hivemind.RebuildRegistry";
    static final String HIVE_MODULE_XML = "/WEB-INF/hivemodule.xml";
    private FilterConfig _filterConfig;
    private Registry _registry;
    static /* synthetic */ Class class$org$apache$hivemind$servlet$HiveMindFilter;

    public void init(FilterConfig config) throws ServletException {
        this._filterConfig = config;
        this.initializeRegistry();
    }

    private void initializeRegistry() {
        long startTime = System.currentTimeMillis();
        LOG.info((Object)ServletMessages.filterInit());
        try {
            this._registry = this.constructRegistry(this._filterConfig);
            LOG.info((Object)ServletMessages.constructedRegistry(this._registry, System.currentTimeMillis() - startTime));
        }
        catch (Exception ex) {
            LOG.error((Object)ex.getMessage(), (Throwable)ex);
        }
    }

    protected Registry constructRegistry(FilterConfig config) {
        RegistryBuilder builder = new RegistryBuilder();
        DefaultClassResolver resolver = new DefaultClassResolver();
        builder.addModuleDescriptorProvider(this.getModuleDescriptorProvider(resolver));
        this.addWebInfDescriptor(config.getServletContext(), resolver, builder);
        return builder.constructRegistry(this.getRegistryLocale());
    }

    protected void addWebInfDescriptor(ServletContext context, ClassResolver resolver, RegistryBuilder builder) {
        ContextResource r = new ContextResource(context, HIVE_MODULE_XML);
        if (r.getResourceURL() != null) {
            XmlModuleDescriptorProvider provider = new XmlModuleDescriptorProvider(resolver, r);
            builder.addModuleDescriptorProvider(provider);
        }
    }

    protected Locale getRegistryLocale() {
        return Locale.getDefault();
    }

    protected ModuleDescriptorProvider getModuleDescriptorProvider(ClassResolver resolver) {
        return new XmlModuleDescriptorProvider(resolver);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        try {
            if (this._registry != null) {
                this._registry.setupThread();
            }
            request.setAttribute(REQUEST_KEY, (Object)this._registry);
            chain.doFilter(request, response);
        }
        finally {
            this.cleanupThread();
            this.checkRegistryRebuild(request);
        }
    }

    private synchronized void checkRegistryRebuild(ServletRequest request) {
        if (request.getAttribute(REBUILD_REQUEST_KEY) == null) {
            return;
        }
        Registry oldRegistry = this._registry;
        this.initializeRegistry();
        oldRegistry.shutdown();
    }

    private void cleanupThread() {
        try {
            this._registry.cleanupThread();
        }
        catch (Exception ex) {
            LOG.error((Object)ServletMessages.filterCleanupError(ex), (Throwable)ex);
        }
    }

    public void destroy() {
        if (this._registry != null) {
            this._registry.shutdown();
        }
        this._filterConfig = null;
    }

    public static Registry getRegistry(HttpServletRequest request) {
        return (Registry)request.getAttribute(REQUEST_KEY);
    }

    public static void rebuildRegistry(HttpServletRequest request) {
        request.setAttribute(REBUILD_REQUEST_KEY, (Object)Boolean.TRUE);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

