/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.util;

import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ApplicationRuntimeException;
import org.apache.hivemind.util.UtilMessages;

public class ConstructorUtils {
    private static final Map _primitiveMap = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    private ConstructorUtils() {
    }

    public static Object invokeConstructor(Class targetClass, Object[] parameters) {
        if (parameters == null) {
            parameters = new Object[]{};
        }
        Class[] parameterTypes = new Class[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            parameterTypes[i] = parameters[i] == null ? null : parameters[i].getClass();
        }
        return ConstructorUtils.invokeMatchingConstructor(targetClass, parameterTypes, parameters);
    }

    private static Object invokeMatchingConstructor(Class targetClass, Class[] parameterTypes, Object[] parameters) {
        Constructor<?>[] constructors = targetClass.getConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Constructor<?> c = constructors[i];
            if (!ConstructorUtils.isMatch(c, parameterTypes)) continue;
            return ConstructorUtils.invoke(c, parameters);
        }
        throw new ApplicationRuntimeException(UtilMessages.noMatchingConstructor(targetClass), null);
    }

    private static boolean isMatch(Constructor c, Class[] types) {
        Class<?>[] actualTypes = c.getParameterTypes();
        if (actualTypes.length != types.length) {
            return false;
        }
        for (int i = 0; i < types.length; ++i) {
            if (types[i] == null && !actualTypes[i].isPrimitive() || ConstructorUtils.isCompatible(actualTypes[i], types[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean isCompatible(Class actualType, Class parameterType) {
        if (actualType.isAssignableFrom(parameterType)) {
            return true;
        }
        if (actualType.isPrimitive()) {
            Class wrapperClass = (Class)_primitiveMap.get(actualType);
            return wrapperClass.isAssignableFrom(parameterType);
        }
        return false;
    }

    public static Object invoke(Constructor c, Object[] parameters) {
        try {
            return c.newInstance(parameters);
        }
        catch (InvocationTargetException ex) {
            Throwable cause = ex.getTargetException();
            throw new ApplicationRuntimeException(UtilMessages.invokeFailed(c, cause), null, cause);
        }
        catch (Exception ex) {
            throw new ApplicationRuntimeException(UtilMessages.invokeFailed(c, ex), null, ex);
        }
    }

    public static List getConstructorsOfLength(Class clazz, int length) {
        ArrayList fixedLengthConstructors = new ArrayList(1);
        Constructor<?>[] constructors = clazz.getDeclaredConstructors();
        for (int i = 0; i < constructors.length; ++i) {
            Class<?>[] parameterTypes;
            if (!Modifier.isPublic(constructors[i].getModifiers()) || (parameterTypes = constructors[i].getParameterTypes()).length != length) continue;
            fixedLengthConstructors.add(constructors[i]);
        }
        return fixedLengthConstructors;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static {
        _primitiveMap.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ConstructorUtils.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        _primitiveMap.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ConstructorUtils.class$("java.lang.Byte")) : class$java$lang$Byte);
        _primitiveMap.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ConstructorUtils.class$("java.lang.Character")) : class$java$lang$Character);
        _primitiveMap.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ConstructorUtils.class$("java.lang.Short")) : class$java$lang$Short);
        _primitiveMap.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ConstructorUtils.class$("java.lang.Integer")) : class$java$lang$Integer);
        _primitiveMap.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ConstructorUtils.class$("java.lang.Long")) : class$java$lang$Long);
        _primitiveMap.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ConstructorUtils.class$("java.lang.Float")) : class$java$lang$Float);
        _primitiveMap.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ConstructorUtils.class$("java.lang.Double")) : class$java$lang$Double);
    }
}

