/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.util;

import java.util.ArrayList;

public class StringUtils {
    public static String[] split(String input) {
        if (input == null) {
            return new String[0];
        }
        ArrayList<String> strings = new ArrayList<String>();
        int startx = 0;
        int length = input.length();
        for (int cursor = 0; cursor < length; ++cursor) {
            if (input.charAt(cursor) != ',') continue;
            String item = input.substring(startx, cursor);
            strings.add(item);
            startx = cursor + 1;
        }
        if (startx < length) {
            strings.add(input.substring(startx));
        }
        return strings.toArray(new String[strings.size()]);
    }

    public static String capitalize(String input) {
        if (input.length() == 0) {
            return input;
        }
        char ch = input.charAt(0);
        if (Character.isUpperCase(ch)) {
            return input;
        }
        return String.valueOf(Character.toUpperCase(ch)) + input.substring(1);
    }

    public static String join(String[] input, char separator) {
        if (input == null || input.length == 0) {
            return null;
        }
        StringBuffer buffer = new StringBuffer();
        for (int i = 0; i < input.length; ++i) {
            if (i > 0) {
                buffer.append(separator);
            }
            buffer.append(input[i]);
        }
        return buffer.toString();
    }

    public static String replace(String string, String pattern, String replacement) {
        StringBuffer sbuf = new StringBuffer();
        int index = string.indexOf(pattern);
        int pos = 0;
        int patternLength = pattern.length();
        while (index >= 0) {
            sbuf.append(string.substring(pos, index));
            sbuf.append(replacement);
            pos = index + patternLength;
            index = string.indexOf(pattern, pos);
        }
        sbuf.append(string.substring(pos));
        return sbuf.toString();
    }
}

