/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.db;

import com.sleepycat.db.CursorConfig;
import com.sleepycat.db.Database;
import com.sleepycat.db.DatabaseEntry;
import com.sleepycat.db.DatabaseException;
import com.sleepycat.db.LockMode;
import com.sleepycat.db.OperationStatus;
import com.sleepycat.db.internal.Dbc;

public class Cursor {
    Dbc dbc;
    protected Database database;
    protected CursorConfig config;

    protected Cursor() {
    }

    Cursor(Database database, Dbc dbc, CursorConfig cursorConfig) throws DatabaseException {
        this.dbc = dbc;
        this.database = database;
        this.config = cursorConfig;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close() throws DatabaseException {
        if (this.dbc != null) {
            try {
                this.dbc.close();
            }
            finally {
                this.dbc = null;
            }
        }
    }

    public Cursor dup(boolean bl) throws DatabaseException {
        return new Cursor(this.database, this.dbc.dup(bl ? 24 : 0), this.config);
    }

    public CursorConfig getConfig() {
        return this.config;
    }

    public Database getDatabase() {
        return this.database;
    }

    public int count() throws DatabaseException {
        return this.dbc.count(0);
    }

    public OperationStatus delete() throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.del(0));
    }

    public OperationStatus getCurrent(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 7 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getFirst(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 9 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getLast(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x11 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getNext(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x12 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getNextDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x13 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getNextNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x14 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getPrev(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x19 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus getPrevDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        Object object = this.dbc.dup(24);
        try {
            Object object2;
            int n = ((Dbc)object).get(DatabaseEntry.IGNORE, DatabaseEntry.IGNORE, 0x19 | LockMode.getFlag(lockMode));
            if (n == 0) {
                object2 = ((Dbc)object).dup(24);
                try {
                    n = ((Dbc)object2).get(DatabaseEntry.IGNORE, DatabaseEntry.IGNORE, 0x13 | LockMode.getFlag(lockMode));
                }
                finally {
                    ((Dbc)object2).close();
                }
            }
            if (n == 0) {
                n = ((Dbc)object).get(databaseEntry, databaseEntry2, 7 | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag()));
            }
            if (n == 0) {
                object2 = this.dbc;
                this.dbc = object;
                object = object2;
            }
            object2 = OperationStatus.fromInt(n);
            return object2;
        }
        finally {
            ((Dbc)object).close();
        }
    }

    public OperationStatus getPrevNoDup(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x1A | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getRecordNumber(DatabaseEntry databaseEntry, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(DatabaseEntry.IGNORE, databaseEntry, 0xD | LockMode.getFlag(lockMode) | (databaseEntry == null ? 0 : databaseEntry.getMultiFlag())));
    }

    public OperationStatus getSearchKey(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x1C | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getSearchKeyRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x1E | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getSearchBoth(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0xA | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getSearchBothRange(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0xC | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus getSearchRecordNumber(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2, LockMode lockMode) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.get(databaseEntry, databaseEntry2, 0x1F | LockMode.getFlag(lockMode) | (databaseEntry2 == null ? 0 : databaseEntry2.getMultiFlag())));
    }

    public OperationStatus put(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(databaseEntry, databaseEntry2, 16));
    }

    public OperationStatus putAfter(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(databaseEntry, databaseEntry2, 1));
    }

    public OperationStatus putBefore(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(databaseEntry, databaseEntry2, 3));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OperationStatus putNoOverwrite(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        Dbc dbc = this.dbc.dup(0);
        try {
            int n = dbc.get(databaseEntry, DatabaseEntry.IGNORE, 0x1C | this.database.rmwFlag);
            if (n == 0) {
                OperationStatus operationStatus = OperationStatus.KEYEXIST;
                return operationStatus;
            }
            if (n != -30989 && n != -30997) {
                OperationStatus operationStatus = OperationStatus.fromInt(n);
                return operationStatus;
            }
            Dbc dbc2 = this.dbc;
            this.dbc = dbc;
            dbc = dbc2;
            OperationStatus operationStatus = OperationStatus.fromInt(this.dbc.put(databaseEntry, databaseEntry2, 16));
            return operationStatus;
        }
        finally {
            dbc.close();
        }
    }

    public OperationStatus putKeyFirst(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(databaseEntry, databaseEntry2, 15));
    }

    public OperationStatus putKeyLast(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(databaseEntry, databaseEntry2, 16));
    }

    public OperationStatus putNoDupData(DatabaseEntry databaseEntry, DatabaseEntry databaseEntry2) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(databaseEntry, databaseEntry2, 21));
    }

    public OperationStatus putCurrent(DatabaseEntry databaseEntry) throws DatabaseException {
        return OperationStatus.fromInt(this.dbc.put(DatabaseEntry.UNUSED, databaseEntry, 7));
    }
}

