/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.tree;

import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LogWritable;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.tree.Key;
import java.nio.ByteBuffer;

public class INDeleteInfo
implements LoggableObject,
LogReadable,
LogWritable {
    private long deletedNodeId;
    private byte[] deletedIdKey;
    private DatabaseId dbId;

    public INDeleteInfo(long deletedNodeId, byte[] deletedIdKey, DatabaseId dbId) {
        this.deletedNodeId = deletedNodeId;
        this.deletedIdKey = deletedIdKey;
        this.dbId = dbId;
    }

    public INDeleteInfo() {
        this.dbId = new DatabaseId();
    }

    public long getDeletedNodeId() {
        return this.deletedNodeId;
    }

    public byte[] getDeletedIdKey() {
        return this.deletedIdKey;
    }

    public DatabaseId getDatabaseId() {
        return this.dbId;
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_IN_DELETE_INFO;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public boolean countAsObsoleteWhenLogged() {
        return false;
    }

    public void postLogWork(long justLoggedLsn) {
    }

    public int getLogSize() {
        return 8 + LogUtils.getByteArrayLogSize(this.deletedIdKey) + this.dbId.getLogSize();
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeLong(logBuffer, this.deletedNodeId);
        LogUtils.writeByteArray(logBuffer, this.deletedIdKey);
        this.dbId.writeToLog(logBuffer);
    }

    public void readFromLog(ByteBuffer itemBuffer, byte entryTypeVersion) throws LogException {
        this.deletedNodeId = LogUtils.readLong(itemBuffer);
        this.deletedIdKey = LogUtils.readByteArray(itemBuffer);
        this.dbId.readFromLog(itemBuffer, entryTypeVersion);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<INDeleteEntry node=\"").append(this.deletedNodeId);
        sb.append("\">");
        sb.append(Key.dumpString(this.deletedIdKey, 0));
        this.dbId.dumpLog(sb, verbose);
        sb.append("</INDeleteEntry>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }
}

