/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hivemind.lib.chain;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.hivemind.ClassResolver;
import org.apache.hivemind.lib.chain.ChainBuilder;
import org.apache.hivemind.service.BodyBuilder;
import org.apache.hivemind.service.ClassFab;
import org.apache.hivemind.service.ClassFabUtils;
import org.apache.hivemind.service.ClassFactory;
import org.apache.hivemind.service.MethodIterator;
import org.apache.hivemind.service.MethodSignature;
import org.apache.hivemind.util.ConstructorUtils;
import org.apache.hivemind.util.Defense;

public class ChainBuilderImpl
implements ChainBuilder {
    private ClassResolver _classResolver;
    private ClassFactory _classFactory;
    private Map _implementations = new HashMap();
    static /* synthetic */ Class class$java$lang$Object;
    static /* synthetic */ Class class$java$lang$String;
    static /* synthetic */ Class class$java$util$List;

    public Object buildImplementation(Class commandInterface, List commands, String toString) {
        Defense.notNull((Object)commandInterface, (String)"commandInterface");
        Defense.notNull((Object)commands, (String)"commands");
        Defense.notNull((Object)toString, (String)"toString");
        Class instanceClass = this.findImplementationClass(commandInterface);
        return this.createInstance(instanceClass, commands, toString);
    }

    private synchronized Class findImplementationClass(Class commandInterface) {
        Class result = (Class)this._implementations.get(commandInterface);
        if (result == null) {
            result = this.constructImplementationClass(commandInterface);
            this._implementations.put(commandInterface, result);
        }
        return result;
    }

    private Class constructImplementationClass(Class commandInterface) {
        String name = ClassFabUtils.generateClassName((Class)commandInterface);
        ClassFab cf = this._classFactory.newClass(name, class$java$lang$Object == null ? (class$java$lang$Object = ChainBuilderImpl.class$("java.lang.Object")) : class$java$lang$Object);
        this.addInfrastructure(cf, commandInterface);
        this.addMethods(cf, commandInterface);
        return cf.createClass();
    }

    void addInfrastructure(ClassFab cf, Class commandInterface) {
        Class array = this._classResolver.findClass(commandInterface.getName() + "[]");
        cf.addInterface(commandInterface);
        cf.addField("_commands", array);
        cf.addField("_toString", class$java$lang$String == null ? (class$java$lang$String = ChainBuilderImpl.class$("java.lang.String")) : class$java$lang$String);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("_commands = ({0}[]) $1.toArray(new {0}[0]);", (Object)commandInterface.getName());
        builder.addln("_toString = $2;");
        builder.end();
        cf.addConstructor(new Class[]{class$java$util$List == null ? (class$java$util$List = ChainBuilderImpl.class$("java.util.List")) : class$java$util$List, class$java$lang$String == null ? (class$java$lang$String = ChainBuilderImpl.class$("java.lang.String")) : class$java$lang$String}, null, builder.toString());
    }

    private Object createInstance(Class instanceClass, List commands, String toString) {
        return ConstructorUtils.invokeConstructor((Class)instanceClass, (Object[])new Object[]{commands, toString});
    }

    void addMethods(ClassFab cf, Class commandInterface) {
        MethodIterator mi = new MethodIterator(commandInterface);
        while (mi.hasNext()) {
            MethodSignature sig = mi.next();
            this.addMethod(cf, commandInterface, sig);
        }
        if (!mi.getToString()) {
            this.addToString(cf);
        }
    }

    void addMethod(ClassFab cf, Class commandInterface, MethodSignature sig) {
        Class returnType = sig.getReturnType();
        if (returnType.equals(Void.TYPE)) {
            this.addVoidMethod(cf, commandInterface, sig);
            return;
        }
        String defaultValue = this.defaultForReturnType(returnType);
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("{0} result = {1};", (Object)ClassFabUtils.getJavaClassName((Class)returnType), (Object)defaultValue);
        builder.addln("for (int i = 0; i < _commands.length; i++)");
        builder.begin();
        builder.addln("result = _commands[i].{0}($$);", (Object)sig.getName());
        builder.addln("if (result != {0}) break;", (Object)defaultValue);
        builder.end();
        builder.addln("return result;");
        builder.end();
        cf.addMethod(1, sig, builder.toString());
    }

    String defaultForReturnType(Class returnType) {
        if (!returnType.isPrimitive()) {
            return "null";
        }
        if (returnType.equals(Boolean.TYPE)) {
            return "false";
        }
        return "0";
    }

    private void addVoidMethod(ClassFab cf, Class commandInterface, MethodSignature sig) {
        BodyBuilder builder = new BodyBuilder();
        builder.begin();
        builder.addln("for (int i = 0; i < _commands.length; i++)");
        builder.addln("_commands[i].{0}($$);", (Object)sig.getName());
        builder.end();
        cf.addMethod(1, sig, builder.toString());
    }

    void addToString(ClassFab cf) {
        MethodSignature sig = new MethodSignature(class$java$lang$String == null ? (class$java$lang$String = ChainBuilderImpl.class$("java.lang.String")) : class$java$lang$String, "toString", null, null);
        cf.addMethod(1, sig, "return _toString;");
    }

    public void setClassFactory(ClassFactory classFactory) {
        this._classFactory = classFactory;
    }

    public void setClassResolver(ClassResolver classResolver) {
        this._classResolver = classResolver;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

