/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.client;

import com.caucho.hessian.client.HessianProxyFactory;
import com.caucho.hessian.client.HessianRuntimeException;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.HessianProtocolException;
import com.caucho.util.CharBuffer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;

public class HessianProxy
implements InvocationHandler {
    private HessianProxyFactory _factory;
    private URL _url;
    private static Class _resin_compat_class_0;

    HessianProxy(HessianProxyFactory factory, URL url) {
        this._factory = factory;
        this._url = url;
    }

    public URL getURL() {
        return this._url;
    }

    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        String methodName = method.getName();
        Class<?>[] params = method.getParameterTypes();
        if (methodName.equals("equals") && params.length == 1 && params[0].equals(HessianProxy._resin_compat_class_0())) {
            Object value = args[0];
            if (value == null || !Proxy.isProxyClass(value.getClass())) {
                return new Boolean(false);
            }
            HessianProxy handler = (HessianProxy)Proxy.getInvocationHandler(value);
            return new Boolean(this._url.equals(handler.getURL()));
        }
        if (methodName.equals("hashCode") && params.length == 0) {
            return new Integer(this._url.hashCode());
        }
        if (methodName.equals("getHessianType")) {
            return proxy.getClass().getInterfaces()[0].getName();
        }
        if (methodName.equals("getHessianURL")) {
            return this._url.toString();
        }
        if (methodName.equals("toString") && params.length == 0) {
            return new CharBuffer().append("[HessianProxy ").append(this._url).append("]").toString();
        }
        InputStream is = null;
        URLConnection conn = null;
        HttpURLConnection httpConn = null;
        try {
            if (this._factory.isOverloadEnabled()) {
                methodName = args != null ? new CharBuffer().append(methodName).append("__").append(args.length).toString() : new CharBuffer().append(methodName).append("__0").toString();
            }
            if ((conn = this.sendRequest(methodName, args)) instanceof HttpURLConnection) {
                httpConn = (HttpURLConnection)conn;
                int code = 500;
                try {
                    code = httpConn.getResponseCode();
                }
                catch (Exception e) {
                    // empty catch block
                }
                if (code != 200) {
                    StringBuffer sb;
                    block34: {
                        sb = new StringBuffer();
                        try {
                            int ch;
                            is = httpConn.getInputStream();
                            if (is != null) {
                                while ((ch = is.read()) >= 0) {
                                    sb.append((char)ch);
                                }
                                is.close();
                            }
                            if ((is = httpConn.getErrorStream()) != null) {
                                while ((ch = is.read()) >= 0) {
                                    sb.append((char)ch);
                                }
                            }
                        }
                        catch (FileNotFoundException e) {
                            throw new HessianRuntimeException(String.valueOf(e));
                        }
                        catch (IOException e) {
                            if (is != null) break block34;
                            throw new HessianProtocolException(new CharBuffer().append(code).append(": ").append(e).toString(), e);
                        }
                    }
                    if (is != null) {
                        is.close();
                    }
                    throw new HessianProtocolException(new CharBuffer().append(code).append(": ").append(sb.toString()).toString());
                }
            }
            is = conn.getInputStream();
            AbstractHessianInput in = this._factory.getHessianInput(is);
            Object object = in.readReply(method.getReturnType());
            return object;
        }
        catch (HessianProtocolException e) {
            throw new HessianRuntimeException(e);
        }
        finally {
            try {
                if (is != null) {
                    is.close();
                }
            }
            catch (Throwable e) {}
            try {
                if (httpConn != null) {
                    httpConn.disconnect();
                }
            }
            catch (Throwable e) {}
        }
    }

    private URLConnection sendRequest(String methodName, Object[] args) throws IOException {
        URLConnection conn = null;
        conn = this._factory.openConnection(this._url);
        if (this._factory.isChunkedPost() && conn instanceof HttpURLConnection) {
            try {
                HttpURLConnection httpConn = (HttpURLConnection)conn;
                httpConn.setChunkedStreamingMode(8192);
            }
            catch (Throwable e) {
                // empty catch block
            }
        }
        OutputStream os = null;
        try {
            os = conn.getOutputStream();
        }
        catch (Exception e) {
            throw new HessianRuntimeException(e);
        }
        try {
            AbstractHessianOutput out = this._factory.getHessianOutput(os);
            out.call(methodName, args);
            out.flush();
            return conn;
        }
        catch (IOException e) {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
            throw e;
        }
        catch (RuntimeException e) {
            if (conn instanceof HttpURLConnection) {
                ((HttpURLConnection)conn).disconnect();
            }
            throw e;
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

