/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractDeserializer;
import com.caucho.hessian.io.AbstractHessianInput;
import com.caucho.hessian.io.IOExceptionWrapper;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Method;

public class EnumDeserializer
extends AbstractDeserializer {
    private Class _enumType;
    private Method _valueOf;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;

    public EnumDeserializer(Class cl) {
        try {
            this._enumType = cl;
            this._valueOf = cl.getMethod("valueOf", EnumDeserializer._resin_compat_class_0(), EnumDeserializer._resin_compat_class_1());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public Class getType() {
        return this._enumType;
    }

    public Object readMap(AbstractHessianInput in) throws IOException {
        String name = null;
        while (!in.isEnd()) {
            String key = in.readString();
            if (key.equals("name")) {
                name = in.readString();
                continue;
            }
            in.readObject();
        }
        in.readMapEnd();
        Object obj = this.create(name);
        in.addRef(obj);
        return obj;
    }

    public Object readObject(AbstractHessianInput in, String[] fieldNames) throws IOException {
        String name = null;
        for (int i = 0; i < fieldNames.length; ++i) {
            if ("name".equals(fieldNames[i])) {
                name = in.readString();
                continue;
            }
            in.readObject();
        }
        Object obj = this.create(name);
        in.addRef(obj);
        return obj;
    }

    private Object create(String name) throws IOException {
        if (name == null) {
            throw new IOException(new CharBuffer().append(this._enumType.getName()).append(" expects name.").toString());
        }
        try {
            return this._valueOf.invoke(null, this._enumType, name);
        }
        catch (Exception e) {
            throw new IOExceptionWrapper(e);
        }
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.lang.Class");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

