/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.hessian.io;

import com.caucho.hessian.io.AbstractHessianOutput;
import com.caucho.hessian.io.AbstractSerializer;
import com.caucho.util.CharBuffer;
import java.io.IOException;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;

public class JavaSerializer
extends AbstractSerializer {
    private Field[] _fields;
    private FieldSerializer[] _fieldSerializers;
    private Method _writeReplace;
    private static Class _resin_compat_class_0;
    private static Class _resin_compat_class_1;
    private static Class _resin_compat_class_2;

    public JavaSerializer(Class cl) {
        int i;
        Object fields;
        if (!JavaSerializer._resin_compat_class_0().isAssignableFrom(cl)) {
            throw new IllegalStateException(new CharBuffer().append("Serialized class ").append(cl.getName()).append(" does not implement java.io.Serializable").toString());
        }
        this._writeReplace = this.getWriteReplace(cl);
        if (this._writeReplace != null) {
            this._writeReplace.setAccessible(true);
        }
        ArrayList<Object> primitiveFields = new ArrayList<Object>();
        ArrayList<Object> compoundFields = new ArrayList<Object>();
        while (cl != null) {
            fields = cl.getDeclaredFields();
            for (i = 0; i < ((Object)fields).length; ++i) {
                Object field = fields[i];
                if (Modifier.isTransient(((Field)field).getModifiers()) || Modifier.isStatic(((Field)field).getModifiers())) continue;
                ((Field)field).setAccessible(true);
                if (((Field)field).getType().isPrimitive() || ((Field)field).getType().getName().startsWith("java.lang.") && !((Field)field).getType().equals(JavaSerializer._resin_compat_class_1())) {
                    primitiveFields.add(field);
                    continue;
                }
                compoundFields.add(field);
            }
            cl = cl.getSuperclass();
        }
        fields = new ArrayList();
        ((ArrayList)fields).addAll(primitiveFields);
        ((ArrayList)fields).addAll(compoundFields);
        this._fields = new Field[((ArrayList)fields).size()];
        ((ArrayList)fields).toArray(this._fields);
        this._fieldSerializers = new FieldSerializer[this._fields.length];
        for (i = 0; i < this._fields.length; ++i) {
            this._fieldSerializers[i] = JavaSerializer.getFieldSerializer(this._fields[i].getType());
        }
    }

    protected Method getWriteReplace(Class cl) {
        while (cl != null) {
            Method[] methods = cl.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                Method method = methods[i];
                if (!method.getName().equals("writeReplace") || method.getParameterTypes().length != 0) continue;
                return method;
            }
            cl = cl.getSuperclass();
        }
        return null;
    }

    public void writeObject(Object obj, AbstractHessianOutput out) throws IOException {
        if (out.addRef(obj)) {
            return;
        }
        Class<?> cl = obj.getClass();
        try {
            if (this._writeReplace != null) {
                Object repl = this._writeReplace.invoke(obj, new Object[0]);
                out.removeRef(obj);
                out.writeObject(repl);
                out.replaceRef(repl, obj);
                return;
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        int ref = out.writeObjectBegin(cl.getName());
        if (ref < 0) {
            this.writeObject10(obj, out);
        } else {
            if (ref == 0) {
                this.writeDefinition20(out);
            }
            this.writeInstance(obj, out);
        }
    }

    private void writeObject10(Object obj, AbstractHessianOutput out) throws IOException {
        for (int i = 0; i < this._fields.length; ++i) {
            Field field = this._fields[i];
            out.writeString(field.getName());
            this._fieldSerializers[i].serialize(out, obj, field);
        }
        out.writeMapEnd();
    }

    private void writeDefinition20(AbstractHessianOutput out) throws IOException {
        out.writeClassFieldLength(this._fields.length);
        for (int i = 0; i < this._fields.length; ++i) {
            Field field = this._fields[i];
            out.writeString(field.getName());
        }
    }

    public void writeInstance(Object obj, AbstractHessianOutput out) throws IOException {
        for (int i = 0; i < this._fields.length; ++i) {
            Field field = this._fields[i];
            this._fieldSerializers[i].serialize(out, obj, field);
        }
    }

    private static FieldSerializer getFieldSerializer(Class type) {
        if (Integer.TYPE.equals(type) || Byte.TYPE.equals(type) || Short.TYPE.equals(type) || Integer.TYPE.equals(type)) {
            return IntFieldSerializer.SER;
        }
        if (Long.TYPE.equals(type)) {
            return LongFieldSerializer.SER;
        }
        if (Double.TYPE.equals(type) || Float.TYPE.equals(type)) {
            return DoubleFieldSerializer.SER;
        }
        if (Boolean.TYPE.equals(type)) {
            return BooleanFieldSerializer.SER;
        }
        if (JavaSerializer._resin_compat_class_2().equals(type)) {
            return StringFieldSerializer.SER;
        }
        return FieldSerializer.SER;
    }

    private static Class _resin_compat_class_0() {
        try {
            Class<?> clazz = _resin_compat_class_0;
            if (clazz == null) {
                clazz = _resin_compat_class_0 = Class.forName("java.io.Serializable");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_1() {
        try {
            Class<?> clazz = _resin_compat_class_1;
            if (clazz == null) {
                clazz = _resin_compat_class_1 = Class.forName("java.lang.Object");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    private static Class _resin_compat_class_2() {
        try {
            Class<?> clazz = _resin_compat_class_2;
            if (clazz == null) {
                clazz = _resin_compat_class_2 = Class.forName("java.lang.String");
            }
            return clazz;
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }

    static class StringFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new StringFieldSerializer();

        StringFieldSerializer() {
        }

        void serialize(AbstractHessianOutput out, Object obj, Field field) throws IOException {
            String value = null;
            try {
                value = (String)field.get(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            out.writeString(value);
        }
    }

    static class DoubleFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new DoubleFieldSerializer();

        DoubleFieldSerializer() {
        }

        void serialize(AbstractHessianOutput out, Object obj, Field field) throws IOException {
            double value = 0.0;
            try {
                value = field.getDouble(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            out.writeDouble(value);
        }
    }

    static class LongFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new LongFieldSerializer();

        LongFieldSerializer() {
        }

        void serialize(AbstractHessianOutput out, Object obj, Field field) throws IOException {
            long value = 0L;
            try {
                value = field.getLong(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            out.writeLong(value);
        }
    }

    static class IntFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new IntFieldSerializer();

        IntFieldSerializer() {
        }

        void serialize(AbstractHessianOutput out, Object obj, Field field) throws IOException {
            int value = 0;
            try {
                value = field.getInt(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            out.writeInt(value);
        }
    }

    static class BooleanFieldSerializer
    extends FieldSerializer {
        static final FieldSerializer SER = new BooleanFieldSerializer();

        BooleanFieldSerializer() {
        }

        void serialize(AbstractHessianOutput out, Object obj, Field field) throws IOException {
            boolean value = false;
            try {
                value = field.getBoolean(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            out.writeBoolean(value);
        }
    }

    static class FieldSerializer {
        static final FieldSerializer SER = new FieldSerializer();

        FieldSerializer() {
        }

        void serialize(AbstractHessianOutput out, Object obj, Field field) throws IOException {
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            out.writeObject(value);
        }
    }
}

