/*
 * Decompiled with CFR 0.152.
 */
package org.easymock.internal;

import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import junit.framework.AssertionFailedError;
import org.easymock.ArgumentsMatcher;
import org.easymock.internal.AssertionFailedErrorWrapper;
import org.easymock.internal.ExpectedMethodCall;
import org.easymock.internal.MethodCall;
import org.easymock.internal.Range;
import org.easymock.internal.Result;
import org.easymock.internal.ResultList;

public class ResultListMap {
    private final List<ArgumentsEntry> results = new ArrayList<ArgumentsEntry>();
    private final ArgumentsMatcher matcher;
    private final Method method;

    public ResultListMap(Method method, ArgumentsMatcher matcher) {
        this.method = method;
        this.matcher = matcher;
    }

    public void addExpected(Object[] expected, Result result, Range count) {
        ExpectedMethodCall matchableArguments = new ExpectedMethodCall(this.method, expected, this.matcher);
        for (ArgumentsEntry entry : this.results) {
            if (!entry.getMatchableArguments().equals(matchableArguments)) continue;
            entry.getResultList().add(result, count);
            return;
        }
        ResultList list = new ResultList();
        list.add(result, count);
        this.results.add(new ArgumentsEntry(matchableArguments, list));
    }

    public Result addActual(Object[] arguments) {
        boolean matched = false;
        for (ArgumentsEntry entry : this.results) {
            ExpectedMethodCall matchableArguments = entry.getMatchableArguments();
            if (!matchableArguments.matches(this.method, arguments)) continue;
            matched = true;
            Result result = entry.getResultList().next();
            if (result == null) continue;
            return result;
        }
        throw new AssertionFailedErrorWrapper(new AssertionFailedError(this.createFailureMessage(arguments, matched)));
    }

    private String createFailureMessage(Object[] actual, boolean matched) {
        StringBuffer result = new StringBuffer();
        if (!matched) {
            result.append("\n    ");
            result.append(new MethodCall(this.method, actual).toString(this.matcher));
            result.append(": ");
            result.append(new Range(7).expectedAndActual(1).replace('7', '0'));
        }
        for (ArgumentsEntry entry : this.results) {
            ExpectedMethodCall matchableArguments = entry.getMatchableArguments();
            ResultList list = entry.getResultList();
            if (list.hasValidCallCount() && !matchableArguments.matches(this.method, actual)) continue;
            int count = list.getCallCount();
            if (matched && matchableArguments.matches(this.method, actual)) {
                ++count;
                matched = false;
            }
            result.append("\n    ");
            result.append(matchableArguments.toString());
            result.append(": ");
            result.append(list.getMessage(count));
        }
        return result.toString();
    }

    public void verify() {
        String failureMessage = "";
        boolean verifyFailed = false;
        for (ArgumentsEntry entry : this.results) {
            ExpectedMethodCall matchableArguments = entry.getMatchableArguments();
            ResultList list = entry.getResultList();
            if (list.hasValidCallCount()) continue;
            verifyFailed = true;
            failureMessage = failureMessage + "\n    " + matchableArguments.toString() + ": " + list.getMessage();
        }
        if (verifyFailed) {
            throw new AssertionFailedError(failureMessage);
        }
    }

    private static class ArgumentsEntry {
        ExpectedMethodCall matchableArguments;
        ResultList resultList;

        ArgumentsEntry(ExpectedMethodCall key, ResultList value) {
            this.matchableArguments = key;
            this.resultList = value;
        }

        public ExpectedMethodCall getMatchableArguments() {
            return this.matchableArguments;
        }

        public ResultList getResultList() {
            return this.resultList;
        }
    }
}

