#!/bin/sh 
#
# This is part of the lw-installer program: 
#    http://kevin.rosenberg.net/lw-installer
# Copyright (c) 2002 Kevin M. Rosenberg
#
#  This program is free software; you can redistribute it and/or modify
#  it under the terms of the GNU General Public License (version 2) as
#  published by the Free Software Foundation.
#
#  This program is distributed in the hope that it will be useful,
#  but WITHOUT ANY WARRANTY; without even the implied warranty of
#  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#  GNU General Public License for more details.
#
#  Should should have a copy of the GNU General Public License on your
#  Debian system in the file /usr/share/common-licenses/GPL-2


if [ ! -f /usr/share/common-lisp/source/common-lisp-controller/common-lisp-controller.lisp ] ; then
  echo "*** Can't find common-lisp-controller.lisp ***" >&2
  echo "Please report this as a bug" &>2
  exit 1
fi

lw_dir=/usr/lib/lispworks
lw_original=$lw_dir/lispworks-4200
lw_exe=$lw_dir/lw-console
lw_clc_dir=/usr/lib/common-lisp/lispworks
make_images=$lw_dir/make-images.sh

lisp_error ()
{
    echo "Error running $lw_exe" >&2
    exit 1
}


case $1 in
    rebuild)
	echo $0 Rebuilding packages...
	shift
	while [ ! -z "$1" ] ; do
	    echo ...Rebuilding $1
	    echo "
(let ((*compile-print* nil)
      (*compile-verbose*  nil)
      (*load-verbose* nil))
   (handler-case
      (progn
         (c-l-c:compile-library (quote $1))
         (quit :status 0)
       )
    (error (e)
      (ignore-errors (format t \"~&Build Error: ~A~%\" e))
      (finish-output)
      (quit :status 1))))" |  $lw_exe - || lisp_error
	    shift
	done 
	;;
    remove)
	echo $0 Removing packages...
	shift
	while [ ! -z "$1" ] ; do
	    echo ...removing package $1
	    rm -rf "/var/cache/common-lisp-controller/*/lispworks/${1}"
	    shift
	done
	rmdir $lw_clc_dir 2> /dev/null 
	;;
    install-clc)
	echo Installing clc...
	$make_images $lw_dir/install-clc.lisp use-original || exit 1
	;;
    remove-clc)
	if [ -x $make_images ]; then
	    $make_images "" use-original || lisp_error
	fi
	;;
    *)
	echo "$0: Unknown command $1" >&2
	echo "Known commands are:" >&2 
	echo "install-clc, remove-clc, rebuild, remove, and make-user-image" >&2
	;;
esac

exit 0
