/* Element.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin;

/**
 * Represents a graph element. Currently elements are either vertices or edges.
 * <p>
 * A graph elements may optionally carry some additional 'annotation' information
 * (also known as a 'label') which is used to augment the way it is printed
 * or displayed in a graphical environment.<p>
 * Different elements in the same graph should be represented by different objects.
 * Graphs are allowed to share vertices when this is meaningful, e.g., when both 
 * are subgraphs of the same graph.
 * <p>
 *
 * @see Vertex
 * @see Edge
 * @see DefaultGraphModel
 */
public class Element {
    
    // IMPORTANT: hash codes of elements should not depend on annotations

    // bean property
    private Object annotation;

    /**
     * Annotation for this element.
     * @return The annotation property for this element or {@code null} when
     * this element is not annotated.
     */
    public Object getAnnotation() {
        return annotation;
    }

    /**
     * Set the annotation property for this element.
     * @param annotation New annotation for this element, or
     * {@code null} to clear the annotation.
     */
    void setAnnotation(Object annotation) {
        this.annotation = annotation;
    }
    
}
