/* GraphBundle.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin;

import org.grinvin.gui.icons.GraphIconFactory;
import org.grinvin.invariants.InvariantValue;
import org.grinvin.util.InternationalizedProperties;

/**
 * A mutable version of {@link GraphBundleView}. Provides methods to store
 * or change information contained in a bundle.
 */
public interface GraphBundle extends GraphBundleView {

    /**
     * Abstract graph representation for this graph bundle.
     */
    public Graph getGraph ();
    
    /**
     * Set the internationalized properties for this graph.
     */
    public void setProperties (InternationalizedProperties properties);
    
    /**
     * Factory method which creates a new (empty) graph for this bundle.
     * Subsequent calls to {@link #getGraph} should return this graph.
     * @return the graph created
     */
    public Graph createGraph ();
    
    /**
     * Factory method which creates a new (empty) embedding 
     * and installs it as the next embedding in this bundle, i.e., the embedding
     * with the next available index.<p>
     * This embedding should have the graph returned by {@link #getGraph}
     * as a peer. Subsequent calls to {@link #getEmbedding} with the appropriate 
     * index, should return the embedding created by this method.
     * @return the embedding created.
     */
    public Embedding createEmbedding ();
    
    /**
     * Add the given InvariantValue as a cached value to this bundle
     * @param value The InvariantValue to be added to this bundle.
     */
    public void addInvariantValue(InvariantValue value);
    
    /**
     * Set the graph icon factory used for displaying this graph as
     * an icon.
     */
    public void setGraphIconFactory(GraphIconFactory graphIconFactory);
    

    //
    public void addGraphBundleListener(GraphBundleListener listener);
    
    //
    public void removeGraphBundleListener(GraphBundleListener listener);

}
