/* TransformationSupport.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gred.transformations;

import javax.swing.event.EventListenerList;

import org.grinvin.gred.TransformationListener;

/**
 * Helper class for implementations of {@link org.grinvin.gred.Transformation}. 
 * Models can delegate listener management and notification to
 * an object of this class.
 */
public class TransformationSupport {
  
    //
    private EventListenerList listenerList = new EventListenerList ();
    
    // [kc] for performance reasons
    private static final Class<TransformationListener>
            TRANSFORMATION_LISTENER_CLASS = TransformationListener.class;
    
    // implements Transformation
    public void addTransformationListener (TransformationListener l) {
        listenerList.add (TRANSFORMATION_LISTENER_CLASS, l);
    }
    
    // implements Transformation
    public void removeTransformationListener (TransformationListener l) {
        listenerList.remove (TRANSFORMATION_LISTENER_CLASS, l);
    }
    
    /**
     * Notify  all listeners of a change to this transformation.
     */
    public void fireTransformationChanged () {
        Object[] listeners = listenerList.getListenerList ();
        for (int i = listeners.length-2; i>=0; i-=2)
            if (listeners[i]==TRANSFORMATION_LISTENER_CLASS)
                ((TransformationListener)listeners[i+1]).transformationChanged ();
    }
    
}
