/* NewGraphListCommand.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.grinvin.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import org.grinvin.graphbrowser.GraphBrowserWindow;
import org.grinvin.grinvin.GrinvinWindow;

import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;

/**
 * Opens a new Graph List.
 */
public class NewGraphListCommand extends ActionCommand {
    
    //
    private GrinvinWindow grinvinWindow;
    
    //
    private static final String KEY = GrinvinWindow.class.getName();
    
    //
    public NewGraphListCommand(CommandManager commandManager, String commandId) {
        super(commandManager, commandId);
        this.grinvinWindow = (GrinvinWindow)((AttributedCommandManager)commandManager).
                getAttribute(KEY);
        // [kc] cannot yet retrieve the graph lists window at this time
        // [kc] not: this.glw = grinvinWindow.getGraphListsWindow().getModel();
    }
    
    // implements handleExecute
    public void handleExecute() {
        GraphBrowserWindow window =
                grinvinWindow.getGraphListsModel().createNewGraphBrowserWindow();
        window.setVisible(true);
        window.toFront();
    }
    
}
