/* SaveWorkspaceAsCommand.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.grinvin.commands;

import java.awt.Window;
import java.io.File;
import java.text.MessageFormat;
import java.util.ResourceBundle;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.JFileChooser;
import javax.swing.filechooser.FileFilter;
import org.grinvin.workspace.Workspace;
import org.grinvin.workspace.WorkspaceException;

import org.pietschy.command.CommandManager;
import org.pietschy.command.file.AbstractSaveAsCommand;
import org.pietschy.command.file.ExtensionFileFilter;

/**
 * Command to save the current workspace to disk.
 */
public class SaveWorkspaceAsCommand extends AbstractSaveAsCommand {
    
    //
    private static final ResourceBundle BUNDLE 
            = ResourceBundle.getBundle("org.grinvin.grinvin.commands.resources");
    
    //
    private static final Logger LOGGER = Logger.getLogger ("org.grinvin.io");
    
    //
    private static final FileFilter FILTER = new ExtensionFileFilter("workspace", "*.workspace");
    
    public SaveWorkspaceAsCommand(CommandManager manager, String commandId) {
        super(manager, commandId, FILTER);
        getFileChooser ().setFileSelectionMode(JFileChooser.DIRECTORIES_ONLY);
    }
    
    // implements performSave
    public void performSave(File directory) {
        try {
            Workspace.getInstance().saveAs(directory);
        } catch (WorkspaceException e) {
            LOGGER.log(Level.SEVERE, "Saving workspace failed", e);
        }
    }
    
    //
    protected void handleError(JFileChooser chooser, Window invoker) {
        LOGGER.severe ("An error occured while saving the workspace.");
    }

    protected String getFileExistsMessage(File directory) {
        return MessageFormat.format(BUNDLE.getString("workspace.overwrite.message"), directory);
    }
    
    // TODO: getFileExistsTitle in AbstractSaveAsCommand is private - see also NewWorkspaceCommand
    
    
}
