/* LargeGraphIcon.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.gui.icons;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import javax.swing.Icon;
import org.grinvin.GraphView;

/**
 * Graph icon for a graph with a large number of vertices
 * or edges. This icon is available in a single standard size which is suitable
 * for use in cell lists.
 */
public class LargeGraphIcon extends AbstractGraphIcon {

    //
    private Icon backgroundIcon;
    
    //
    private int bgIconHeight;
    
    //
    private int bgIconWidth;
    
    //
    private static final Font FONT = new Font ("Serif", Font.BOLD, 24);
    
    // 
    private static final Color COLOR = Color.BLACK;
    
    //
    private static final Color SELECTED_COLOR  = new Color(0, 127, 255);
    
    //
    private int numberOfVertices;
    
    //
    private int numberOfEdges;
    
    public LargeGraphIcon (GraphView graph, Icon backgroundIcon) {
        numberOfVertices = graph.getNumberOfVertices ();
        numberOfEdges = graph.getNumberOfEdges ();
        this.backgroundIcon = backgroundIcon;
        this.bgIconHeight = backgroundIcon.getIconHeight();
        this.bgIconWidth = backgroundIcon.getIconWidth();
    }
    
    public void paintIcon (Component c, Graphics g, int x, int y) {
        Graphics2D g2 = (Graphics2D)g.create ();
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING,
            RenderingHints.VALUE_ANTIALIAS_ON);
        backgroundIcon.paintIcon (c, g2, x, y);
        g2.translate (x, y);
        g2.setColor (selected ? SELECTED_COLOR : COLOR);
        g2.setFont (FONT);
        g2.drawString (Integer.toString (numberOfVertices), 0, 20);
        String edges = Integer.toString (numberOfEdges);
        int w = g2.getFontMetrics ().stringWidth (edges);
        g2.drawString (edges, bgIconWidth - w, bgIconWidth - 2);
    }

    public int getIconWidth () {
        return bgIconWidth;
    }

    public int getIconHeight () {
        return bgIconHeight;
    }
    
    
}
