/* InvariantMap.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.help;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import javax.help.HelpSet;
import javax.help.Map;
import javax.help.Map.ID;

import org.grinvin.invariants.InvariantManager;

/**
 * Provides the mapping of the context-sensitive help ID of invariants and
 * the URL for their help page.
 */
public class InvariantMap implements Map {
    
    private static final InvariantMap SINGLETON = new InvariantMap();
    
    public static InvariantMap getInstance() {
        return SINGLETON;
    }
    
    private InvariantMap(){
        invariantids = InvariantManager.getInstance().getIds();
    }
    
    private final List<String> invariantids;
    
    public boolean isValidID(String string, HelpSet helpSet) {
        return invariantids.contains(string);
    }
    
    public Enumeration getAllIDs() {
        Vector<Map.ID> ids = new Vector<Map.ID>(); // NOPMD
        for(int i = 0; i<invariantids.size(); i++)
            ids.add(ID.create(invariantids.get(i), HelpManager.getHelpSet()));
        return ids.elements();
    }
    
    public URL getURLFromID(Map.ID iD) throws MalformedURLException {
        String id = iD.id;
        if(invariantids.contains(id))
            return new URL("invariant:" + id);
        else
            return null;
    }
    
    public boolean isID(URL uRL) {
        return invariantids.contains(uRL.getHost());
    }
    
    public Map.ID getIDFromURL(URL uRL) {
        if(uRL==null) return null;
        String id = uRL.getHost();
        if(invariantids.contains(id))
            return ID.create(id, HelpManager.getHelpSet());
        else
            return null;
    }
    
    public Map.ID getClosestID(URL uRL) {
        return getIDFromURL(uRL);
    }
    
    public Enumeration getIDs(URL uRL) {
        Vector<String> ids = new Vector<String>(); // NOPMD
        ids.add(getIDFromURL(uRL).id);
        return ids.elements();
    }
    
    
}
