/* BooleanValue.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.invariants;

import java.util.ResourceBundle;
import org.jdom.Element;

/**
 * Invariant type which allows boolean values.
 * Identified by the string <code>boolean</code>.
 */
public class BooleanValue extends InvariantValue {
    

    private boolean value;
    
    /**
     * Create a new unitialized value of this type. Used by the loader.
     */
    BooleanValue () {
        super ("boolean");
    }
    
    /**
     * Create an object of this type with the given boolean value.
     */
    public BooleanValue (boolean value, InvariantComputer computer) {
        super ("boolean", computer);
        this.value = value;
    }
    
    /**
     * Return the actual value as a real number.
     */
    public double asDouble () {
        return Double.NaN;
    }
    
    //
    public String toText () {
        ResourceBundle rbundle = ResourceBundle.getBundle ("org.grinvin.invariants.resources");
        return rbundle.getString(Boolean.toString(value));
    }
        
    //
    public void loadValue (Element element) {
        value = Boolean.valueOf (element.getTextTrim ());
    }
    
    //
    public void saveValue (Element element) {
        element.setText (Boolean.toString(value));
    }
    
    
}
