/* package-info.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

/**
 * Provides classes and interfaces for basic operations on
 * graph invariants.<p>
 *
 * <h2>Basic concepts</h2>
 * This package introduces several concepts which are similarly
 * named but very distinct: the notion of <i>invariant</i>, <i>invariant type</i>,
 * <i>invariant value</i> and <i>invariant computer</i>.
 * <ul>
 * <li>An <i>invariant</i> is a mathematical concept which can be computed for a
 * given graph. Examples are the diameter of a graph, its average
 * degree, its largest Laplacian eigenvalue, whether the graph is 2-connected, ...
 * Invariants are represented as objects of type {@link org.grinvin.invariants.Invariant}.</li>
 * <li>An <i>invariant value</i> is the value of a given invariant for a particular graph, 
 * i.e., the value 2 for the diameter of the Petersen graph, the value <code>true</code>
 * for the 2-connectedness of a hexagon. Invariant values are stored as objects of type
 * {@link org.grinvin.invariants.InvariantValue}.</li>
 * <li>Some invariants (like diameter) are integers, others are real numbers, boolean values, ...
 * This determines the <i>type</i> of the invariant.
 * In Java-terms this means that every invariant stores its value as an object which is an instance
 * of one specific implementation of {@code InvariantValue}.</li>
 * <li>An algorithm to compute a specific invariant is implemented as a 
 * class of type {@link org.grinvin.invariants.InvariantComputer}. An invariant computer is used to
 * obtain the value of a specific invariant for any graph we care to hand it. It is allowed for different
 * invariant computers to compute the same invariant (presumably using a different algorithm).</li>
 * </ul>
 * 
 * Invariants are identified by a (universally) unique string. It is the task of 
 * the <i>invariant manager</i> (a singleton object of type {@link org.grinvin.invariants.InvariantManager})
 * to retrieve (and if necessary create) the correct invariant instance for a given id. Also invariant types
 * are identified by a unique string (which is mapped internally to a corresponding {@code InvariantValue}).<p>
 * Invariant computers are identified by their fully qualified class name. They are registered
 * with the invariant manager which will interrogate them about which invariants they are able to compute.
 * At startup a default list of invariant computers is automatically registered
 * with the manager.
 *
 * <h2>Parametrized invariants</h2>
 * Sometimes the same algorithm can be used to compute values for different invariants
 * which only differ in a parameter. For example, the algorithm that counts the number of vertices
 * of degree 3 is essentially the same as for degree 4. The corresponding invariants are called
 * <i>parametrized invariants</i>. (Each set of actual values for the parameters is considered to
 * correspond to a separate invariant.)<p>
 *
 * Identifiers of parametrized invariants consist of two parts: a <i>generic identifier</i> 
 * and a parameter string. A generic identifier has a similar structure as an identifier of an
 * ordinary invariant, e.g., {@code org.grinvin.invariants.NumberOfVerticesOfDegree}. The parameter string
 * has the same structure as a query string of a URL, e.g., {@code ?degree=3}. In our example, 
 * the full name of the invariant would then be
 * <pre>
 *     org.grinvin.invariants.NumberOfVerticesOfDegree?degree=3
 * </pre>
 * Parametrized invariants can be created by <i>invariant factories</i> of type {@link org.grinvin.invariants.InvariantFactory}.
 * The invariant factory is identified by the generic identifier of the invariants it creates.<p>
 *
 * As with other invariants, the value of a parametrized invariant for a given graph is computed by
 * an invariant computer. The invariant manager tries to determine which invariant computer to 
 * use in the following manner:
 * <ul>
 * <li>First, as with ordinary invariants, the manager tries to locate an invariant computer 
 * which has registered itself as being the computer
 * for this specific parametrized invariant, with the given parameter values.</li>
 * <li>If not, the manager locates a so-called <i>invariant computer factory</i> 
 * (of class {@link org.grinvin.invariants.InvariantComputerFactory}) for the generic identifier of the parametrized invariant.
 * This is a class which can create an appropriate invariant computer for any values of the parameters.
 * This (anonymous) invariant computer is then registered with the manager, to ease subsequent lookups and
 * avoid duplication.</li>
 * </ul>.
 */
package org.grinvin.invariants;


