/* InvariantValuesSaver.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.io;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Collection;

import org.grinvin.invariants.InvariantValue;
import org.grinvin.preferences.GrinvinPreferences;
import org.grinvin.preferences.GrinvinPreferences.Preference;

import org.jdom.Document;
import org.jdom.Element;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

/**
 * Saved for the computed values of a saved GraphBundle
 */
public class InvariantValuesSaver {
    
    //
    private Collection<InvariantValue> values;
    
    public InvariantValuesSaver(Collection<InvariantValue> values) {
        this.values = values;
    }
    
    //
    public void save(OutputStream out) throws IOException {
        Element result = new Element("invariantvalues");
        
        for (InvariantValue value : values)
            result.addContent(value.toElement());
        
        XMLOutputter outputter;
        if (GrinvinPreferences.INSTANCE.getStringPreference(Preference.XMLOUTPUT_FORMAT).equals("pretty"))
            outputter = new XMLOutputter(Format.getPrettyFormat());
        else
            outputter = new XMLOutputter(Format.getCompactFormat());
        
        Document doc = new Document(result);
        outputter.output(doc, out);
    }
    
}
