/* InvariantTableCellRenderer.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list;

import java.awt.Color;
import javax.swing.table.DefaultTableCellRenderer;

import org.grinvin.GraphURIType;
import org.grinvin.invariants.Invariant;
import org.grinvin.invariants.InvariantManager;

/**
 * Table cell renderer for objects of type {@link Invariant}.
 */
public class InvariantTableCellRenderer extends DefaultTableCellRenderer {
    
    //
    Color stdColor;
    
    public InvariantTableCellRenderer() {
        stdColor = getForeground();
    }
    
    /**
     * Renders an invariant.
     */
    @Override public void setValue(Object value) {
        if (value instanceof Invariant) {
                Invariant invariant = (Invariant)value;
                setText(invariant.getName());
                setIcon(GraphURIType.INVARIANT.getSmallIcon());
                if (InvariantManager.getInstance().getInvariantComputerFor(invariant) == null)
                    setForeground(Color.RED);
                else
                    setForeground(stdColor);
        } else if (value != null)
            throw new IllegalArgumentException
                    ("InvariantTableCellRenderer can only be used with columns of type Invariant");
    }
    
}
