/* GraphRename.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import be.ugent.caagt.swirl.commands.AttributedCommandManager;

import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

import org.grinvin.graphbrowser.GraphBrowserMultiPanel;
import org.grinvin.list.GraphList;
import org.grinvin.list.GraphListElement;
import org.grinvin.list.GraphListModel;

import org.pietschy.command.ActionCommand;
import org.pietschy.command.CommandManager;

/**
 * GUI command which allows the user to rename the currently selected
 * graph list element.<p>
 * Acts upon a array list model and a selection model stored as attributes in
 * an attributed command manager.
 */
public class GraphRename extends ActionCommand implements ListSelectionListener {
    
    //
    private static final String KEY = GraphBrowserMultiPanel.class.getName();
    
    //
    private GraphBrowserMultiPanel panel;
        
    /**
     * Construct an action command of this type.
     * @param commandManager Command manager, which must be of class {@link AttributedCommandManager}
     */
    public GraphRename(CommandManager commandManager, String id) {
        super(commandManager, id);
        this.panel = (GraphBrowserMultiPanel)((AttributedCommandManager)commandManager).getAttribute(KEY);
        this.panel.getSelectionModel().addListSelectionListener(this);
        GraphList list = panel.getGraphList();
        ListSelectionModel selectionModel = panel.getSelectionModel();
        int index = selectionModel.getMinSelectionIndex();
        setEnabled(!(index < 0 || index != selectionModel.getMaxSelectionIndex() || !list.get(index).isNameEditable()));
    }
    
    /**
     * Ask the user to rename the currently selected graph list element.
     */
    protected void handleExecute() {
        GraphList list = panel.getGraphList();
        ListSelectionModel selectionModel = panel.getSelectionModel();
        
        int index = selectionModel.getMinSelectionIndex();
        if (index < 0)
            return; // none selected
        if (index != selectionModel.getMaxSelectionIndex())
            return; // more than one selection
        GraphListElement gle = list.get(index);
        
        if (gle.isNameEditable()) {
            new GraphRenamePanel().showDialog(gle, panel);
        }
        
    }

    public void valueChanged(ListSelectionEvent e) {
        GraphList list = panel.getGraphList();
        ListSelectionModel selectionModel = panel.getSelectionModel();
        
        int index = selectionModel.getMinSelectionIndex();
        if (index < 0 || index != selectionModel.getMaxSelectionIndex() || !list.get(index).isNameEditable())
            setEnabled(false);
        else    
            setEnabled(true);
    }
    
}
