/* GraphRenamePanel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.commands;

import java.awt.Component;
import java.util.ResourceBundle;
import javax.swing.Icon;

import org.grinvin.GraphBundleView;
import org.grinvin.list.GraphListElement;
import org.grinvin.preferences.GrinvinPreferences;
import org.grinvin.preferences.GrinvinPreferences.Preference;

/**
 * Dialog panel for renaming a graph.
 */
public class GraphRenamePanel extends RenamePanel {
    
    private static final ResourceBundle BUNDLE
            = ResourceBundle.getBundle("org.grinvin.list.commands.resources");
    
    /**
     * Construct a panel of this type.
     */
    public GraphRenamePanel() {
        super();
    }
    
    //
    protected String getOldLabelText() {
        return BUNDLE.getString("GraphRenamePanel.name.old");
    }
    
    //
    protected String getNewLabelText() {
        return BUNDLE.getString("GraphRenamePanel.name.new");
    }
    
    //
    protected String getPanelTitle() {
        return BUNDLE.getString("GraphRenamePanel.title");
    }
    
    /**
     * Create and activate the dialog for the given graph list element.
     * When finished, the name of
     * the graph list element will be changed, except when the dialog was canceled
     * by the user.
     * @param gle GraphListElement of which the name can be changed by the user.
     * @param parent Parent of this dialog
     */
    public void showDialog(GraphListElement gle, Component parent) {
        assert gle != null : "Dialog shown without corresponding graph list element";
        GraphBundleView bundle = gle.getBundle();
        int size = Math.min(GrinvinPreferences.INSTANCE.getIntPreference(Preference.GRAPHICON_WIDTH), GrinvinPreferences.INSTANCE.getIntPreference(Preference.GRAPHICON_HEIGHT) - 15) - 10;
        Icon icon = bundle.getGraphIconFactory().createIcon(bundle, size);
        super.showDialog(gle, icon, parent);
    }
    
}
