/* IntegerListEditor.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2007 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.params;

import java.awt.Dimension;
import java.awt.KeyboardFocusManager;
import java.awt.event.ActionEvent;
import java.text.ParseException;
import javax.swing.AbstractAction;
import javax.swing.JFormattedTextField;
import javax.swing.JFormattedTextField.AbstractFormatter;
import javax.swing.KeyStroke;
import javax.swing.text.DefaultFormatterFactory;

/**
 * Default {@link ParameterEditor} for lists of integers. The type implicitely associated
 * with this editor, is {@code org.grinvin.params.IntegerList}.
 */
class IntegerListEditor implements ParameterEditor {
    
    //
    public IntegerList fromText(String string) {
        return new IntegerList(string);
    }
    
    //
    public String toText(Object value) {
        return value.toString();
    }
    
    //
    public ParameterComponent getEditorComponent() {
        return new IntegerListTextField();
    }
    
    //
    private class IntegerListTextField extends JFormattedTextField implements ParameterComponent {
        
        //
        public IntegerListTextField() {
            super(new DefaultFormatterFactory(new IntegerListFormatter()));
            Dimension dim = getPreferredSize();
            dim.width = 60;
            setPreferredSize(dim);
            getInputMap(WHEN_FOCUSED).put(KeyStroke.getKeyStroke("ENTER"), "focusNextComponent");
            getActionMap().put("focusNextComponent", new AbstractAction() {
                public void actionPerformed(ActionEvent ev) {
                    KeyboardFocusManager.getCurrentKeyboardFocusManager().focusNextComponent();
                }
            });
        }
        
        //
        public void setParameterValue(Object value) {
            setValue(value);
        }
        
        //
        public IntegerList getParameterValue() {
            return (IntegerList)getValue();
        }
        
    }
    
    private class IntegerListFormatter extends AbstractFormatter {
        public Object stringToValue(String text) throws ParseException {
            if(text == null)
                return null;
            else
                return new IntegerList(text);
        }

        public String valueToString(Object value) throws ParseException {
            if(value == null)
                return "";
            else
                return value.toString();
        }
        
    }
}
