/* GraphTreeModel.java
 * =========================================================================
 * This file is part of the GrInvIn project - http://www.grinvin.org
 * 
 * Copyright (C) 2005-2008 Universiteit Gent
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or (at
 * your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 * 
 * A copy of the GNU General Public License can be found in the file
 * LICENSE.txt provided with the source distribution of this program (see
 * the META-INF directory in the source jar). This license can also be
 * found on the GNU website at http://www.gnu.org/licenses/gpl.html.
 * 
 * If you did not receive a copy of the GNU General Public License along
 * with this program, contact the lead developer, or write to the Free
 * Software Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA
 * 02110-1301, USA.
 */

package org.grinvin.list.graphs;

import javax.swing.event.TreeModelListener;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreePath;

/**
 *
 */
public class GraphTreeModel implements TreeModel {
    
    //
    private GraphGroup root;
    
    //
    private static final GraphTreeModel STANDARD_TREE
            = new GraphTreeModel(GraphListElementManager.getInstance().getStandardGraphNodes());
    
    
    /**
     * Return the tree model for the standard invariants that come with GrInvIn.
     */
    public static GraphTreeModel getStandardTree() {
        return STANDARD_TREE;
    }
    
    public GraphTreeModel(GraphGroup root) {
        this.root = root;
    }
    
    public Object getRoot() {
        return root;
    }
    
    public Object getChild(Object parent, int index) {
        GraphNode node = (GraphNode)parent;
        if (node.getChildren() != null)
            return node.getChildren().get(index);
        else
            return null;
    }
    
    public int getChildCount(Object parent) {
        GraphNode node = (GraphNode)parent;
        if (node.getChildren() != null)
            return node.getChildren().size();
        else
            return 0;
    }
    
    public boolean isLeaf(Object node) {
        return ((GraphNode)node).getChildren() == null;
    }
    
    public void valueForPathChanged(TreePath path, Object newValue) { }
    
    public int getIndexOfChild(Object parent, Object child) {
        GraphNode node = (GraphNode)parent;
        int i = 0;
        for (GraphNode graphnode : node.getChildren()) {
            if (graphnode == child)
                return i;
            i++;
        }
        return -1;
    }
    
    public void addTreeModelListener(TreeModelListener l) { }
    
    public void removeTreeModelListener(TreeModelListener l) { }
    
}
