/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRootPane;
import org.workingfrog.i18n.swing.I18NJLayeredPane;
import org.workingfrog.i18n.swing.I18NJPanel;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJRootPane
extends JRootPane
implements LocaleListener {
    public I18NJRootPane() {
        this.setGlassPane(this.createGlassPane());
        this.setLayeredPane(new I18NJLayeredPane());
        this.setContentPane(this.createContentPane());
        this.setLayout(this.createRootLayout());
        ((JComponent)this).setDoubleBuffered(true);
        this.updateUI();
    }

    protected Component createGlassPane() {
        I18NJPanel c = new I18NJPanel();
        c.setName(String.valueOf(this.getName()) + ".glassPane");
        c.setVisible(false);
        ((JPanel)c).setOpaque(false);
        return c;
    }

    protected Container createContentPane() {
        I18NJPanel c = new I18NJPanel();
        c.setName(String.valueOf(this.getName()) + ".contentPane");
        c.setLayout(new BorderLayout(){

            public void addLayoutComponent(Component comp, Object constraints) {
                if (constraints == null) {
                    constraints = "Center";
                }
                super.addLayoutComponent(comp, constraints);
            }
        });
        return c;
    }

    public void localeChanged(LocaleEvent event) {
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (Translator.checkObject(components[i], this)) {
                ((LocaleListener)((Object)components[i])).localeChanged(event);
            }
            ++i;
        }
    }
}

