/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import java.awt.Component;
import java.util.HashMap;
import javax.swing.Icon;
import javax.swing.JScrollBar;
import javax.swing.JTabbedPane;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJTabbedPane
extends JTabbedPane
implements LocaleListener {
    private String bundle = "CoreMenu";
    private HashMap i18nKeys = new HashMap();

    public I18NJTabbedPane() {
    }

    public I18NJTabbedPane(int tabPlacement) {
        super(tabPlacement);
    }

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void addTab(String i18nKey, Component component) {
        super.addTab(this.initKey(i18nKey), component);
    }

    public void addTab(String i18nKey, Icon icon, Component component) {
        super.addTab(this.initKey(i18nKey), icon, component);
    }

    public void addTab(String i18nKey, Icon icon, Component component, String tip) {
        super.addTab(this.initKey(i18nKey), icon, component, tip);
    }

    public String getTitleAt(int index) {
        return Translator.checkValue(this.bundle, (String)this.i18nKeys.get(new Integer(index)), this);
    }

    private String initKey(String i18nKey) {
        this.i18nKeys.put(new Integer(this.getTabCount()), i18nKey);
        Translator.checkKey(i18nKey, this);
        return Translator.checkValue(this.bundle, i18nKey, this);
    }

    public void localeChanged(LocaleEvent event) {
        int i = 0;
        while (i < this.getTabCount()) {
            this.setTitleAt(i, Translator.checkValue(this.bundle, (String)this.i18nKeys.get(new Integer(i)), this));
            ++i;
        }
        Component[] components = this.getComponents();
        int i2 = 0;
        while (i2 < components.length) {
            if (!(components[i2] instanceof JScrollBar) && Translator.checkObject(components[i2], this)) {
                ((LocaleListener)((Object)components[i2])).localeChanged(event);
            }
            ++i2;
        }
    }
}

