/*
 * Decompiled with CFR 0.152.
 */
package org.workingfrog.i18n.swing;

import java.awt.Component;
import javax.swing.JTextArea;
import org.workingfrog.i18n.util.LocaleEvent;
import org.workingfrog.i18n.util.LocaleListener;
import org.workingfrog.i18n.util.Translator;

public class I18NJTextArea
extends JTextArea
implements LocaleListener {
    private String bundle = "text";
    private String i18nKey = "text.error";

    public void setBundle(String bundle) {
        this.bundle = bundle;
    }

    public void setText(String i18nKey) {
        Translator.checkKey(i18nKey, this);
        this.i18nKey = i18nKey;
        super.setText(Translator.checkValue(this.bundle, i18nKey, this));
    }

    public void localeChanged(LocaleEvent event) {
        super.setText(Translator.checkValue(this.bundle, this.i18nKey, this));
        Component[] components = this.getComponents();
        int i = 0;
        while (i < components.length) {
            if (!(components[i] instanceof LocaleListener)) {
                Translator.log(2, "I18NJTextArea, N : " + components[i]);
            } else {
                ((LocaleListener)((Object)components[i])).localeChanged(event);
            }
            ++i;
        }
    }
}

