package org.jboss.test.remoting.transport.socket.timeout.idle;

import java.net.Socket;
import java.io.ObjectOutputStream;
import java.io.ObjectInputStream;
import java.io.IOException;
import java.io.BufferedOutputStream;
import java.io.BufferedInputStream;

/**
 * @author <a href="mailto:tom.elrod@jboss.com">Tom Elrod</a>
 */
public class RawClient
{
   protected String address = "localhost";
   protected int port = 6700;

   public boolean enableTcpNoDelay = false;
   public int timeout = 60000;

   private Socket socket = null;

   private ObjectOutputStream oos;
   private ObjectInputStream objInputStream;

   public void startClient()
   {
//      while(true)
//      {
//         try
//         {
//            Thread.sleep(1000);
//         }
//         catch(InterruptedException e)
//         {
//            e.printStackTrace();
//         }

         try
         {
            getSocket();

            oos.writeObject("This is the request");

            //oos.flush();

            oos.reset();
            // to make sure stream gets reset
            // Stupid ObjectInputStream holds object graph
            // can only be set by the client/server sending a TC_RESET
            oos.writeObject(Boolean.TRUE);
            oos.flush();
            oos.reset();


            Object obj = objInputStream.readObject();

            objInputStream.readObject(); // for stupid ObjectInputStream reset

            System.out.println("response: " + obj);

            try
            {
               Thread.currentThread().sleep(60000);
            }
            catch (InterruptedException e)
            {
               e.printStackTrace();
            }

         }
         catch(IOException e)
         {
            e.printStackTrace();
         }
         catch(ClassNotFoundException e)
         {
            e.printStackTrace();
         }
//      }
   }

   public void getSocket() throws IOException
   {
      if(socket == null)
      {
         try
         {
            socket = new Socket(address, port);
            socket.setTcpNoDelay(enableTcpNoDelay);
//            socket.setSoTimeout(timeout);

            BufferedOutputStream out = new BufferedOutputStream(socket.getOutputStream());
//         out.flush();
            BufferedInputStream in = new BufferedInputStream(socket.getInputStream());

            oos = new ObjectOutputStream(out);
            objInputStream = new ObjectInputStream(in);

         }
         catch(IOException e)
         {
            e.printStackTrace();
         }
      }
      else
      {
         oos.reset();
         oos.writeByte(1);
         oos.flush();
         oos.reset();
         objInputStream.readByte();
//         objInputStream.reset();
      }
   }

   public static void main(String[] args)
   {
      RawClient client = new RawClient();
      client.startClient();
   }
}
