package jdepend.framework;

import junit.framework.*;

/**
 * The <code>AllTests</code> class is a test suite 
 * for the JDepend package.
 * 
 * @author <b>Mike Clark</b> (mike@clarkware.com)
 * @author Clarkware Consulting, Inc.
 */

public class AllTests {

	public static Test suite() {
	
		TestSuite suite = new TestSuite("JDepend Test Suite");

		suite.addTestSuite(ClassFileParserTest.class);
        suite.addTestSuite(JarFileParserTest.class);
        suite.addTestSuite(ConstraintTest.class);
        suite.addTestSuite(CycleTest.class);
        suite.addTestSuite(CollectAllCyclesTest.class);
        suite.addTestSuite(FileManagerTest.class);
        suite.addTestSuite(FilterTest.class);
		suite.addTestSuite(MetricTest.class);
        suite.addTestSuite(PropertyConfiguratorTest.class);	
		suite.addTestSuite(ExampleTest.class);
		
		return suite;
	}
		
	public static void main(String[] args) {
		junit.textui.TestRunner.run(suite());
	}
}
