/*
 * Copyright (C) MX4J.
 * All rights reserved.
 *
 * This software is distributed under the terms of the MX4J License version 1.0.
 * See the terms of the MX4J License in the documentation provided with this software.
 */

package javax.management;

import java.util.EventListener;

/**
 * Implemented by an object that want to receive notifications.
 * 
 * @author <a href="mailto:biorn_steedom@users.sourceforge.net">Simone Bordet</a>
 * @version $Revision: 1.5 $
 */
public interface NotificationListener extends EventListener
{
    /**
     * Called when a notification occurs.
     *
     * @param notification The notification object
     * @param handback Helps in associating information regarding the listener.
     */
	public void handleNotification(Notification notification, Object handback);
}
