/* SVN FILE: $Id$ */
/**
* Project Name : ManDVD
*
* @package className
* @subpackage subclassName
* @author $Author$
* @copyright $Copyright$
* @version $Revision$
* @lastrevision $Date$
* @modifiedby $LastChangedBy$
* @lastmodified $LastChangedDate$
* @license $License$
* @filesource $URL$
*/

// C++ Implementation: mandvd
//
// Description: Generic functions for ManDVD interface fuctions
//
// Author  : Gibault Stphane
// Modifier: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution

#include <mandvd.h>
#include <mainfrm.h>

/* Main methods for ManDVD */

/* Showing about dialog */
void mainfrm::aboutdialog_Clicked()
{
    /* Just a simple soundtest :-p */
    QSound sound("/usr/share/sounds/KDE_Click.wav");
    sound.play();

    QMessageBox::about(this, table_message[63] + MANDVDVER,
		       table_message[64] + HOMEPG);
}

/* Show dialog for new project again to be able to change setting on the fly  */
void mainfrm::bt_change_clicked()
{
    QSound sound("/usr/share/sounds/KDE_Click.wav");
    sound.play();

    Etape_02->setDisabled(true);
    toolButton72_2->setDisabled(true);

    newproj->show();
    newproj->raise();
}


/* This sets the current working standard for this video project at startup */
void mainfrm::videostandard_highlighted(const QString & txtvar)
{
    QString txtvalue = txtvar;

    if (txtvalue == "PAL") {
	videosizedef->clear();
	videosizedef->insertItem(HDDVD);
	videosizedef->insertItem(PALDVD);
	videosizedef->insertItem(PALVCD);
	videosizedef->setCurrentItem(1);
    } else {
	videosizedef->clear();
	videosizedef->insertItem(HDDVD);
	videosizedef->insertItem(NTSCDVD);
	videosizedef->insertItem(NTSCVCD);
	videosizedef->setCurrentItem(1);
    }
    /*
       Audioencoding default settings 
     */
    audioencode->setChecked(false);
    audioencode2->setChecked(true);
}


/* Calulate new estimated size of the DVD */
void mainfrm::calculsize()
{
    // *** Calcul de la taille du DVD ***
    bool reencodeMe = true;
    tmp_001 = "";
    p->reset();			// Reset Progressdialog for mencoder

    /* Check if this is a video that shall be reencoded */
    lvideo = lst_video_1->firstChild();

    while (lvideo) {
	/* Check if this is */
	if (lvideo->text(1) == path_video) {
	    // Check if video is marked to reencode. 
	    // Also "9" for all intro movies. Same space is used :-(
	    if (lvideo->text(2) == "1" || lvideo->text(2) == "9")
		reencodeMe = true;
	    else
		reencodeMe = false;

	    break;		// Bail out of while loop if video found
	}
	lvideo = lvideo->nextSibling();
    }

    if (reencodeMe)
	videoSizeCalc();
    else {
	// If not to reencode add the filesize
	QFile myfic(path_video);
	unsigned long tmp_int_001 = (unsigned long) myfic.size();
	tmp_int_001 = ((tmp_int_001 / 1024) / 1024);
	taille_DVD = taille_DVD + tmp_int_001;
	lvideo->setText(8, QString::number((ulong) tmp_int_001));
	myfic.close();
	setDvdInfo();
    }
}


/* New aproach: Try to estimate size with tcprobe. If fail then encode a short
 * while and pic up estimated size from mencoder. 
 */
void mainfrm::videoSizeCalc()
{
    proc_ffmpeg = new QProcess(this);
    proc_ffmpeg->addArgument("tcprobe");	// Was ffmpeg
    proc_ffmpeg->addArgument("-i");
    proc_ffmpeg->addArgument(path_video);

    connect(proc_ffmpeg, SIGNAL(readyReadStdout()), this,
	    SLOT(readFromMPStdout()));
    connect(proc_ffmpeg, SIGNAL(processExited()), this,
	    SLOT(doneFFmpegEncode()));

    if (!proc_ffmpeg->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + "tcprobe :-(");
	sizeCalcMC();		// Try mencoder if tcprobe failed to start
    }
}

void mainfrm::setDvdInfo()
{
    // Set label in the program window for DVD size etc 
    QString temp;

    temp = temp.setNum(dvdsizeMB);
    volume->setText(table_message[52] + "<b>" +
		    QString::number(taille_DVD) + table_message[76] +
		    temp + " MB" + "<br />" + dvdsizedef->currentText() +
		    " " + videostandard->currentText() + " " +
		    videosizedef->currentText());

    bt_et02_con->setEnabled(true);

    /* Disc "might be" full */
    if (taille_DVD > (unsigned long) dvdsizeMB) {
	QMessageBox::warning(this, MANDVDVER, table_message[5]);
    }
    // *** Compteur graphique ***
    QImage tmpimg_1 = prg_001->pixmap()->convertToImage();
    QImage tmpimg_2 = prg_002->pixmap()->convertToImage();
    QImage tmpimg_3 = prg_003->pixmap()->convertToImage();

    bitBlt(&tmpimg_1, 0, 0, &tmpimg_2, 0, 0, -1, -1);

    if (taille_DVD > 0) {
	int wposition;
	wposition = 128 - ((taille_DVD * 128) / dvdsizeMB);

	if (wposition < 0) {
	    wposition = 0;
	}

	bitBlt(&tmpimg_1, 0, wposition, &tmpimg_3, 0, wposition, -1, -1);
    }

    prg_001->setPixmap(tmpimg_1);
    p->hide();			// Hide Progressdialog
    p->reset();			// Reset Progressdialog for mencoder
}

/* Start a process to run mencoder on the video to determine size */
void mainfrm::sizeCalcMC()
{
    // Mencoder is going to run, show Progressdialog
    p->raise();
    p->show();
    p->setProgress(0);

    QString frames = CFRAMES;

    QString mencarg =
	"mencoder -v -frames " + frames +
	" -oac lavc -lavcopts acodec=ac3:abitrate=384 -ovc lavc -of mpeg -mpegopts format=dvd -vf scale="
	+ QString::number(projwid) + ":" + QString::number(projhau) +
	",harddup -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:vrc_maxrate=9800:vbitrate="
	+ QString::number(slidevbitrate->value()) + ":keyint=15:aspect=" +
	video_format + " -ofps 25 \"" + path_video +
	"\" -o \"" "/dev/null\"";

    mencarg = mencarg.utf8();

    QFile sfile(wpathtotalproj + "/sample.sh");

    if (sfile.open(IO_WriteOnly)) {
	sfile.writeBlock("#!/bin/bash\n", 12);
	sfile.writeBlock(mencarg, mencarg.length());
    }

    sfile.close();

    proc_menc = new QProcess(this);
    proc_menc->addArgument("bash");
    proc_menc->addArgument(wpathtotalproj + "/sample.sh");

    connect(proc_menc, SIGNAL(readyReadStdout()), this,
	    SLOT(readMencFromStdout()));
    connect(proc_menc, SIGNAL(processExited()), this,
	    SLOT(doneTestEncode()));

    if (!proc_menc->start()) {
	// If fail add the file size anyway
	QFile myfic(path_video);
	unsigned long tmp = (unsigned long) myfic.size();
	tmp = ((tmp / 1024) / 1024);
	taille_DVD = taille_DVD + tmp;	// Total size of current DVD
	lvideo->setText(8, QString::number((ulong) tmp));	// Current video set size to filesize
    } else {
	// Different message in label while mencoder runs a test encode to pic up size
	volume->setText("<b>" + textLabel5_2->text() + " ? --> " + "/<b>" +
			table_message[76]);
	lvideo->setText(11, "Mencoded");	// Mark as a mencoded size estimate
	Etape_02->setDisabled(true);
    }
}

/* Read info from mencoder stdout to capture estimated size of movie */
void mainfrm::readMencFromStdout()
{
    QString msize = "";

    lineEdit1->setText(proc_menc->readStdout());
    tmp_001 = lineEdit1->text();

    int i = tmp_001.find("fps", 0, true);
    int spos = tmp_001.findRev("mb", i + 25, false);

    if (spos > 10) {
	msize = tmp_001.mid(spos - 4, 4);
    }
    // Set global variable tmp_vsize now holds estimated size
    if (msize.toULong() > 0)
	tmp_vsize = msize;

    // Find data for progressdialog and set value
    i = tmp_001.find("Pos:", 0, true);
    i = tmp_001.find("f", i, TRUE);
    msize = tmp_001.mid(i - 4, 4);

    p->setProgress(msize.toInt());

    if (p->wasCanceled()) {
	proc_menc->tryTerminate();
    }
}


/* After test encoding is done with proc_menc 
*  Pre : Mencoder has been running test encoding to try to pick up size.
*  Post: Globale variable tmp_vsize increase the total DVD estimated size. 
*/
void mainfrm::doneTestEncode()
{
    if (tmp_vsize.toULong() > 0) {
	// Add 20% size for saftey
	unsigned long tvs = (unsigned long) tmp_vsize.toULong() * 1.2;
	taille_DVD = taille_DVD + tvs;
	lvideo->setText(8, QString::number((ulong) tvs));
    } else {
	// If calc with proc_menc failed set size with input file size
	QFile myfic(path_video);
	unsigned long tmp_int_001;
	tmp_int_001 = (unsigned long) myfic.size();
	tmp_int_001 = ((tmp_int_001 / 1024) / 1024);
	// Add 20% size for saftey
	unsigned long tvs = (unsigned long) tmp_int_001 * 1.2;
	tmp_int_001 = tvs;	// Global, is this really needed :-p
	taille_DVD = taille_DVD + tvs;
	lvideo->setText(8, QString::number((ulong) tvs));
    }
    Etape_02->setEnabled(true);
    setDvdInfo();
    p->reset();			// Reset Progresswindow
    readAudioEncMC();		// A bit dangorus test to pick up info without running movie
}


/* Thisfunction runs as a QProcess and produces output in the program console
 * and also some encoding information to the GUI when encoding video.
 */
void mainfrm::readFromMPStdout()
{
    int wid, hig;
    double sizefactor, sizefactorHDTV;
    QString wd, ht, tmp_read;

    unsigned long totalbytesmovie = 0;

    tmp_001 = "";

    lineEdit1->setText(proc_ffmpeg->readStdout());
    tmp_read = lineEdit1->text();

    int i = tmp_read.find(QRegExp("[0-9][0-9][0-9]x[0-9][0-9][0-9]"), 0);

    if (i < 0)
	i = tmp_read.find(QRegExp
			  ("[0-9][0-9][0-9][0-9]x[0-9][0-9][0-9][0-9]"),
			  0);

    sizefactor = 1.0;
    sizefactorHDTV = 1.0;

    // Adjust variabels depending on video format
    if (i > 0) {
	wd = tmp_read.mid(i - 1, 4);
	ht = tmp_read.mid(i + 4, 4);
	wid = wd.toInt();
	hig = ht.toInt();

	/* Asuming higher input quality, calculate for more space */
	if (wid == 720 && hig > 480) {
	    sizefactor = 1.03;
	    sizefactorHDTV = 1.0;
	}

	/* Asuming higher input quality, calculate for more space HDTV input file */
	if (wid > 720 && hig > 480) {
	    sizefactor = 1.03;
	    sizefactorHDTV = 1.1;
	}
    }

    int j = tmp_read.contains("length:");

    if (j > 0) {
	int k = tmp_read.find("duration=");

	if (k > 0) {
	    k = k + 8;
	}

	QString tmpstr = tmp_read.mid(k, 8);
	tmp_read = tmpstr;
    }

    /* Convert time to seconds */
    QString hr = tmp_read.left(2);
    QString mn = tmp_read.mid(3, 2);
    QString sk = tmp_read.right(2);

    int h = hr.toInt();
    int m = mn.toInt();
    int s = sk.toInt();

    /* Must be this type unsigned long, else computation errors */
    unsigned long totalsekmovie = h * 3600 + m * 60 + s;

    if (projwid == 720) {
	totalbytesmovie =
	    totalsekmovie * SCALEFACTOR720 * sizefactor * sizefactorHDTV;
    } else if (projwid == 352) {
	totalbytesmovie = totalsekmovie * SCALEFACTOR480 * sizefactor;
    } else if (projwid == 1280) {
	totalbytesmovie =
	    totalsekmovie * SCALEFACTOR720 * sizefactor * sizefactorHDTV *
	    1.44;
    } else {
	totalbytesmovie = totalsekmovie * SCALEFACTOR352 * sizefactor;
    }

    if (totalsekmovie > 0) {
	QString string;
	tmp_001 = string.setNum(totalbytesmovie);
    }
}


/* This function will run after ffmpeg has finished and calculate encoded video size.
 * ffmpeg is now changed to use tcprobe bu the functon name remains the same.  
 */
void mainfrm::doneFFmpegEncode()
{
    unsigned long tmp_int_001;

    if (tmp_001.toULongLong() > 0) {
	tmp_int_001 = tmp_001.toULongLong();
	tmp_int_001 = ((tmp_int_001 / 1024) / 1024);
	taille_DVD = taille_DVD + tmp_int_001;
	lvideo->setText(8, QString::number((ulong) tmp_int_001));
	setDvdInfo();

	QListViewItem *i = lst_video_1->selectedItem();
	if (i != 0)
	    readAudioEncMC();	// A bit dangorus test o pick up info without running movie
    } else {
	// If calc with proc_ffmpeg failed fall back and try with mencoder
	sizeCalcMC();
    }

}

/* Read from proc_format stdout to find format */
void mainfrm::get_video_format()
{
    tmp_012 = "";
    lineEdit1->setText(proc_format->readStdout());
    tmp_012 = lineEdit1->text();
}


/* Check for known Audioenc 
 * Reads the global variable tmp_001 for outdata genrated from mencoder
 * mencoder needs to run first to pick up data. Sets a symbol in GUI
 * to indicate codec to the user.
 */
void mainfrm::checkAudioEnc()
{
    QListViewItem *i = lst_video_1->selectedItem();
    if (i != 0) {
	mp3_icon->hide();
	dolby_icon->hide();
	mp4_icon->hide();
	wmv_icon->hide();
	flv_icon->hide();

	if (tmp_001.find(MENC_AC3, 0, false) != -1) {
	    dolby_icon->show();
	    i->setText(10, MENC_AC3);
	}

	if (tmp_001.find(FFMP_AC3, 0, false) != -1) {
	    dolby_icon->show();
	    i->setText(10, MENC_AC3);
	}

	if (tmp_001.find(MENC_MP3, 0, false) != -1) {
	    mp3_icon->show();
	    i->setText(10, MENC_MP3);
	}

	if (tmp_001.find(MENC_MP4, 0, false) != -1) {
	    mp4_icon->show();
	    i->setText(10, MENC_MP4);
	}

	if (tmp_001.find(MENC_DIVX, 0, false) != -1) {
	    divx_icon->show();
	    i->setText(10, MENC_DIVX);
	}

	int index = tmp_001.find("AUDIO:", 0, true);

	if (index != -1) {
	    index = tmp_001.find("kbit", index, false);
	    index = tmp_001.findRev(".", index, false);	// pos of point in 384.000
	    tmp_001 = tmp_001.mid(index - 3, 3);

	    int t = tmp_001.toInt(&ok, 10);

	    if (t > 0) {
		i->setText(9, tmp_001);
		textLabelACodec->setText(tmp_001 + " kbit/s");
	    }
	}
    }
}

/* Starts a mencoder process that encodes just a couple of frames to
 * find out which audioencoder that is used in the video */
void mainfrm::readAudioEncMC()
{
    QListViewItem *i = lst_video_1->firstChild();

    while (i) {
	if (i->text(1) == path_video)
	    break;
	i = i->nextSibling();
    }
    if (i != 0) {
	QString frames = "10";
	QString path = i->text(1);
	video_format = i->text(5);

	QString mencarg =
	    "mencoder -v -frames " + frames +
	    " -oac lavc -lavcopts acodec=ac3:abitrate=384 -ovc lavc -of mpeg -mpegopts format=dvd -vf scale="
	    + QString::number(projwid) + ":" +
	    QString::number(projhau) +
	    ",harddup -srate 48000 -af lavcresample=48000 -lavcopts threads=2:vcodec=mpeg2video:vrc_buf_size=1835:vrc_maxrate=9800:vbitrate=5000:keyint=15:aspect="
	    + video_format + " -ofps 25 \"" + path +
	    "\" -o \"" "/dev/null\"";

	mencarg = mencarg.utf8();
	QFile sfile(wpathtotalproj + "/sample.sh");

	if (sfile.open(IO_WriteOnly)) {
	    sfile.writeBlock("#!/bin/bash\n", 12);
	    sfile.writeBlock(mencarg, mencarg.length());
	}

	sfile.close();
	tmp_001 = "";

	proc_001 = new QProcess(this);
	proc_001->addArgument("bash");
	proc_001->addArgument(wpathtotalproj + "/sample.sh");

	connect(proc_001, SIGNAL(readyReadStdout()), this,
		SLOT(test_type_video()));

	if (!proc_001->start()) {
	    QMessageBox::warning(this, MANDVDVER,
				 table_message[0] + "mencoder :-(");
	}
    }
}



/* Main dialog functions */

/* Double click on videolist will play/stop current movie */
void mainfrm::lst_video_1_doubleClicked(QListViewItem *)
{
    QListViewItem *i = lst_video_1->selectedItem();

    if (i != 0) {
	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotStop();
	    checkAudioEnc();
	    buttonGroupMovierun->hide();
	} else {
	    m_pMPlayerWidget->setFilename(i->text(1));
	    m_pMPlayerWidget->slotPlay();
	    readAudioEncMC();	// Movie is playing. Pick up data for audio
	    // Ignore introvideo
	    QString tmp = i->text(2);
	    tmp = tmp.left(1);
	    if (!tmp.contains("9")) {
		updatelistViewSubTitle(i);
		buttonGroupMovierun->show();
	    }
	}
    }
}


/* This function runs when the video list i clicked */
void mainfrm::lst_video_1_selectionChanged()
{
    mp3_icon->hide();
    dolby_icon->hide();
    mp4_icon->hide();
    wmv_icon->hide();
    flv_icon->hide();
    divx_icon->hide();
    textLabelButtonTxt->hide();
    textLabelButtonPic->hide();

    QListViewItem *i = lst_video_1->selectedItem();
    if (lst_video_1->selectedItem() != FALSE) {
	if (i->text(10) == MENC_AC3)
	    dolby_icon->show();
	if (i->text(10) == FFMP_AC3)
	    dolby_icon->show();
	if (i->text(10) == MENC_MP3)
	    mp3_icon->show();
	if (i->text(10) == MENC_MP4)
	    mp4_icon->show();
	if (i->text(10) == MENC_DIVX)
	    divx_icon->show();

	textLabelACodec->setText(i->text(9) + " kbit/s");

	if (i != 0) {
	    if (m_pMPlayerWidget->isPlaying() == true) {
		m_pMPlayerWidget->slotStop();
	    }
	    if (i->text(2) != "9") {
		if (i->text(7) != "") {
		    textLabelButtonPic->raise();
		    textLabelButtonPic->show();
		} else {
		    textLabelButtonTxt->raise();
		    textLabelButtonTxt->show();
		}
	    } else {
		textLabelButtonPic->hide();
	    }

	    pathnamevideo->setText(i->text(1));

	    if (i->text(5) == "") {
		theformat->setText(tr("Video format : ..."));
	    } else {
		theformat->setText(tr("Video format: ") + i->text(5) +
				   tr("  Size: ") + i->text(8) +
				   tr(" MB"));
	    }
	    if (i->text(2) == "0") {
		bt_force->setEnabled(true);
	    } else {
		bt_force->setDisabled(true);
	    }
	    if (i->text(2) == "9") {
		bt_modifier_titre->setDisabled(true);
		bt_cut_film->setDisabled(true);
		bt_chapitres->setDisabled(true);
		bt_gest_sub->setDisabled(true);
		bt_gest_sub_2->setDisabled(true);
		toolButtonAddsubSrt->setDisabled(true);
	    } else {
		bt_modifier_titre->setEnabled(true);
		bt_cut_film->setEnabled(true);
		bt_chapitres->setEnabled(true);
		bt_gest_sub->setEnabled(true);
		bt_gest_sub_2->setEnabled(true);
		toolButtonAddsubSrt->setEnabled(true);
	    }
	    pathnamevideo->show();
	    theformat->show();
	}
    }
}


/* This function will set resolution for the DVD from the 
 * selected value from startup interface. (Hard to debug)
 */
void mainfrm::toolButton72_clicked()
{
    bool recalculate = false;
    double rsfactor = 1.0;	// Init: Resizefactor for mencoded files

    if (lineEdit11->text() != "") {
	newproj->hide();

	QString wl_qtr1 = videosizedef->currentText();
	QString wl_qtr2;
	QString wid, hau;

	int x = wl_qtr1.find("x", 0, FALSE);
	wl_qtr2 = wl_qtr1.mid(0, x);
	rc_001 = wl_qtr2.toInt(&ok, 10);

	if (rc_001 == 1280) {
	    QMessageBox::warning(this, MANDVDVER, table_message[77]);
	    btformat_2->setChecked(TRUE);
	    btformat->setEnabled(FALSE);
	    btformat_mix->setEnabled(FALSE);
	    textLabelHD->show();
	    textLabelHD->raise();
	    btformat->setEnabled(FALSE);
	    slidevbitrate->setValue(6000);
	} else {
	    btformat->setEnabled(TRUE);
	    btformat_mix->setEnabled(TRUE);
	    slidevbitrate->setValue(5000);
	    textLabelHD->hide();
	}

	/* If projekt standard is changed trigger to recalculate */
	if (rc_001 != projwid && projwid != 0) {
	    recalculate = true;

	    // Set factor for mencoded files to avoid run again
	    if (projwid == 1280) {
		if (rc_001 == 720)
		    rsfactor = (1.0 / 1.44);	// 1280 --> 720
		else
		    rsfactor = (1.0 / 1.44) * (2.0 / 3.0);	// 1280 --> 352
	    } else if (projwid == 720) {
		if (rc_001 == 1280)
		    rsfactor = 1.441;	// 720 --> 1280
		else
		    rsfactor = (2.0 / 3.0);	// 720 --> 352 
	    } else {
		if (rc_001 == 720)
		    rsfactor = 1.501;	// 352 --> 720
		else
		    rsfactor = 1.501 * 1.44;	// 352 --> 1280
	    }
	}

	if (ok != true) {
	    projwid = 720;
	} else {
	    projwid = rc_001;
	}

	wl_qtr2 = wl_qtr1.mid(x + 1, 3);
	rc_001 = wl_qtr2.toInt(&ok, 10);

	if (ok != true) {
	    projhau = 576;
	} else {
	    projhau = rc_001;
	}

	/* If projekt standard is changed trigger to recalculate */
	if (videostandard->currentText() == "PAL" && projfps == 29) {
	    recalculate = true;
	}
	if (videostandard->currentText() == "NTSC" && projfps == 25) {
	    recalculate = true;
	}
	// No videos present - Dont recalulate obiously
	if (taille_DVD == 0)
	    recalculate = false;

	if (videostandard->currentText() == "PAL") {
	    projfps = 25;
	} else {
	    projfps = 29;
	    projhau = 480;	// Setting standard resolution for NTSC (Micko)
	}

	// Set maximum size of DVD for estimated vidoes on the DVD
	if (dvdsizedef->currentText() == "DVD5") {
	    dvdsizeMB = SIZEDVD5;
	} else {
	    dvdsizeMB = SIZEDVD9;
	}

	// Update grapichs of used DVD incase media has changed!
	setDvdInfo();

	QString temp;
	temp = temp.setNum(dvdsizeMB);
	volume->setText(table_message[52] + "<b>" +
			QString::number(taille_DVD) + table_message[76] +
			temp + " MB" + "<br />" +
			dvdsizedef->currentText() + " " +
			videostandard->currentText() + " " +
			videosizedef->currentText());

	wid = wid.setNum(projwid);
	hau = hau.setNum(projhau);

	wpathtotalproj = lineEdit11->text();
	path_out->setText(wpathtotalproj);

	Etape_02->setEnabled(true);

	QPixmap wl_pix1(90, 61);
	::bitBlt(&wl_pix1, 0, 0, m_pMPlayerWidget, 10, 0, 90, 61,
		 Qt::CopyROP, false);

	QImage wl_img1 = prevmaskfilm->pixmap()->convertToImage();
	QImage wl_img2 = prevmaskfilm_2->pixmap()->convertToImage();
	QPixmap wl_pix2(wl_img1);
	QPixmap wl_pix3(wl_img2);
	::bitBlt(&wl_pix3, 5, 5, &wl_pix1, 0, 0, -1, -1, Qt::CopyROP,
		 false);
	::bitBlt(&wl_pix3, 0, 0, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP,
		 false);

	bt_ajout_intro->setEnabled(true);

	if (recalculate) {
	    /* Reset size to zero and recalculate */
	    taille_DVD = 0;
	    /* Prepare to run thru the lists of movies */
	    QListViewItem *lvi = lst_video_1->firstChild();

	    /* Now, run thru the lists of movies and claculate size and set encoding info on all items */
	    while (lvi) {
		panneau_titre->setEnabled(true);
		path_video = lvi->text(1);	// This sets the video to be calculated for sixe too !
		video_size_ok = 0;
		video_codec_ok = 0;
		audio_freq_ok = 0;

		/* Check if vido standard is ok to not reencode */
		a_reencoder = "";

		// *** Pickup video information ***
		proc_format = new QProcess(this);
		proc_format->addArgument("tcprobe");
		proc_format->addArgument("-i");
		proc_format->addArgument(path_video);

		connect(proc_format, SIGNAL(readyReadStdout()), this,
			SLOT(get_video_format()));

		if (!proc_format->start()) {
		    QMessageBox::warning(this, MANDVDVER,
					 table_message[0] + "tcprobe");
		}

		/* Wait for process to get video info to finish */
		if (proc_format->isRunning())
		    QTimer::singleShot(1000, proc_format, SLOT(kill()));

		/* Wait for process to get video info to finish */
		if (proc_format->isRunning())
		    sleep(1);

		if (proc_format->normalExit()) {
		    rc_001 = tmp_012.find(" " + wid + "x" + hau, 0);
		    if (rc_001 != -1) {
			video_size_ok = 1;
		    }
		    // Detects its a standard PAL video 
		    rc_001 = tmp_012.find("PTS", 0);

		    if (rc_001 != -1)
			video_codec_ok = 1;

		    rc_001 = tmp_012.find("48000", 0);

		    if (rc_001 != -1)
			audio_freq_ok = 1;

		    if (video_size_ok == 0 || video_codec_ok == 0
			|| audio_freq_ok == 0)
			a_reencoder = "1";
		    else
			a_reencoder = "0";
		}
		// Set audioencode to force AC3 if mp4a audio format found 
		// Experimental. Should be always set if not AC3
		rc_001 = tmp_012.find("mp4a", 0);
		if (rc_001 != -1) {
		    audioencode->setChecked(false);
		    audioencode2->setChecked(true);
		}

		/* Set encoding info */
		lvi->setText(2, a_reencoder);

		/* Could be developed to handle: No reencode in other formats if movies match */
		if (projwid != 720) {
		    // Obviously all movies should be reecoded since it not a standard DVD project
		    lvi->setText(2, "1");
		}

		/* Try to set symbol right to show that this video should be reencoded */
		if (lvi->text(0) != "Introduction video") {

		    if (lvi->text(2) == "1") {
			QImage wl_img1 = lvi->pixmap(0)->convertToImage();
			QPixmap wl_pix1(wl_img1);

			QImage wl_img2 =
			    previcon_3->pixmap()->convertToImage();
			QPixmap wl_pix2(wl_img2);
			::bitBlt(&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1,
				 Qt::CopyROP, false);
			lvi->setPixmap(0, wl_pix1);
			bt_force->setDisabled(true);
		    } else {
			QImage wl_img1 = lvi->pixmap(0)->convertToImage();
			QPixmap wl_pix1(wl_img1);

			QImage wl_img2 =
			    previcon_2->pixmap()->convertToImage();

			QPixmap wl_pix2(wl_img2);
			::bitBlt(&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1,
				 Qt::CopyROP, false);
			lvi->setPixmap(0, wl_pix1);
			bt_force->setEnabled(true);
		    }
		}

		/* Terminate child-process */
		proc_format->tryTerminate();
		QTimer::singleShot(500, proc_format, SLOT(kill()));
		lvi = lvi->nextSibling();
	    }

	    QListViewItem *lst_v = lst_video_1->firstChild();

	    while (lst_v) {
		if (lst_v->text(11) == "Mencoded") {
		    // Mencoded size, dont run again to save time
		    QString tmp = lst_v->text(8);
		    double nsize = tmp.toDouble();
		    nsize = nsize * rsfactor;
		    int tsizem = (int) nsize;
		    lst_v->setText(8, QString::number((int) tsizem));
		    taille_DVD = taille_DVD + tsizem;
		    setDvdInfo();
		    lst_v = lst_v->nextSibling();
		} else {
		    // Need to wait for proc_ffmpeg to finsh. Else corrupt global variables
		    if (!proc_ffmpeg->isRunning()) {	// && !proc_menc->isRunning()) {
			path_video = lst_v->text(1);	// This sets the video to be calculated for size!
			calculsize();
			lst_v = lst_v->nextSibling();
		    } else {
			// Give the process 2 sec to terminate. Else program might hang here?
			QTimer::singleShot(1000, proc_ffmpeg,
					   SLOT(kill()));
		    }
		}
	    }
	}

	/* Prepare to run thru the lists of movies again */
	QListViewItem *lst_v = lst_video_1->firstChild();

	while (lst_v) {
	    /* Disable intro video button if Intro is found. Here it has to be string "9" !? Wierd :-p  */
	    if (lst_v->text(0) == "Introduction video") {
		lst_v->setText(2, "9");	// Intro movie is tagged with 9 on pos 2
		lst_v->setPixmap(0, *previcon_1->pixmap());
		bt_ajout_intro->setDisabled(true);
		bt_supprime_video->setEnabled(true);
		break;
	    }
	    lst_v = lst_v->nextSibling();
	}

    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[9]);
    }
}


/* Just close */
void mainfrm::toolButton72_2_clicked()
{
    this->close();
}


/* Capure a pic from the imported video and add it in the list lst_video_1 */
void mainfrm::capture_image_film()
{
    QPixmap wl_pix1(90, 61);
    ::bitBlt(&wl_pix1, 0, 0, m_pMPlayerWidget, 10, 0, 90, 61, Qt::CopyROP,
	     false);
    QImage wl_img1 = prevmaskfilm->pixmap()->convertToImage();
    QImage wl_img2 = prevmaskfilm_2->pixmap()->convertToImage();
    QPixmap wl_pix2(wl_img1);
    QPixmap wl_pix3(wl_img2);

    ::bitBlt(&wl_pix3, 5, 5, &wl_pix1, 0, 0, -1, -1, Qt::CopyROP, false);
    ::bitBlt(&wl_pix3, 0, 0, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);

    tmp_001 = textLabel2_11->text();
    rc_002 = tmp_001.find(":", 0);

    if (rc_002 != -1) {
	tmp_002 = tmp_001.mid(rc_002 + 2, tmp_001.length() - (rc_002 + 2));
    }

    if (tmp_002 != QString::number(avvalue->value())) {
	a_reencoder = "1";
    }

    wchapitres = "";

    QListViewItem *i =
	new QListViewItem(lst_video_1, titre_element->text(), path_video,
			  a_reencoder, wchapitres,
			  QString::number(audio_bitrate), video_format,
			  "$$" + tmp_002 + "##" +
			  QString::number(avvalue->value()),
			  lineEdit8->text());

    // variable readBitrate holds value from tcprobe read bitrate
    i->setText(12, readBitrate);

    // Choose pixmap symbol for reencode or not
    if (a_reencoder == "0") {
	QImage wl_img3 = previcon_2->pixmap()->convertToImage();
	QPixmap wl_pix4(wl_img3);
	::bitBlt(&wl_pix3, 3, 20, &wl_pix4, 0, 0, -1, -1, Qt::CopyROP,
		 false);
	i->setPixmap(0, wl_pix3);
    } else {
	QImage wl_img3 = previcon_3->pixmap()->convertToImage();
	QPixmap wl_pix4(wl_img3);
	::bitBlt(&wl_pix3, 3, 20, &wl_pix4, 0, 0, -1, -1, Qt::CopyROP,
		 false);
	i->setPixmap(0, wl_pix3);
    }

    wchapitres = "";
    panneau_titre->hide();
    panneau_bouton_1->setEnabled(true);
    nombre_video = nombre_video + 1;

    lst_video_1->setEnabled(true);
    bt_modifier_titre->setEnabled(true);
    bt_gest_sub_2->setEnabled(true);
    bt_supprime_video->setEnabled(true);
    bt_chapitres->setEnabled(true);
    bt_gest_sub->setEnabled(true);
    toolButtonAddsubSrt->setEnabled(true);
    bt_cut_film->setEnabled(true);
    panneau_bouton_1->setEnabled(true);

    // *** Calculate size of DVD (taille du DVD) ***
    calculsize();
    //   
    lst_video_1->setSelected(i, true);
    panneau_titre->setEnabled(true);
}


/******************* INTERFACE NAVIGATION **********************/


/*** INTERFACE (2) Add Media ***
 * Move to next layout menu background from start window. 
 * Etape_02 --> Etape_03
 */
void mainfrm::bt_et02_con_clicked()
{
// *** Validation pour passage � l'�tape 3 ***
    buttonGroupMovierun->hide();
    int nbremini = 0;
    if (bt_ajout_intro->isEnabled() == false) {
	nbremini = 1;
    }
    if (nombre_video > nbremini) {
	Etape_02->hide();
	idtpage->setText(table_message[31]);
	Etape_03->setGeometry(0, 110, 1000, 700);
	// Dont ever show help lines for menu button posision
	zs_1->hide();
	zs_2->hide();
	zs_3->hide();
	zs_4->hide();

	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotStop();
	}
	// Save default menu on disc and point to that as default set
	QPixmap menupix = apercu_fond->pixmap()->convertToImage();
	menupix.save(wpathtotalproj + "/menustd.png", "PNG", -1);
	path_fond = wpathtotalproj + "/menustd.png";

	QImage myimg(path_fond, 0);
	QImage myimg_2 = myimg.smoothScale(940, 540, QImage::ScaleMin);
	QPixmap mypix(myimg_2);
	QPixmap wl_pix1(720, 576);
	wl_pix1.fill(Qt::black);
	// Sets a black frame around the background menu. Good or bad!? Bets me
	QImage wl_img1 = wl_pix1.convertToImage();
	::bitBlt(&wl_pix1, (720 - mypix.width()) / 2,
		 (576 - mypix.height()) / 2, &mypix, 0, 0, -1, -1,
		 Qt::CopyROP, false);

	QImage wl_img2 = wl_pix1.convertToImage();
	save_fond = wl_img2.copy(0, 0, 720, 576, 0);
	// *** Mise en place des fonds d'cran pour le menu ***       
	my_pixmap_001->setPixmap(wl_pix1);

	vframe->hide();
	fautyrencoder = 1;
	Etape_03->show();
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[2]);
    }
}


/*** INTERFACE (3) DVD menu create ***
 * Move backwards from menu background to add mendia
 * Etape_03 --> Etape_02 
 */
void mainfrm::bt_et03_con_2_clicked()
{

// ***********************************
// *** Validation pour passage Etape 2 ***
// ***********************************
    Etape_03->hide();
    idtpage->setText(table_message[30]);
    Etape_02->setGeometry(0, 110, 1000, 700);
    // vframe is the size and location of video preview frame from m_pMPlayerWidget
    vframe->setGeometry(28, 117, 195, 110);
    vframe->show();
    vframe->raise();
    textLabelButtonTxt->hide();
    textLabelButtonPic->hide();
    Etape_02->show();
}


/*** INTERFACE (3) DVD menu create ***
 * Move away from menu background to menu creation with buttons
 * Etape_03 --> Etape_04 
 */
void mainfrm::bt_et03_con_clicked()
{
    // ***********************************
    // *** Validation pour passage  l'tape 4 ***
    // ***********************************
    if (path_fond != "") {
	QString tmp_007;
	Etape_03->hide();
	idtpage->setText(table_message[32]);
	bt_dyna_modif->hide();

	// *** Chargement de la liste des vidos ***
	lst_video_2->clear();

	int cpt_001 = 0;
	int cpt_002;
	int cpt_003;
	int totnumcahpters = 0;

	after_lire->clear();
	after_lire->insertItem(table_message[53], -1);

	QListViewItem *j;
	QListViewItem *lvi = lst_video_1->firstChild();

	// Insert movies in the list for DVD menu creation 
	// I dont get the idea behind the number 39? The answer to everything is supposed to be 42!
	while (cpt_001 < nombre_video) {	//&& cpt_001 < 39) {
	    if (lvi->text(2) != "9") {	// Dont add intro video!
		tmp_001 = lvi->text(0);
		tmp_002 = lvi->text(1);
		tmp_003 = lvi->text(2);
		tmp_004 = lvi->text(3);	// Chapter
		tmp_005 = lvi->text(4);	// Must be subtitle from after conflict 2.6-0 BETA
		tmp_006 = lvi->text(5);
		tmp_007 = lvi->text(6);
		tmp_008 = lvi->text(7);
		after_lire->insertItem(tmp_001, -1);
		j = new QListViewItem(lst_video_2, tmp_001, tmp_002,
				      tmp_003, tmp_004, tmp_005, tmp_006,
				      tmp_007, tmp_008);

		j->setText(12, lvi->text(12));	// The "actual bitrate" to the list also

		// Add chapters under current movie if present
		if (tmp_004.length() > 0) {
		    cpt_002 = 0;
		    cpt_003 = 1;

		    while (tmp_004.mid(cpt_002, 8) != "        ") {
			new QListViewItem(j,
					  prefchap + " " +
					  QString::number(cpt_003),
					  tmp_001 + "|||" +
					  QString::number(cpt_003 + 1),
					  "0", "$$CHAP$$", tmp_005,
					  tmp_006, tmp_007, "");
			cpt_002 = cpt_002 + 9;
			cpt_003 = cpt_003 + 1;

			totnumcahpters++;
		    }
		}
	    }
	    lvi = lvi->nextSibling();
	    cpt_001++;
	}

	totnumbuttons = cpt_001 + totnumcahpters - 1;

	if (totnumbuttons >= MAXNUMMOV) {
	    int chpt = MAXNUMMOV - (cpt_001 - 1);
	    QMessageBox::warning(this, MANDVDVER,
				 tr
				 ("You will not be able to add all chapters if you indended too!\nThere is a limit of max ")
				 + QString::number(MAXNUMMOV) +
				 tr
				 (" buttons in one menu.\nYou can add max ")
				 + QString::number(chpt) +
				 tr
				 (" chapters to the menu.\n Hopefully a future version will have more menus and the problem will be gone."));
	}

	Etape_04->setGeometry(0, 110, 1000, 700);
	my_pixmap_002->setPixmap(*emptymask->pixmap());
	my_pixmap_003->setPixmap(*emptymask->pixmap());
	bt_rename_chap->setDisabled(true);
	bt_tab_order->setDisabled(true);
	bt_maskedit->setDisabled(true);
	bt_add_film_menu->setEnabled(true);
	Etape_04->show();
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[4]);
    }
}


/*** INTERFACE (4) DVD menu ***
 * Button clicked to go to last menu for generating DVD 
 * Etape_04 --> Etape_05 
 */
void mainfrm::bt_et04_con_clicked()
{
// ***********************************
// *** Validation pour passage  l'tape 5 ***
// ***********************************
    if (max_boutons > 0) {
	if (lst_video_2->childCount() == 0) {
	    Etape_04->hide();
	    startfilm->clear();
	    startfilm->insertItem("DVD_Menu", -1);
	    startfilm->insertItem(table_boutons_lien[0][0], -1);
	    idtpage->setText(table_message[33]);
	    optencode->hide();
	    Etape_05->setGeometry(0, 110, 1000, 700);
	    Etape_05->show();
	    prevmaskfilm_3->hide();
	} else {
	    QMessageBox::warning(this, MANDVDVER, table_message[7]);
	}
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[7]);
    }
}

/*** INTERFACE (4) DVD menubuttons ***
 * Move backwards from menu creation to first menu layout 
 * Etape_04 --> Etape_03
 */
void mainfrm::bt_et04_con_2_clicked()
{
// *** Validation pour retour  l'tape 3 ***
    if (max_boutons == 0) {
	Etape_04->hide();
	idtpage->setText(table_message[31]);
	Etape_03->setGeometry(0, 110, 1000, 700);
	Etape_03->show();
    } else {
	if (QMessageBox::question
	    (this, MANDVDVER, table_message[3], table_message[61],
	     table_message[62], QString::null, 0, 1) == 0) {

	    // If menu cleared we must reeencode hole dvd! (If moved back after encoded movie)
	    fautyrencoder = 1;
	    maskeditDone = false;	// Detect if maskedit has been done

	    max_boutons = 0;
	    QPixmap mypix(save_fond);
	    apercu_fond->setPixmap(mypix);
	    my_pixmap_001->setPixmap(mypix);
	    Etape_04->hide();
	    idtpage->setText(table_message[31]);
	    Etape_03->setGeometry(0, 110, 1000, 700);
	    Etape_03->show();
	}
    }
    prevmaskfilm_3->hide();
}


/*** INTERFACE (5) DVD generate ***
 * Move backwards
 * Etape_05 --> Etape_04
 */
void mainfrm::bt_et_05_clicked()
{
    Etape_05->hide();
    myconsole->hide();
    idtpage->setText(table_message[32]);
    Etape_04->setGeometry(0, 110, 1000, 700);
    bt_rename_chap->setDisabled(true);
    Etape_04->show();
}


/* Add a video to the project in main menu */
void mainfrm::add_video_clicked()
{
    buttonGroupMovierun->hide();
    Etape_02->setDisabled(true);
    bt_mainquitprg->setDisabled(true);
    bt_aboutprg->setDisabled(true);
    bt_save_1->setDisabled(true);
    bt_change->setDisabled(true);
    bt_et02_con->setDisabled(true);

    if (nombre_video < MAXNUMMOV) {
	QString myfic =
	    QFileDialog::getOpenFileName(dossier_travail_2, VIDEOS, this,
					 table_message[65],
					 table_message[66]);

	if (myfic.isNull()) {
	    Etape_02->setEnabled(true);
	    bt_mainquitprg->setEnabled(true);
	    bt_aboutprg->setEnabled(true);
	    bt_save_1->setEnabled(true);
	    bt_change->setEnabled(true);
	    bt_et02_con->setEnabled(true);
	} else {
	    // Check if already in list of movies
	    QListViewItem *v = lst_video_1->firstChild();
	    bool inList = FALSE;

	    while (v) {
		if (myfic == v->text(1)) {
		    inList = TRUE;
		    break;
		}
		v = v->nextSibling();
	    }
	    if (inList) {
		QMessageBox::warning(this, MANDVDVER,
				     tr("Movie already added!"));
		Etape_02->setEnabled(true);
		bt_mainquitprg->setEnabled(true);
		bt_aboutprg->setEnabled(true);
		bt_save_1->setEnabled(true);
		bt_change->setEnabled(true);
		bt_et02_con->setEnabled(true);
	    } else {
		int i = myfic.findRev('/');
		if (i != 1) {
		    dossier_travail_2 = myfic.mid(0, i);
		} else {
		    dossier_travail_2 = myfic;
		}
		video_size_ok = 0;
		video_codec_ok = 0;
		audio_freq_ok = 0;
		multiangle = 0;
		audio_bitrate = 0;
		yaaudio = 0;
		type_video = "0";
		rc_004 = 0;
		video_format = "4/3";
		readBitrate = "0";

		pathnamevideo->hide();
		theformat->hide();
		panneau_bouton_1->setDisabled(true);
		lineEdit8->setText("");
		appimgbt->hide();
		panneau_titre->show();
		panneau_titre->raise();
		tmp_001 = myfic;	// path to video

		int cpt_001 = tmp_001.length();

		while (tmp_001.mid(cpt_001, 1) != "/" && cpt_001 != 0) {
		    cpt_001 = cpt_001 - 1;
		}

		if (cpt_001 > 0) {
		    titre_element->setText(tmp_001.mid(cpt_001 + 1,
						       tmp_001.length() -
						       (cpt_001 + 5)));
		} else {
		    titre_element->setText("");
		}

		path_video = myfic;	// Can not be set to UTF8 char for none latin names without trouble
		bt_et02_con->setDisabled(true);
		a_reencoder = "0";

		// *** Pickup video information ***
		proc_001 = new QProcess(this);
		proc_001->addArgument("tcprobe");
		proc_001->addArgument("-i");
		proc_001->addArgument(myfic);

		connect(proc_001, SIGNAL(readyReadStdout()), this,
			SLOT(test_type_video()));
		connect(proc_001, SIGNAL(processExited()), this,
			SLOT(fin_import()));

		tmp_001 = "";

		if (!proc_001->start()) {
		    QMessageBox::warning(this, MANDVDVER,
					 table_message[0] + "tcprobe :-(");
		}
	    }
	}
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[1]);
    }
    Etape_02->setEnabled(true);
}


/* Importing a video to the project: Child process called from add_video_clicked !?*/
void mainfrm::fin_import()
{
    // ****************************************
    // *** Fin de l'importation / contrle des fichiers ***
    // ****************************************
    rc_001 = tmp_001.find(" " + QString::number(projwid) + "x" +
			  QString::number(projhau), 0);

    if (rc_001 != -1) {
	video_size_ok = 1;
    }

    rc_001 = tmp_001.find("PTS", 0);

    if (rc_001 != -1) {
	video_codec_ok = 1;
    }

    rc_001 = tmp_001.find("48000", 0);

    if (rc_001 != -1) {
	audio_freq_ok = 1;
    }

    rc_001 = tmp_001.find("4:3", 0);
    if (rc_001 != -1) {
	video_format = "4/3";
    }

    rc_001 = tmp_001.find("16:9", 0);
    if (rc_001 != -1) {
	video_format = "16/9";
    }

    rc_001 = tmp_001.find("audio track:", 0);
    if (rc_001 != -1) {
	yaaudio = 1;
    }

    rc_001 = tmp_001.find("frame rate: -f 23.9", 0);
    if (rc_001 != -1) {
	readBitrate = "24";
    }

    rc_001 = tmp_001.find("frame rate: -f 25", 0);
    if (rc_001 != -1) {
	readBitrate = "25";
    }

    rc_001 = tmp_001.find("frame rate: -f 29.9", 0);
    if (rc_001 != -1) {
	readBitrate = "30";
    }
    // Works only on mpeg when tcprobe output bitrate
    rc_001 = tmp_001.find("bitrate", 0);

    if (rc_001 != -1 && yaaudio == 1) {
	rc_002 = tmp_001.find("bitrate", rc_001 + 9);
	if (rc_002 != -1 && yaaudio == 1) {
	    tmp_004 = tmp_001.mid(rc_002 + 8, 3);
	    rc_003 = tmp_004.toInt(&ok, 10);
	    if (ok == true) {
		audio_bitrate = rc_003;
	    } else {
		audio_bitrate = 0;
	    }
	}
    }

    rc_001 = tmp_001.find("--av_fine_ms ", 0);
    if (rc_001 != -1) {
	if (tmp_001.mid(rc_001 + 13, 1) != "0") {
	    audio_freq_ok = 0;
	    //
	    tmp_008 = "";
	    rc_003 = rc_001 + 13;
	    while (tmp_001.mid(rc_003, 1) != " ") {
		tmp_008 = tmp_008 + tmp_001.mid(rc_003, 1);
		rc_003 = rc_003 + 1;
	    }
	    textLabel2_11->setText("A/V sync (ms) : " + tmp_008);
	    rc_001 = tmp_008.toInt(&ok, 10);
	    if (ok == true) {
		avvalue->setValue(rc_001);
	    } else {
		avvalue->setValue(0);
	    }
	    //
	} else {
	    tmp_008 = "0";
	    textLabel2_11->setText("A/V sync (ms) : " + tmp_008);
	    avvalue->setValue(0);
	}
    } else {
	tmp_008 = "0";
	textLabel2_11->setText("A/V sync (ms) : " + tmp_008);
	avvalue->setValue(0);
    }

    rc_001 = tmp_001.find("-f " + QString::number(projfps), 0);
    if (rc_001 == -1) {
	audio_freq_ok = 0;
    }

    rc_001 = tmp_001.find("presentation unit", 0);
    if (rc_001 != -1) {
	multiangle = 1;
    }
    //
    if (multiangle == 0) {
	panneau_titre->setEnabled(true);

	if (video_size_ok == 0 || video_codec_ok == 0
	    || audio_freq_ok == 0) {
	    a_reencoder = "1";
	} else {
	    a_reencoder = "0";
	}
    } else {
	// *** DVD Multi angles ***
	panneau_titre->setEnabled(true);
	if (type_video == "0") {
	    a_reencoder = "1";
	} else {
	    a_reencoder = "0";
	}
    }
}

/* Test type of encoding of video */
void mainfrm::test_type_video()
{
    // **********************************
    // *** Test le type d'encodage de la video ***
    // **********************************
    lineEdit1->setText(proc_001->readStdout());
    tmp_001 = tmp_001 + lineEdit1->text();

    // A bit dangerous. MUST BE SCRUTINZED HARD! 
    // This goes together with calls after mencoder or tcprobe has finsched 
    // picking up the video estimated size
    checkAudioEnc();
}



/****  Functions interface to modify a movie *****/


/* Button in Main GUI Etape_02 clicked to mofify a title  */
void mainfrm::bt_modifier_titre_clicked()
{
    buttonGroupMovierun->hide();
    QListViewItem *i = lst_video_1->selectedItem();

    if (i != 0 && i->text(2) != "9") {
	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotStop();
	}

	bt_et02_con->setDisabled(true);
	panneau_bouton_1->setDisabled(true);
	lst_video_1->setDisabled(true);

	tmp_004 = i->text(6);
	rc_003 = tmp_004.find("$$", 0);

	if (rc_003 != -1) {
	    rc_003 = rc_003 + 2;
	    tmp_008 = "";
	    while (tmp_004.mid(rc_003, 2) != "##" && rc_003 < (int) tmp_004.length())	// Cast to avoid cc-warning
	    {
		tmp_008 = tmp_008 + tmp_004.mid(rc_003, 1);
		rc_003 = rc_003 + 1;
	    }
	    textLabel2_11->setText("A/V sync (ms) : " + tmp_008);
	    rc_003 = tmp_004.find("##", 0);
	    if (rc_003 != -1) {
		tmp_008 = "";
		rc_003 = rc_003 + 2;

		while (rc_003 < (int) tmp_004.length()) {	// Cast to avoid cc-warning

		    tmp_008 = tmp_008 + tmp_004.mid(rc_003, 1);
		    rc_003 = rc_003 + 1;
		}

		rc_001 = tmp_008.toInt(&ok, 10);

		if (ok == true) {
		    avvalue->setValue(rc_001);
		} else {
		    avvalue->setValue(0);
		}
	    } else {
		avvalue->setValue(0);
	    }
	} else {
	    textLabel2_11->setText("A/V sync (ms) : 0");
	    avvalue->setValue(0);
	}
	//
	lineEdit8->setText(i->text(7));
	titre_element->setText(i->text(0));
	path_video = i->text(1);
	QString tac = i->text(9);
	audio_bitrate = tac.toInt(&ok, 10);

	if (lineEdit8->text() != "") {
	    QImage myimg(lineEdit8->text(), 0);
	    QPixmap mypix(myimg);
	    appimgbt->setPixmap(mypix);
	    appimgbt->show();
	    appimgbt->raise();
	} else {
	    appimgbt->hide();
	}
	panneau_titre->show();
	panneau_titre->raise();
	rc_004 = 1;
    }
}


/* Extract picture from the video clicked */
void mainfrm::extimgvideo_clicked()
{
    Etape_02->setDisabled(true);
    m_pMPlayerWidget->setFilename(path_video);
    captureframe->setGeometry(320, 170, 360, 390);
    captureframe->show();
    captureframe->raise();
    mediabar->setGeometry(330, 460, 290, 30);
    mediabar->show();
    mediabar->raise();
    vframe->setGeometry(330, 180, 341, 273);
    vframe->show();
    vframe->raise();

    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotStop();
    }
    m_pMPlayerWidget->slotPlay();
}

/* Extrakt and svae a picture from the movie clicked 
 * This picture will then show up in menu creation */
void mainfrm::bt_c_6_clicked()
{
    QListViewItem *i = lst_video_1->selectedItem();


    //QPixmap wl_pix1(90, 61);

    //   ::bitBlt(&wl_pix1, 0, 0, m_pMPlayerWidget, 10, 0, 90, 61, Qt::CopyROP, false);
/*
    QImage wl_img1 = prevmaskfilm->pixmap()->convertToImage();
    QImage wl_img2 = prevmaskfilm_2->pixmap()->convertToImage();
    QPixmap wl_pix2(wl_img1);
    QPixmap wl_pix3(wl_img2);

    ::bitBlt(&wl_pix3, 5, 5, &wl_pix1, 0, 0, -1, -1, Qt::CopyROP, false);
    ::bitBlt(&wl_pix3, 0, 0, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);
*/

    // Pixmap to save on disc
    QPixmap cap_screen(333, 248);
    // Pixmap for videolist
    QPixmap wl_pix5(90, 61);
    QImage img;
    //cap_screen.fill(Qt::black);

    ::bitBlt(&cap_screen, 0, 0, m_pMPlayerWidget, 0, 7, -1, -1,
	     Qt::CopyROP, false);

    QImage wl_img1 = prevmaskfilm->pixmap()->convertToImage();
    QImage wl_img2 = prevmaskfilm_2->pixmap()->convertToImage();
    QPixmap wl_pix2(wl_img1);
    QPixmap wl_pix3(wl_img2);

    ::bitBlt(&wl_pix3, 0, 0, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP, false);

    img = cap_screen.convertToImage();
    img = img.smoothScale(90, 61, QImage::ScaleFree);
    wl_pix5 = QPixmap(img);
    ::bitBlt(&wl_pix3, 5, 5, &wl_pix5, 0, 0, -1, -1, Qt::CopyROP, false);

    // Choose pixmap symbol for reencode or not
    if (a_reencoder == "0") {
	QImage wl_img3 = previcon_2->pixmap()->convertToImage();
	QPixmap wl_pix6(wl_img3);
	::bitBlt(&wl_pix3, 3, 20, &wl_pix6, 0, 0, -1, -1, Qt::CopyROP,
		 false);
	i->setPixmap(0, wl_pix3);
    } else {
	QImage wl_img3 = previcon_3->pixmap()->convertToImage();
	QPixmap wl_pix6(wl_img3);
	::bitBlt(&wl_pix3, 3, 20, &wl_pix6, 0, 0, -1, -1, Qt::CopyROP,
		 false);
	i->setPixmap(0, wl_pix3);
    }

    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotPause();
    }

    QString myfic = QFileDialog::getSaveFileName(path_out->text(),
						 "Images (*.png *.PNG)",
						 this,
						 "Enregistrer", "Images");
    if (!myfic.isNull()) {
	if (myfic.right(4) != ".png" && myfic.right(4) != ".PNG") {
	    myfic = myfic + ".png";
	}

	cap_screen.save(myfic, "PNG");
	btvalidcapture_clicked();
	QImage myimg(myfic, 0);
	QPixmap mypix(myimg);
	appimgbt->setPixmap(mypix);
	appimgbt->show();
	appimgbt->raise();
	lineEdit8->setText(myfic);
    }
}

/* Edit picture from movie with the Gimp */
void mainfrm::extimgvideo_gimp_clicked()
{
    // **************************************
    // *** Modification d'une frame avec the gimp ***
    // **************************************
    if (lineEdit8->text() != "") {
	proc_001 = new QProcess(this);
	proc_001->addArgument("gimp");
	proc_001->addArgument(lineEdit8->text());
	connect(proc_001, SIGNAL(processExited()), this,
		SLOT(fin_thegimp_extractimg()));
	if (!proc_001->start()) {
	    QMessageBox::warning(this, MANDVDVER,
				 table_message[0] + "The Gimp");
	} else {
	    this->setDisabled(true);
	}
    }
}

void mainfrm::fin_thegimp_extractimg()
{
    this->setEnabled(true);
    QImage myimg(lineEdit8->text(), 0);
    QPixmap mypix(myimg);
    appimgbt->setPixmap(mypix);
}




/* Button: Remove a video from the project clicked */
void mainfrm::bt_supprime_video_clicked()
{
    // ******************************************
    // *** Suppression d'une vido de la liste du projet  ***
    // ******************************************
    buttonGroupMovierun->hide();
    int nbremini = 0;

    QListViewItem *i = lst_video_1->selectedItem();

    if (i != 0) {
	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotStop();
	}
	// Pick up size from Videolist insted of running everything backwards :-p 
	tmp_vsize = i->text(8);	// Column for the estimated size of video
	taille_DVD = taille_DVD - tmp_vsize.toUInt();
	path_video = i->text(1);
	nombre_video = nombre_video - 1;

	if (nombre_video == 0)
	    taille_DVD = 0;

	setDvdInfo();

	// *** Removal of Introvideo code for it is "9" ***
	if (i->text(2) == "9") {
	    bt_ajout_intro->setEnabled(true);
	    pathintro = "";
	}

	if (bt_ajout_intro->isEnabled() == false) {
	    nbremini = 1;
	}
	// Remove the video from the list
	lst_video_1->takeItem(i);
	pathnamevideo->hide();
	theformat->hide();
	//

	// Remove the subtitles for this video
	removeSubTitlesMovie(i);	// Backed and frontend

	if (lst_video_1->childCount() == nbremini) {
	    bt_force->setDisabled(true);

	    if (nbremini != 1) {
		bt_supprime_video->setDisabled(true);
	    }

	    bt_gest_sub->setDisabled(true);
	    toolButtonAddsubSrt->setDisabled(true);
	    bt_chapitres->setDisabled(true);
	    bt_modifier_titre->setDisabled(true);
	    bt_gest_sub_2->setDisabled(true);
	    toolButtonAddsubSrt->setDisabled(true);
	    bt_cut_film->setDisabled(true);
	    volume->setText(table_message[52] + "<B>0 MB</B>");
	    taille_DVD = 0;
	} else {
	    lst_video_1->setSelected(lst_video_1->currentItem(), true);
	}
    }
}


/* Cancel choose title for video */
void mainfrm::bt_cancel_titre_clicked()
{
    // ***********************************
    // *** On annule l'ajout du titre  la video ***
    // ***********************************
    panneau_titre->hide();
    lst_video_1->setEnabled(true);
    panneau_bouton_1->setEnabled(true);
    bt_et02_con->setEnabled(true);
    wchapitres = "";

    bt_mainquitprg->setEnabled(true);
    bt_aboutprg->setEnabled(true);
    bt_save_1->setEnabled(true);
    bt_change->setEnabled(true);
    bt_et02_con->setEnabled(true);
}

/* Force to reecode video */
void mainfrm::bt_force_clicked()
{
    QListViewItem *i = lst_video_1->selectedItem();

    if (i != 0) {
	QImage wl_img1 = i->pixmap(0)->convertToImage();
	QPixmap wl_pix1(wl_img1);

	QImage wl_img2 = previcon_3->pixmap()->convertToImage();
	QPixmap wl_pix2(wl_img2);

	::bitBlt(&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP,
		 false);
	i->setPixmap(0, wl_pix1);
	i->setText(2, "1");
	bt_force->setDisabled(true);
    }
}

/* Add movie clicked OK after GUI is visible for Title edit etc 
 *( mPlayerWidget running) 
 */
void mainfrm::bt_add_cont_clicked()
{
    // *********************************
    // *** Ajout  du film  la liste des vidos ***
    // *********************************
    if (titre_element->text() != "") {
	if (rc_004 == 0) {
	    m_pMPlayerWidget->setFilename(path_video);
	    m_pMPlayerWidget->slotPlay();
	    m_pMPlayerWidget->slotSeek(50, 1);	//TEST MB

	    panneau_titre->setDisabled(true);
	    // ***Cration d'un timer ***
	    mytimer = new QTimer(this);
	    connect(mytimer, SIGNAL(timeout()),
		    SLOT(capture_image_film()));
	    mytimer->start(3000, true);
	} else {
	    QListViewItem *i = lst_video_1->selectedItem();

	    if (i != 0) {
		tmp_001 = textLabel2_11->text();
		rc_002 = tmp_001.find(":", 0);

		if (rc_002 != -1) {
		    tmp_002 =
			tmp_001.mid(rc_002 + 2,
				    tmp_001.length() - (rc_002 + 2));
		}

		if (tmp_002 != QString::number(avvalue->value())) {
		    a_reencoder = "1";
		    i->setText(2, "1");
		    i->setPixmap(0, *previcon_3->pixmap());
		    //
		    QImage wl_img1 = i->pixmap(0)->convertToImage();
		    QPixmap wl_pix1(wl_img1);
		    QImage wl_img2 =
			previcon_3->pixmap()->convertToImage();
		    QPixmap wl_pix2(wl_img2);
		    ::bitBlt(&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1,
			     Qt::CopyROP, false);
		}

		i->setText(6,
			   "$$" + tmp_002 + "##" +
			   QString::number(avvalue->value()));
		i->setText(0, titre_element->text());
		i->setText(7, lineEdit8->text());

		panneau_titre->hide();
		lst_video_1->setEnabled(true);
		bt_modifier_titre->setEnabled(true);
		bt_supprime_video->setEnabled(true);
		bt_chapitres->setEnabled(true);
		bt_et02_con->setEnabled(true);
		panneau_bouton_1->setEnabled(true);
	    }
	}
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[6]);
    }
    bt_mainquitprg->setEnabled(true);
    bt_aboutprg->setEnabled(true);
    bt_save_1->setEnabled(true);
    bt_change->setEnabled(true);
    bt_et02_con->setEnabled(true);
}


/* Add introduction video on DVD!? m_pMPlayerWidget */
void mainfrm::bt_ajout_intro_clicked()
{

    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotStop();
    }
    QString myfic =
	QFileDialog::getOpenFileName(dossier_travail_2, VIDEOS, this,
				     table_message[65], table_message[66]);
    if (myfic.isNull()) {
    } else {
	int ia = myfic.findRev('/');
	if (ia != 1) {
	    dossier_travail_2 = myfic.mid(0, ia);
	} else {
	    dossier_travail_2 = myfic;
	}
	// Path to introduction movie
	pathintro = myfic;	// Might need to be converted to UTF8 for none latin chars

	QListViewItem *i =
	    new QListViewItem(lst_video_1, "Introduction video", pathintro,
			      "9",
			      "", "", video_format, "", "");

	i->setPixmap(0, *previcon_1->pixmap());
	bt_ajout_intro->setDisabled(true);
	bt_supprime_video->setEnabled(true);
	nombre_video = nombre_video + 1;
	path_video = myfic;
	calculsize();
    }
}



/* The Gimp functions: Start extrenal process */
void mainfrm::bt_modif_gimp_2_clicked()
{
    proc_001 = new QProcess(this);
    proc_001->addArgument("gimp");
    proc_001->addArgument(table_images[num_photo->value() - 1][0]);
    connect(proc_001, SIGNAL(processExited()), this,
	    SLOT(fin_thegimp_2()));

    if (!proc_001->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + "The Gimp");
    } else {
	this->setDisabled(true);
    }
}

void mainfrm::fin_thegimp_2()
{
    QPixmap loadimg(table_images[num_photo->value() - 1][0]);
    QImage myimg = loadimg.convertToImage();
    QImage myimg_2 = myimg.smoothScale(320, 256, QImage::ScaleMax);
    QLabel *pntloc = table_pnt_img[num_photo->value() - 1];
    pntloc->setPixmap(myimg_2);
    apercu_photo_diapo->setPixmap(myimg_2);
    this->setEnabled(true);
}


/********* PROJECT SAVE AND LOAD FROM DISC ***********************************************************/

/* Open and restore a saved project */
void mainfrm::goopenproj(QString myfic)
{
    QString myrec;
    QFile myfichier(myfic);
    QTextStream mystream(&myfichier);
    QListViewItem *j;
    QString tmp_007;
    QImage wl_img1;
    nombre_video = 0;
    taille_DVD = 0;

    bt_ajout_intro->setEnabled(true);

    if (myfichier.open(IO_ReadOnly)) {
	myrec = mystream.readLine();
	rc_001 = myrec.toInt(&ok, 10);

	if (ok != true) {
	    projfps = 25;
	} else {
	    projfps = rc_001;
	}

	if (projfps == 25)
	    videostandard->setCurrentItem(0);
	else
	    videostandard->setCurrentItem(1);

	myrec = mystream.readLine();
	rc_001 = myrec.toInt(&ok, 10);

	if (ok != true) {
	    projhau = 576;
	} else {
	    projhau = rc_001;
	}

	myrec = mystream.readLine();
	rc_001 = myrec.toInt(&ok, 10);

	if (ok != true) {
	    projwid = 720;
	} else {
	    projwid = rc_001;
	}

	if (projwid == 1280) {
	    textLabelHD->show();
	    textLabelHD->raise();
	    slidevbitrate->setValue(6000);
	    btformat_2->setChecked(TRUE);
	    btformat->setEnabled(FALSE);
	    btformat_mix->setEnabled(FALSE);
	} else {
	    textLabelHD->hide();
	    slidevbitrate->setValue(5000);
	    btformat->setEnabled(TRUE);
	    btformat_mix->setEnabled(TRUE);
	}

	if (projwid == 720)
	    videosizedef->setCurrentItem(1);
	else if (projwid == 1280)
	    videosizedef->setCurrentItem(0);
	else
	    videosizedef->setCurrentItem(2);

	myrec = mystream.readLine();

	// Restor project out destination for encoding files etc
	// What happens if folder removed!? 
	wpathtotalproj = myrec;
	path_out->setText(wpathtotalproj);
	dossier_travail_2 = myrec;	// Open file dialogs
	dossier_travail = myrec;

	myrec = mystream.readLine();
	bt_ajout_intro->setEnabled(true);

	while (mystream.atEnd() == false && myrec != "$$FINMEDIAS$$") {
	    myrec = mystream.readLine();
	    tmp_001 = myrec;
	    myrec = mystream.readLine();
	    tmp_002 = myrec;
	    myrec = mystream.readLine();
	    tmp_003 = myrec;
	    myrec = mystream.readLine();
	    tmp_004 = myrec;
	    myrec = mystream.readLine();
	    tmp_005 = myrec;
	    myrec = mystream.readLine();
	    tmp_006 = myrec;
	    myrec = mystream.readLine();
	    tmp_007 = myrec;
	    myrec = mystream.readLine();
	    tmp_008 = myrec;
	    myrec = mystream.readLine();
	    tmp_vsize = myrec;	// The estimated size of encoded video
	    myrec = mystream.readLine();
	    QString tmp_abit = myrec;	// Audio bitrate of video
	    myrec = mystream.readLine();
	    QString tmp_acod = myrec;	// Audio codec size of video
	    myrec = mystream.readLine();
	    QString tmp_mcod = myrec;	// Mark: Size estimate from mencoder
	    myrec = mystream.readLine();
	    QString tmp_bitr = myrec;	// Mark: Size estimate from mencoder
	    // Insert item into the videolist lst_video_1
	    j = new QListViewItem(lst_video_1, tmp_001, tmp_002, tmp_003,
				  tmp_004, tmp_005, tmp_006, tmp_007,
				  tmp_008);

	    // Must restore all columns
	    j->setText(8, QString::number((ulong) tmp_vsize.toULong()));
	    j->setText(9, tmp_abit);
	    j->setText(10, tmp_acod);
	    j->setText(11, tmp_mcod);
	    j->setText(12, tmp_bitr);

	    wl_img1.load(savepathproj + "/minbtsize" +
			 QString::number(nombre_video) + j->text(0) +
			 ".png");

	    j->setPixmap(0, wl_img1);
	    nombre_video = nombre_video + 1;
	    path_video = tmp_002;

	    // *** Calcul de la taille du DVD ***
	    // Add video size to total size of DVD
	    taille_DVD = taille_DVD + tmp_vsize.toUInt();

	    /* Disable introvideobutton if intro is found */
	    if (j->text(2) == "9") {
		bt_ajout_intro->setDisabled(true);
		pathintro = j->text(1);
	    }
	    myrec = mystream.readLine();
	}

	// Restore subtitles for DVD-burn to disc
	listViewSubTitle_2->clear();

	int x = myfic.findRev(".");
	myfic = myfic.mid(0, x);
	myfic = myfic + "_subs.sma";
	QFile infile(myfic);
	QTextStream instream(&infile);

	if (infile.open(IO_ReadOnly)) {
	    myrec = instream.readLine();
	    while (instream.atEnd() == false && myrec != "$$FINMEDIAS$$") {
		myrec = instream.readLine();
		tmp_001 = myrec;
		myrec = instream.readLine();
		tmp_002 = myrec;
		myrec = instream.readLine();
		tmp_003 = myrec;
		::new QListViewItem(listViewSubTitle_2, tmp_001, tmp_002,
				    tmp_003);
		myrec = instream.readLine();
	    }
	    infile.close();

	} else {
	    QMessageBox::warning(this, MANDVDVER,
				 tr
				 ("Could not find a subtitle file for this project!"));
	}

	newproj->hide();
	lineEdit11->setText(wpathtotalproj);
	Etape_02->setEnabled(true);
	lst_video_1->setEnabled(true);
	bt_modifier_titre->setEnabled(true);
	bt_gest_sub_2->setEnabled(true);
	bt_supprime_video->setEnabled(true);
	bt_chapitres->setEnabled(true);
	bt_gest_sub->setEnabled(true);
	toolButtonAddsubSrt->setEnabled(true);
	bt_cut_film->setEnabled(true);
	panneau_bouton_1->setEnabled(true);

	// Set maximum size of DVD for estimated vidoes on the DVD
	if (dvdsizedef->currentText() == "DVD5") {
	    dvdsizeMB = SIZEDVD5;
	} else {
	    dvdsizeMB = SIZEDVD9;
	}
	setDvdInfo();
    }
}

/* Save a current project to disc */
void mainfrm::gosaveproj(QString fic)
{
    QFile outfic(fic);

    if (outfic.open(IO_WriteOnly)) {
	/* Test to sort before saving */
	lst_video_1->setSorting(2, true);
	lst_video_1->sort();

	int cpt_001 = 0;
	QImage wl_img1;
	QString tmp_007;
	tmp_001 = QString::number(projfps);
	outfic.writeBlock(tmp_001 + "\n", tmp_001.length() + 1);
	tmp_001 = QString::number(projhau);
	outfic.writeBlock(tmp_001 + "\n", tmp_001.length() + 1);
	tmp_001 = QString::number(projwid);
	outfic.writeBlock(tmp_001 + "\n", tmp_001.length() + 1);
	tmp_001 = wpathtotalproj;	// Location of Video projekt ??
	outfic.writeBlock(tmp_001 + "\n", tmp_001.length() + 1);

	QListViewItem *lvi = lst_video_1->firstChild();

	path_out->setText(savepathproj);	// Set path_out temorary for save directory

	while (cpt_001 < nombre_video && cpt_001 < 39) {
	    tmp_001 = lvi->text(0);
	    tmp_002 = lvi->text(1);
	    tmp_003 = lvi->text(2);
	    tmp_004 = lvi->text(3);
	    tmp_005 = lvi->text(4);	// Subtitle now
	    tmp_006 = lvi->text(5);
	    tmp_007 = lvi->text(6);
	    tmp_008 = lvi->text(7);
	    tmp_vsize = lvi->text(8);	// Estimated size of video
	    QString tmp_abit = lvi->text(9);	// Audio bitrate of video
	    QString tmp_acod = lvi->text(10);	// Audio codec size of video
	    QString tmp_mcod = lvi->text(11);	// Marked if size estimated with mencoder
	    QString tmp_bitr = lvi->text(12);	// Marked if size estimated with mencoder
	    //
	    outfic.writeBlock("$$MEDIAS$$\n", 11);
	    outfic.writeBlock(tmp_001 + "\n", tmp_001.length() + 1);
	    outfic.writeBlock(tmp_002 + "\n", tmp_002.length() + 1);
	    outfic.writeBlock(tmp_003 + "\n", tmp_003.length() + 1);
	    outfic.writeBlock(tmp_004 + "\n", tmp_004.length() + 1);
	    outfic.writeBlock(tmp_005 + "\n", tmp_005.length() + 1);
	    outfic.writeBlock(tmp_006 + "\n", tmp_006.length() + 1);
	    outfic.writeBlock(tmp_007 + "\n", tmp_007.length() + 1);
	    outfic.writeBlock(tmp_008 + "\n", tmp_008.length() + 1);
	    outfic.writeBlock(tmp_vsize + "\n", tmp_vsize.length() + 1);
	    outfic.writeBlock(tmp_abit + "\n", tmp_abit.length() + 1);
	    outfic.writeBlock(tmp_acod + "\n", tmp_acod.length() + 1);
	    outfic.writeBlock(tmp_mcod + "\n", tmp_mcod.length() + 1);
	    outfic.writeBlock(tmp_bitr + "\n", tmp_bitr.length() + 1);
	    //

	    wl_img1 = lvi->pixmap(0)->convertToImage();
	    wl_img1.save(path_out->text() + "/minbtsize" +
			 QString::number(cpt_001) + lvi->text(0) + ".png",
			 "PNG");
	    //
	    lvi = lvi->nextSibling();
	    cpt_001 = cpt_001 + 1;
	}
	// Restore active path for project
	path_out->setText(wpathtotalproj);

	outfic.writeBlock("$$FINMEDIAS$$\n", 14);
	outfic.close();

	// Save subtitles for DVD-burn to disc
	int x = fic.findRev(".");
	fic = fic.mid(0, x);
	fic = fic + "_subs.sma";
	QFile outfile(fic);

	if (outfile.open(IO_WriteOnly)) {
	    QListViewItem *lsub = listViewSubTitle_2->firstChild();
	    while (lsub) {
		tmp_001 = lsub->text(0);
		tmp_002 = lsub->text(1);
		tmp_003 = lsub->text(2);
		outfile.writeBlock("$$MEDIAS$$\n", 11);
		outfile.writeBlock(tmp_001 + "\n", tmp_001.length() + 1);
		outfile.writeBlock(tmp_002 + "\n", tmp_002.length() + 1);
		outfile.writeBlock(tmp_003 + "\n", tmp_003.length() + 1);
		lsub = lsub->nextSibling();
	    }
	    outfile.writeBlock("$$FINMEDIAS$$\n", 14);
	    outfile.close();

	} else {
	    QMessageBox::warning(this, MANDVDVER, table_message[8]);
	}

	QMessageBox::warning(this, MANDVDVER, table_message[39]);
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[8]);
    }
}


/* Save and Open project functions */
void mainfrm::toolButton168_2_clicked()
{
    if (savepathproj == "") {
	QDir currentDir = QDir::home();
	QString savepathproj = currentDir.path() + MANDVDSAVE;
    }

    QString myfic = QFileDialog::getOpenFileName(savepathproj,
						 "Pro ManDVD (*.pma)",
						 this, table_message[74],
						 table_message[74]);
    if (savepathproj.isNull()) {
    } else {

	/* Testing MB: Loading a new project while program is running */
	lst_video_1->clear();
	taille_DVD = 0;
	bt_ajout_intro->setEnabled(true);

	// If save project path is changed it must update savepathproj
	int pos = myfic.findRev("/");
	QString test = myfic.mid(0, pos);
	if (test != savepathproj) {
	    savepathproj = test;
	}
	goopenproj(myfic);
    }
}

/* Function to choose destination folder for the projekt to be saved */
void mainfrm::bt_save_1_clicked()
{
    if (savepathproj == "") {
	QDir currentDir = QDir::home();
	savepathproj = currentDir.path() + MANDVDSAVE;
    }

    QString myfic = QFileDialog::getSaveFileName(savepathproj,
						 "Projet ManDVD (*.pma)",
						 this,
						 tr("Sauvegarde projet"),
						 tr("Sauvegarde projet"));
    if (myfic.isNull()) {
    } else {
	if (myfic.right(4) != ".pma") {
	    myfic = myfic + ".pma";
	}
	// If save project path is changed it must update savepathproj
	int pos = myfic.findRev("/");
	QString test = myfic.mid(0, pos);
	if (test != savepathproj) {
	    savepathproj = test;
	}
	gosaveproj(myfic);	// The file for project
    }
}

/* Choose destination of DVD-project location */
void mainfrm::toolButton71_clicked()
{
    QDir currentDir = QDir::home();
    QString myfic = currentDir.path() + QDir::separator();

    myfic = QFileDialog::getExistingDirectory(myfic,
					      this,
					      tr("Folder destination"),
					      table_message[70], TRUE);
    if (myfic.isNull()) {
    } else {
	lineEdit11->setText(myfic);
	wpathtotalproj = myfic;	// Critical, I forgot how its used :-(
	dossier_travail_2 = myfic;	// Set open file dialog to same as proj for a starter. 
	dossier_travail = myfic;
    }
}



/*
 *  TERMINATING PROGRAM
 */

/* This function starts process to clean up temporary files when closing down program */
void mainfrm::bt_quit_clicked()
{
    // ****************************
    // *** Fermeture de l'application ***
    // ****************************

    proc_001 = new QProcess(this);
    proc_001->addArgument("bash");
    proc_001->addArgument(wpathtotalproj + "nettoyageglobal.sh");

    connect(proc_001, SIGNAL(processExited()), this, SLOT(fin_netttout()));
    proc_001->start();

}

/* Just to close down */
void mainfrm::fin_netttout()
{
    this->close();
}

/* What will happen when user wants to exit prog
 * User should not be able to close down on main window
 * without a warning dialog. 
 */
void mainfrm::closeEvent(QCloseEvent * qcloseevent)
{

    if (QMessageBox::question
	(this, MANDVDVER, table_message[17], table_message[61],
	 table_message[62], QString::null, 0, 1) == 0) {
	QFile myfic_2(wpathtotalproj + "nettoyageglobal.sh");
	if (myfic_2.open(IO_WriteOnly)) {
	    tmp_001 = "#!/bin/bash\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "cd " + wpathtotalproj + "\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f gibmenanim*.*\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f gibvideo*.*\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f genmenu*.*\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f dvdauthor.xml\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f encode.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f menu.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f normal.jpg\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f cliquee.png\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f survolee.png\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f silent.*\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f sample.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f gravage.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f nettoyage.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f geneffetsanim.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f limagefond.png\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f tmplimagefond.png\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    /* More files to remove on close down */
	    tmp_001 = "rm -f gibintromenu.mpg\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f spmuxGV*.xml\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f empty.srt\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f spmuxmandvd.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f menustd.png\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f convertimg.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    // Clean up some after slideshow
	    tmp_001 = "rm -f GIBtmpphoto*.png\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f gendiapo.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    //
	    tmp_001 = "rm -f " + lockfile + "\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    tmp_001 = "rm -f nettoyageglobal.sh\n";
	    myfic_2.writeBlock(tmp_001, tmp_001.length());
	    myfic_2.close();
	}

	bt_quit_clicked();
	qcloseevent->accept();
	delete(p);		// Delete progressbar
	return;
    }
}


/*
*  Functions belonging to DVD-menu generation process
*/


/* Go to enode/burn DVD !? */
void mainfrm::bt_param_encode_clicked()
{
    if (optencode->isVisible() == true) {
	optencode->hide();
    } else {
	fautyrencoder = 1;	// Set 1 to reenccode all movies on dvd
	optencode->show();
	optencode->raise();
    }
}


/*Slide: Videobitrate value before burning */
void mainfrm::slidevbitrate_valueChanged(int)
{
    textLabel1_29->setText(tr("Video bitrate : ") +
			   QString::number(slidevbitrate->value()) +
			   " kb/s");
}


/* Create iso-image */
void mainfrm::bt_grave_3_clicked()
{
    pb_009->setProgress(0);
    creation_iso->setGeometry(314, 329, 371, 42);
    creation_iso->show();
    creation_iso->raise();
    rc_001 = 0;
    Etape_05->setDisabled(true);
    proc_003 = new QProcess(this);
    proc_003->addArgument("mkisofs");
    proc_003->addArgument("-o");
    proc_003->addArgument(path_out->text() + "/Mandvdiso.iso");
    proc_003->addArgument("-dvd-video");
    proc_003->addArgument(path_out->text() + "/DVD/");

    connect(proc_003, SIGNAL(readyReadStderr()), this,
	    SLOT(stdout_mkiso()));
    connect(proc_003, SIGNAL(processExited()), this, SLOT(fin_iso()));

    if (!proc_003->start()) {
	QMessageBox::warning(this, MANDVDVER,
			     table_message[0] + "mkisofs");
    }
}

/* Process dvd iso-file */
void mainfrm::stdout_mkiso()
{
    // ****************************
    // *** Lecture de la sortie console ***   
    // ****************************
    lineEdit1->setText(proc_003->readStderr());
    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find("%", 0);
    if (rc_001 != -1) {
	tmp_002 = tmp_001.mid(1, 2);
	rc_001 = tmp_002.toInt(&ok, 10);
	if (ok == true) {
	    pb_009->setProgress(rc_001);
	}
    }
    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find("error", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }

    tmp_001 = lineEdit1->text();
    rc_001 = tmp_001.find(" not recognized", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }

    rc_001 = tmp_001.find("Unable", 0);
    if (rc_001 != -1) {
	rc_002 = 1;
    }
    lecture_console->append(lineEdit1->text());
    lecture_console->append(proc_003->readStdout());
}

/* Finish dvd iso-file */
void mainfrm::fin_iso()
{
    if (rc_002 == 0) {
	pb_009->setProgress(100);
	QMessageBox::warning(this, MANDVDVER,
			     table_message[36] + path_out->text() +
			     "Mandvdiso.iso");
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[37]);
    }
    creation_iso->hide();
    Etape_05->setEnabled(true);
}

/* Generate DVD with K3b */
void mainfrm::bt_grave_2_clicked()
{
    // ******************************
    // *** Generation du DVD avec K3B ***
    // ******************************
    proc_003 = new QProcess(this);
    proc_003->addArgument("k3b");
    proc_003->addArgument("--videodvd");
    proc_003->addArgument(path_out->text() + "DVD/AUDIO_TS");
    proc_003->addArgument(path_out->text() + "DVD/VIDEO_TS");
    if (!proc_003->start()) {
	QMessageBox::warning(this, MANDVDVER, table_message[0] + "k3b");
    }
}

/* Hide or show program console */
void mainfrm::affconsole_clicked()
{
    if (myconsole->isVisible() == true) {
	myconsole->hide();
    } else {
	myconsole->show();
	myconsole->raise();
    }
}
