/* SVN FILE: $Id$ */
/**
* Project Name : ManDVD
*
* @package className
* @subpackage subclassName
* @author $Author$
* @copyright $Copyright$
* @version $Revision$
* @lastrevision $Date$
* @modifiedby $LastChangedBy$
* @lastmodified $LastChangedDate$
* @license $License$
* @filesource $URL$
*/
/****************************************************************************
** ManDVD
**
** Created: Mon May 08 14:00:00 2006
**      by: Gibault Stphane
**	Hacked on by Mikael Bhm micko@bag.org
**
** This is a tool for simply creating DVD Video
** 
****************************************************************************/
//
// C++ Implementation: chapter management
//
// Description: Functions (backend) for editing subtitles
//
//
// Author: Mikael Bhm <micko@bag.org>, (C) 2008
//
// Copyright: See COPYING file that comes with this distribution
//

#include <subtitle.h>
#include <mainfrm.h>

/* Subtitles managing functions */


/* Function that inserts all subs for choosen movie in lst_video_1 in GUI
 * Primary key for matching is path to the selected video. 
 * Pre : List for GUI listViewSubTitle is in unknown state
 * Post: List is cleared and updated from the backen subtitle data. 
 */
void mainfrm::updatelistViewSubTitle(QListViewItem * i)
{
    QListViewItem *lsub = listViewSubTitle_2->firstChild();	//Backend

    listViewSubTitle->clear();

    while (lsub) {
	if (i->text(1) == lsub->text(2)) {	// Match
	    ::new QListViewItem(listViewSubTitle, lsub->text(0),
				lsub->text(1), lsub->text(2));
	}
	lsub = lsub->nextSibling();
    }
    textLabelMRname->setText("<font size=\"+2\"><font color=\"#0055ff\">" +
			     i->text(0) + "</font></font>");
}


/* Function run when subtitlelist is clicked. The function
 * will insert the clicked subtitle to mplayer stdin thru the
 * mplayer widget. Does not garantie sync as actual resault but
 * there could be development in changeing subtitle sync.
 * Pre  : m_pMPlayerWidget is defined and has loaded a movie.
 * Post : All subs removed and current subtitle is shown.
 */
void mainfrm::pushButtonShowsub_clicked()
{
    QListViewItem *lsub = listViewSubTitle->selectedItem();
    if (lsub != 0) {
	if (m_pMPlayerWidget->isPlaying() == false) {
	    m_pMPlayerWidget->setFilename(lsub->text(2));
	    m_pMPlayerWidget->slotPlay();
	}
	QString subba = "sub_remove -1\n";
	m_pMPlayerWidget->writeToStdin(subba);
	subba = "sub_load  \"" + lsub->text(1) + "\"\n";
	m_pMPlayerWidget->writeToStdin(subba);
	subba = "sub_select 0\n";
	m_pMPlayerWidget->writeToStdin(subba);
    }
}

/* Remove current subtitle in list of subtitles 
 * Pre : Subtitlelist is untouched 
 * Post: The selected item in the list is removed 
 */
void mainfrm::listViewsubTitle_DoubleClicked(QListViewItem * i,
					     QPoint const &, int)
{
    QListViewItem *lsub = listViewSubTitle_2->firstChild();	//Backend

    if (lsub != 0 && i != 0) {
	while (lsub) {
	    if (i->text(2) == lsub->text(2)) {	// Match
		listViewSubTitle_2->takeItem(lsub);
		break;
	    }
	    lsub = lsub->nextSibling();
	}
	listViewSubTitle->takeItem(i);
    }
}

/* Remove all subtitles in list of subtitles for one specific movie (i)
 * Pre : Subtitlelists are untouched 
 * Post: All subtitles for one movie (path) is removed in both backend and 
 *       frontend list of subs. 
 */
void mainfrm::removeSubTitlesMovie(QListViewItem * i)
{
    QListViewItem *lsub = listViewSubTitle->firstChild();
    QListViewItem *lsub_2 = listViewSubTitle_2->firstChild();

    while (lsub) {
	if (i->text(1) == lsub->text(2)) {	// Match
	    listViewSubTitle->takeItem(lsub);
	}
	lsub = lsub->nextSibling();
    }

    while (lsub_2) {
	if (i->text(1) == lsub_2->text(2)) {	// Match
	    listViewSubTitle_2->takeItem(lsub_2);
	}
	lsub_2 = lsub_2->nextSibling();
    }
}


/* Remove all subtitles in list of subtitles 
 * Pre : Subtitlelist is untouched 
 * Post: List of subtitles are empty
 */
void mainfrm::removeAllSubtitleList()
{
    QListViewItem *lsub = listViewSubTitle_2->firstChild();

    while (lsub) {
	listViewSubTitle_2->takeItem(lsub);
	lsub = lsub->nextSibling();
    }
}


/* If sublist dialog is shown it will hide without any other action */
void mainfrm::pushButtoncloseSubList_Clicked()
{
    buttonGroupMovierun->hide();
}

/* Dialog for importing subs is closed. Cancel button clicked */
void mainfrm::srtCancelbutton_pushed()
{
    importSubs->hide();
    Etape_02->setEnabled(true);
}

/* Combox to choose language is activated. This indicates that
 * the user has choosen a language position for curren subtitle */
void mainfrm::strComobox_Activated(QString const &)
{
    srtOkpushButton->setEnabled(true);
}

/* OK button clicked in dialog for imorting a subtitle. If the language is
 * already choosen the subtitle will be replaced with the choosen. 
 * Pre : Button is only activated if a file is choosen and a language
 * Post: The new subtitle is inserted into the list. 
 */
void mainfrm::srtOKbutton_clicked()
{
    bool match = FALSE;
    QListViewItem *wsub = listViewSubTitle->firstChild();	// Window
    QListViewItem *lsub = listViewSubTitle_2->firstChild();	//Backend
    QString mname, mpath, slang, spath;
    QListViewItem *i = lst_video_1->selectedItem();

    slang = srtcomboBox->currentText();
    spath = lineEdit15->text();	// Might need to be utf8
    mpath = i->text(1);		// Might need to be utf8

    // Insert item into the backend subtitlelist
    // Search if the language already in the list for this movie 
    while (lsub) {
	if (lsub->text(0) == slang && lsub->text(2) == mpath) {
	    // This is already in list --> Replace with current subtitle!
	    lsub->setText(1, spath);	// Replace the new subfile
	    match = TRUE;
	    break;
	}
	lsub = lsub->nextSibling();
    }

    // Create a new post and insert into list
    if (!match) {
	lsub = new QListViewItem(listViewSubTitle_2, slang, spath, mpath);
    }
    // Update the list display for user GUI
    if (buttonGroupMovierun->isVisible()) {
	if (!match) {
	    wsub =
		new QListViewItem(listViewSubTitle, slang, spath, mpath);
	} else {
	    // Must be in list, where to find out
	    //wsub = listViewSubTitle->firstChild();
	    while (wsub) {
		if (wsub->text(0) == slang) {
		    wsub->setText(1, spath);
		    break;
		}
		wsub = wsub->nextSibling();
	    }
	}
	m_pMPlayerWidget->slotPlay();
	textLabelMRname->setText(i->text(0));
    } else {
	updatelistViewSubTitle(i);	// Update GUI list
	buttonGroupMovierun->show();
    }

    srtOkpushButton->setDisabled(true);
    importSubs->hide();
    Etape_02->setEnabled(true);
}

/* Fildialog button in sub add box clicked. User can choose a subtitle
 * input file for subs. If user cancel no action is taken.
 */
void mainfrm::srtInputFileButton_clicked()
{
    QString filesrt = QFileDialog::getOpenFileName(dossier_travail_2,
						   tr
						   ("Videos (*.srt *.SRT )"),
						   this, table_message[65],
						   table_message[72]);
    if (filesrt.isNull()) {
    } else {
	int i = filesrt.findRev('/');

	if (i != 1) {
	    dossier_travail_2 = filesrt.mid(0, i);
	} else {
	    dossier_travail_2 = filesrt;
	}
	lineEdit15->setText(filesrt);
	srtcomboBox->setEnabled(true);
    }
}



/* ********** OLD BURN IN SUBTITLE CODE *************/

/* Butten clicked in main window to add a non burn in subtitle */
void mainfrm::button_addStr_clicked()
{
    QListViewItem *i = lst_video_1->selectedItem();

    if (i != 0 && i->text(2) != "9") {
	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotStop();
	}

	lineEdit11_2->setText("");
	tmp_001 = i->text(4);
	rc_001 = tmp_001.find("$$$", 0);

	if (rc_001 != -1) {
	    tmp_002 =
		tmp_001.mid(rc_001 + 3, tmp_001.length() - (rc_001 + 3));
	    lineEdit11_2->setText(tmp_002);
	}

	Etape_02->setDisabled(true);
	tmp_008 = i->text(1);
	srtcomboBox->setDisabled(true);
	srtOkpushButton->setDisabled(true);
	lineEdit15->clear();
	importSubs->show();
	importSubs->raise();
    }
}

/* Button to add a burned in subtitle clicked */
void mainfrm::bt_gest_sub_2_clicked()
{
    QListViewItem *i = lst_video_1->selectedItem();

    if (i != 0 && i->text(2) != "9") {

	int cpt1;
	int cpt2;

	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotStop();
	}

	nomfilm = i->text(1);
	QString lstfiltres = i->text(2);

	if (lstfiltres.find("eq=", 0, false) == -1) {
	    btreglages->setChecked(false);
	    sl_lum->setValue(0);
	    sl_con->setValue(0);
	} else {
	    int cpt1 = lstfiltres.find("eq=", 0, false) + 3;
	    int cpt2 = 0;	// Warningfix MB
	    tmp_001 = "";
	    tmp_002 = "";

	    while (lstfiltres.mid(cpt1, 1) != "," && lstfiltres.mid(cpt1, 1) != " " && cpt1 < (int) lstfiltres.length())	// Cast to avoid cc-warning
	    {
		if (lstfiltres.mid(cpt1, 1) != ":") {
		    if (cpt2 == 0) {
			tmp_001 = tmp_001 + lstfiltres.mid(cpt1, 1);
		    } else {
			tmp_002 = tmp_002 + lstfiltres.mid(cpt1, 1);
		    }
		} else {
		    cpt2 = 1;
		}
		cpt1 = cpt1 + 1;
	    }
	    //
	    rc_001 = tmp_001.toInt(&ok, 10);
	    if (ok == true) {
		sl_lum->setValue(rc_001);
	    } else {
		sl_lum->setValue(0);
	    }
	    //
	    rc_001 = tmp_002.toInt(&ok, 10);
	    if (ok == true) {
		sl_con->setValue(rc_001);
	    } else {
		sl_con->setValue(0);
	    }
	    //
	    btreglages->setChecked(true);
	}

	if (lstfiltres.find("delogo=", 0, false) == -1) {
	    btdelogo->setChecked(false);
	    spx->setValue(0);
	    spy->setValue(0);
	    spl->setValue(0);
	    sph->setValue(0);
	} else {
	    cpt1 = lstfiltres.find("delogo=", 0, false) + 7;
	    cpt2 = 0;
	    tmp_001 = "";
	    tmp_002 = "";
	    tmp_003 = "";
	    tmp_004 = "";

	    while (lstfiltres.mid(cpt1, 1) != "," && lstfiltres.mid(cpt1, 1) != " " && cpt1 < (int) lstfiltres.length())	// Cast to avoid cc-warning
	    {
		if (lstfiltres.mid(cpt1, 1) != ":") {
		    if (cpt2 == 0) {
			tmp_001 = tmp_001 + lstfiltres.mid(cpt1, 1);
		    } else {
			if (cpt2 == 1) {
			    tmp_002 = tmp_002 + lstfiltres.mid(cpt1, 1);
			} else {
			    if (cpt2 == 2) {
				tmp_003 =
				    tmp_003 + lstfiltres.mid(cpt1, 1);
			    } else {
				if (cpt2 == 3) {
				    tmp_004 =
					tmp_004 + lstfiltres.mid(cpt1, 1);
				}
			    }
			}
		    }
		} else {
		    cpt2 = cpt2 + 1;
		}
		cpt1 = cpt1 + 1;
	    }
	    //
	    rc_001 = tmp_001.toInt(&ok, 10);
	    if (ok == true) {
		spx->setValue(rc_001);
	    } else {
		spx->setValue(0);
	    }
	    //
	    rc_001 = tmp_002.toInt(&ok, 10);
	    if (ok == true) {
		spy->setValue(rc_001);
	    } else {
		spy->setValue(0);
	    }
	    //
	    rc_001 = tmp_003.toInt(&ok, 10);
	    if (ok == true) {
		spl->setValue(rc_001);
	    } else {
		spl->setValue(0);
	    }
	    //
	    rc_001 = tmp_004.toInt(&ok, 10);
	    if (ok == true) {
		sph->setValue(rc_001);
	    } else {
		sph->setValue(0);
	    }
	    //
	    btdelogo->setChecked(true);
	}

	if (lstfiltres.find("mirror", 0, false) == -1) {
	    btmirroir->setChecked(false);
	} else {
	    btmirroir->setChecked(true);
	}

	if (lstfiltres.find("denoise3d=", 0, false) == -1) {
	    btdenoise->setChecked(false);
	} else {
	    btdenoise->setChecked(true);
	}

	Etape_02->setDisabled(true);
	addfilter->setGeometry(55, 104, 890, 619);
	addfilter->show();
	addfilter->raise();
    }
}

/* Button in main window add sub (Burned in) is clicked */
void mainfrm::bt_gest_sub_clicked()
{
    QListViewItem *i = lst_video_1->selectedItem();

    if (i != 0 && i->text(2) != "9") {
	if (m_pMPlayerWidget->isPlaying() == true) {
	    m_pMPlayerWidget->slotStop();
	}
	lineEdit11_2->setText("");
	tmp_001 = i->text(4);
	rc_001 = tmp_001.find("$$$", 0);

	if (rc_001 != -1) {
	    tmp_002 =
		tmp_001.mid(rc_001 + 3, tmp_001.length() - (rc_001 + 3));
	    lineEdit11_2->setText(tmp_002);
	}
	//
	Etape_02->setDisabled(true);
	tmp_008 = i->text(1);

	m_pMPlayerWidget->setFilename(tmp_008);
	gestsubtitle->setGeometry(294, 295, 411, 110);
	gestsubtitle->show();
	gestsubtitle->raise();
    }
}

/* Cancelbutton in subtitelwindow for Burn-in subs */
void mainfrm::toolButton72_2_2_clicked()
{
    gestsubtitle->hide();
    Etape_02->setEnabled(true);
}

/* Import subtilte ? */
void mainfrm::toolButton72_3_clicked()
{
    // *** Sauvegarde du sous titre ***
    if (lineEdit11_2->text() != "") {
	QListViewItem *i = lst_video_1->selectedItem();

	if (i != 0) {
	    QImage wl_img1 = i->pixmap(0)->convertToImage();
	    QPixmap wl_pix1(wl_img1);
	    QImage wl_img2 = previcon_3->pixmap()->convertToImage();
	    QPixmap wl_pix2(wl_img2);
	    ::bitBlt(&wl_pix1, 3, 20, &wl_pix2, 0, 0, -1, -1, Qt::CopyROP,
		     false);

	    tmp_001 = i->text(4);
	    int j = tmp_001.find("$$$");
	    if (j == -1) {
		tmp_001 = tmp_001 + "$$$" + lineEdit11_2->text();
	    } else {
		if (j > 0) {
		    tmp_002 = tmp_001.mid(0, j);
		} else {
		    tmp_002 = "";
		}
		tmp_002 = tmp_002 + "$$$" + lineEdit11_2->text();
		tmp_001 = tmp_002;
	    }
	    i->setText(4, tmp_001);
	    i->setText(2, "1");
	    i->setPixmap(0, wl_pix1);
	}
    }
    //
    gestsubtitle->hide();
    Etape_02->setEnabled(true);
}

/* Import subtitle. Open filedialog to import an srt-file */
void mainfrm::toolButton71_2_clicked()
{
    // *********************************
    // *** Paramtrage du dossier de travail ***
    // *********************************

    QString myfic = QFileDialog::getOpenFileName(dossier_travail_2,
						 tr
						 ("Videos (*.srt *.SRT )"),
						 this, table_message[65],
						 table_message[72]);
    if (myfic.isNull()) {
    } else {
	int i = myfic.findRev('/');

	if (i != 1) {
	    dossier_travail_2 = myfic.mid(0, i);
	} else {
	    dossier_travail_2 = myfic;
	}
	lineEdit11_2->setText(myfic);
    }
}

/* Subttle ?? */
void mainfrm::deplace_h_valueChanged(int)
{
    depl_coupe();
}

/* Subttle ?? */
void mainfrm::deplace_w_valueChanged(int)
{
    depl_coupe();
}

void mainfrm::bteditsstitre_clicked()
{
    listdessub->clear();
    if (lineEdit11_2->text() == "") {
	rc_003 = 0;
    } else {
	rc_003 = 1;
	//
	QFile myfic(lineEdit11_2->text());
	QTextStream mystream(&myfic);
	if (myfic.open(IO_ReadOnly)) {
	    QString myrec = mystream.readLine();
	    while (mystream.atEnd() == false) {

		// *** Timing ***
		myrec = mystream.readLine();
		tmp_001 = myrec.mid(0, 8);
		tmp_002 = myrec.mid(17, 8);
		// *** Texte ***
		myrec = mystream.readLine();
		// *** Ajout  la listview ***
		// Warningfix MB not tested, sorry!
		::new QListViewItem(listdessub, tmp_001, tmp_002, myrec);
		// *** Ligne blanche ***
		myrec = mystream.readLine();	// *** Position ***
		myrec = mystream.readLine();
	    }
	}
    }
    newsubt->setDisabled(true);
    createsubtitle->setGeometry(15, 140, 970, 420);
    createsubtitle->show();
    createsubtitle->raise();
    mediabar->setGeometry(25, 460, 341, 30);
    mediabar->show();
    mediabar->raise();
    vframe->setGeometry(25, 190, 341, 273);
    vframe->show();
    vframe->raise();
}

/* Subtitle */
void mainfrm::btcloseedit_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	m_pMPlayerWidget->slotStop();
    }
    listdessub->setSortColumn(1);
    listdessub->setSortOrder(Qt::Ascending);
    listdessub->sort();
    if (rc_003 == 0) {
	QString myfic = QFileDialog::getSaveFileName(path_out->text(),
						     tr
						     ("Subtitle (*.srt)"),
						     this,
						     table_message[65],
						     tr
						     ("Subtitle export"));
	if (myfic.isNull()) {
	} else {
	    if (myfic.right(4) != ".srt") {
		myfic = myfic + ".srt";
	    }
	    save_sub(myfic);
	}
    } else {
	save_sub(lineEdit11_2->text());
    }
    createsubtitle->hide();
    mediabar->hide();
    vframe->setGeometry(31, 125, 115, 71);
    vframe->show();
    vframe->raise();
}

/* Subtitle */
void mainfrm::save_sub(QString locpathname)
{
    QFile myfic(locpathname);
    int cpt_001 = 1;
    int cpt_002 = 0;
    if (myfic.open(IO_WriteOnly)) {
	QListViewItem *lvi = listdessub->firstChild();
	cpt_002 = listdessub->childCount();
	while (cpt_001 <= cpt_002) {
	    tmp_001 = lvi->text(0);
	    tmp_002 = lvi->text(1);
	    tmp_003 = lvi->text(2);

	    tmp_004 = QString::number(cpt_001) + "\n";
	    myfic.writeBlock(tmp_004, tmp_004.length());

	    tmp_004 = tmp_001 + ",000 --> " + tmp_002 + ",000\n";
	    myfic.writeBlock(tmp_004, tmp_004.length());

	    tmp_004 = tmp_003 + "\n";
	    myfic.writeBlock(tmp_004, tmp_004.length());

	    tmp_004 = "\n";
	    myfic.writeBlock(tmp_004, tmp_004.length());

	    lvi = lvi->nextSibling();
	    cpt_001 = cpt_001 + 1;
	}
	myfic.close();
	lineEdit11_2->setText(locpathname);
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[8]);
    }
}

/* Subttle ?? */
void mainfrm::bt_deb_sub_clicked()
{
    if (m_pMPlayerWidget->isPlaying() == true) {
	int iHour;
	int iMin;
	int iSec;
	QTime mytime;
	float fElapsedTime =
	    m_pMPlayerWidget->m_rxParseElapsedTime.cap(1).toFloat();
	iHour = (int) (fElapsedTime / 3600.0);
	iMin = (int) ((fElapsedTime - iHour * 3600) / 60.0);
	iSec = (int) (fElapsedTime - iHour * 3600 - iMin * 60);
	mytime.setHMS(iHour, iMin, iSec);
	hre_deb_sub->setTime(mytime);
    }
}


/*  SUBTITLE: Modify before burn in in last UI ETape_05 */

/* Subtitle burn in: Select font */
void mainfrm::toolButton114_clicked()
{
    // **************************************
    // *** Choix police de caractre des sous titres ***
    // ***************************************
    QString myfic = QFileDialog::getOpenFileName("/usr/share/fonts/",
						 tr("Fonts (*.ttf *.TTF)"),
						 this, table_message[65],
						 table_message[73]);
    if (myfic.isNull()) {
    } else {
	lineEdit12->setText(myfic);
	slider10->setEnabled(true);
    }
}

/* Belongs in subtitle? */
void mainfrm::toolButton135_clicked()
{
    if (hre_deb_sub->time() < hre_fin_sub->time()) {
	if (rc_002 == 0) {
	    QTime mytime;
	    QTime mytime2;
	    mytime = hre_deb_sub->time();
	    mytime2 = hre_fin_sub->time();
	    // QListViewItem *i = // Removed because cc-warning but will it still work? listdessub is global
	    new QListViewItem(listdessub, mytime.toString("hh:mm:ss"),
			      mytime2.toString("hh:mm:ss"),
			      textsub->text());
	    QTime raztime(0, 0, 0, 0);
	    hre_deb_sub->setTime(raztime);
	    hre_fin_sub->setTime(raztime);
	    textsub->setText("");
	} else {
	    QListViewItem *i = listdessub->selectedItem();

	    if (i != 0) {
		QTime mytime;
		QTime mytime2;
		mytime = hre_deb_sub->time();
		mytime2 = hre_fin_sub->time();
		i->setText(0, mytime.toString("hh:mm:ss"));
		i->setText(1, mytime2.toString("hh:mm:ss"));
		i->setText(2, textsub->text());
		QTime raztime(0, 0, 0, 0);
		hre_deb_sub->setTime(raztime);
		hre_fin_sub->setTime(raztime);
		textsub->setText("");
	    }
	}
	newsubt->setDisabled(true);
	listdessub->setEnabled(true);
	toolButton133_2->setEnabled(true);
	toolButton133_2_2->setEnabled(true);
	btcloseedit->setEnabled(true);
	btcloseedit_2->setEnabled(true);
    } else {
	QMessageBox::warning(this, MANDVDVER, table_message[29]);
    }
}
