all_amino94_dat = {
"TYR": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0295, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0295, 'type': 'HC'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CG', 'CE2', 'CD2', 'HD2'], ['CD2', 'CZ', 'CE2', 'HE2'], ['CD1', 'CZ', 'CE1', 'HE1'], ['CG', 'CE1', 'CD1', 'HD1'], ['CD1', 'CD2', 'CG', 'CB'], ['CE1', 'CE2', 'CZ', 'OH']],
	"INTX,KFORM":['INT', '1'],
	"HD2":{'torsion': 180.0, 'tree': 'E', 'NC': 16, 'NB': 19, 'NA': 21, 'I': 22, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1699, 'type': 'HA'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"OH":{'torsion': 180.0, 'tree': 'S', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 120.0, 'blen': 1.36, 'charge': -0.5579, 'type': 'OH'},
	"HD1":{'torsion': 0.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 13, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1699, 'type': 'HA'},
	"HE1":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 15, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1656, 'type': 'HA'},
	"HE2":{'torsion': 180.0, 'tree': 'E', 'NC': 14, 'NB': 16, 'NA': 19, 'I': 20, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1656, 'type': 'HA'},
	"CD2":{'torsion': 0.0, 'tree': 'S', 'NC': 14, 'NB': 16, 'NA': 19, 'I': 21, 'angle': 120.0, 'blen': 1.4, 'charge': -0.1906, 'type': 'CA'},
	"NAMRES":'TYROSINE',
	"CD1":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 120.0, 'blen': 1.4, 'charge': -0.1906, 'type': 'CA'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'CD1', 'HD1', 'CE1', 'HE1', 'CZ', 'OH', 'HH', 'CE2', 'HE2', 'CD2', 'HD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"CE1":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 14, 'angle': 120.0, 'blen': 1.4, 'charge': -0.2341, 'type': 'CA'},
	"CE2":{'torsion': 0.0, 'tree': 'B', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 19, 'angle': 120.0, 'blen': 1.4, 'charge': -0.2341, 'type': 'CA'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0876, 'type': 'H1'},
	"HH":{'torsion': 0.0, 'tree': 'E', 'NC': 14, 'NB': 16, 'NA': 17, 'I': 18, 'angle': 113.0, 'blen': 0.96, 'charge': 0.3992, 'type': 'HO'},
	"CZ":{'torsion': 0.0, 'tree': 'B', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 16, 'angle': 120.0, 'blen': 1.4, 'charge': 0.3226, 'type': 'C'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 23, 'I': 24, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.51, 'charge': -0.0011, 'type': 'CA'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0014, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0152, 'type': 'CT'},
	"loopList":[['CG', 'CD2']],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 23, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"ASN": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0797, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0797, 'type': 'HC'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'OD1', 'ND2', 'HD21', 'HD22', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"ND2":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 116.6, 'blen': 1.335, 'charge': -0.9191, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 16, 'I': 17, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.2041, 'type': 'CT'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CB', 'ND2', 'CG', 'OD1'], ['CG', 'HD21', 'ND2', 'HD22']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1048, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CG":{'torsion': 180.0, 'tree': 'B', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 111.1, 'blen': 1.522, 'charge': 0.713, 'type': 'C'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0143, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HD21":{'torsion': 180.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 13, 'I': 14, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4196, 'type': 'H'},
	"OD1":{'torsion': 0.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5931, 'type': 'O'},
	"HD22":{'torsion': 0.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 13, 'I': 15, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4196, 'type': 'H'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 16, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'ASPARAGINE',
},
"ASH": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0488, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0488, 'type': 'HC'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'OD1', 'OD2', 'HD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 15, 'I': 16, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0316, 'type': 'CT'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CB', 'OD1', 'CG', 'OD2']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0864, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '0'],
	"CG":{'torsion': 180.0, 'tree': 'B', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.527, 'charge': 0.6462, 'type': 'C'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0341, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"OD2":{'torsion': 270.0, 'tree': 'S', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 117.2, 'blen': 1.26, 'charge': -0.6376, 'type': 'OH'},
	"OD1":{'torsion': 90.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 117.2, 'blen': 1.26, 'charge': -0.5554, 'type': 'O'},
	"HD2":{'torsion': 180.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 13, 'I': 14, 'angle': 109.5, 'blen': 0.96, 'charge': 0.4747, 'type': 'HO'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 15, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'ASP neutral',
},
"LYN": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.034, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.034, 'type': 'HC'},
	"HZ2":{'torsion': 180.0, 'tree': 'E', 'NC': 14, 'NB': 17, 'NA': 20, 'I': 21, 'angle': 109.47, 'blen': 1.01, 'charge': 0.38604, 'type': 'H'},
	"HZ3":{'torsion': 300.0, 'tree': 'E', 'NC': 14, 'NB': 17, 'NA': 20, 'I': 22, 'angle': 109.47, 'blen': 1.01, 'charge': 0.38604, 'type': 'H'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"NZ":{'torsion': 180.0, 'tree': 'B', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 20, 'angle': 109.47, 'blen': 1.47, 'charge': -1.03581, 'type': 'N3'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 24, 'I': 24, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"INTX,KFORM":['INT', '1'],
	"HG3":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.01041, 'type': 'HC'},
	"HG2":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.01041, 'type': 'HC'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HE3":{'torsion': 60.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 19, 'angle': 109.5, 'blen': 1.09, 'charge': -0.03358, 'type': 'HP'},
	"HE2":{'torsion': 300.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 18, 'angle': 109.5, 'blen': 1.09, 'charge': -0.03358, 'type': 'HP'},
	"HD2":{'torsion': 300.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 15, 'angle': 109.5, 'blen': 1.09, 'charge': 0.01155, 'type': 'HC'},
	"HD3":{'torsion': 60.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 16, 'angle': 109.5, 'blen': 1.09, 'charge': 0.01155, 'type': 'HC'},
	"NAMRES":'LYSINE neutral',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ2', 'HZ3', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0994, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"CD":{'torsion': 180.0, 'tree': '3', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 14, 'angle': 109.47, 'blen': 1.525, 'charge': -0.03768, 'type': 'CT'},
	"CE":{'torsion': 180.0, 'tree': '3', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 17, 'angle': 109.47, 'blen': 1.525, 'charge': 0.32604, 'type': 'CT'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.525, 'charge': 0.06612, 'type': 'CT'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.07206, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.04845, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 23, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"CYS": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1112, 'type': 'H1'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1112, 'type': 'H1'},
	"HG":{'torsion': 180.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 96.0, 'blen': 1.33, 'charge': 0.1933, 'type': 'HS'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'SG', 'HG', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"SG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 116.0, 'blen': 1.81, 'charge': -0.3119, 'type': 'SH'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 13, 'I': 14, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.1231, 'type': 'CT'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1124, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0213, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 13, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'CYSTEINE',
},
"ARG": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0327, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0327, 'type': 'HC'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['NE', 'NH1', 'CZ', 'NH2'], ['CD', 'CZ', 'NE', 'HE'], ['CZ', 'HH11', 'NH1', 'HH12'], ['CZ', 'HH21', 'NH2', 'HH22']],
	"HH11":{'torsion': 0.0, 'tree': 'E', 'NC': 17, 'NB': 19, 'NA': 20, 'I': 21, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4478, 'type': 'H'},
	"HH12":{'torsion': 180.0, 'tree': 'E', 'NC': 17, 'NB': 19, 'NA': 20, 'I': 22, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4478, 'type': 'H'},
	"HH21":{'torsion': 0.0, 'tree': 'E', 'NC': 17, 'NB': 19, 'NA': 23, 'I': 24, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4478, 'type': 'H'},
	"HH22":{'torsion': 180.0, 'tree': 'E', 'NC': 17, 'NB': 19, 'NA': 23, 'I': 25, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4478, 'type': 'H'},
	"INTX,KFORM":['INT', '1'],
	"NE":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 17, 'angle': 111.0, 'blen': 1.48, 'charge': -0.5295, 'type': 'N2'},
	"HG2":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0285, 'type': 'HC'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.3479, 'type': 'N'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HD2":{'torsion': 300.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 15, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0687, 'type': 'H1'},
	"HD3":{'torsion': 60.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 16, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0687, 'type': 'H1'},
	"NAMRES":'ARGININE',
	"HE":{'torsion': 0.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 18, 'angle': 118.5, 'blen': 1.01, 'charge': 0.3456, 'type': 'H'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'HD2', 'HD3', 'NE', 'HE', 'CZ', 'NH1', 'HH11', 'HH12', 'NH2', 'HH21', 'HH22', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"NH2":{'torsion': 180.0, 'tree': 'B', 'NC': 14, 'NB': 17, 'NA': 19, 'I': 23, 'angle': 118.0, 'blen': 1.33, 'charge': -0.8627, 'type': 'N2'},
	"HG3":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0285, 'type': 'HC'},
	"NH1":{'torsion': 0.0, 'tree': 'B', 'NC': 14, 'NB': 17, 'NA': 19, 'I': 20, 'angle': 122.0, 'blen': 1.33, 'charge': -0.8627, 'type': 'N2'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.156, 'type': 'H1'},
	"CZ":{'torsion': 180.0, 'tree': 'B', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 19, 'angle': 123.0, 'blen': 1.33, 'charge': 0.8076, 'type': 'CA'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2747, 'type': 'H'},
	"CD":{'torsion': 180.0, 'tree': '3', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 14, 'angle': 109.47, 'blen': 1.525, 'charge': 0.0486, 'type': 'CT'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 26, 'I': 27, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5894, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.525, 'charge': 0.039, 'type': 'CT'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.2637, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0007, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 26, 'angle': 111.1, 'blen': 1.522, 'charge': 0.7341, 'type': 'C'},
},
"LEU": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0457, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0457, 'type': 'HC'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"INTX,KFORM":['INT', '1'],
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"NAMRES":'LEUCINE',
	"HG":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0361, 'type': 'HC'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG', 'CD1', 'HD11', 'HD12', 'HD13', 'CD2', 'HD21', 'HD22', 'HD23', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HD11":{'torsion': 60.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 13, 'I': 14, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1, 'type': 'HC'},
	"HD12":{'torsion': 180.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 13, 'I': 15, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1, 'type': 'HC'},
	"HD13":{'torsion': 300.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 13, 'I': 16, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1, 'type': 'HC'},
	"CD2":{'torsion': 180.0, 'tree': '3', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 17, 'angle': 109.47, 'blen': 1.525, 'charge': -0.4121, 'type': 'CT'},
	"CD1":{'torsion': 60.0, 'tree': '3', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.47, 'blen': 1.525, 'charge': -0.4121, 'type': 'CT'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0922, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 21, 'I': 22, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.525, 'charge': 0.3531, 'type': 'CT'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0518, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.1102, 'type': 'CT'},
	"HD21":{'torsion': 60.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 17, 'I': 18, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1, 'type': 'HC'},
	"HD23":{'torsion': 300.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 17, 'I': 20, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1, 'type': 'HC'},
	"HD22":{'torsion': 180.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 17, 'I': 19, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1, 'type': 'HC'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 21, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"HID": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0402, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0402, 'type': 'HC'},
	"NE2":{'torsion': 0.0, 'tree': 'S', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 16, 'angle': 109.0, 'blen': 1.31, 'charge': -0.5727, 'type': 'NB'},
	"ND1":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 122.0, 'blen': 1.39, 'charge': -0.3811, 'type': 'NA'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CG', 'CE1', 'ND1', 'HD1'], ['CG', 'NE2', 'CD2', 'HD2'], ['ND1', 'NE2', 'CE1', 'HE1'], ['ND1', 'CD2', 'CG', 'CB']],
	"CE1":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 14, 'angle': 108.0, 'blen': 1.32, 'charge': 0.2057, 'type': 'CR'},
	"INTX,KFORM":['INT', '1'],
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HD1":{'torsion': 0.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 13, 'angle': 126.0, 'blen': 1.01, 'charge': 0.3649, 'type': 'H'},
	"HD2":{'torsion': 180.0, 'tree': 'E', 'NC': 14, 'NB': 16, 'NA': 17, 'I': 18, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1147, 'type': 'H4'},
	"HE1":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 15, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1392, 'type': 'H5'},
	"NAMRES":'HISTIDINE DELTAH',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'ND1', 'HD1', 'CE1', 'HE1', 'NE2', 'CD2', 'HD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"CD2":{'torsion': 0.0, 'tree': 'S', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 110.0, 'blen': 1.36, 'charge': 0.1292, 'type': 'CV'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0881, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 19, 'I': 20, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 115.0, 'blen': 1.51, 'charge': -0.0266, 'type': 'CC'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0188, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0462, 'type': 'CT'},
	"loopList":[['CG', 'CD2']],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 19, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"NME": {	"HH32":{'torsion': 120.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0976, 'type': 'H1'},
	"HH33":{'torsion': 240.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0976, 'type': 'H1'},
	"atNameList":['N', 'H', 'CH3', 'HH31', 'HH32', 'HH33'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HH31":{'torsion': 0.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0976, 'type': 'H1'},
	"impropTors":[['-M', 'CH3', 'N', 'H']],
	"CH3":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.149, 'type': 'CT'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"NAMRES":'N-methyl all atom',
},
"HIE": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0367, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0367, 'type': 'HC'},
	"NE2":{'torsion': 0.0, 'tree': 'B', 'NC': 11, 'NB': 12, 'NA': 13, 'I': 15, 'angle': 109.0, 'blen': 1.31, 'charge': -0.2795, 'type': 'NA'},
	"ND1":{'torsion': 180.0, 'tree': 'S', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 122.0, 'blen': 1.39, 'charge': -0.5432, 'type': 'NB'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CE1', 'CD2', 'NE2', 'HE2'], ['CG', 'NE2', 'CD2', 'HD2'], ['ND1', 'NE2', 'CE1', 'HE1'], ['ND1', 'CD2', 'CG', 'CB']],
	"CE1":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 13, 'angle': 108.0, 'blen': 1.32, 'charge': 0.1635, 'type': 'CR'},
	"INTX,KFORM":['INT', '1'],
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HE2":{'torsion': 180.0, 'tree': 'E', 'NC': 12, 'NB': 13, 'NA': 15, 'I': 16, 'angle': 125.0, 'blen': 1.01, 'charge': 0.3339, 'type': 'H'},
	"HD2":{'torsion': 180.0, 'tree': 'E', 'NC': 13, 'NB': 15, 'NA': 17, 'I': 18, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1862, 'type': 'H4'},
	"HE1":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 12, 'NA': 13, 'I': 14, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1435, 'type': 'H5'},
	"NAMRES":'HISTIDINE EPSILONH',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'ND1', 'CE1', 'HE1', 'NE2', 'HE2', 'CD2', 'HD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"CD2":{'torsion': 0.0, 'tree': 'S', 'NC': 12, 'NB': 13, 'NA': 15, 'I': 17, 'angle': 110.0, 'blen': 1.36, 'charge': -0.2207, 'type': 'CW'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.136, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 19, 'I': 20, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 115.0, 'blen': 1.51, 'charge': 0.1868, 'type': 'CC'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0581, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0074, 'type': 'CT'},
	"loopList":[['CG', 'CD2']],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 19, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"MET": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0241, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0241, 'type': 'HC'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 19, 'I': 20, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"SD":{'torsion': 180.0, 'tree': 'S', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 14, 'angle': 110.0, 'blen': 1.81, 'charge': -0.2737, 'type': 'S'},
	"INTX,KFORM":['INT', '1'],
	"HG3":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.044, 'type': 'H1'},
	"HG2":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.044, 'type': 'H1'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HE3":{'torsion': 300.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 15, 'I': 18, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0684, 'type': 'H1'},
	"HE2":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 15, 'I': 17, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0684, 'type': 'H1'},
	"HE1":{'torsion': 60.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 15, 'I': 16, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0684, 'type': 'H1'},
	"NAMRES":'METHIONINE',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'SD', 'CE', 'HE1', 'HE2', 'HE3', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.088, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"CE":{'torsion': 180.0, 'tree': '3', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 15, 'angle': 100.0, 'blen': 1.78, 'charge': -0.0536, 'type': 'CT'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.525, 'charge': 0.0018, 'type': 'CT'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0237, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': 0.0342, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 19, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"IDBGEN,IREST,ITYPF":['1', '1', '2'],
"ALA": {	"HB2":{'torsion': 180.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0603, 'type': 'HC'},
	"HB3":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0603, 'type': 'HC'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB1', 'HB2', 'HB3', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HB1":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0603, 'type': 'HC'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 12, 'I': 13, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.1825, 'type': 'CT'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0823, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0337, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 12, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'ALANINE',
},
"PHE": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0295, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0295, 'type': 'HC'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CG', 'CE2', 'CD2', 'HD2'], ['CD2', 'CZ', 'CE2', 'HE2'], ['CE1', 'CE2', 'CZ', 'HZ'], ['CD1', 'CZ', 'CE1', 'HE1'], ['CG', 'CE1', 'CD1', 'HD1'], ['CD1', 'CD2', 'CG', 'CB']],
	"INTX,KFORM":['INT', '1'],
	"HD2":{'torsion': 180.0, 'tree': 'E', 'NC': 16, 'NB': 18, 'NA': 20, 'I': 21, 'angle': 120.0, 'blen': 1.09, 'charge': 0.133, 'type': 'HA'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HD1":{'torsion': 0.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 13, 'angle': 120.0, 'blen': 1.09, 'charge': 0.133, 'type': 'HA'},
	"HE1":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 15, 'angle': 120.0, 'blen': 1.09, 'charge': 0.143, 'type': 'HA'},
	"HE2":{'torsion': 180.0, 'tree': 'E', 'NC': 14, 'NB': 16, 'NA': 18, 'I': 19, 'angle': 120.0, 'blen': 1.09, 'charge': 0.143, 'type': 'HA'},
	"CD2":{'torsion': 0.0, 'tree': 'S', 'NC': 14, 'NB': 16, 'NA': 18, 'I': 20, 'angle': 120.0, 'blen': 1.4, 'charge': -0.1256, 'type': 'CA'},
	"NAMRES":'PHENYLALANINE',
	"CD1":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 120.0, 'blen': 1.4, 'charge': -0.1256, 'type': 'CA'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'CD1', 'HD1', 'CE1', 'HE1', 'CZ', 'HZ', 'CE2', 'HE2', 'CD2', 'HD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"CE1":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 14, 'angle': 120.0, 'blen': 1.4, 'charge': -0.1704, 'type': 'CA'},
	"CE2":{'torsion': 0.0, 'tree': 'B', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 18, 'angle': 120.0, 'blen': 1.4, 'charge': -0.1704, 'type': 'CA'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0978, 'type': 'H1'},
	"CZ":{'torsion': 0.0, 'tree': 'B', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 16, 'angle': 120.0, 'blen': 1.4, 'charge': -0.1072, 'type': 'CA'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 22, 'I': 23, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 115.0, 'blen': 1.51, 'charge': 0.0118, 'type': 'CA'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0024, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0343, 'type': 'CT'},
	"loopList":[['CG', 'CD2']],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 22, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"HZ":{'torsion': 180.0, 'tree': 'E', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1297, 'type': 'HA'},
},
"CYM": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1122, 'type': 'H1'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1122, 'type': 'H1'},
	"atNameList":['N', 'HN', 'CA', 'HA', 'CB', 'HB3', 'HB2', 'SG', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"SG":{'torsion': 180.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 116.0, 'blen': 1.81, 'charge': -0.8844, 'type': 'SH'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 12, 'I': 13, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"impropTors":[['-M', 'CA', 'N', 'HN'], ['CA', '+M', 'C', 'O']],
	"HN":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0508, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0351, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.2413, 'type': 'CT'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 12, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'CYSTEINE with negative charge',
},
"CYX": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.091, 'type': 'H1'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.091, 'type': 'H1'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'SG', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"SG":{'torsion': 180.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 116.0, 'blen': 1.81, 'charge': -0.1081, 'type': 'S'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 12, 'I': 13, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.079, 'type': 'CT'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0766, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0429, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 12, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'CYSTINE(S-S BRIDGE)',
},
"PRO": {	"HB2":{'torsion': 256.3, 'tree': 'E', 'NC': 5, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0253, 'type': 'HC'},
	"HB3":{'torsion': 136.3, 'tree': 'E', 'NC': 5, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0253, 'type': 'HC'},
	"atNameList":['N', 'CD', 'HD2', 'HD3', 'CG', 'HG2', 'HG3', 'CB', 'HB2', 'HB3', 'CA', 'HA', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5748, 'type': 'O'},
	"impropTors":[['CA', '+M', 'C', 'O'], ['-M', 'CD', 'N', 'CA']],
	"HG2":{'torsion': 218.0, 'tree': 'E', 'NC': 4, 'NB': 5, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0213, 'type': 'HC'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 117.0, 'blen': 1.337, 'charge': -0.2548, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"HG3":{'torsion': 98.0, 'tree': 'E', 'NC': 4, 'NB': 5, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0213, 'type': 'HC'},
	"CG":{'torsion': 200.1, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 5, 'I': 8, 'angle': 103.2, 'blen': 1.5, 'charge': 0.0189, 'type': 'CT'},
	"HA":{'torsion': 60.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 14, 'I': 15, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0641, 'type': 'H1'},
	"CB":{'torsion': 338.3, 'tree': 'B', 'NC': 4, 'NB': 5, 'NA': 8, 'I': 11, 'angle': 106.0, 'blen': 1.51, 'charge': -0.007, 'type': 'CT'},
	"CD":{'torsion': 356.1, 'tree': '3', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 126.1, 'blen': 1.458, 'charge': 0.0192, 'type': 'CT'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CA":{'torsion': 175.2, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 14, 'angle': 120.6, 'blen': 1.451, 'charge': -0.0266, 'type': 'CT'},
	"loopList":[['CB', 'CA']],
	"HD2":{'torsion': 80.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 5, 'I': 6, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0391, 'type': 'H1'},
	"HD3":{'torsion': 320.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 5, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0391, 'type': 'H1'},
	"CUT":['0.00000'],
	"C":{'torsion': 300.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 14, 'I': 16, 'angle': 109.5, 'blen': 1.522, 'charge': 0.5896, 'type': 'C'},
	"NAMRES":'PROLINE',
},
"ACE": {	"HH32":{'torsion': 60.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 5, 'I': 6, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1123, 'type': 'HC'},
	"HH33":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 5, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1123, 'type': 'HC'},
	"atNameList":['HH31', 'CH3', 'HH32', 'HH33', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.000', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.000', '90.000', '0.000', '0.00000']],
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 5, 'NA': 8, 'I': 9, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"impropTors":[['CH3', '+M', 'C', 'O']],
	"CH3":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 90.0, 'blen': 1.09, 'charge': -0.3662, 'type': 'CT'},
	"INTX,KFORM":['INT', '1'],
	"HH31":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 90.0, 'blen': 1.0, 'charge': 0.1123, 'type': 'HC'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'NOMI', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 5, 'I': 8, 'angle': 111.1, 'blen': 1.53, 'charge': 0.5972, 'type': 'C'},
	"NAMRES":'ACE BEGINNING GROUP',
},
"LYS": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0362, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0362, 'type': 'HC'},
	"HZ2":{'torsion': 180.0, 'tree': 'E', 'NC': 14, 'NB': 17, 'NA': 20, 'I': 22, 'angle': 109.47, 'blen': 1.01, 'charge': 0.34, 'type': 'H'},
	"HZ3":{'torsion': 300.0, 'tree': 'E', 'NC': 14, 'NB': 17, 'NA': 20, 'I': 23, 'angle': 109.47, 'blen': 1.01, 'charge': 0.34, 'type': 'H'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"HZ1":{'torsion': 60.0, 'tree': 'E', 'NC': 14, 'NB': 17, 'NA': 20, 'I': 21, 'angle': 109.47, 'blen': 1.01, 'charge': 0.34, 'type': 'H'},
	"NZ":{'torsion': 180.0, 'tree': '3', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 20, 'angle': 109.47, 'blen': 1.47, 'charge': -0.3854, 'type': 'N3'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 24, 'I': 25, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5894, 'type': 'O'},
	"INTX,KFORM":['INT', '1'],
	"HG3":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0103, 'type': 'HC'},
	"HG2":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0103, 'type': 'HC'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.3479, 'type': 'N'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HE3":{'torsion': 60.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 19, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1135, 'type': 'HP'},
	"HE2":{'torsion': 300.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 17, 'I': 18, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1135, 'type': 'HP'},
	"HD2":{'torsion': 300.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 15, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0621, 'type': 'HC'},
	"HD3":{'torsion': 60.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 16, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0621, 'type': 'HC'},
	"NAMRES":'LYSINE',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'HD2', 'HD3', 'CE', 'HE2', 'HE3', 'NZ', 'HZ1', 'HZ2', 'HZ3', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1426, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2747, 'type': 'H'},
	"CD":{'torsion': 180.0, 'tree': '3', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 14, 'angle': 109.47, 'blen': 1.525, 'charge': -0.0479, 'type': 'CT'},
	"CE":{'torsion': 180.0, 'tree': '3', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 17, 'angle': 109.47, 'blen': 1.525, 'charge': -0.0143, 'type': 'CT'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.525, 'charge': 0.0187, 'type': 'CT'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.24, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0094, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 24, 'angle': 111.1, 'blen': 1.522, 'charge': 0.7341, 'type': 'C'},
},
"NAMDBF":'db94.dat',
"SER": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0352, 'type': 'H1'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0352, 'type': 'H1'},
	"HG":{'torsion': 180.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.47, 'blen': 0.96, 'charge': 0.4275, 'type': 'HO'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'OG', 'HG', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 13, 'I': 14, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': 0.2117, 'type': 'CT'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"OG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.43, 'charge': -0.6546, 'type': 'OH'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0843, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0249, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 13, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'SERINE',
},
"ASP": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0122, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0122, 'type': 'HC'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'OD1', 'OD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 14, 'I': 15, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5819, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0303, 'type': 'CT'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CB', 'OD1', 'CG', 'OD2']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.088, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.5163, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CG":{'torsion': 180.0, 'tree': 'B', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.527, 'charge': 0.7994, 'type': 'C'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0381, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2936, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"OD2":{'torsion': 270.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 117.2, 'blen': 1.26, 'charge': -0.8014, 'type': 'O2'},
	"OD1":{'torsion': 90.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 117.2, 'blen': 1.26, 'charge': -0.8014, 'type': 'O2'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 14, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5366, 'type': 'C'},
	"NAMRES":'ASPARTIC ACID',
},
"GLN": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0171, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0171, 'type': 'HC'},
	"NE2":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 16, 'angle': 116.6, 'blen': 1.335, 'charge': -0.9407, 'type': 'N'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CG', 'NE2', 'CD', 'OE1'], ['CD', 'HE21', 'NE2', 'HE22']],
	"INTX,KFORM":['INT', '1'],
	"HG3":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0352, 'type': 'HC'},
	"HG2":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0352, 'type': 'HC'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0031, 'type': 'CT'},
	"NAMRES":'GLUTAMINE',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'OE1', 'NE2', 'HE21', 'HE22', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HE21":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4251, 'type': 'H'},
	"HE22":{'torsion': 0.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 16, 'I': 18, 'angle': 119.8, 'blen': 1.01, 'charge': 0.4251, 'type': 'H'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.085, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"CD":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 14, 'angle': 111.1, 'blen': 1.522, 'charge': 0.6951, 'type': 'C'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 19, 'I': 20, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.525, 'charge': -0.0645, 'type': 'CT'},
	"OE1":{'torsion': 0.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 15, 'angle': 120.5, 'blen': 1.229, 'charge': -0.6086, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0036, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 19, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"GLU": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0173, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0173, 'type': 'HC'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'OE1', 'OE2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CG', 'OE1', 'CD', 'OE2']],
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 17, 'I': 18, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5819, 'type': 'O'},
	"CD":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 14, 'angle': 109.47, 'blen': 1.527, 'charge': 0.8054, 'type': 'C'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': 0.056, 'type': 'CT'},
	"HG2":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0425, 'type': 'HC'},
	"OE1":{'torsion': 90.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 15, 'angle': 117.2, 'blen': 1.26, 'charge': -0.8188, 'type': 'O2'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1105, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.5163, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"HG3":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0425, 'type': 'HC'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.51, 'charge': 0.0136, 'type': 'CT'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0397, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2936, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 17, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5366, 'type': 'C'},
	"OE2":{'torsion': 270.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 16, 'angle': 117.2, 'blen': 1.26, 'charge': -0.8188, 'type': 'O2'},
	"NAMRES":'GLUTAMIC ACID',
},
"TRP": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0339, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0339, 'type': 'HC'},
	"HZ2":{'torsion': 0.0, 'tree': 'E', 'NC': 14, 'NB': 16, 'NA': 17, 'I': 18, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1572, 'type': 'HA'},
	"HZ3":{'torsion': 180.0, 'tree': 'E', 'NC': 17, 'NB': 19, 'NA': 21, 'I': 22, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1447, 'type': 'HA'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CD1', 'CE2', 'NE1', 'HE1'], ['CE2', 'CH2', 'CZ2', 'HZ2'], ['CZ2', 'CZ3', 'CH2', 'HH2'], ['CH2', 'CE3', 'CZ3', 'HZ3'], ['CZ3', 'CD2', 'CE3', 'HE3'], ['CG', 'NE1', 'CD1', 'HD1'], ['CD1', 'CD2', 'CG', 'CB']],
	"CH2":{'torsion': 180.0, 'tree': 'B', 'NC': 14, 'NB': 16, 'NA': 17, 'I': 19, 'angle': 116.0, 'blen': 1.39, 'charge': -0.1134, 'type': 'CA'},
	"CZ3":{'torsion': 0.0, 'tree': 'B', 'NC': 16, 'NB': 17, 'NA': 19, 'I': 21, 'angle': 121.0, 'blen': 1.35, 'charge': -0.1972, 'type': 'CA'},
	"NE1":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 14, 'angle': 107.0, 'blen': 1.43, 'charge': -0.3418, 'type': 'NA'},
	"INTX,KFORM":['INT', '1'],
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HE3":{'torsion': 180.0, 'tree': 'E', 'NC': 19, 'NB': 21, 'NA': 23, 'I': 24, 'angle': 120.0, 'blen': 1.09, 'charge': 0.17, 'type': 'HA'},
	"HD1":{'torsion': 0.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 13, 'angle': 120.0, 'blen': 1.09, 'charge': 0.2062, 'type': 'H4'},
	"HE1":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 15, 'angle': 125.5, 'blen': 1.01, 'charge': 0.3412, 'type': 'H'},
	"NAMRES":'TRYPTOPHAN',
	"CD1":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 127.0, 'blen': 1.34, 'charge': -0.1638, 'type': 'CW'},
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'CD1', 'HD1', 'NE1', 'HE1', 'CE2', 'CZ2', 'HZ2', 'CH2', 'HH2', 'CZ3', 'HZ3', 'CE3', 'HE3', 'CD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"CD2":{'torsion': 0.0, 'tree': 'E', 'NC': 19, 'NB': 21, 'NA': 23, 'I': 25, 'angle': 117.0, 'blen': 1.4, 'charge': 0.1243, 'type': 'CB'},
	"CE2":{'torsion': 0.0, 'tree': 'S', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 16, 'angle': 109.0, 'blen': 1.31, 'charge': 0.138, 'type': 'CN'},
	"CE3":{'torsion': 0.0, 'tree': 'B', 'NC': 17, 'NB': 19, 'NA': 21, 'I': 23, 'angle': 122.0, 'blen': 1.41, 'charge': -0.2387, 'type': 'CA'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1123, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 26, 'I': 27, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 115.0, 'blen': 1.51, 'charge': -0.1415, 'type': 'C*'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0275, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.005, 'type': 'CT'},
	"CZ2":{'torsion': 180.0, 'tree': 'B', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 128.0, 'blen': 1.4, 'charge': -0.2601, 'type': 'CA'},
	"loopList":[['CG', 'CD2'], ['CE2', 'CD2']],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 26, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"HH2":{'torsion': 180.0, 'tree': 'E', 'NC': 16, 'NB': 17, 'NA': 19, 'I': 20, 'angle': 120.0, 'blen': 1.09, 'charge': 0.1417, 'type': 'HA'},
},
"CIP": {	"INTX,KFORM":['INT', '1'],
	"atNameList":['NA+'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.0000', '0.0000', '0.0000', '0.000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.0000', '0.0000', '0.0000', '0.000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.0000', '90.0000', '0.0000', '0.000']],
	"NA+":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 90.0, 'blen': 1.0, 'charge': 1.0, 'type': 'IP'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.000000'],
	"NAMRES":'Sodium Ion',
},
"GLY": {	"HA3":{'torsion': 60.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0698, 'type': 'H1'},
	"atNameList":['N', 'H', 'CA', 'HA2', 'HA3', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HA2":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0698, 'type': 'H1'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 9, 'I': 10, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0252, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 9, 'angle': 110.4, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'GLYCINE',
},
"CIM": {	"INTX,KFORM":['INT', '1'],
	"atNameList":['CL-'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.0000', '0.0000', '0.0000', '0.000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.0000', '0.0000', '0.0000', '0.000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.0000', '90.0000', '0.0000', '0.000']],
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CUT":['0.000000'],
	"CL-":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 90.0, 'blen': 1.0, 'charge': -1.0, 'type': 'IM'},
	"NAMRES":'Chloride Ion',
},
"HOH": {	"INTX,KFORM":['INT', '1'],
	"atNameList":['H1', 'O', 'H2'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.000', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.000', '90.000', '0.000', '0.00000']],
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"O":{'torsion': -39.22, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 104.52, 'blen': 0.9572, 'charge': -0.834, 'type': 'OW'},
	"loopList":[['H1', 'H2']],
	"H1":{'torsion': -98.89, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 101.43, 'blen': 1.0, 'charge': 0.417, 'type': 'HW'},
	"CUT":['0.00000'],
	"H2":{'torsion': -151.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 5, 'I': 6, 'angle': 104.52, 'blen': 0.9572, 'charge': 0.417, 'type': 'HW'},
	"NAMRES":'WATER, TIP3P MODEL',
},
"THR": {	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB', 'CG2', 'HG21', 'HG22', 'HG23', 'OG1', 'HG1', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HG23":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0642, 'type': 'HC'},
	"HB":{'torsion': 180.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0043, 'type': 'H1'},
	"HG22":{'torsion': 180.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0642, 'type': 'HC'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': 0.3654, 'type': 'CT'},
	"HG1":{'torsion': 180.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 14, 'I': 15, 'angle': 109.47, 'blen': 0.96, 'charge': 0.4102, 'type': 'HO'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1007, 'type': 'H1'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"HG21":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 11, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0642, 'type': 'HC'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"INTX,KFORM":['INT', '1'],
	"OG1":{'torsion': 60.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 14, 'angle': 109.47, 'blen': 1.43, 'charge': -0.6761, 'type': 'OH'},
	"CG2":{'torsion': 300.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.47, 'blen': 1.525, 'charge': -0.2438, 'type': 'CT'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0389, 'type': 'CT'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 16, 'I': 17, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 16, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"NAMRES":'THREONINE',
},
"HIP": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.081, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.081, 'type': 'HC'},
	"NE2":{'torsion': 0.0, 'tree': 'B', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 16, 'angle': 109.0, 'blen': 1.31, 'charge': -0.1718, 'type': 'NA'},
	"ND1":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 122.0, 'blen': 1.39, 'charge': -0.1513, 'type': 'NA'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CG', 'CE1', 'ND1', 'HD1'], ['CE1', 'CD2', 'NE2', 'HE2'], ['CG', 'NE2', 'CD2', 'HD2'], ['ND1', 'NE2', 'CE1', 'HE1'], ['ND1', 'CD2', 'CG', 'CB']],
	"CE1":{'torsion': 180.0, 'tree': 'B', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 14, 'angle': 108.0, 'blen': 1.32, 'charge': -0.017, 'type': 'CR'},
	"INTX,KFORM":['INT', '1'],
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"HD1":{'torsion': 0.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 12, 'I': 13, 'angle': 126.0, 'blen': 1.01, 'charge': 0.3866, 'type': 'H'},
	"HD2":{'torsion': 180.0, 'tree': 'E', 'NC': 14, 'NB': 16, 'NA': 18, 'I': 19, 'angle': 120.0, 'blen': 1.09, 'charge': 0.2317, 'type': 'H4'},
	"HE1":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 12, 'NA': 14, 'I': 15, 'angle': 120.0, 'blen': 1.09, 'charge': 0.2681, 'type': 'H5'},
	"HE2":{'torsion': 180.0, 'tree': 'E', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 125.0, 'blen': 1.01, 'charge': 0.3911, 'type': 'H'},
	"NAMRES":'HISTIDINE PLUS',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'ND1', 'HD1', 'CE1', 'HE1', 'NE2', 'HE2', 'CD2', 'HD2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"CD2":{'torsion': 0.0, 'tree': 'S', 'NC': 12, 'NB': 14, 'NA': 16, 'I': 18, 'angle': 110.0, 'blen': 1.36, 'charge': -0.1141, 'type': 'CW'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.1212, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2747, 'type': 'H'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.3479, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 20, 'I': 21, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5894, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': 'S', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 115.0, 'blen': 1.51, 'charge': -0.0012, 'type': 'CC'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.1354, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0414, 'type': 'CT'},
	"loopList":[['CG', 'CD2']],
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 20, 'angle': 111.1, 'blen': 1.522, 'charge': 0.7341, 'type': 'C'},
},
"VAL": {	"HG22":{'torsion': 180.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 14, 'I': 16, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0791, 'type': 'HC'},
	"HG23":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 14, 'I': 17, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0791, 'type': 'HC'},
	"HG21":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 14, 'I': 15, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0791, 'type': 'HC'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
	"HG13":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0791, 'type': 'HC'},
	"HG12":{'torsion': 180.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0791, 'type': 'HC'},
	"HG11":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 11, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0791, 'type': 'HC'},
	"INTX,KFORM":['INT', '1'],
	"CG2":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 14, 'angle': 109.47, 'blen': 1.525, 'charge': -0.3192, 'type': 'CT'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CG1":{'torsion': 60.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.47, 'blen': 1.525, 'charge': -0.3192, 'type': 'CT'},
	"NAMRES":'VALINE',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB', 'CG1', 'HG11', 'HG12', 'HG13', 'CG2', 'HG21', 'HG22', 'HG23', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HB":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': -0.0297, 'type': 'HC'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0969, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 18, 'I': 19, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0875, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': 0.2985, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 18, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
"ILE": {	"HG22":{'torsion': 180.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0882, 'type': 'HC'},
	"HG23":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0882, 'type': 'HC'},
	"HG21":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 10, 'I': 11, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0882, 'type': 'HC'},
	"HD13":{'torsion': 300.0, 'tree': 'E', 'NC': 8, 'NB': 14, 'NA': 17, 'I': 20, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0186, 'type': 'HC'},
	"HG13":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 14, 'I': 16, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0236, 'type': 'HC'},
	"HG12":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 14, 'I': 15, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0236, 'type': 'HC'},
	"INTX,KFORM":['INT', '1'],
	"CG2":{'torsion': 60.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.47, 'blen': 1.525, 'charge': -0.3204, 'type': 'CT'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CG1":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 14, 'angle': 109.47, 'blen': 1.525, 'charge': -0.043, 'type': 'CT'},
	"NAMRES":'ISOLEUCINE',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB', 'CG2', 'HG21', 'HG22', 'HG23', 'CG1', 'HG12', 'HG13', 'CD1', 'HD11', 'HD12', 'HD13', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HD11":{'torsion': 60.0, 'tree': 'E', 'NC': 8, 'NB': 14, 'NA': 17, 'I': 18, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0186, 'type': 'HC'},
	"HD12":{'torsion': 180.0, 'tree': 'E', 'NC': 8, 'NB': 14, 'NA': 17, 'I': 19, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0186, 'type': 'HC'},
	"HB":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0187, 'type': 'HC'},
	"CD1":{'torsion': 180.0, 'tree': '3', 'NC': 6, 'NB': 8, 'NA': 14, 'I': 17, 'angle': 109.47, 'blen': 1.525, 'charge': -0.066, 'type': 'CT'},
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0869, 'type': 'H1'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 21, 'I': 22, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': -0.0597, 'type': 'CT'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 109.47, 'blen': 1.525, 'charge': 0.1303, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 21, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O']],
},
"filename":'all_amino94.in',
"GLH": {	"HB2":{'torsion': 300.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 9, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0256, 'type': 'HC'},
	"HB3":{'torsion': 60.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 10, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0256, 'type': 'HC'},
	"impropTors":[['-M', 'CA', 'N', 'H'], ['CA', '+M', 'C', 'O'], ['CG', 'OE1', 'CD', 'OE2']],
	"INTX,KFORM":['INT', '0'],
	"HG3":{'torsion': 60.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 13, 'angle': 109.5, 'blen': 1.09, 'charge': 0.043, 'type': 'HC'},
	"HG2":{'torsion': 300.0, 'tree': 'E', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 12, 'angle': 109.5, 'blen': 1.09, 'charge': 0.043, 'type': 'HC'},
	"N":{'torsion': 180.0, 'tree': 'M', 'NC': 1, 'NB': 2, 'NA': 3, 'I': 4, 'angle': 116.6, 'blen': 1.335, 'charge': -0.4157, 'type': 'N'},
	"IFIXC,IOMIT,ISYMDU,IPOS":['CORR', 'OMIT', 'DU', 'BEG'],
	"CA":{'torsion': 180.0, 'tree': 'M', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 6, 'angle': 121.9, 'blen': 1.449, 'charge': 0.0145, 'type': 'CT'},
	"HE2":{'torsion': 180.0, 'tree': 'E', 'NC': 11, 'NB': 14, 'NA': 16, 'I': 17, 'angle': 109.5, 'blen': 0.96, 'charge': 0.4641, 'type': 'HO'},
	"OE2":{'torsion': 270.0, 'tree': 'S', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 16, 'angle': 117.2, 'blen': 1.26, 'charge': -0.6511, 'type': 'OH'},
	"NAMRES":'GLU neutral',
	"atNameList":['N', 'H', 'CA', 'HA', 'CB', 'HB2', 'HB3', 'CG', 'HG2', 'HG3', 'CD', 'OE1', 'OE2', 'HE2', 'C', 'O'],
	"DUMM":[['1', 'DUMM', 'DU', 'M', '0', '-1', '-2', '0.000', '0.000', '0.000', '0.00000'], ['2', 'DUMM', 'DU', 'M', '1', '0', '-1', '1.449', '0.000', '0.000', '0.00000'], ['3', 'DUMM', 'DU', 'M', '2', '1', '0', '1.522', '111.100', '0.000', '0.00000']],
	"HA":{'torsion': 300.0, 'tree': 'E', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 7, 'angle': 109.5, 'blen': 1.09, 'charge': 0.0779, 'type': 'H1'},
	"H":{'torsion': 0.0, 'tree': 'E', 'NC': 2, 'NB': 3, 'NA': 4, 'I': 5, 'angle': 119.8, 'blen': 1.01, 'charge': 0.2719, 'type': 'H'},
	"CD":{'torsion': 180.0, 'tree': 'B', 'NC': 6, 'NB': 8, 'NA': 11, 'I': 14, 'angle': 109.47, 'blen': 1.527, 'charge': 0.6801, 'type': 'C'},
	"O":{'torsion': 0.0, 'tree': 'E', 'NC': 4, 'NB': 6, 'NA': 18, 'I': 19, 'angle': 120.5, 'blen': 1.229, 'charge': -0.5679, 'type': 'O'},
	"CG":{'torsion': 180.0, 'tree': '3', 'NC': 4, 'NB': 6, 'NA': 8, 'I': 11, 'angle': 109.47, 'blen': 1.51, 'charge': -0.0174, 'type': 'CT'},
	"OE1":{'torsion': 90.0, 'tree': 'E', 'NC': 8, 'NB': 11, 'NA': 14, 'I': 15, 'angle': 117.2, 'blen': 1.26, 'charge': -0.5838, 'type': 'O'},
	"CB":{'torsion': 60.0, 'tree': '3', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 8, 'angle': 111.1, 'blen': 1.525, 'charge': -0.0071, 'type': 'CT'},
	"CUT":['0.00000'],
	"C":{'torsion': 180.0, 'tree': 'M', 'NC': 3, 'NB': 4, 'NA': 6, 'I': 18, 'angle': 111.1, 'blen': 1.522, 'charge': 0.5973, 'type': 'C'},
},
}