#
# Authors : Sowjanya Karnati,Michel F Sanner, Ruth Huey
#
# $Id
import unittest


class PmvScriptBaseTest(unittest.TestCase):
    def setdmode(self,mode, mv):
        """
        load display commands for mode and set them as default command for new molecule
        """
        if mode=='cpk':
            mv.browseCommands('displayCommands', commands=['displayCPK'],log=0, package='Pmv')
	    print "added"
            mv.addOnAddObjectCmd(mv.displayCPK)

        elif mode=='lines':
            mv.browseCommands('bondsCommands',
			  commands=('buildBondsByDistance',), log=0)
	    mv.addOnAddObjectCmd(mv.buildBondsByDistance)
            mv.browseCommands('displayCommands', commands=('displayLines',), log=0)
	    mv.addOnAddObjectCmd(mv.displayLines)

        elif mode=='ss':
            mv.browseCommands('secondaryStructureCommands',
			  commands=('ribbon',), log=0)
	    mv.addOnAddObjectCmd(mv.ribbon)

        elif mode=='sb':
            mv.browseCommands('bondsCommands',
			  commands=('buildBondsByDistance',), log=0)
    	    mv.addOnAddObjectCmd(mv.buildBondsByDistance)
            mv.browseCommands('displayCommands',
			  commands=('displaySticksAndBalls',), log=0)
	    mv.addOnAddObjectCmd(mv.displaySticksAndBalls, (),
			     {'cquality':8, 'bquality':10})

        elif mode=='ms':
	        mv.browseCommands('msmsCommands', commands=('computeMSMS',), log=0)
	        mv.browseCommands('msmsCommands', commands=('displayMSMS',), log=0)
	        mv.addOnAddObjectCmd(mv.computeMSMS, (), {'density':3.0})
	        mv.addOnAddObjectCmd(mv.displayMSMS)
	
        elif mode=='ca':
            mv.browseCommands('traceCommands', commands=('computeTrace',), log=0)
            mv.browseCommands('traceCommands', commands=('extrudeTrace',), log=0)
            mv.browseCommands('traceCommands', commands=('displayTrace',), log=0)
	    mv.addOnAddObjectCmd(mv.computeTrace)
	    mv.addOnAddObjectCmd(mv.extrudeTrace)
	    mv.addOnAddObjectCmd(mv.displayTrace)

        elif mode=='bt':
            mv.browseCommands('bondsCommands',
			  commands=('buildBondsByDistance',), log=0)
            mv.browseCommands('displayCommands',
			  commands=('displayBackboneTrace',), log=0)
	    mv.addOnAddObjectCmd(mv.displayBackboneTrace, (), 
			     {'cquality':8, 'bquality':10, 'cradius':0.25,
			      'bRad':0.33} )
	    
        elif mode=='sp':
            mv.browseCommands('splineCommands', commands=('computeSpline',), log=0)
            mv.browseCommands('splineCommands', commands=('extrudeSpline',), log=0)
            mv.browseCommands('splineCommands',
			  commands=('displayExtrudedSpline',), log=0)
	    mv.addOnAddObjectCmd(mv.computeSpline)
	    mv.addOnAddObjectCmd(mv.extrudeSpline)
	    mv.addOnAddObjectCmd(mv.displayExtrudedSpline)

        elif mode=='sssb':
            mv.browseCommands('displayCommands',
			  commands=('displaySSSB',), log=0, package='Pmv')
	    mv.addOnAddObjectCmd(mv.displaySSSB)


    def setcmode(self,mode, mv):
        """
    load color commands for mode and set them as default command for new molecule
        """
        if mode=='ca':
            mv.browseCommands('colorCommands', commands=('colorByAtomType',),
			  log=0, package='Pmv')
	    mv.addOnAddObjectCmd(mv.colorByAtomType)

        elif mode=='cr':
            mv.browseCommands('colorCommands',
			  commands=('colorByResidueType',), log=0)
	    mv.addOnAddObjectCmd(mv.colorByResidueType)
	    
        elif mode=='cc':
            mv.browseCommands('colorCommands', commands=('colorByChains',),
			  log=0, package='Pmv')
	    mv.addOnAddObjectCmd(mv.colorByChains)

        elif mode=='cm':
            self.mv.browseCommands('colorCommands', commands=('colorByMolecules',),
			       log=0, package='Pmv')
    	    mv.addOnAddObjectCmd(mv.colorByMolecules)

        elif mode=='cdg':
            mv.browseCommands('colorCommands', commands=('colorAtomsUsingDG',),
			  log=0, package='Pmv')
	    mv.addOnAddObjectCmd(mv.colorAtomsUsingDG)

        elif mode=='cs':
            mv.browseCommands('colorCommands',
			  commands=('colorResiduesUsingShapely',), log=0 )
	    mv.addOnAddObjectCmd(mv.colorResiduesUsingShapely)

        elif mode=='css':
            mv.browseCommands('secondaryStructureCommands',
			  commands=('colorBySecondaryStructure',), log=0)
	    mv.addOnAddObjectCmd(mv.colorBySecondaryStructure)
    
    def callpmv(self,dmode,cmode,mol):
        self.mol=mol
        from Pmv.moleculeViewer import MoleculeViewer
        
        mv = MoleculeViewer(logMode="no", customizer="./empty", verbose=False,
                            #withShell=0, 
                            )

        mv.browseCommands('fileCommands',package= 'Pmv')
        
        mv.browseCommands('deleteCommands',package='Pmv') 
        mv.browseCommands('colorCommands',package='Pmv')
        mv.browseCommands("interactiveCommands",package='Pmv')
        mv.browseCommands("displayCommands",package = 'Pmv')
        mv.browseCommands("bondsCommands",
                          commands=['buildBondsByDistance'],
                          package='Pmv', log = 0)
        
        mv.setOnAddObjectCommands(['buildBondsByDistance',
                                       'displayLines'],
                                  log=0)
        self.mv=mv
        #self.mv.readMolecule("Data/1crn.pdb")
        
        if dmode is not None or cmode is not None:
        # save current list of commands run when a molecule is loaded
            
            addCmds = self.mv.getOnAddObjectCmd()
	    # remove them
	    for c in addCmds:
	        print c
            self.mv.removeOnAddObjectCmd(c[0])
	    # set the mode
	    #self.setdmode('lines',self.mv)
        self.setdmode(dmode, self.mv)

        if cmode is not None:
	        # set the mode
	        self.setcmode(cmode, self.mv)
	        
        mv.readMolecule(self.mol)

        if dmode is not None or cmode is not None:
            # get current list of commands run when a molecule is loaded
            cmds = self.mv.getOnAddObjectCmd()
	    # remove them
	    for c in cmds:
	        self.mv.removeOnAddObjectCmd(c[0])
	    # restore original list of commands
	    for c in addCmds:
	        apply( self.mv.addOnAddObjectCmd, c )


    def tearDown(self):
        self.mv.Exit(0)
        
        
class PmvModeTests(PmvScriptBaseTest):


    def test_pmvscript_mode_cpk(self):
        """checks starting pmv with displaymode 'cpk' and colormode coloratoms by
        davidgoodsell colors 'cdg'"""
        dmode = 'cpk'
        cmode='cdg'
        mol="Data/1crn.pdb"
        self.callpmv(dmode,cmode,mol) 
        cpkats = self.mv.Mols[0].geomContainer.atoms['cpk'] 
        cpkvertices = self.mv.Mols[0].geomContainer.geoms['cpk'].vertexSet
        #checks command loaded
        self.assertEqual(hasattr(self.mv,'displayCPK'),True)
        #checks cpk is displayed
        self.assertEqual(len(cpkats),327)
        #checks cpkgeometry vertices >0
        self.assertEqual(len(cpkvertices)>0,True)


    def test_pmvscript_mode_ss(self):
        """checks starting pmv with displaymode secondary structure 'ss' and colormode colorBySecondarystructure 'css'"""
        dmode = 'ss'
        cmode='css'
        mol="Data/1crn.pdb"
        self.callpmv(dmode,cmode,mol) 
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"ribbon"),True)
        #checks geomC has key secondary structure 
        self.assertEqual(self.mv.Mols[0].geomContainer.atoms.has_key("secondarystructure"),True)
        #checks chain has attr secondarystructureset and their length
        self.failUnless( hasattr(self.mv.Mols[0].chains[0], 'secondarystructureset') and \
                         len(self.mv.Mols[0].chains[0].secondarystructureset)==10)


    def test_pmvscript_mode_bt(self):
        """checks starting pmv with displaymode backbone trace 'bt' and colormode colorByResidueType 'cr'"""
        dmode = 'bt'
        cmode='cr'
        mol="Data/1crn.pdb"
        self.callpmv(dmode,cmode,mol)    
        ballvert = self.mv.Mols[0].geomContainer.geoms['CAballs'].vertexSet
        stickvert = self.mv.Mols[0].geomContainer.geoms['CAsticks'].vertexSet
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"displayBackboneTrace"),True)
        #checks geomC has key CAballs and CAsticks
        self.assertEqual(self.mv.Mols[0].geomContainer.atoms.has_key("CAballs"),True) 
        self.assertEqual(self.mv.Mols[0].geomContainer.atoms.has_key("CAsticks"),True)
        #checks caballgeometry vertices >0,castickgeometry vertices >0
        self.assertEqual(len(ballvert)>0,True)
        self.assertEqual(len(stickvert)>0,True)


    def test_pmvscript_mode_lines(self):
        """checks starting pmv with displaymode 'lines' and colormode
        colorByAtomType 'ca'"""
        dmode = 'lines'
        cmode='ca'
        mol="Data/1crn.pdb"
        self.callpmv(dmode,cmode,mol)    
        linevert = self.mv.Mols[0].geomContainer.geoms['bonded'].vertexSet
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"displayLines"),True)
        #checks lines displayed
        self.assertEqual(len(self.mv.Mols[0].geomContainer.atoms['bonded'])>0,True)
        #checks linegeometry vertices >0
        self.assertEqual(len(linevert)>0,True)


    def test_pmvscript_mode_sb(self):
        """checks starting pmv with displaymode SticksandBalls 'sb' and colormode colorByChain 'cc'"""
        dmode = 'sb'
        cmode='cc'
        mol="Data/1crn.pdb"
        self.callpmv(dmode,cmode,mol)    
        ballvert = self.mv.Mols[0].geomContainer.geoms['balls'].vertexSet
        stickvert = self.mv.Mols[0].geomContainer.geoms['sticks'].vertexSet
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"displaySticksAndBalls"),True)
        #checks sticks and balls displayed
        self.assertEqual(len(self.mv.Mols[0].geomContainer.atoms['sticks'])>0,True)
        self.assertEqual(len(self.mv.Mols[0].geomContainer.atoms['balls'])>0,True)
        #checks ballgeometry vertices >0,stickgeometry vertices >0
        self.assertEqual(len(ballvert)>0,True)
        self.assertEqual(len(stickvert)>0,True)


    def test_pmvscript_mode_sp(self):
        """checks starting pmv with displaymode spline 'sp' and colormode color by residues shapely 'cs'"""
        dmode = 'sp'
        cmode='cs'
        mol="Data/1crn.pdb"
        self.callpmv(dmode,cmode,mol)    
        CA_atoms = self.mv.allAtoms.get(lambda x : x.name == 'CA')
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"displayExtrudedSpline"),True)
        #checks geomC has key spline
        self.assertEqual(self.mv.Mols[0].geomContainer.atoms.has_key("spline "),True)
        self.assertEqual(len(self.mv.Mols[0].chains[0].spline['spline '][1]),len(CA_atoms))


    def test_pmvscript_mode_sssb(self):
        """checks starting pmv with displaymode displaySecondarystructure and color mode None"""
        dmode = 'sssb'
        cmode=None
        mol="Data/1crn_test.pdb"
        self.callpmv(dmode,cmode,mol)    
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"displaySSSB"),True)
        #checks geomC has key secondarystructure
        self.assertEqual(self.mv.Mols[0].geomContainer.atoms.has_key("secondarystructure"),True)
        #checks chain has attr secondarystructureset and their length
        self.failUnless( hasattr(self.mv.Mols[0].chains[0], 'secondarystructureset') and \
                         len(self.mv.Mols[0].chains[0].secondarystructureset)==10)


    def test_pmvscript_mode_ca(self):
        "checks starting pmv with displaymode catrace 'ca' and cmode is colorByMolecule 'cm'"
        dmode = 'ca'
        cmode='cm'
        mol="Data/1crn_test.pdb"
        self.callpmv(dmode,cmode,mol)
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"displayTrace"),True) 
        #checks geomC has key trace,CATrace and CATrace geomtry vertices >0
        self.assertEqual(self.mv.Mols[0].geomContainer.atoms.has_key("trace"),True)
        self.assertEqual(self.mv.Mols[0].geomContainer.atoms.has_key("CATrace"),True)
        self.assertEqual(len(self.mv.Mols[0].geomContainer.geoms['CATrace '].vertexSet.vertices.array)>0,True)


    def test_pmvscript_mode_ms(self):
        "checks starting pmv with displaymode msms 'ms' and colormode is None"
        dmode = 'ms'
        cmode=None
        mol="Data/1crn.pdb"
        self.callpmv(dmode,cmode,mol)
        #checks command loaded
        self.assertEqual(hasattr(self.mv,"displayMSMS"),True)
        #checks geomC has key MSMS-MOL
        self.assertEqual(self.mv.Mols[0].geomContainer.geoms.has_key("MSMS-MOL"),True)
        self.assertEqual(self.mv.Mols[0].geomContainer.msmsAtoms["MSMS-MOL"],self.mv.Mols[0].allAtoms)
        self.assertEqual(len(self.mv.Mols[0].geomContainer.geoms["MSMS-MOL"].vertexSet)>0,True)


if __name__ == '__main__':
    unittest.main()
