########################################################################
#
#    Vision Network - Python source code - file generated by vision
#    Friday 13 April 2007 12:35:49 
#    
#       The Scripps Research Institute (TSRI)
#       Molecular Graphics Lab
#       La Jolla, CA 92037, USA
#
# Copyright: Daniel Stoffler, Michel Sanner and TSRI
#   
# revision: Guillaume Vareille
#  
#########################################################################
#
# $Header: /opt/cvs/python/packages/share1.5/Vision/doc/Examples/matplotlib/BoxPlot_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#
# $Id: BoxPlot_net.py,v 1.3 2007/08/29 20:37:16 vareille Exp $
#

from traceback import print_exc
## loading libraries ##
from Vision.matplotlibNodes import matplotliblib
masterNet.getEditor().addLibraryInstance(matplotliblib,"Vision.matplotlibNodes", "matplotliblib")

from Vision.StandardNodes import stdlib
masterNet.getEditor().addLibraryInstance(stdlib,"Vision.StandardNodes", "stdlib")

try:
    ## saving node BoxPlot ##
    from Vision.matplotlibNodes import BoxPlotNE
    BoxPlot_5 = BoxPlotNE(constrkw = {}, name='BoxPlot', library=matplotliblib)
    masterNet.addNode(BoxPlot_5,127,312)
    BoxPlot_5.inputPortByName['notch'].widget.set(1, run=False)
    BoxPlot_5.inputPortByName['color'].widget.set("r", run=False)
    BoxPlot_5.inputPortByName['linestyle'].widget.set("s", run=False)
except:
    print "WARNING: failed to restore BoxPlotNE named BoxPlot in network masterNet"
    print_exc()
    BoxPlot_5=None

try:
    ## saving node ReadTable ##
    from Vision.StandardNodes import ReadTable
    ReadTable_6 = ReadTable(constrkw = {}, name='ReadTable', library=stdlib)
    masterNet.addNode(ReadTable_6,78,7)
    ReadTable_6.inputPortByName['filename'].widget.set("Data/boxplot_data.dat", run=False)
    ReadTable_6.inputPortByName['sep'].widget.set(",", run=False)
    ReadTable_6.inputPortByName['datatype'].widget.set("float", run=False)
    apply(ReadTable_6.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore ReadTable named ReadTable in network masterNet"
    print_exc()
    ReadTable_6=None

try:
    ## saving node Index ##
    from Vision.StandardNodes import Index
    Index_7 = Index(constrkw = {}, name='Index', library=stdlib)
    masterNet.addNode(Index_7,102,173)
    apply(Index_7.configure, (), {'expanded': True})
except:
    print "WARNING: failed to restore Index named Index in network masterNet"
    print_exc()
    Index_7=None

masterNet.freeze()

## saving connections for network BoxPlot ##
if ReadTable_6 is not None and Index_7 is not None:
    try:
        masterNet.connectNodes(
            ReadTable_6, Index_7, "data", "data", blocking=True)
    except:
        print "WARNING: failed to restore connection between ReadTable_6 and Index_7 in network masterNet"
if Index_7 is not None and BoxPlot_5 is not None:
    try:
        masterNet.connectNodes(
            Index_7, BoxPlot_5, "data", "x", blocking=True)
    except:
        print "WARNING: failed to restore connection between Index_7 and BoxPlot_5 in network masterNet"
masterNet.unfreeze()
#masterNet.run()

