/*
 *   mwmmsg.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
/*****************************************************************************/
/* Strings numbered from 1 to this constant are used to put info             */
/* into the display line.                                                    */
/*****************************************************************************/
#define MWM_STR_LAST_DISPLAY_STRING   13

#define MWM_STATE_INITIALIZING  1
#define MWM_STATE_READY         2
#define MWM_STATE_DIALING       3
#define MWM_STATE_NEGOTIATING   4
#define MWM_STATE_CONNECT       5
#define MWM_STATE_LINEINUSE     6
#define MWM_STATE_FAX           7
#define MWM_STATE_TAM           8
#define MWM_STATE_HANDSET       9
#define MWM_STATE_FAXRECEIVE    10
#define MWM_STATE_FAXSEND       11


/*****************************************************************************/
/* The following IDs are used for DOS specific messages.                     */
/*****************************************************************************/
#define MWM_DOSSTR_BANNER_1       32
#define MWM_DOSSTR_LOADED         33
#define MWM_DOSSTR_LOAD_FAIL      34
#define MWM_DOSSTR_CANT_UNLOAD    35
#define MWM_DOSSTR_FILE_NOT_FOUND 36
#define MWM_DOSSTR_UNLOADED       37
#define MWM_DOSSTR_UNINSTALLED    38
#define MWM_DOSSTR_BAD_PARM       39
#define MWM_DOSSTR_ALREADY_LOADED 40
#define MWM_DOSSTR_HELP           41
#define MWM_DOSSTR_HELP1          42
#define MWM_DOSSTR_HELP2          43
#define MWM_DOSSTR_HELP3          44
#define MWM_DOSSTR_HELP4          45
#define MWM_DOSSTR_HELP5          46
#define MWM_DOSSTR_HELP6          47

#define MWM_DOSSTR_NOT_LOADED     48

/*****************************************************************************/
/* The following IDs are used by MWAUDIO for DOS specific messages.      */
/*****************************************************************************/
#define  MWA_DOSSTR_BANNER_1              2000
#define  MWA_DOSSTR_LOADED_1_5            2001
#define  MWA_DOSSTR_LOADED_PRO_1          2002
#define  MWA_DOSSTR_UNLOADED              2003
#define  MWA_DOSSTR_ERROR_1               2004
#define  MWA_DOSSTR_NOT_LOADED            2005
#define  MWA_DOSSTR_APM_DRIVER            2006


/*****************************************************************************/
/* The following identifiers are used for Mwave Modem messages.              */
/* These are the messages used by MWMODEM.EXE                                */
/*****************************************************************************/
#define MWM_STR_INTERNALERROR       256
#define MWM_STR_PHONE_LINE_IN_USE   257
#define MWM_STR_HANDSET_IN_USE      258
#define MWM_STR_COM_IN_USE          259
#define MWM_STR_MANAGER_OVERCOMMIT  260
#define MWM_STR_DSP_FILE_NOT_FOUND  261
#define MWM_STR_SPEED_NOT_INSTALLED 262
#define MWM_STR_NO_MANAGER          263
#define MWM_STR_INVALID_COUNTRY     264

#define MWM_STR_WINDOW_TITLE        272
#define MWM_STR_HELP_NOT_AVAIL      273
#define MWM_STR_SCRFORMAT           274
#define MWM_STR_LOGFORMAT           275
#define MWM_STR_PRIMARY             276
#define MWM_STR_SECONDARY           277
#define MWM_STR_FILE                278
#define MWM_STR_LINE                279

#define MWM_STR_2400                290
#define MWM_STR_9600                291
#define MWM_STR_14400               292
#define MWM_STR_19200               293
#define MWM_STR_28800               294
#define MWM_STR_33600               295
#define MWM_STR_56K                 296
#define MWM_STR_64000               297
#define MWM_STR_V22BIS              298
#define MWM_STR_V32BIS              299
#define MWM_STR_V34                 300
#define MWM_STR_X2                  301
#define MWM_STR_K56FLEX             302
#define MWM_STR_V90                 303
#define MWM_STR_WARNING             304
#define MWM_STR_CONCURRENCY         305
#define MWM_STR_56K_CONCURRENCY     306
#define MWM_STR_VOLTAGETITLE        307
#define MWM_STR_VOLTAGEWARNING1     308
#define MWM_STR_VOLTAGEWARNING2     309
#define MWM_STR_VOLTAGEWARNING3     310
#define MWM_STR_VOLTAGEWARNING4     311

#define MWM_STR_DETAILS             400
#define MWM_STR_RESTART             401
#define MWM_STR_CLOSE               402
#define MWM_STR_ERROR_TITLE         403
#define MWM_STR_ERROR1              404
#define MWM_STR_ERROR2              405
#define MWM_STR_ERROR3              406
#define MWM_STR_ERROR4              407

#define MWM_STR_SEND                450
#define MWM_STR_RECEIVE             451
#define MWM_STR_RESTORE             452
#define MWM_STR_HIDE                453
#define MWM_STR_ALWAYSONTOP         454

#define MWM_STR_X2ONLY              470
#define MWM_STR_V90ONLY             471

#define MWM_STR_NOX2                480

/*****************************************************************************/
/*  Help Table Definitions.                                                  */
/*****************************************************************************/
#define MWM_MAIN_HELPTABLE             10
#define MWM_MENU_SUBTABLE             100
#define MWM_MAIN_HELP_PANEL          1000
#define MWM_INTERNALERROR_HELP       1001
#define MWM_PHONE_LINE_IN_USE_HELP   1002
#define MWM_HANDSET_IN_USE_HELP      1003
#define MWM_COM_IN_USE_HELP          1004
#define MWM_MANAGER_OVERCOMMIT_HELP  1005
#define MWM_DSP_FILE_NOT_FOUND_HELP  1006
#define MWM_NO_MANAGER_HELP          1007
#define MWM_SPEED_NOT_INSTALLED_HELP 1008



/*****************************************************************************/
/* Max string lengths...these may vary by language.                          */
/*****************************************************************************/
#define MWM_MAX_MESSAGE_LENGTH          256
#define MWM_MAX_FILENAME_LENGTH         256   /*Allocate this many characters for qualified filenames.*/
#define MWM_MAX_DISPLAY_MESSAGE_LENGTH  256

#define MWM_MODEM_LIGHT_TEXT_LENGTH     6



/*****************************************************************************/
/* Resource IDs for LED Text.                                                */
/* 4/20/93                                                                   */
/*****************************************************************************/
#define MWM_STR_POWER_LED         64
#define MWM_STR_DTR_LED           65
#define MWM_STR_SENDDATA_LED      66
#define MWM_STR_RECEIVEDATA_LED   67
#define MWM_STR_OFFHOOK_LED       68
#define MWM_STR_CARRIERDETECT_LED 69
#define MWM_STR_AUTOANSWER_LED    70
#define MWM_STR_HIGHSPEED_LED     71


/*****************************************************************************/
/* Primary Error Codes                                                       */
/*                                                                           */
/* Secondary Error Codes are generally either 0 or the return code of the    */
/* specified dsp Manager call.                                               */
/*****************************************************************************/
#define MWM_DSP_ERROR                  1
#define MWM_MEIO_ERROR                 2
#define MWM_OS_ERROR                   4
#define MWM_WT_ERROR                   5  /* MTS 3361*/
#define MWM_DIS_ERROR                  6  /* MTS 2416*/
#define MWM_BL_ERROR                   7  /* Blacklister Error - Added 03/14/97*/
#define MWM_DEBUG_MESSAGE             15
#define MWM_USER_MESSAGE              16


