/*
 *   mwmspcfc.h
 *
 *  Written By: Paul Schroeder IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#include <mwmparse.h>

/*****************************************************************************/
/* DCR 3444 .. Integrate world trade stuff...                                */
/*****************************************************************************/
#include <mwagent.h>
#include <mwwttbl.h>
#include <mwnotify.h>  // DCR 2456

#include "mwmqsize.h"
#include <datamove.h>

#define MW_START2400         0    // Must be 0...indicates non-automode modem.
#define MW_START9600         1
#define MW_START14400        2
#define MW_START19200        3
#define MW_START28800        4
#define MW_START33600        5
#define MW_START64000        6
#define MW_BADPARAMETER      7


/*****************************************************************************/
/* MTS 2916                                                                  */
/*****************************************************************************/
#define MWM_DETECTION_CPF   0
#define MWM_CONNECTION_CPF  1

#define MWM_ASYNC_PACING_OFFSET   0
#define MWM_ASYNC_ASYNC_OFFSET    2
#define MWM_ASYNC_ECC_1X_OFFSET   4
#define MWM_ASYNC_ECC_2X_OFFSET   6
#define MWM_ASYNC_ECC_3X_OFFSET   8
#define MWM_ASYNC_ECC_4X_OFFSET  10
#define MWM_ASYNC_ECC_5X_OFFSET  12


#define MSG_missingstring     "Cannot Load Message from String Table"

#define MWM_DSP_ENVIRONMENT_VARIABLE   "MWPATH"
#define MWM_ERROR_FILENAME             "MWMERROR.LOG"

#define MWM_SUBCODE_1   1
#define MWM_SUBCODE_2   2
#define MWM_SUBCODE_3   3
#define MWM_SUBCODE_4   4
#define MWM_SUBCODE_5   5

typedef struct
{
  HWND   hwndMainWindow;
  ULONG  ulUsePopups;
  HANDLE hInstance;
  HANDLE hinstResources;
} MWM_INSTANCE_INFO, *PMWM_INSTANCE_INFO;



/*****************************************************************************/
/* These are the bit definitions for the MCTL STATUS public label.           */
/*****************************************************************************/
#define  MWM_STATUS_V42BIS_RECEIVE   0x0020  /* v42bis receive only connection */
#define  MWM_STATUS_V42BIS_TRANSMIT  0x0010  /* v42bis transmit only connection */
#define  MWM_STATUS_V42BIS_BIDIRECT  0x0008  /* v42bis bidirectional connection */
#define  MWM_STATUS_V42BIS_CONNECT   0x0038  /* Bits of Protocol to indicate v42bis */
#define  MWM_STATUS_MNP5_CONNECT     0x0001  /* bit of Protocol to indicate mnp 5   */
#define  MWM_STATUS_MNP_CONNECT      0x2000  /* bit of protocol to indicate mnp 1-4 */
#define  MWM_STATUS_V42_CONNECT      0x4000  /* bit of protocol to indicate v.42    */
#define  MWM_STATUS_V120_CONNECT     0x1000  /* bit of protocol to indicate v.120   */
#define  MWM_STATUS_V22BIS_CONNECT   0x0080  /* bit of protocol to indicate v.22bis */
#define  MWM_STATUS_V32BIS_CONNECT   0x0100  /* bit of protocol to indicate v.32bis */
#define  MWM_STATUS_V34_CONNECT      0x0200  /* bit of protocol to indicate v.34    */
#define  MWM_STATUS_V80_CONNECT      0x0800  /* bit of protocol to indicate V80   $4*/
#define  MWM_STATUS_H324_CONNECT     0x0400  /* bit of protocol to indicate H324 videophone  $4*/
#define  MWM_STATUS_PCM_CONNECT      0x8000  /* bit of protocol to indicate PCM */


/*****************************************************************************/
/* Structure used to hold Modem status information.  This structure is       */
/* filled by reading a public label from MCTL.  It is then passed to the     */
/* window procedure with the MWM_UPDATEMODEMLIGHTS message.                  */
/*****************************************************************************/
typedef struct
{
   USHORT       usModemLights;
   USHORT       usLineSpeed;
   USHORT       usProtocol;
   USHORT       usV42bisDictionarySize;
}MWM_MODEM_STATUS, *PMWM_MODEM_STATUS;

#define ANSWER  0
#define DIAL    1

/*****************************************************************************/
/* DCR 2487                                                                  */
/* Definitions for various features that should be loaded at startup...      */
/*****************************************************************************/
#define FEATURE_AUTOMODE     0x0007  // mask for any of the high speed pumps (except V.34)
#define FEATURE_V32          0x0001
#define FEATURE_V32BIS       0x0002
#define FEATURE_V32TER       0x0004
#define FEATURE_V34          0x0008
#define FEATURE_DISCRIM      0x0010
#define FEATURE_CLASS2       0x0020
#define FEATURE_MNP          0x0040
#define FEATURE_MNP5         0x0080
#define FEATURE_V42BIS       0x0f00  // Mask to determine if feature is available
#define FEATURE_V42BIS_512   0x0100  // These say which one to load...
#define FEATURE_V42BIS_1024  0x0200  //
#define FEATURE_V42BIS_2048  0x0400  //
#define FEATURE_V42BIS_4096  0x0800  //
#define FEATURE_V42           0x1000
#define FEATURE_MNPPRELOAD    0x2000  // PRELOADPROBLEM
#define FEATURE_SLIMBASE      0x4000  // SLIMBASE               // MTS=SB
#define FEATURE_V80           0x8000  // V.80 enabled (set in ulFeaturesToLoad) $1
#define FEATURE_V8           0x20000  // V.8 Support
#define FEATURE_V42PRELOAD   0x40000  // Preload V.42 like MNPPRELOAD MTS 4192
#define FEATURE_GETSIZE      0x80000  // Query resource usage (debug) at different load states.
#define FEATURE_CLASS1      0x100000  // Class 1 Fax.
#define FEATURE_V23         0x800000  // V.23
#define FEATURE_V34EM       0x1000000 // V.34 Enhanced Mode
#define FEATURE_V32BISSTUB  0x4000000 // V.32bis Stub Task
#define FEATURE_PCM         0x8000000 // V.PCM
#define FEATURE_ASYNC2X     0x10000000 // ASYNC2X


/**********************************************************
** PCM Bitmaps for INI File value
***********************************************************/
#define FEATURE_X2              0x0001
#define FEATURE_K56FLEX         0x0002
#define FEATURE_PCM_INTERIM     0x0004
#define FEATURE_V90             0x0008
#define FEATURE_PCM_SYMMETRIC   0x0010

/**********************************************************
** Offsets in V.34 DYNASEGM table
***********************************************************/
#define OFFSET_PHASE2SUB         2
#define OFFSET_DATAMODEINIT      4
#define OFFSET_PHASE2            6
#define OFFSET_PHASE34           8
#define OFFSET_DATAMODEDATA1    10
#define OFFSET_DATAMODEDATA2    12
#define OFFSET_DATAMODEDATA3    14
#define OFFSET_V34CONSTEL       16
#define OFFSET_DATAMODE1        18
#define OFFSET_DATAMODE2        20
#define OFFSET_DATAMODE3        22
#define OFFSET_PHASE2DATA1      24
#define OFFSET_PHASE2DATA2      26
#define OFFSET_X2PHASE34        28
#define OFFSET_X2PHASE34D       30
#define OFFSET_X2DMINIT         32
#define OFFSET_X2DM1            34
#define OFFSET_X2DMDATA1        36
#define OFFSET_X2DMDATA2        38

/**********************************************************
** Masks for V.34 DynaSegs Debug Segments
***********************************************************/
#define DSDEBUG_PHASE34         0x0001
#define DSDEBUG_X2PHASE34       0x0002

/**********************************************************
** Masks for V.34 segments to load
***********************************************************/
#define ALL_CODE_SEGMENTS       0x0000
#define NO_DATAMODE1            0x0001
#define NO_DATAMODE2            0x0002
#define NO_DATAMODE3            0x0004

/**********************************************************
** Which ASYNC task to use for data connections?
***********************************************************/
#define ASYNC1X                 0x0000
#define ASYNC2X                 0x0001

typedef struct
{
   HSEG         ahsegMemPool[15];
   HCONNECTION  hConnect1;            // HANDIN_1->TELEOUT_1 (class80:HANDIN_1->VOICEADC_1)
   HCONNECTION  hConnect2;
   HCONNECTION  hConnect3;
   HCONNECTION  hConnect4;
   HCONNECTION  hConnectUart;
   HCONNECTION  hConnectMicCDADC;
   ULONG        ulFeaturesToLoad;  // DCR 2487
   ULONG        ulLongTermFeatures;
   ULONG        ulInstalledFeatures;
   HDSP         hDSP;                  // Pointer to DSP handle
   ULONG        ulAddressLEDS;    /*CH01*/
   USHORT       usLineOwned;
   USHORT       usUARTMode;
   HMOD         hmodInterpolator;
   HMOD         hmodCallProg;          // MTS 3361
   HMOD         hmodV22;
   HMOD         hmodVDP;
   /* Class 2 fax Module Handles */
   HMOD         hmodT30;          // Change FAX00 to T30  11/20/96
   HMOD         hmodFAXPMP;       // also used in class 80
   HMOD         hmodCLASSx;       // Class2, class1, class8, or class80 module
   HMOD         hmodSILDET;       // Fax Silence Detection module
   /* End of Class 2 Modules */
   /* DCRs 2416 and 2487 */
   ULONG        ulModemPriority;  // These should probably be variable for multiple
   ULONG        ulModemPriority2; // instances of the modem
   ULONG        ulModemPriority3;
   USHORT       usContendRetry;
   /* End of DCR 2456 */
   HMOD         hmodModem;
   HMOD         hmodAsync;
   HMOD         hmodMNP;
   HMOD         hmodMNP5;
   HMOD         hmodV42bis;
   HMOD         hmodV42;
   HMTASK       hmtV42PKT;             // V.42 Packet task handle
   HMTASK       hmtV42LAPDLC;          // V.42 LAP DLC Task handle
   HMTASK       hmtV42MAC;             // V.42 MAC Task handle
   HMTASK       hmtV42bis;             // V.42bis task handle
   HMTASK       hmtMNP5;               // MNP5 task handle
   HMTASK       hmtProtSupr;
   HMTASK       hmtCLASSx;        // Class2, class1, class8, or class80 task
   HMTASK       hmtT30;                // 11/20/96 Tim..Change hmtFAXMAN to hmtT30
   HMTASK       hmtMHINT;
   /* End additions for DCRs 2416 and 2487 */
   HMTASK       hmctlTask;             // modem control task handle
   HMTASK       hv22Task;              // v22 task handle
   HMTASK       hvdpTask;              // vdp task handle
   HMTASK       hasyTask;              // async task handle
   HMTASK       hmtMNP;                // mnp task handle
   HMTASK       hinterpTask;           // interpolator task handle
   HMTASK       hmtUART;               // UART Task Handle
   HMOD         hmodFakeUART;          // UART Module Handle
   HMTASK       hmtFakeUART;           // MTS 4263
   HMTASK       hmtCallProg;           // MTS 3361
   HMTASK       hmtCallProgMove;       // MTS 3361
   HSEG         hsegPercentTT;         // MTS
   HMOD         hmodRAMMBASE;
   HMOD         hmodGSM;
   HMOD         hmodSPKVOD;
   HMTASK       hmtRAMMBASE;
   HMTASK       hmtGSMCOD;
   HMTASK       hmtGSMDEC;
   HMTASK       hmtMOVE79;
   HMTASK       hmtMOVE97;
//   HMTASK       hmtINTERP8;
//   HMTASK       hmtDECIMA;
   HMTASK       hmtSPKVOD;
   HMOD         hmodV8;
   HMTASK       hmtV8;
   HMOD         hmodV34;
   HMTASK       hmtV34;
   HSEG         hsegAsyncACMPROC;
   HSEG         hsegAsyncECMPROC;
   HSEG         hsegV42UI_seg;
   HSEG         hsegV42XID_seg;                                     //$B
   HSEG         hsegV42DET_seg;                                     //$B
   HSEG         hsegV42BTempGPC1;
   HSEG         hsegV42BTempGPC2;
   HSEG         hsegV42BTempDSEG;
   HSEG         hsegMCTLDIALT;
   /* DCR 2416 Integrate Discriminator */
   /* End of DCR 2416 */
   ULONG        ulDiscrimState;
   /* Class 1 Module Handles */
// HMOD         hmodCLASS1;
   HMOD         hmodCL1_HDLC;
// HMTASK       hmtCLASS1;
   HMTASK       hmtCL1_HDLC;
   /* End of Class 1 Module Handles */
   /* 12/08/95 Voice Handles */
   HMOD         hmodCANCEL;
   HMOD         hmodSPK076;
   HMOD         hmodDTMFRM;
   HMOD         hmodINT9608;
   HMOD         hmodINT0896;
   HMOD         hmodMIX9LINE;
   HMOD         hmodMIX9RECORD;
   HMOD         hmodGAINWT;
   HMOD         hmodAGC9;
   HMOD         hmodAGC9WT;
   HMOD         hmodAGC8;
   HMOD         hmodDISC;
   HMTASK       hmtCANCEL;
   HMTASK       hmtSPK076;
   HMTASK       hmtSPK076DBM944;
   HMTASK       hmtDTMFRMMove;
   HMTASK       hmtDTMFR;
   HMTASK       hmtINT9608;
   HMTASK       hmtINT0896;
   HMTASK       hmtMIX9LINE;
   ULONG        ulDSPAddrGPCSpeakerphoneToLine;
   ULONG        ulDSPAddrGPCWaveToLine;
   HMTASK       hmtMIX9RECORD;
   ULONG        ulDSPAddrGPCSpeakerphoneToWave;
   ULONG        ulDSPAddrGPCLineToWave;
   HMTASK       hmtGAINWT;
   HMTASK       hmtAGC9;
   HMTASK       hmtAGC9WT;
   HMTASK       hmtAGC8;
   HMTASK       hmtDISC;
   HMTASK       hmtDISCFILT;
   LONG         lSpeakerVolume;
   LONG         lMicGain;
   ULONG        ulClass8StateFlags;
   HCONNECTION  hconSpeakerphone;
   /* 12/08/95 End of Voice Handles */
   /* 1/16/96 Segment handle for class 1 */
   HSEG         hsegMCTLSUBS1;
   HSEG         hsegMCTLFAX00;
   ULONG        ulDSPAddrV34DYNASEGS;
   ULONG        ulDSPAddrV34DYNASEG_TABLE;
   USHORT       bCIDCapability;                 /* caller ID capable(1) */
   HMOD         hmodCALLERID;                   /* caller ID module */
   HMTASK       hmtCALLERID_ASYNC;              /* caller ID async task */
   HSEG         hsegMCTLCTL08;                  // MCTL Class 8 Segment */
   /* 04/15/96 - VoiceView handles */
   HMOD         hmodVVPROT;
   HMOD         hmodVVHDLC;
   HMOD         hmodTONEGEN;
   HMOD         hmodROUTER;
   HMOD         hmodVV0896;                     /* optional interpolators */
   HMOD         hmodVV9608;
   HSEG         hsegMCTLCTL80;
   HCONNECTION  hConnectVIO;                    /* VOICEDAC_1->HANDOUT_1 */
   /*          - end of VoiceView handles */
   ULONG        ulModemPriorityMIDIGameMode;    // MTS 6601 New RAD for MIDI Games mode
   ULONG        ulDialingModem;
   /* Begin 33600bps support DR 07/08/96 */
   ULONG        ulDSPAddrV34EMCtrl;
   ULONG        ulDSPAddrPCMCtrl;
   ULONG        ulDSPAddrComS28Min;
   BOOL         bV34EMConnectionPossible;
   BOOL         bV34EMResponseReceived;
   BOOL         bV34EMConnectionEstablished;
   /* End 33600bps support */
   HSEG         hsegCLASSxV80_ON;  //$3
   HMOD         hmodV80MAC;        //$5 V80MAC module handle
   HMTASK       hmtV80MAC;         //$5 V80MAC module handle
   /* Begin native audio support */
   HMOD         hmodpc2gpc;
   HMTASK       htpc2gpc;
   HMOD         hmodvplay;
   HMTASK       htvplay;
   HMOD         hmodgpc2pc;
   HMTASK       htgpc2pc;
   HMOD         hmodvrec;
   HMTASK       htvrec;

   HMOD         hmodADPCM;
   HMTASK       hmtADPCM_COMPRESS;
   HMTASK       hmtADPCM_DECOMPRESS;

   NadDatamoverStream_t nadPlay;
   NadDatamoverStream_t nadRecord;
   HIPC         hIPC;           //$9
   HIPC         hIPC2;          //$9
   RIPCINFO     IPCInfo;        //$9
   RIPCINFO     IPCInfo2;       //$9
   /* End native audio support */
   HMOD         hmodDRing;
   HMTASK       hmtDRing;
   USHORT       bDRingCapability;
   /* Tim 11/20/96 Class 2 Restructure */
   HMOD         hmodMHINT;
   /* Tim 11/20/96 End of Class 2 Restructure */
   BOOL         bPercentTTMode;     // DR 11/20/96 PercentTTMode Flag
   USHORT       us17MIPS;           // DR 11/20/96 17 MIPS platform flag
   USHORT       usDynaSegmValue;    // MTS 7795 - DR 02/17/96
   USHORT       usV34RAD;           // V.34 RAD Flag - 02/24/97 DR              //$C
   BOOL         bV80HandsetSnoop;   // DR 02/12/97 V.80 Handset Snoop           //$C
   USHORT       usV80RAD;           // V.80 RAD Flag - 03/11/97 DR
   ULONG        ulBlcklistModemHandle;  // Blacklister handle for data calls
   ULONG        ulBlcklistFaxHandle;    // Blacklister handle for fax calls
   ULONG        ulBlcklistVoiceHandle;  // Blacklister handle for voice calls
   BOOL         bOverVoltageTestingEnabled;  // Over-current/voltage testing
   USHORT       usPCMValue;         // PCM value in INI file
   BOOL         bPCMConnectionPossible;
   USHORT       usPCMConnection;
   BOOL         bPCMResponseReceived;
   BOOL         bFirstIPC83Received;
   USHORT       usDSDebugValue;
   USHORT       usQuoteNValue;
   char         achV34ModuleName[25];
   USHORT       usMEIOToggle;
   HIPC         hmctlIPC;           // Modem Control IPC handle
   BOOL         bSuspending;
   ULONG        ulDSPAddrX2Datamodes;
   BOOL         bSuspendingDuringCall;
   REGISTERS    SavedRegisters;
   ULONG        ulDSPAddrBitrateX;
   ULONG        ulDSPAddrBitrateR;
   USHORT       usDialOrAnswerFlag;
   USHORT       usLongTermPCMValue;
   BOOL         bV90x2AutomodingDone;
   BOOL         bCarrierDetected;
   USHORT       usConnectSpeed;
   HMTASK       hmtV42LAPDLCxmit;      // V.42 LAP DLCxmit Task handle
   HMTASK       hmtV42MACxmit;         // V.42 MACxmit Task handle
   USHORT       usWTChangeDRVRSTATValue;
} MWM_DSPINFO, *PMWM_DSPINFO;

extern PMWM_DSPINFO pGlobalDspInfo;
/*****************************************************************************/
/* Global variables used by LOAD functions.                                  */
/* Moved out of DSP_INFO to allow restarting modem.                          */
/*****************************************************************************/
#ifdef DEBUG
extern USHORT      usDebugWindow;
extern USHORT      usShowTimeStamp;
#endif
extern PMWM_INSTANCE_INFO pInstanceInfo;
extern PVOID       INIFile;
extern HANDLE      hinstDiscrim;    // MTS 2416
extern HMEIO       hMEIO;
extern PFNWRITEDSPSNAPSHOT pfnWriteDSPSnapshot;
/* MTS RADD Variables for MWCONTEND */
extern HMCONV      hMwContend;
/* Handles to the BlackListing Server */
extern HMCONV      hMwBlackList;
/* DCR 2456 Power Management */
extern HMWAVE      hMwave;
extern HMCONV      hMwNotify;
extern HMCONV      hMWQueryClient;



ULONG mwmcapiMoveUARTToDMA(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmcapiMoveDMAToUART(PMWM_DSPINFO pmwmDspInfo);


ULONG mwmFaxDialToClass2(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxClassxDiscrimToDiscrim(PMWM_DSPINFO pmwmDspInfo, USHORT usClass);
ULONG mwmFaxClass2ToDial(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxModemToDiscrim(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxDiscrimToClassxDiscrim(PMWM_DSPINFO pmwmDspInfo, USHORT usClass);
ULONG MWM_ENTRY mwmFaxQueryProtocol(PMWM_DSPINFO pmwmDspInfo, char *achFaxProtocol);
ULONG mwmFaxReceivedFCLASS0(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxReceivedFCLASS1(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxReceivedFCLASS2(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxReceivedFCLASS8(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxDialToClass1(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxDialToClass8(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmFaxReceivedSubclassV80(PMWM_DSPINFO pmwmDspInfo);  //$1


ULONG mwmLoadCallProgress(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadConfiguration(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadDiscrimBase(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadDiscrimToDial(PMWM_DSPINFO pmwmDspInfo);       // MTS 2416
ULONG mwmLoadDialToModem(PMWM_DSPINFO pmwmDspInfo);         // MTS 2416
ULONG mwmLoadInterpolator(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadCarrierDetectToProtocol(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadLineSpeedToCarrierDetect(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadMakeMEIOConnections(PMWM_DSPINFO pmwmDspInfo);
//ULONG mwmLoadMakeMNPConnections(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed);
ULONG mwmLoadMakeMNPConnections(PMWM_DSPINFO pmwmDspInfo, HMTASK hmtDatapump);
ULONG mwmLoadMakeMNP5Connections(PMWM_DSPINFO pmwmDspInfo);
//ULONG mwmLoadMakeV42Connections(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed);
ULONG mwmLoadMakeV42Connections(PMWM_DSPINFO pmwmDspInfo, HMTASK hmtDatapump);
ULONG mwmLoadMakeV42bisConnections(PMWM_DSPINFO pmwmDspInfo, MWM_MODEM_STATUS *pModemStatus);
ULONG mwmLoadModemToDial(PMWM_DSPINFO pmwmDspInfo);         // MTS 2416
ULONG mwmLoadDialToDiscrim(PMWM_DSPINFO pmwmDspInfo);       // MTS 2416
ULONG mwmLoadSwapToDummyAsync(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadSwapToRealAsync(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadSwapAsync(PMWM_DSPINFO pmwmDspInfo, USHORT usFastOrSlow);
//ULONG mwmLoadSwapToDummyDatapump(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadSwapDatapumpITCB(PMWM_DSPINFO pmwmDspInfo, USHORT usDPToUse);
ULONG mwmLoadV8AndConnect(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadModemToDpCycles(PMWM_DSPINFO pmwmDspInfo);                                 //$7
ULONG mwmLoadDpCyclesToLineSpeed(PMWM_DSPINFO pmwmDspInfo, USHORT usDontLoadProtocols); //$7
ULONG mwmLoadMNP(PMWM_DSPINFO pmwmDspInfo, HMTASK hTask, USHORT usMustHave);
ULONG mwmLoadSetCurrentSpeed(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmLoadPSV8ITCBSettings(PMWM_DSPINFO pmwmDspInfo);


ULONG mwmPoolAllocateCoreChunk(PMWM_DSPINFO pmwmDspInfo, USHORT *pusCoreChunkAddress);
ULONG mwmPoolFreeCoreChunk(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPoolAllocInitialECBuffer(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPoolFreeV42bisDictionary(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPoolGuessMaxV42bisEntries(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPoolCleanupAfterNegotiation(PMWM_DSPINFO pmwmDspInfo,
                                     MWM_MODEM_STATUS *pModemStatus);
ULONG mwmPoolDummyV34Segments(PMWM_DSPINFO pmwmDspInfo, USHORT usActionFlag );

ULONG mwmPumpsMakeVDPConnections(PMWM_DSPINFO pmwmDspInfo, BOOL bStubTask);
ULONG mwmPumpsMakeV34Connections(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPumpsMakeV22Connections(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPumpsFreeV34Segments(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPumpsFreeV34DataSegments(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPumpsFreeVDPSegments(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPumpsLoadV34Segments(PMWM_DSPINFO pmwmDspInfo, USHORT usSegmentFlag);
ULONG mwmPumpsLoadVDPSegments(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPumpsFreeX2DataSegments(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmPumpsLoadV34DynaSeg(PMWM_DSPINFO pmwmDspInfo, char *pszSegmentName,
                             ULONG ulDynasegsTableOffset, char *pszFilename,
                             SHORT sLine, USHORT usMustHave);
ULONG mwmPumpsFreeV34DynaSeg(PMWM_DSPINFO pmwmDspInfo, char *pszSegmentName,
                             ULONG ulDynasegsTableOffset, char *pszFilename,
                             SHORT sLine);
ULONG MWM_ENTRY mwmPumpsV34IPC(PMWM_DSPINFO pmwmDspInfo, ULONG ulParm1, ULONG ulParm2 );
ULONG MWM_ENTRY mwmPumpsGetBitrates(PMWM_DSPINFO pmwmDspInfo, USHORT *pusSendRate, USHORT *pusReceiveRate );


ULONG mwmRAMMLoadSpeechCoder(PMWM_DSPINFO pmwmDspInfo);         // MTS 4092
ULONG mwmRAMMMakeRAMMBASEConnections(PMWM_DSPINFO pmwmDspInfo, HMTASK hmtDatapump); // MTS 4092
ULONG mwmRAMMLoadGSMSPK(PMWM_DSPINFO pmwmDspInfo, USHORT usNoGSM);
ULONG mwmRAMMUnloadGSMSPK(PMWM_DSPINFO pmwmDspInfo, USHORT usNoGSM);
ULONG mwmRAMMUnloadSpeechCoder(PMWM_DSPINFO pmwmDspInfo);       // MTS 4092

ULONG mwmrspEchoFAXResponse(PMWM_DSPINFO pmwmDspInfo,USHORT usControlStat);
ULONG mwmrspEchoStringToATRLCBUF(PMWM_DSPINFO pmwmDspInfo, PSZ achString);
ULONG mwmrspFDCSResponse(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmrspFDISResponse(PMWM_DSPINFO pmwmDspInfo, USHORT usFDISFlag);
ULONG mwmrspFCSIResponse(PMWM_DSPINFO pmwmDspInfo, USHORT usFCSIFlag);
ULONG mwmrspFPTSResponse(PMWM_DSPINFO pmwmDspInfo, BOOL bGetLineCount);
ULONG mwmrspFHNGResponse(PMWM_DSPINFO pmwmDspInfo);


/*****************************************************************************/
/* Code for the following function definitions is in mwmSpcfc.c              */
/*****************************************************************************/
ULONG        mwmSpcfcAddToVersionList(PMWM_DSPINFO pmwmDspInfo, char *pszFileName,
                                      HMOD hMod, char *pszIdentifier, PVOID INIFile);
ULONG        mwmSpcfcAfterConnectCPFAdjust(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);
ULONG        mwmSpcfcLineSpeedToModemCPFAdjust(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);
ULONG        mwmSpcfcModemToLineSpeedCPFAdjust(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);
ULONG        mwmSpcfcCarrierDetectToProtocolCPFAdjust(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);
ULONG        mwmSpcfcRaiseUARTAsyncCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol, USHORT usMustHave);
ULONG        mwmSpcfcLowerUARTAsyncCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);
ULONG        mwmSpcfcProtocolToLineSpeedCPFAdjust(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);
ULONG        mwmSpcfcSetAsyncCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usCompressionFactor, USHORT usMustHave);
ULONG        mwmSpcfcSetAsyncPace(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);
ULONG        mwmSpcfcSetMNPCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usPhase);
ULONG        mwmSpcfcSetV42MACCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usPhase);
ULONG        mwmSpcfcSetV42DLCCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usPhase);
ULONG        mwmSpcfcSetV42PKTCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usPhase);
ULONG        mwmSpcfcSetV42MACxmitCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usPhase);
ULONG        mwmSpcfcSetV42DLCxmitCycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usPhase);
ULONG        mwmSpcfcGetTaskFPS(PMWM_DSPINFO pmwmDspInfo, HMTASK hTask, ULONG *pulTaskFPS);
ULONG        mwmSpcfcGetTaskCPF(PMWM_DSPINFO pmwmDspInfo, HMTASK hTask, ULONG *pulTaskCPF,char *achFile, SHORT sLine);
ULONG        mwmSpcfcGetTaskState(PMWM_DSPINFO pmwmDspInfo, HMTASK hTask, USHORT *pusState);

ULONG        mwmSpcfcRaiseUARTV80Cycles(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);               //$6
ULONG        mwmSpcfcLowerUARTV80Cycles(PMWM_DSPINFO pmwmDspInfo, USHORT usProtocol);               //$6
ULONG        mwmSpcfcSetV80Cycles(PMWM_DSPINFO pmwmDspInfo, USHORT usLineSpeed, USHORT usMustHave); //$6

ULONG        mwmSpcfcAccessDSPData(HDSP hDSP, HMTASK hTask, char *pszLabel,
                                   USHORT usReadWriteFlag, USHORT usNumWords,
                                   USHORT *pBuffer, char *pszSourceFilename,
                                   USHORT usLine);


void  MWM_ENTRY mwmHandleError( PMWM_INSTANCE_INFO pInstanceInfo, char *achFile, SHORT sLine,
                                ULONG ulPrimaryCode, ULONG ulSecondaryCode );
void  MWM_ENTRY mwmHandleErrorWithSubcode( PMWM_INSTANCE_INFO pInstanceInfo, char *achFile, SHORT sLine,
                                           ULONG ulPrimaryCode, ULONG ulSecondaryCode, USHORT usSubcode );
ULONG MWM_ENTRY mwmIPC(PMWM_DSPINFO pmwmDspInfo, ULONG ulParm1, ULONG ulParm2 );
ULONG MWM_ENTRY mwmSpcfcLoadModem(PMWM_DSPINFO pmwmDspInfo);

PMWM_DSPINFO MWM_ENTRY mwmSpcfcInitialize( PVOID INIFile, PMWM_INSTANCE_INFO pInstanceInfo, USHORT usPCMValue );
ULONG MWM_ENTRY mwmSpcfcQueryPhoneLine( PMWM_DSPINFO pmwmDspInfo, PUSHORT pusLineAvailable );
ULONG MWM_ENTRY mwmSpcfcQueryModemStatus( PMWM_DSPINFO pmwmDspInfo, PMWM_MODEM_STATUS pModemStatus,
                                          ULONG *pulAddressLEDS);
ULONG MWM_ENTRY mwmSpcfcUnloadModem(PMWM_DSPINFO pmwmDspInfo, USHORT CloseApp);
ULONG MWM_ENTRY mwmSpcfcSetSpeed(PMWM_DSPINFO pmwmDspInfo, SHORT sModemStartSpeed, int fTemp);
USHORT MWM_ENTRY mwmSpcfcCheckSpeedParm(PMWM_DSPINFO pmwmDspInfo, USHORT sRequestedSpeed);
ULONG  MWM_ENTRY mwmSpcfcSetFeatures(PMWM_DSPINFO pmwmDspInfo, int fTemp);
ULONG MWM_ENTRY mwmSpcfcReleaseLine(PMWM_DSPINFO pmwmDspInfo );
/* MTS 5873 Created mwmSpcfcSetProtocol */
ULONG MWM_ENTRY mwmSpcfcSetProtocol(PMWM_DSPINFO pmwmDspInfo, SHORT sModemCurrSlashNVal, int fTemp);

void  MWM_ENTRY mwmSpcfcActivateDebugWindow( BOOL bActivateFlag );
void  MWM_ENTRY mwmSpcfcActivateTimeStamp( BOOL bActivateFlag );

ULONG        mwmSpcfcPlayRingWave(PMWM_DSPINFO pmwmDspInfo);
ULONG        mwmSpcfcQueryUARTTaskHandle( PMWM_DSPINFO pmwmDspInfo, HMTASK  *phmtTask );
ULONG        mwmSpcfcUpdateCyclesPerFrame(PMWM_DSPINFO pmwmDspInfo);

ULONG   MWM_ENTRY mwmSpcfcNSClientProc(DWORD  dwConversationId,
                                       USHORT wMessage,
                                       ULONG  lParam,
                                       USHORT wSize,
                                       void FAR *pBuffer);

ULONG   APIENTRY mwmSpcfcBLClientProc(DWORD  dwConversationId,
                                      USHORT wMessage,
                                      ULONG  lParam,
                                      USHORT wSize,
                                      void FAR *pBuffer);
ULONG   APIENTRY mwmSpcfcWTClientProc(ULONG  dwConversationId,
                                    USHORT wMessage,
                                    ULONG  lParam,
                                    USHORT wSize,
                                    void FAR *pBuffer);
ULONG   APIENTRY QueryClientProc(ULONG  dwConversationId,
                                 USHORT wMessage,
                                 ULONG  lParam,
                                 USHORT wSize,
                                 void FAR *pBuffer);
ULONG          mwmSpcfcGetIPSUsed(PMWM_DSPINFO pmwmDspInfo, ULONG *pulIPSUsed);
ULONG          mwmSpcfcSetWTParms(PMWM_DSPINFO pmwmDspInfo);
ULONG          mwmSpcfcSetUpCP_Parms(PMWM_DSPINFO pmwmDspInfo, HMTASK hCpTask);
ULONG          mwmSpcfcSetDPCPF(PMWM_DSPINFO pmwmDspInfo,
                                HMTASK hmtDatapump,
                                char *achLabel);
ULONG mwmSpcfcSetMaxS28ComPortSpeed(PMWM_DSPINFO pmwmDspInfo);

/* Added function for V.34 Enhanced Mode (33600bps)  DR 07/08/96 */
ULONG mwmSpcfcIsV34EMConnectionPossible(PMWM_DSPINFO pmwmDspInfo);

/* Added function for PCM Mode DR 05/06/97 */
ULONG mwmSpcfcIsPCMConnectionPossible(PMWM_DSPINFO pmwmDspInfo);

ULONG mwmAnywhereToDiscrim(PMWM_DSPINFO pmwmDspInfo);


ULONG mwmcmsgWriteConnectMessage(PMWM_DSPINFO pmwmDspInfo,
                                 MWM_MODEM_STATUS  *pModemStatus);
USHORT MWM_ENTRY mwmcmsgConvertX2ConnectSpeed(USHORT usLineSpeed);


/* LOAD LIB procedures for caller ID */
void  mwmCidlInit(PMWM_DSPINFO pmwmDspInfo);
void  mwmCidlCheck(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmCidlLoad(PMWM_DSPINFO pmwmDspInfo, ULONG ulDesiredCid);

/* LOAD LIB procedures for distinctive ring */
void  mwmCidlInitDRing(PMWM_DSPINFO pmwmDspInfo);
void  mwmCidlCheckDRing(PMWM_DSPINFO pmwmDspInfo);
ULONG mwmCidlLoadDRing(PMWM_DSPINFO pmwmDspInfo, ULONG ulDesiredCid);

ULONG mwmV80LAnywhereV80ToDial(PMWM_DSPINFO pmwmDspInfo);                   //$7
ULONG mwmV80LV8V21AndConnect(PMWM_DSPINFO pmwmDspInfo,BOOL bConnectToEchoCanceller); //$7
ULONG mwmV80LLoadV8AndV21(PMWM_DSPINFO pmwmDspInfo, BOOL bConnectToEC);     //$D
ULONG mwmV80LV8V21Unload(PMWM_DSPINFO pmwmDspInfo);                         //$7
ULONG mwmV80LDialToV80nPumps(PMWM_DSPINFO pmwmDspInfo);                     //$7
ULONG mwmV80LV80DiscrimToDial(PMWM_DSPINFO pmwmDspInfo);                    //$7
ULONG mwmV80LCyclesAdjustToLineSpeed(PMWM_DSPINFO pmwmDspInfo,              //$8
                                     USHORT usProtocol,
                                     USHORT OnLine);
ULONG mwmV80LReceivedSubclassV80(PMWM_DSPINFO pmwmDspInfo);                 //$7
ULONG mwmV80LDiscrimToV80Discrim(PMWM_DSPINFO pmwmDspInfo, USHORT usClass); //$7
ULONG mwmV80LSetCISEND(PMWM_DSPINFO pmwmDspInfo, USHORT usValue);           //$7
ULONG mwmV80LGetSUBCLASS(PMWM_DSPINFO pmwmDspInfo, USHORT *pusSUBCLASS);    //$7
ULONG mwmV80LSetSUBCLASS(PMWM_DSPINFO pmwmDspInfo, USHORT usSUBCLASS);      //$7
ULONG mwmV80LEnableNativeAudio(PMWM_DSPINFO pmwmDspInfo);                   //$8
ULONG mwmV80LDisableNativeAudio(PMWM_DSPINFO pmwmDspInfo);                  //$8


ULONG mwmFaxGetFCLASS(PMWM_DSPINFO pmwmDspInfo, USHORT *pusFCLASS, USHORT *pusSubMode);
ULONG mwmFaxClassXToDiscrim(PMWM_DSPINFO pmwmDspInfo, USHORT usCurClass);
ULONG mwmFaxSetFCLASS(PMWM_DSPINFO pmwmDspInfo, USHORT usFCLASS);

ULONG MWM_ENTRY mwmSpcfcDetermineFeatures(PMWM_DSPINFO pmwmDspInfo, USHORT usPCMValue);

void MWM_ENTRY mwmHandleMessage(PMWM_DSPINFO pmwmDspInfo); // @TBD
void MWM_ENTRY mwmPostMessage(UINT uMsg, LONG wParam, LONG lParam); // @TBD

#ifdef DEBUG
   void    dprintf(char *szFormat, ...);
   #define DPF  dprintf
#else
   #define DPF ((void)0)
#endif

extern USHORT ldbg;
