/*
 *   dspsrv.h -- DSP Manager Server prototypes/defines
 *
 *  Written By: Mike Sullivan IBM Corporation
 *
 *  Copyright (C) 1999 IBM Corporation
 *
 * This program is free software; you can redistribute it and/or modify      
 * it under the terms of the GNU General Public License as published by      
 * the Free Software Foundation; either version 2 of the License, or         
 * (at your option) any later version.                                       
 *                                                                           
 * This program is distributed in the hope that it will be useful,           
 * but WITHOUT ANY WARRANTY; without even the implied warranty of            
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the             
 * GNU General Public License for more details.                              
 *                                                                           
 * NO WARRANTY                                                               
 * THE PROGRAM IS PROVIDED ON AN "AS IS" BASIS, WITHOUT WARRANTIES OR        
 * CONDITIONS OF ANY KIND, EITHER EXPRESS OR IMPLIED INCLUDING, WITHOUT      
 * LIMITATION, ANY WARRANTIES OR CONDITIONS OF TITLE, NON-INFRINGEMENT,      
 * MERCHANTABILITY OR FITNESS FOR A PARTICULAR PURPOSE. Each Recipient is    
 * solely responsible for determining the appropriateness of using and       
 * distributing the Program and assumes all risks associated with its        
 * exercise of rights under this Agreement, including but not limited to     
 * the risks and costs of program errors, damage to or loss of data,         
 * programs or equipment, and unavailability or interruption of operations.  
 *                                                                           
 * DISCLAIMER OF LIABILITY                                                   
 * NEITHER RECIPIENT NOR ANY CONTRIBUTORS SHALL HAVE ANY LIABILITY FOR ANY   
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL        
 * DAMAGES (INCLUDING WITHOUT LIMITATION LOST PROFITS), HOWEVER CAUSED AND   
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR     
 * TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE    
 * USE OR DISTRIBUTION OF THE PROGRAM OR THE EXERCISE OF ANY RIGHTS GRANTED  
 * HEREUNDER, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGES             
 *                                                                           
 * You should have received a copy of the GNU General Public License         
 * along with this program; if not, write to the Free Software               
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA 
 *                                                                           
 * 
 *  10/23/2000 - Alpha Release 0.1.0
 *            First release to the public
 *
 */
#ifndef _DSPSRV_H
#define _DSPSRV_H

#define DSPSRVAPI 

#define MWAVE_SERVICE_NAME  TEXT("Mwave_Manager")
#define MWAVE_SERVICE_PIPE  TEXT("\\\\.\\pipe\\Mwave_Manager")

#define REQUEST_BUFFER_SIZE      1000
#define ANSWER_BUFFER_SIZE       (64*1024)

/*
 * A client sends a request that is build from this header and
 * followed by the packet and buffers bodys in the same order.
 */

typedef struct _MwMgr_Request_Head {
       DWORD   dwRequestCode; /* function requested.                         */
       DWORD   dwPacketSize;  /* Packet Size in bytes, Zero if none          */
       DWORD   dwPgBuf1Size;  /* Pg Buffer1 size, including terminating null */
       DWORD   dwPgBuf2Size;  /* Pg Buffer2  "       "         "         "   */
       DWORD   dwPgBuf3Size;  /* Pg Buffer3  "       "         "         "   */
       DWORD   dwRetBufSize;  /* return buffer size, zero if none            */
} MWMGR_REQUEST_HEAD,*PMWMGR_REQUEST_HEAD;
  
/*
 * The Manager Server returns an answer that is build from this header 
 * follwed by the buffer body (if any).
 */

typedef struct _MwMgrAnswer_Head {
       DWORD   dwReturnCode;  /* Manager return code                     */
       DWORD   dwHandle;      /* return handle, zero if none             */
       DWORD   dwBufSize;     /* return buffer actual size, zero if none */
} MWMGR_ANSWER_HEAD,*PMWMGR_ANSWER_HEAD;
 
DSPSRVAPI BOOL StartMwaveSubsystem( void );
DSPSRVAPI BOOL StopMwaveSubsystem( void );
DSPSRVAPI BOOL IssueMwaveAPIRequest( BYTE * pbRequestBuffer, unsigned uRequestSize,
                                            BYTE ** ppbAnswerBuffer, unsigned * puAnswerSize );
DSPSRVAPI void FreeMwaveAPIAnswerBuffer( BYTE * pbAnswerBuffer );

#endif /* _DSPSRV_H */
