/* ============================================================
 * File  : main.cpp (mythstream parser)
 * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
 * Date  : oct 2006
 *
 * Copyright 2006 by Eric Giesselbach

 * This program is free software; you can redistribute it
 * and/or modify it under the terms of the GNU General
 * Public License as published bythe Free Software Foundation;
 * either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * ============================================================ */


#include <qdom.h>
#include <iostream>
#include <qobject.h>
#include <qptrlist.h>
#include <qfile.h>
#include <qstringlist.h>


using namespace std;

QString urlPrefix = "http://fake";
QDomDocument doc("returndata");
QDomElement root;

QString stage, path, choice;

bool readTextFile(QString fileName, QString *data)
{
    QFile f(fileName);
    if ( f.open( IO_ReadOnly ) )
    {
      *data = (QString)f.readAll(); 
      f.close();
      return true;
    }
      else
        return false;
}

// <nodename>nodevalue</nodename>
void addTextNode(QDomElement &elem, QString nodename, QString nodevalue)
{
  QDomElement elem1 = doc.createElement( nodename  );
  QDomText txt = doc.createTextNode( nodevalue );
  
  elem1.appendChild(txt);
  elem.appendChild(elem1);
}

//      <meta>
//         <name>meta data name</name>
//         <content></content>
//         <viewer></viewer>
//      </meta>
void addMetaNode(QDomElement &elem, QString name, QString content, QString viewer)
{
  QDomElement elem1 = doc.createElement( "meta"  );
  
  addTextNode(elem1, "name"   , name);
  addTextNode(elem1, "content", content);
  addTextNode(elem1, "viewer" , viewer);
  
  elem.appendChild(elem1);
}

void decodeFakeURL(QString url)
{
  // fake url: http://fake#[stage]#[path]#[choice]
  QString fake = "";

  url = url.mid(7);

  fake   = url.section('#', 0, 0);
  stage  = url.section('#', 1, 1);
  path   = url.section('#', 2, 2);
  choice = url.section('#', 3, 3);

  if (fake != "fake")
  {
    stage  = "0";
    choice = "";
    path   = "";
  }

}

// add item node with child nodes name, url, descr, handler
void addItem(unsigned int next, QString thispath, QString thischoice, QString name, QString descr, QString handler)
{
    QDomElement elem = doc.createElement( "item" );
    root.appendChild( elem );

    addTextNode(elem, "name"   , name);
    addTextNode(elem, "url"    , urlPrefix + "#" + QString::number(next) + "#" + thispath + "#" + thischoice);
    addTextNode(elem, "descr"  , descr);
    addTextNode(elem, "handler", handler);
}

// add list of item nodes based on csv list
// every value is added as fakeurl choice, to name and to descr
void addItemList(unsigned int next, QString thispath, QString choices, QString name, QString descr, QString handler)
{
    QStringList alph = QStringList::split(',', choices);

    for ( QStringList::Iterator it = alph.begin(); it != alph.end(); ++it )
      addItem(next, thispath, *it, name + *it, descr + *it, handler);
}

// add list of item nodes based on file with id, value lines.
// every line generates an item, id is added to the fakeurl path, value is presented in the gui
void addItemListFromFile(unsigned int next, QString thispath, QString limitchoice, QString fileName,
                         QString name, QString descr, QString handler)
{
  QString content;
  QString *data = &content;

  QString id, value;

  readTextFile(fileName, data);
  QStringList lines = QStringList::split("\n", *data);

  if (thispath != "") thispath += "|";

  for ( QStringList::Iterator it = lines.begin(); it != lines.end(); ++it )
  {
    id    = QString(*it).section(",", 0, 0);
    value = QString(*it).section(",", 1, 1);

    if (value.left(1) == limitchoice || limitchoice == "any")
      addItem(next, thispath + id, "", name + value, descr + value, handler);
  }
}


int main( int argc, char **argv )
{
    QString id, value, cid, lid, gid, urlbase;
    QString alphs = "A,B,C,D,E,F,G,H,I,J,K,L,M,N,O,P,Q,R,S,T,U,V,W,X,Y,Z";
           
  // start as: program <filename> [<url>]
  
    if (argc < 2)
    {
        cerr << "parser started without filename" << endl;
        exit(-1);
    }
  
    QString source = argv[1];
    QString url = "";
  
    if (argc > 2)
      url = argv[2];
    
    decodeFakeURL(url); // get stage, path and choice
  
  // generate xml document
    QDomElement elem;
    root = doc.createElement( "items" );
    doc.appendChild(root);

  // first menu
    if (stage == "0")
    {
      addItem(11, "", "", "TV Stations"   , "Any Country", "*wwmp/menu");
      
      addItem( 1, "", "", "Radio Stations", "Any Country", "*wwmp/menu");
    }
    else if (stage == "1")   // 0 < Radio menu < 11
    {
      addItem(3, "all", "", "Any Country", "Any Country", "*wwmp/menu");
      
      addItemList(2, path, alphs, "Country starts with ", "Country ", "*wwmp/menu");    
    }
    else if (stage == "2")
    {
      addItemListFromFile(3, "", choice, "wwmp/gen_countries.txt", "", "Select ", "*wwmp/menu");    
    }
    else if (stage == "3")
    {  
      addItem(5, path + "|all", "", "Any Language", "Any Language", "*wwmp/menu"); 
      
      addItemList(4, path, alphs, "Lang starts with ", "Lang ", "*wwmp/menu");
    }
    else if (stage == "4")
    {
      addItemListFromFile(5, path, choice, "wwmp/gen_languages.txt", "", "Select ", "*wwmp/menu");     
    }
    else if (stage == "5")
    {
      addItem(6, path + "|all", "", "All Genres", "Select all Genres", "*wwmp/menu");
      
      addItemListFromFile(6, path, "any", "wwmp/ra_genres.txt", "", "Select ", "*wwmp/menu");
    }
    else if (stage == "6")
    {
      cid = path.section('|', 0, 0);
      lid = path.section('|', 1, 1);
      gid = path.section('|', 2, 2);
  
      urlbase = "http://www.worldwidemediaproject.com/playlist.php?showtype=country&ptype=gb";
  
      elem = doc.createElement( "item" );
      root.appendChild( elem );
      addTextNode(elem, "name", "WorldMedia selection: radio stations");
      addTextNode(elem, "url"  , urlbase + "&id=" + cid + "&language=" + lid + "&genre=" + gid + "&avtype=2");
      addTextNode(elem, "descr", "WorldMedia Playlist query");
      addTextNode(elem, "handler", "wwmp/wwmp_ubu");
    }  
    else if (stage == "11")  // TV Menu > 10
    {
      addItem(13, "all", "", "Any Country", "Any Country", "*wwmp/menu");
      
      addItemList(12, path, alphs, "Country starts with ", "Country ", "*wwmp/menu");    
    }
    else if (stage == "12")
    {
      addItemListFromFile(13, "", choice, "wwmp/gen_countries.txt", "", "Select ", "*wwmp/menu");    
    }
    else if (stage == "13")
    {  
      addItem(15, path + "|all", "", "Any Language", "Any Language", "*wwmp/menu"); 
      
      addItemList(14, path, alphs, "Lang starts with ", "Lang ", "*wwmp/menu");
    }
    else if (stage == "14")
    {
      addItemListFromFile(15, path, choice, "wwmp/gen_languages.txt", "", "Select ", "*wwmp/menu");     
    }
    else if (stage == "15")
    {
      addItem(16, path + "|all", "", "All Genres", "Select all Genres", "*wwmp/menu");
      
      addItemListFromFile(16, path, "any", "wwmp/tv_genres.txt", "", "Select ", "*wwmp/menu");
    }
    else if (stage == "16")
    {
      cid = path.section('|', 0, 0);
      lid = path.section('|', 1, 1);
      gid = path.section('|', 2, 2);
  
      urlbase = "http://www.worldwidemediaproject.com/playlist.php?showtype=country&ptype=gb";
  
      elem = doc.createElement( "item" );
      root.appendChild( elem );
      addTextNode(elem, "name", "WorldMedia selection: radio stations");
      addTextNode(elem, "url"  , urlbase + "&id=" + cid + "&language=" + lid + "&genre=" + gid + "&avtype=1");
      addTextNode(elem, "descr", "WorldMedia Playlist query");
      addTextNode(elem, "handler", "wwmp/wwmp_ubu");
    }


  // dump xml to stdout
    cout << doc.toString() << endl;
}


