#! /usr/bin/perl
#* ============================================================
# * File  : example.pl
# * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
# * Date  : 2004-10-31
# * Description : XML stream list parser for streamtuned / mythstream
# * ============================================================ */


  
use English;
use XML::Simple;
use XML::DOM;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

# filtering unescaped & 
$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$fdata = <INFO>;                 # Read all
close(INFO);
$fdata =~ s/&(amp;){0}/&amp;/g;

eval{ $data = $xml->XMLin($fdata, ForceArray => 1); };


foreach my $entry (@{$data->{Channels}})
{ 
    $descr = "";
    $descr = $entry->{Program_x0020_Name}->[0] . "";
    if ($descr eq "" ) {$descr = "[emptystring]"; }
    
    $item = $doc->createElement('item');
    $root->appendChild($item);

    $item->appendChild( newNode('name' , $entry->{Channel_Name}->[0]) );
    $item->appendChild( newNode('url'  , $entry->{Channel_x0020_URL}->[0]) );
    $item->appendChild( newNode('descr', $descr) );

    $node = 'Action: mark as nonfunctional';
    $meta = $doc->createElement('meta');
    $meta->appendChild( newNode('name'   , $node) );
    $meta->appendChild( newNode('content', $node) );
    $meta->appendChild( newNode('viewer' , 'url') );
    $item->appendChild( $meta );

}


print $head->toString;
print $root->toString;
print "\n";



sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


