#! /usr/bin/perl
#* ============================================================
# * File  : icecast.pl
# * Author: Eric Giesselbach <ericgies@kabelfoon.nl>
# * Date  : 2004-10-31, 2006-10-04
# * Description : icecast XML list parser for streamtuned / mythstream
# *               icecast XML: http://dir.xiph.org/yp.xml
# * ============================================================ */

use English;
use XML::Simple;
use XML::DOM;

# create object
$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line
my $bitrate = "";

eval { $data = $xml->XMLin($source); };

foreach my $entry (@{$data->{entry}})
{
  if ($entry->{listen_url} ne "")
  {
    $item = $doc->createElement('item');
    $root->appendChild($item);
  
    $bitrate = $entry->{bitrate};
    $bitrate =~ s/^(\d+)$/\1 bps/;
  
    $item->appendChild( newNode('name' , $entry->{server_name} . " - " . $entry->{genre} . " (" . $bitrate . ")" ) );
    $item->appendChild( newNode('url'  , $entry->{listen_url}) );
    $item->appendChild( newNode('descr', $entry->{genre}) );    
  }
}


print $head->toString;
print $root->toString;
print "\n";


#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


