#! /usr/bin/perl
#* ============================================================
# * File        : omroep/programurl.pl
# * Version     : 0.1
# * Author      : Eric
# * Date        : 2006-09-11
# * Description: parser for omroep/program_menu.pl
# *
# * Requires:
# * - mythstream v0.17_2
# * - omroep/program_menu.pl
# *
# *  
# * ============================================================ */

use English;
use XML::DOM;
use HTML::Entities;

#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO);

#------------------------------------------------------------------------------
# Parse playlist
#------------------------------------------------------------------------------

              
## <td><a class="title" href="/index.php/serie?serID=...">Cinema.nl: Filmfestival Cannes 2006</a></td>
## <td align="right">28-05-2006</td>
              
## <td align="right"><a href="http://player.omroep.nl/?aflID=2915682&amp;md5=d5ade5147e7a7c3ac402ebd581b9e6c0" target="player" onclick="return openPlayer(this.href,0,0,'2915682');"><img src="/pics/icon.bekijk_uitzending_small.gif" border="0" width="17" height="15" alt="bekijk uitzending: Cinema.nl: Filmfestival Cannes 2006" /></a></td>


sub dump_lines
{
  @lines = split ( "\n", $data);

  my $date = "";
  
  foreach $line(@lines)
  {
    $index++;
    
    if (@matches = ( $line =~ m/<td[^>]+>(\d\d-\d\d\-\d{4})</) )
    {
      $date = @matches[0];
    }
      
    if (@matches = ( $line =~ m/<td[^>]+>\s+<a\ href="(\S*)"\ target="player"/ ) )
    {
      $url = @matches[0];
      
      $item = $doc->createElement('item');
      $root->appendChild($item);

      $name = decode_entities($name);
     
      $item->appendChild( newNode('name', "uitzending van $date" ) );
      $item->appendChild( newNode('url', $url) );
      $item->appendChild( newNode('descr', "uitzending van $date") );
      $item->appendChild( newNode('handler', "omroep/mediaurl") );

      $date = "";
      $name = "";
    }

# <a href="/index.php/serie2?serID=746&amp;md5=a935269d4a43d1446ccc194325d2301e" .... icon.meerafleveringen.gif"
    if (@matches = ( $line =~ m/<a\shref="(\/index\.php\/serie\S*)".+icon\.meerafleveringen\.gif/ ) )
    {
      $url = @matches[0];
      
      $item = $doc->createElement('item');
      $root->appendChild($item);

      $name = "meer afleveringen...";
     
      $item->appendChild( newNode('name', $name ) );
      $item->appendChild( newNode('url', $url) );
      $item->appendChild( newNode('descr', $name) );
      $item->appendChild( newNode('handler', "omroep/programurl") );
      
      $name = "";
    }
  
  }
}

#------------------------------------------------------------------------------
# search url's in $data and place them in special format
#------------------------------------------------------------------------------

&dump_lines();

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}



