#! /usr/bin/perl
### -------------------------------------------------------------------------
### Program: bbc_l2.pl:
### Copyright (c) 2005 Robin Gilks
###
### This program is free software; you can redistribute it and/or
### modify it under the terms of the GNU General Public License
### as published by the Free Software Foundation; either version 2
### of the License, or (at your option) any later version.
###
### This program is distributed in the hope that it will be useful,
### but WITHOUT ANY WARRANTY; without even the implied warranty of
### MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
### GNU General Public License for more details.
###
### You should have received a copy of the GNU General Public License
### along with this program; if not, write to the Free Software
### Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
### -------------------------------------------------------------------------
###
### This is a MythStream parser or harvester. It handles the second level 
### access. See the notes at the start of bbc_l1.pl

use English;
use XML::DOM;
use LWP::Simple;			# Reqd for get http command.

#------------------------------------------------------------------------------
# Init
#------------------------------------------------------------------------------

&read_parse();    # get commandline parameters into @in
$source = $in[0]; # source filename from command line

$domain = 'http://www.bbc.co.uk';

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

#------------------------------------------------------------------------------
# read file into $data
#------------------------------------------------------------------------------

$datafile = $source;
open( INFO, "<$datafile" );      # Open file for reading
undef $/;
$data = <INFO>;                 # Read all
close(INFO) ;

#------------------------------------------------------------------------------
# search url's in $data and place them in special format
#------------------------------------------------------------------------------


  @lines = split ( "\n", $data);
  foreach $line(@lines)
  {
    if ($line =~ m/var AudioStream/)
    {
	$line =~ s/var AudioStream = //;
        $line =~ s/"//g;	# remove "
        $line =~ s/;//g;	# remove ;
	$line = $line.'.rpm';
        $rpmfile = get("$domain.$line");
	    die "Couldn't get it!" unless defined $rpmfile;

        $item = $doc->createElement('item');
        $root->appendChild($item);

        $item->appendChild( newNode('name', 'dummy') );
        $item->appendChild( newNode('url', $rpmfile));
	
    }
  }



print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse 
{
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}


