#!/usr/bin/perl
#* ============================================================
# * File  : wwmp_menu.pl
# * Author: Eric
# * Date  : 2006-09-11
# * Description: World Wide Media Project menu
# *              http://www.worldwidemediaproject.com
# * Requires mythstream v0.17_2
# * ============================================================ */

    
use English;
use XML::Simple;
use XML::DOM;

$xml = new XML::Simple;

my $doc = XML::DOM::Document->new;
my $head = $doc->createXMLDecl ('1.0');
my $root = $doc->createElement('items');

sub newNode
{
  local $name  = shift;
  local $value = shift;
  local $node = $doc->createElement($name);
  local $text = $doc->createTextNode($value);
  $node->appendChild($text);
  
  return $node;
}

my $stage  = 0;  # menu level
my $choice = "";  # choice in last menu
my $path   = "";  # | separated values based on previous choices

sub decodeFakeURL
{
  local $url  = shift;    # fake url: http://fake#[stage]#[path]#[choice]
  
  # remove quotes from url
  $url =~ s/^\"?(.*?)\"?$/$1/;
  
  
  $url = substr($url, 7);
  ($fake, $stage, $path, $choice) = split('#', $url);

  if ($fake ne 'fake')
  {
    $stage  = 0;
    $choice = "";
    $path   = "";
  }

  # print "\n $stage, $path, $choice \n";
}

#------------------------------------------------------------------------------
# Init and Run
#------------------------------------------------------------------------------

  &read_parse();    # get commandline parameters into @in
  
  @alph      = split( / */, 'ABCDEFGHIJKLMNOPQRSTUVWXYZ');
  $urlPrefix = "http://fake";

  $source = $in[0]; # source filename from command line
  $url    = $in[1];
  
  decodeFakeURL($url); # get stage, path and choice
  

  if ($stage == 0)
  {
    
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'TV Stations') );
    $item->appendChild( newNode('url'  , "$urlPrefix#11#") );
    $item->appendChild( newNode('descr', 'Any Country' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );
  
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Radio Stations') );
    $item->appendChild( newNode('url'  , "$urlPrefix#1#") );
    $item->appendChild( newNode('descr', 'Any Country' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );

  }

  # Radio
  elsif ($stage == 1)
  {
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Any Country') );
    $item->appendChild( newNode('url'  , "$urlPrefix#3#all#") );
    $item->appendChild( newNode('descr', 'Any Country' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );
  
    foreach $alph (@alph)
    {   
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , 'Country starts with ' . $alph) );
      $item->appendChild( newNode('url'  , "$urlPrefix#2#$path#$alph") );
      $item->appendChild( newNode('descr', 'Country ' . $alph . '...' ) );
      $item->appendChild( newNode('handler', '*wwmp/menu' ) );
    }  

  }
  elsif ($stage == 2)
  {
  
    open( FD, "<wwmp/gen_countries.txt" );
    @list = <FD>;
    close FD;
  
    foreach $line (@list)
    {
      ($id, $country) = split(',', $line);
      if (substr($country, 0, 1) eq $choice)
      {
        $item = $doc->createElement('item');
        $root->appendChild($item);
        $item->appendChild( newNode('name' , $country) );
        $item->appendChild( newNode('url'  , "$urlPrefix#3#$id#") );
        $item->appendChild( newNode('descr', 'Select ' . $country ) );
        $item->appendChild( newNode('handler', '*wwmp/menu' ) );
      }
    }

  }
  elsif ($stage == 3)
  {

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Any Language') );
    $item->appendChild( newNode('url'  , "$urlPrefix#5#$path|all#") );
    $item->appendChild( newNode('descr', 'Any Language' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );
  
    foreach $alph (@alph)
    {   
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , 'Lang starts with ' . $alph) );
      $item->appendChild( newNode('url'  , "$urlPrefix#4#$path#$alph") );
      $item->appendChild( newNode('descr', 'Lang ' . $alph . '...' ) );
      $item->appendChild( newNode('handler', '*wwmp/menu' ) );
    }  

  }
  elsif ($stage == 4)
  {

    open( FD, "<wwmp/gen_languages.txt" );
    @list = <FD>;
    close FD;
     
    foreach $line (@list)
    {
      ($id, $lang) = split(',', $line);
      if (substr($lang, 0, 1) eq $choice)
      {
        $item = $doc->createElement('item');
        $root->appendChild($item);
        $item->appendChild( newNode('name' , $lang ) );
        $item->appendChild( newNode('url'  , "$urlPrefix#5#$path|$id#") );
        $item->appendChild( newNode('descr', 'Select ' . $lang ) );
        $item->appendChild( newNode('handler', '*wwmp/menu' ) );
      }
    }
    
  }
  elsif ($stage == 5)
  {

    open( FD, "<wwmp/ra_genres.txt" );
    @list = <FD>;
    close FD;

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'All Genres') );
    $item->appendChild( newNode('url'  , "$urlPrefix#6#$path|all#") );
    $item->appendChild( newNode('descr', 'Select all genres' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );

    foreach $line (@list)
    {
      ($id, $genre) = split(',', $line);
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , $genre) );
      $item->appendChild( newNode('url'  , "$urlPrefix#6#$path|$id#") );
      $item->appendChild( newNode('descr', 'Select ' . $genre ) );
      $item->appendChild( newNode('handler', '*wwmp/menu' ) );
    }

  }
  elsif ($stage == 6)
  {

    ($cid, $lid, $gid) = split('\|', $path);

    $urlbase = 'http://www.worldwidemediaproject.com/playlist.php?showtype=country&ptype=gb';

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'WorldMedia selection: radio stations') );
    $item->appendChild( newNode('url'  , $urlbase . '&id=' . $cid . '&language=' . $lid . '&genre=' . $gid . '&avtype=2') );
    $item->appendChild( newNode('descr', 'WorldMedia Playlist query' ) );
    $item->appendChild( newNode('handler', 'wwmp/wwmp_ubu' ) );
  }
  
  elsif ($stage == 11)
  {
    
    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Any Country') );
    $item->appendChild( newNode('url'  , "$urlPrefix#13#all#") );
    $item->appendChild( newNode('descr', 'Any Country' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );
  
    foreach $alph (@alph)
    {   
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , 'Country starts with ' . $alph) );
      $item->appendChild( newNode('url'  , "$urlPrefix#12#$path#$alph") );
      $item->appendChild( newNode('descr', 'Country ' . $alph . '...' ) );
      $item->appendChild( newNode('handler', '*wwmp/menu' ) );
    }  

  }
  elsif ($stage == 12)
  {
  
    open( FD, "<wwmp/gen_countries.txt" );
    @list = <FD>;
    close FD;
  
    foreach $line (@list)
    {
      ($id, $country) = split(',', $line);
      if (substr($country, 0, 1) eq $choice)
      {
        $item = $doc->createElement('item');
        $root->appendChild($item);
        $item->appendChild( newNode('name' , $country) );
        $item->appendChild( newNode('url'  , "$urlPrefix#13#$id#") );
        $item->appendChild( newNode('descr', 'Select ' . $country ) );
        $item->appendChild( newNode('handler', '*wwmp/menu' ) );
      }
    }

  }
  elsif ($stage == 13)
  {

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'Any Language') );
    $item->appendChild( newNode('url'  , "$urlPrefix#15#$path|all#") );
    $item->appendChild( newNode('descr', 'Any Language' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );
  
    foreach $alph (@alph)
    {   
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , 'Lang starts with ' . $alph) );
      $item->appendChild( newNode('url'  , "$urlPrefix#14#$path#$alph") );
      $item->appendChild( newNode('descr', 'Lang ' . $alph . '...' ) );
      $item->appendChild( newNode('handler', '*wwmp/menu' ) );
    }  

  }
  elsif ($stage == 14)
  {

    open( FD, "<wwmp/gen_languages.txt" );
    @list = <FD>;
    close FD;
     
    foreach $line (@list)
    {
      ($id, $lang) = split(',', $line);
      if (substr($lang, 0, 1) eq $choice)
      {
        $item = $doc->createElement('item');
        $root->appendChild($item);
        $item->appendChild( newNode('name' , $lang ) );
        $item->appendChild( newNode('url'  , "$urlPrefix#15#$path|$id#") );
        $item->appendChild( newNode('descr', 'Select ' . $lang ) );
        $item->appendChild( newNode('handler', '*wwmp/menu' ) );
      }
    }
    
  }
  elsif ($stage == 15)
  {

    open( FD, "<wwmp/tv_genres.txt" );
    @list = <FD>;
    close FD;

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'All Genres') );
    $item->appendChild( newNode('url'  , "$urlPrefix#16#$path|all#") );
    $item->appendChild( newNode('descr', 'Select all genres' ) );
    $item->appendChild( newNode('handler', '*wwmp/menu' ) );

    foreach $line (@list)
    {
      ($id, $genre) = split(',', $line);
      $item = $doc->createElement('item');
      $root->appendChild($item);
      $item->appendChild( newNode('name' , $genre) );
      $item->appendChild( newNode('url'  , "$urlPrefix#16#$path|$id#") );
      $item->appendChild( newNode('descr', 'Select ' . $genre ) );
      $item->appendChild( newNode('handler', '*wwmp/menu' ) );
    }

  }
  elsif ($stage == 16)
  {

    ($cid, $lid, $gid) = split('\|', $path);

    $urlbase = 'http://www.worldwidemediaproject.com/playlist.php?showtype=country&ptype=gb';

    $item = $doc->createElement('item');
    $root->appendChild($item);
    $item->appendChild( newNode('name' , 'WorldMedia selection: radio stations') );
    $item->appendChild( newNode('url'  , $urlbase . '&id=' . $cid . '&language=' . $lid . '&genre=' . $gid . '&avtype=1') );
    $item->appendChild( newNode('descr', 'WorldMedia Playlist query' ) );
    $item->appendChild( newNode('handler', 'wwmp/wwmp_ubu' ) );
  }

print $head->toString;
print $root->toString;
print "\n";

#--------------------------------------------------------------------------------
# get command line parameters
#--------------------------------------------------------------------------------

sub read_parse {
  local (*in) = @_ if @_;
  local ($i);
  push(@in, @ARGV);
  foreach $i (0 .. $#in) { $in[$i] =~ s/\+/ /g;}
  return scalar(@in);
}








