/*************
* Header file for winprint.c
* $Id: winprint.h,v 1.3 2011/05/21 12:44:28 h_vogt Exp $
************/

#ifndef WINPRINT_H
#define WINPRINT_H

void WPRINT_PrintInit(HWND hwnd);
BOOL CALLBACK WPRINT_Abort( HDC hdc, int iError);
int WPRINT_Init(void);
int WPRINT_NewViewport( GRAPH * graph);
int WPRINT_Close(void);
int WPRINT_Clear(void);
int WPRINT_DrawLine(int x1, int y1, int x2, int y2);
int WPRINT_Arc(int x0, int y0, int radius, double theta, double delta_theta);
int WPRINT_Text( char * text, int x, int y, int degrees);
int WPRINT_DefineColor(int colorid, double red, double green, double blue);
int WPRINT_DefineLinestyle(int num, int mask);
int WPRINT_SetLinestyle(int style);
int WPRINT_SetColor( int color);
int WPRINT_Update(void);
int WPRINT_DiagramReady(void);

#endif /* WINPRINT_H */
