/* NOTE: Do not edit this file, it is generated by a script:
   ExportTrace.py --api cg 3.1 --prefix traceCg -t traverseTraceCg --library Cg -o traceCg.c
*/

#include <stdlib.h>
#include <stdio.h>
#include <string.h>
#include "trace.h"

#include <Cg/cg.h>
#include "traceCgState.h"

#ifdef _WIN32
# define DLLEXPORT __declspec(dllexport)
#elif defined(__GNUC__) && __GNUC__>=4
# define DLLEXPORT __attribute__ ((visibility("default")))
#elif defined(__SUNPRO_C) || defined(__SUNPRO_CC)
# define DLLEXPORT __global
#else
# define DLLEXPORT
#endif

/* Declare Cg API functions. */

#if !defined(__APPLE__)
DLLEXPORT void *cgInternal(void);
#endif

/* Declare Cg callback functions. */

void cb_cgCompilerInclude(CGcontext, const char *);
CGbool cb_cgStateSet(CGstateassignment);
CGbool cb_cgStateReset(CGstateassignment);
CGbool cb_cgStateValidate(CGstateassignment);

/* Load Cg library. */

#if defined(_WIN32)
# if !defined(WIN32_LEAN_AND_MEAN)
#   define WIN32_LEAN_AND_MEAN 1
# endif
# if !defined(NOGDI)
#   define NOGDI 1
# endif
# include <windows.h>
# undef WIN32_LEAN_AND_MEAN
# undef NOGDI
#elif defined(__APPLE__)
# include <AvailabilityMacros.h>
# if !defined(MAC_OS_X_VERSION_10_3)
#   include <mach-o/dyld.h>
# else
#   include <dlfcn.h>
# endif
#else
# include <dlfcn.h>
#endif

typedef struct _TraceCg_Handle *TraceCg_Handle;

static TraceCg_Handle
traceCg_LoadLibrary(const char *filename)
{
#if defined(_WIN32)
  return (TraceCg_Handle) LoadLibrary(filename);
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return (TraceCg_Handle) NSAddImage(filename, NSADDIMAGE_OPTION_NONE);
#else
  return (TraceCg_Handle) dlopen(filename, RTLD_LAZY);
#endif
}

static int
traceCg_FreeLibrary(TraceCg_Handle handle)
{
#if defined(_WIN32)
  return FreeLibrary((HMODULE)handle) ? 1 : 0;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return 1;
#else
  return dlclose(handle) ? 0 : 1;
#endif
}

static void *
traceCg_GetProcAddress(TraceCg_Handle handle, const char *name)
{
#if defined(_WIN32)
  return handle ? GetProcAddress((HMODULE)handle, name) : NULL;
#elif defined(__APPLE__) && !defined(MAC_OS_X_VERSION_10_3)
  return NSIsSymbolNameDefined(name) ? NSAddressOfSymbol(NSLookupAndBindSymbol(name)) : NULL;
#else
  return dlsym(handle, name);
#endif
}

static int traceCg_initialized = 0;
static TraceCg_Handle traceCg_handle = NULL;

/* Cg API function pointers. */

struct TraceCg_Functions
{
  CGenum (*cgSetLockingPolicy)(CGenum);
  CGenum (*cgGetLockingPolicy)(void);
  CGenum (*cgSetSemanticCasePolicy)(CGenum);
  CGenum (*cgGetSemanticCasePolicy)(void);
  CGcontext (*cgCreateContext)(void);
  void (*cgSetContextBehavior)(CGcontext, CGbehavior);
  CGbehavior (*cgGetContextBehavior)(CGcontext);
  const char *(*cgGetBehaviorString)(CGbehavior);
  CGbehavior (*cgGetBehavior)(const char *);
  void (*cgDestroyContext)(CGcontext);
  CGbool (*cgIsContext)(CGcontext);
  const char *(*cgGetLastListing)(CGcontext);
  void (*cgSetLastListing)(CGhandle, const char *);
  void (*cgSetAutoCompile)(CGcontext, CGenum);
  CGenum (*cgGetAutoCompile)(CGcontext);
  void (*cgSetParameterSettingMode)(CGcontext, CGenum);
  CGenum (*cgGetParameterSettingMode)(CGcontext);
  void (*cgSetCompilerIncludeString)(CGcontext, const char *, const char *);
  void (*cgSetCompilerIncludeFile)(CGcontext, const char *, const char *);
  void (*cgSetCompilerIncludeCallback)(CGcontext, CGIncludeCallbackFunc);
  CGIncludeCallbackFunc (*cgGetCompilerIncludeCallback)(CGcontext);
  CGprogram (*cgCreateProgram)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **);
  CGprogram (*cgCreateProgramFromFile)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **);
  CGprogram (*cgCopyProgram)(CGprogram);
  void (*cgDestroyProgram)(CGprogram);
  CGprogram (*cgGetFirstProgram)(CGcontext);
  CGprogram (*cgGetNextProgram)(CGprogram);
  CGcontext (*cgGetProgramContext)(CGprogram);
  CGbool (*cgIsProgram)(CGprogram);
  void (*cgCompileProgram)(CGprogram);
  CGbool (*cgIsProgramCompiled)(CGprogram);
  const char *(*cgGetProgramString)(CGprogram, CGenum);
  CGprofile (*cgGetProgramProfile)(CGprogram);
  char const * const *(*cgGetProgramOptions)(CGprogram);
  void (*cgSetProgramProfile)(CGprogram, CGprofile);
  CGenum (*cgGetProgramInput)(CGprogram);
  CGenum (*cgGetProgramOutput)(CGprogram);
  int (*cgGetProgramOutputVertices)(CGprogram);
  void (*cgSetProgramOutputVertices)(CGprogram, int);
  void (*cgSetPassProgramParameters)(CGprogram);
  void (*cgUpdateProgramParameters)(CGprogram);
  void (*cgUpdatePassParameters)(CGpass);
  CGparameter (*cgCreateParameter)(CGcontext, CGtype);
  CGparameter (*cgCreateParameterArray)(CGcontext, CGtype, int);
  CGparameter (*cgCreateParameterMultiDimArray)(CGcontext, CGtype, int, const int *);
  void (*cgDestroyParameter)(CGparameter);
  void (*cgConnectParameter)(CGparameter, CGparameter);
  void (*cgDisconnectParameter)(CGparameter);
  CGparameter (*cgGetConnectedParameter)(CGparameter);
  int (*cgGetNumConnectedToParameters)(CGparameter);
  CGparameter (*cgGetConnectedToParameter)(CGparameter, int);
  CGparameter (*cgGetNamedParameter)(CGprogram, const char *);
  CGparameter (*cgGetNamedProgramParameter)(CGprogram, CGenum, const char *);
  CGparameter (*cgGetNamedProgramUniformBuffer)(CGprogram, const char *);
  CGparameter (*cgGetNamedEffectUniformBuffer)(CGeffect, const char *);
  const char *(*cgGetUniformBufferBlockName)(CGparameter);
  CGparameter (*cgGetFirstParameter)(CGprogram, CGenum);
  CGparameter (*cgGetNextParameter)(CGparameter);
  CGparameter (*cgGetFirstLeafParameter)(CGprogram, CGenum);
  CGparameter (*cgGetNextLeafParameter)(CGparameter);
  CGparameter (*cgGetFirstStructParameter)(CGparameter);
  CGparameter (*cgGetFirstUniformBufferParameter)(CGparameter);
  CGparameter (*cgGetNamedStructParameter)(CGparameter, const char *);
  CGparameter (*cgGetNamedUniformBufferParameter)(CGparameter, const char *);
  CGparameter (*cgGetFirstDependentParameter)(CGparameter);
  CGparameter (*cgGetArrayParameter)(CGparameter, int);
  int (*cgGetArrayDimension)(CGparameter);
  CGtype (*cgGetArrayType)(CGparameter);
  int (*cgGetArraySize)(CGparameter, int);
  int (*cgGetArrayTotalSize)(CGparameter);
  void (*cgSetArraySize)(CGparameter, int);
  void (*cgSetMultiDimArraySize)(CGparameter, const int *);
  CGprogram (*cgGetParameterProgram)(CGparameter);
  CGcontext (*cgGetParameterContext)(CGparameter);
  CGbool (*cgIsParameter)(CGparameter);
  const char *(*cgGetParameterName)(CGparameter);
  CGtype (*cgGetParameterType)(CGparameter);
  CGtype (*cgGetParameterBaseType)(CGparameter);
  CGparameterclass (*cgGetParameterClass)(CGparameter);
  int (*cgGetParameterRows)(CGparameter);
  int (*cgGetParameterColumns)(CGparameter);
  CGtype (*cgGetParameterNamedType)(CGparameter);
  const char *(*cgGetParameterSemantic)(CGparameter);
  CGresource (*cgGetParameterResource)(CGparameter);
  CGresource (*cgGetParameterBaseResource)(CGparameter);
  unsigned long (*cgGetParameterResourceIndex)(CGparameter);
  CGenum (*cgGetParameterVariability)(CGparameter);
  CGenum (*cgGetParameterDirection)(CGparameter);
  CGbool (*cgIsParameterReferenced)(CGparameter);
  CGbool (*cgIsParameterUsed)(CGparameter, CGhandle);
  const double *(*cgGetParameterValues)(CGparameter, CGenum, int *);
  void (*cgSetParameterValuedr)(CGparameter, int, const double *);
  void (*cgSetParameterValuedc)(CGparameter, int, const double *);
  void (*cgSetParameterValuefr)(CGparameter, int, const float *);
  void (*cgSetParameterValuefc)(CGparameter, int, const float *);
  void (*cgSetParameterValueir)(CGparameter, int, const int *);
  void (*cgSetParameterValueic)(CGparameter, int, const int *);
  int (*cgGetParameterValuedr)(CGparameter, int, double *);
  int (*cgGetParameterValuedc)(CGparameter, int, double *);
  int (*cgGetParameterValuefr)(CGparameter, int, float *);
  int (*cgGetParameterValuefc)(CGparameter, int, float *);
  int (*cgGetParameterValueir)(CGparameter, int, int *);
  int (*cgGetParameterValueic)(CGparameter, int, int *);
  int (*cgGetParameterDefaultValuedr)(CGparameter, int, double *);
  int (*cgGetParameterDefaultValuedc)(CGparameter, int, double *);
  int (*cgGetParameterDefaultValuefr)(CGparameter, int, float *);
  int (*cgGetParameterDefaultValuefc)(CGparameter, int, float *);
  int (*cgGetParameterDefaultValueir)(CGparameter, int, int *);
  int (*cgGetParameterDefaultValueic)(CGparameter, int, int *);
  const char *(*cgGetStringParameterValue)(CGparameter);
  void (*cgSetStringParameterValue)(CGparameter, const char *);
  int (*cgGetParameterOrdinalNumber)(CGparameter);
  CGbool (*cgIsParameterGlobal)(CGparameter);
  int (*cgGetParameterIndex)(CGparameter);
  void (*cgSetParameterVariability)(CGparameter, CGenum);
  void (*cgSetParameterSemantic)(CGparameter, const char *);
  void (*cgSetParameter1f)(CGparameter, float);
  void (*cgSetParameter2f)(CGparameter, float, float);
  void (*cgSetParameter3f)(CGparameter, float, float, float);
  void (*cgSetParameter4f)(CGparameter, float, float, float, float);
  void (*cgSetParameter1d)(CGparameter, double);
  void (*cgSetParameter2d)(CGparameter, double, double);
  void (*cgSetParameter3d)(CGparameter, double, double, double);
  void (*cgSetParameter4d)(CGparameter, double, double, double, double);
  void (*cgSetParameter1i)(CGparameter, int);
  void (*cgSetParameter2i)(CGparameter, int, int);
  void (*cgSetParameter3i)(CGparameter, int, int, int);
  void (*cgSetParameter4i)(CGparameter, int, int, int, int);
  void (*cgSetParameter1iv)(CGparameter, const int *);
  void (*cgSetParameter2iv)(CGparameter, const int *);
  void (*cgSetParameter3iv)(CGparameter, const int *);
  void (*cgSetParameter4iv)(CGparameter, const int *);
  void (*cgSetParameter1fv)(CGparameter, const float *);
  void (*cgSetParameter2fv)(CGparameter, const float *);
  void (*cgSetParameter3fv)(CGparameter, const float *);
  void (*cgSetParameter4fv)(CGparameter, const float *);
  void (*cgSetParameter1dv)(CGparameter, const double *);
  void (*cgSetParameter2dv)(CGparameter, const double *);
  void (*cgSetParameter3dv)(CGparameter, const double *);
  void (*cgSetParameter4dv)(CGparameter, const double *);
  void (*cgSetMatrixParameterir)(CGparameter, const int *);
  void (*cgSetMatrixParameterdr)(CGparameter, const double *);
  void (*cgSetMatrixParameterfr)(CGparameter, const float *);
  void (*cgSetMatrixParameteric)(CGparameter, const int *);
  void (*cgSetMatrixParameterdc)(CGparameter, const double *);
  void (*cgSetMatrixParameterfc)(CGparameter, const float *);
  void (*cgGetMatrixParameterir)(CGparameter, int *);
  void (*cgGetMatrixParameterdr)(CGparameter, double *);
  void (*cgGetMatrixParameterfr)(CGparameter, float *);
  void (*cgGetMatrixParameteric)(CGparameter, int *);
  void (*cgGetMatrixParameterdc)(CGparameter, double *);
  void (*cgGetMatrixParameterfc)(CGparameter, float *);
  CGenum (*cgGetMatrixParameterOrder)(CGparameter);
  CGparameter (*cgGetNamedSubParameter)(CGparameter, const char *);
  const char *(*cgGetTypeString)(CGtype);
  CGtype (*cgGetType)(const char *);
  CGtype (*cgGetNamedUserType)(CGhandle, const char *);
  int (*cgGetNumUserTypes)(CGhandle);
  CGtype (*cgGetUserType)(CGhandle, int);
  int (*cgGetNumParentTypes)(CGtype);
  CGtype (*cgGetParentType)(CGtype, int);
  CGbool (*cgIsParentType)(CGtype, CGtype);
  CGbool (*cgIsInterfaceType)(CGtype);
  const char *(*cgGetResourceString)(CGresource);
  CGresource (*cgGetResource)(const char *);
  const char *(*cgGetEnumString)(CGenum);
  CGenum (*cgGetEnum)(const char *);
  const char *(*cgGetProfileString)(CGprofile);
  CGprofile (*cgGetProfile)(const char *);
  int (*cgGetNumSupportedProfiles)(void);
  CGprofile (*cgGetSupportedProfile)(int);
  CGbool (*cgIsProfileSupported)(CGprofile);
  CGbool (*cgGetProfileProperty)(CGprofile, CGenum);
  const char *(*cgGetParameterClassString)(CGparameterclass);
  CGparameterclass (*cgGetParameterClassEnum)(const char *);
  const char *(*cgGetDomainString)(CGdomain);
  CGdomain (*cgGetDomain)(const char *);
  CGdomain (*cgGetProgramDomain)(CGprogram);
  CGerror (*cgGetError)(void);
  CGerror (*cgGetFirstError)(void);
  const char *(*cgGetErrorString)(CGerror);
  const char *(*cgGetLastErrorString)(CGerror *);
  void (*cgSetErrorCallback)(CGerrorCallbackFunc);
  CGerrorCallbackFunc (*cgGetErrorCallback)(void);
  void (*cgSetErrorHandler)(CGerrorHandlerFunc, void *);
  CGerrorHandlerFunc (*cgGetErrorHandler)(void **);
  const char *(*cgGetString)(CGenum);
  CGeffect (*cgCreateEffect)(CGcontext, const char *, const char **);
  CGeffect (*cgCreateEffectFromFile)(CGcontext, const char *, const char **);
  CGeffect (*cgCopyEffect)(CGeffect);
  void (*cgDestroyEffect)(CGeffect);
  CGcontext (*cgGetEffectContext)(CGeffect);
  CGbool (*cgIsEffect)(CGeffect);
  CGeffect (*cgGetFirstEffect)(CGcontext);
  CGeffect (*cgGetNextEffect)(CGeffect);
  CGprogram (*cgCreateProgramFromEffect)(CGeffect, CGprofile, const char *, const char **);
  CGtechnique (*cgGetFirstTechnique)(CGeffect);
  CGtechnique (*cgGetNextTechnique)(CGtechnique);
  CGtechnique (*cgGetNamedTechnique)(CGeffect, const char *);
  const char *(*cgGetTechniqueName)(CGtechnique);
  CGbool (*cgIsTechnique)(CGtechnique);
  CGbool (*cgValidateTechnique)(CGtechnique);
  CGbool (*cgIsTechniqueValidated)(CGtechnique);
  CGeffect (*cgGetTechniqueEffect)(CGtechnique);
  CGpass (*cgGetFirstPass)(CGtechnique);
  CGpass (*cgGetNamedPass)(CGtechnique, const char *);
  CGpass (*cgGetNextPass)(CGpass);
  CGbool (*cgIsPass)(CGpass);
  const char *(*cgGetPassName)(CGpass);
  CGtechnique (*cgGetPassTechnique)(CGpass);
  CGprogram (*cgGetPassProgram)(CGpass, CGdomain);
  void (*cgSetPassState)(CGpass);
  void (*cgResetPassState)(CGpass);
  CGstateassignment (*cgGetFirstStateAssignment)(CGpass);
  CGstateassignment (*cgGetNamedStateAssignment)(CGpass, const char *);
  CGstateassignment (*cgGetNextStateAssignment)(CGstateassignment);
  CGbool (*cgIsStateAssignment)(CGstateassignment);
  CGbool (*cgCallStateSetCallback)(CGstateassignment);
  CGbool (*cgCallStateValidateCallback)(CGstateassignment);
  CGbool (*cgCallStateResetCallback)(CGstateassignment);
  CGpass (*cgGetStateAssignmentPass)(CGstateassignment);
  CGparameter (*cgGetSamplerStateAssignmentParameter)(CGstateassignment);
  const float *(*cgGetFloatStateAssignmentValues)(CGstateassignment, int *);
  const int *(*cgGetIntStateAssignmentValues)(CGstateassignment, int *);
  const CGbool *(*cgGetBoolStateAssignmentValues)(CGstateassignment, int *);
  const char *(*cgGetStringStateAssignmentValue)(CGstateassignment);
  CGprogram (*cgGetProgramStateAssignmentValue)(CGstateassignment);
  CGparameter (*cgGetTextureStateAssignmentValue)(CGstateassignment);
  CGparameter (*cgGetSamplerStateAssignmentValue)(CGstateassignment);
  int (*cgGetStateAssignmentIndex)(CGstateassignment);
  int (*cgGetNumDependentStateAssignmentParameters)(CGstateassignment);
  CGparameter (*cgGetDependentStateAssignmentParameter)(CGstateassignment, int);
  int (*cgGetNumDependentProgramArrayStateAssignmentParameters)(CGstateassignment);
  CGparameter (*cgGetDependentProgramArrayStateAssignmentParameter)(CGstateassignment, int);
  CGparameter (*cgGetConnectedStateAssignmentParameter)(CGstateassignment);
  CGstate (*cgGetStateAssignmentState)(CGstateassignment);
  CGstate (*cgGetSamplerStateAssignmentState)(CGstateassignment);
  CGstate (*cgCreateState)(CGcontext, const char *, CGtype);
  CGstate (*cgCreateArrayState)(CGcontext, const char *, CGtype, int);
  void (*cgSetStateCallbacks)(CGstate, CGstatecallback, CGstatecallback, CGstatecallback);
  void (*cgSetStateLatestProfile)(CGstate, CGprofile);
  CGstatecallback (*cgGetStateSetCallback)(CGstate);
  CGstatecallback (*cgGetStateResetCallback)(CGstate);
  CGstatecallback (*cgGetStateValidateCallback)(CGstate);
  CGprofile (*cgGetStateLatestProfile)(CGstate);
  CGcontext (*cgGetStateContext)(CGstate);
  CGtype (*cgGetStateType)(CGstate);
  const char *(*cgGetStateName)(CGstate);
  CGstate (*cgGetNamedState)(CGcontext, const char *);
  CGstate (*cgGetFirstState)(CGcontext);
  CGstate (*cgGetNextState)(CGstate);
  CGbool (*cgIsState)(CGstate);
  void (*cgAddStateEnumerant)(CGstate, const char *, int);
  CGstate (*cgCreateSamplerState)(CGcontext, const char *, CGtype);
  CGstate (*cgCreateArraySamplerState)(CGcontext, const char *, CGtype, int);
  CGstate (*cgGetNamedSamplerState)(CGcontext, const char *);
  CGstate (*cgGetFirstSamplerState)(CGcontext);
  CGstateassignment (*cgGetFirstSamplerStateAssignment)(CGparameter);
  CGstateassignment (*cgGetNamedSamplerStateAssignment)(CGparameter, const char *);
  void (*cgSetSamplerState)(CGparameter);
  CGparameter (*cgGetNamedEffectParameter)(CGeffect, const char *);
  CGparameter (*cgGetFirstLeafEffectParameter)(CGeffect);
  CGparameter (*cgGetFirstEffectParameter)(CGeffect);
  CGparameter (*cgGetEffectParameterBySemantic)(CGeffect, const char *);
  CGannotation (*cgGetFirstTechniqueAnnotation)(CGtechnique);
  CGannotation (*cgGetFirstPassAnnotation)(CGpass);
  CGannotation (*cgGetFirstParameterAnnotation)(CGparameter);
  CGannotation (*cgGetFirstProgramAnnotation)(CGprogram);
  CGannotation (*cgGetFirstEffectAnnotation)(CGeffect);
  CGannotation (*cgGetNextAnnotation)(CGannotation);
  CGannotation (*cgGetNamedTechniqueAnnotation)(CGtechnique, const char *);
  CGannotation (*cgGetNamedPassAnnotation)(CGpass, const char *);
  CGannotation (*cgGetNamedParameterAnnotation)(CGparameter, const char *);
  CGannotation (*cgGetNamedProgramAnnotation)(CGprogram, const char *);
  CGannotation (*cgGetNamedEffectAnnotation)(CGeffect, const char *);
  CGbool (*cgIsAnnotation)(CGannotation);
  const char *(*cgGetAnnotationName)(CGannotation);
  CGtype (*cgGetAnnotationType)(CGannotation);
  const float *(*cgGetFloatAnnotationValues)(CGannotation, int *);
  const int *(*cgGetIntAnnotationValues)(CGannotation, int *);
  const char *(*cgGetStringAnnotationValue)(CGannotation);
  const char * const *(*cgGetStringAnnotationValues)(CGannotation, int *);
  const CGbool *(*cgGetBoolAnnotationValues)(CGannotation, int *);
  const int *(*cgGetBooleanAnnotationValues)(CGannotation, int *);
  int (*cgGetNumDependentAnnotationParameters)(CGannotation);
  CGparameter (*cgGetDependentAnnotationParameter)(CGannotation, int);
  void (*cgEvaluateProgram)(CGprogram, float *, int, int, int, int);
  CGbool (*cgSetEffectName)(CGeffect, const char *);
  const char *(*cgGetEffectName)(CGeffect);
  CGeffect (*cgGetNamedEffect)(CGcontext, const char *);
  CGparameter (*cgCreateEffectParameter)(CGeffect, const char *, CGtype);
  CGtechnique (*cgCreateTechnique)(CGeffect, const char *);
  CGparameter (*cgCreateEffectParameterArray)(CGeffect, const char *, CGtype, int);
  CGparameter (*cgCreateEffectParameterMultiDimArray)(CGeffect, const char *, CGtype, int, const int *);
  CGpass (*cgCreatePass)(CGtechnique, const char *);
  CGstateassignment (*cgCreateStateAssignment)(CGpass, CGstate);
  CGstateassignment (*cgCreateStateAssignmentIndex)(CGpass, CGstate, int);
  CGstateassignment (*cgCreateSamplerStateAssignment)(CGparameter, CGstate);
  CGbool (*cgSetFloatStateAssignment)(CGstateassignment, float);
  CGbool (*cgSetIntStateAssignment)(CGstateassignment, int);
  CGbool (*cgSetBoolStateAssignment)(CGstateassignment, CGbool);
  CGbool (*cgSetStringStateAssignment)(CGstateassignment, const char *);
  CGbool (*cgSetProgramStateAssignment)(CGstateassignment, CGprogram);
  CGbool (*cgSetSamplerStateAssignment)(CGstateassignment, CGparameter);
  CGbool (*cgSetTextureStateAssignment)(CGstateassignment, CGparameter);
  CGbool (*cgSetFloatArrayStateAssignment)(CGstateassignment, const float *);
  CGbool (*cgSetIntArrayStateAssignment)(CGstateassignment, const int *);
  CGbool (*cgSetBoolArrayStateAssignment)(CGstateassignment, const CGbool *);
  CGannotation (*cgCreateTechniqueAnnotation)(CGtechnique, const char *, CGtype);
  CGannotation (*cgCreatePassAnnotation)(CGpass, const char *, CGtype);
  CGannotation (*cgCreateParameterAnnotation)(CGparameter, const char *, CGtype);
  CGannotation (*cgCreateProgramAnnotation)(CGprogram, const char *, CGtype);
  CGannotation (*cgCreateEffectAnnotation)(CGeffect, const char *, CGtype);
  CGbool (*cgSetIntAnnotation)(CGannotation, int);
  CGbool (*cgSetFloatAnnotation)(CGannotation, float);
  CGbool (*cgSetBoolAnnotation)(CGannotation, CGbool);
  CGbool (*cgSetStringAnnotation)(CGannotation, const char *);
  int (*cgGetNumStateEnumerants)(CGstate);
  const char *(*cgGetStateEnumerant)(CGstate, int, int *);
  const char *(*cgGetStateEnumerantName)(CGstate, int);
  int (*cgGetStateEnumerantValue)(CGstate, const char *);
  CGeffect (*cgGetParameterEffect)(CGparameter);
  CGparameterclass (*cgGetTypeClass)(CGtype);
  CGtype (*cgGetTypeBase)(CGtype);
  CGbool (*cgGetTypeSizes)(CGtype, int *, int *);
  void (*cgGetMatrixSize)(CGtype, int *, int *);
  int (*cgGetNumProgramDomains)(CGprogram);
  CGdomain (*cgGetProfileDomain)(CGprofile);
  CGprofile (*cgGetProfileSibling)(CGprofile, CGdomain);
  CGprogram (*cgCombinePrograms)(int, const CGprogram *);
  CGprogram (*cgCombinePrograms2)(const CGprogram, const CGprogram);
  CGprogram (*cgCombinePrograms3)(const CGprogram, const CGprogram, const CGprogram);
  CGprogram (*cgCombinePrograms4)(const CGprogram, const CGprogram, const CGprogram, const CGprogram);
  CGprogram (*cgCombinePrograms5)(const CGprogram, const CGprogram, const CGprogram, const CGprogram, const CGprogram);
  CGprofile (*cgGetProgramDomainProfile)(CGprogram, int);
  CGprogram (*cgGetProgramDomainProgram)(CGprogram, int);
  CGobj (*cgCreateObj)(CGcontext, CGenum, const char *, CGprofile, const char **);
  CGobj (*cgCreateObjFromFile)(CGcontext, CGenum, const char *, CGprofile, const char **);
  void (*cgDestroyObj)(CGobj);
  long (*cgGetParameterResourceSize)(CGparameter);
  CGtype (*cgGetParameterResourceType)(CGparameter);
  const char *(*cgGetParameterResourceName)(CGparameter);
  int (*cgGetParameterBufferIndex)(CGparameter);
  int (*cgGetParameterBufferOffset)(CGparameter);
  CGbuffer (*cgCreateBuffer)(CGcontext, int, const void *, CGbufferusage);
  CGbool (*cgIsBuffer)(CGbuffer);
  void (*cgSetBufferData)(CGbuffer, int, const void *);
  void (*cgSetBufferSubData)(CGbuffer, int, int, const void *);
  void (*cgSetProgramBuffer)(CGprogram, int, CGbuffer);
  void (*cgSetUniformBufferParameter)(CGparameter, CGbuffer);
  void *(*cgMapBuffer)(CGbuffer, CGbufferaccess);
  void (*cgUnmapBuffer)(CGbuffer);
  void (*cgDestroyBuffer)(CGbuffer);
  CGbuffer (*cgGetProgramBuffer)(CGprogram, int);
  CGbuffer (*cgGetUniformBufferParameter)(CGparameter);
  int (*cgGetBufferSize)(CGbuffer);
  int (*cgGetProgramBufferMaxSize)(CGprofile);
  int (*cgGetProgramBufferMaxIndex)(CGprofile);
  CGbuffer (*cgGetEffectParameterBuffer)(CGparameter);
  void (*cgSetEffectParameterBuffer)(CGparameter, CGbuffer);
#if !defined(__APPLE__)
  void *(*cgInternal)(void);
#endif
};

static struct TraceCg_Functions traceCg_Native;

/* Declare Cg helper functions. */

static void *getHelper(const char *name);

static size_t helperCgGetArrayDimSize(CGparameter);
static size_t helperCgGetMatrixParameterSize(CGparameter);
static size_t helperCgGetParameterArraySize(CGparameter, long, long, long);
static size_t helperCgGetMatrixParameterArraySize(CGparameter, long, long);
static size_t helperCgGetArrayStateAssignmentSize(CGstateassignment);
static size_t helperCgCreateBufferSize(int);
static size_t helperCgGetBufferSize(CGbuffer, int);
static CGstatecallback helperCgStateSetCallbackStateAssignment(CGstateassignment);
static CGstatecallback helperCgStateResetCallbackStateAssignment(CGstateassignment);
static CGstatecallback helperCgStateValidateCallbackStateAssignment(CGstateassignment);

/* Cg helper function pointers. */

static size_t (*traceCg_helperCgGetArrayDimSize)(CGparameter) = NULL;
static size_t (*traceCg_helperCgGetMatrixParameterSize)(CGparameter) = NULL;
static size_t (*traceCg_helperCgGetParameterArraySize)(CGparameter, long, long, long) = NULL;
static size_t (*traceCg_helperCgGetMatrixParameterArraySize)(CGparameter, long, long) = NULL;
static size_t (*traceCg_helperCgGetArrayStateAssignmentSize)(CGstateassignment) = NULL;
static size_t (*traceCg_helperCgCreateBufferSize)(int) = NULL;
static size_t (*traceCg_helperCgGetBufferSize)(CGbuffer, int) = NULL;
static CGstatecallback (*traceCg_helperCgStateSetCallbackStateAssignment)(CGstateassignment) = NULL;
static CGstatecallback (*traceCg_helperCgStateResetCallbackStateAssignment)(CGstateassignment) = NULL;
static CGstatecallback (*traceCg_helperCgStateValidateCallbackStateAssignment)(CGstateassignment) = NULL;

struct TraceCgState traceCg_state;

/* Initialize TraceCg. */

void
traceCg_init(void)
{
  const char *library = "Cg";
  const char *filename = NULL;
  int versionMajor = 0;
  int versionMinor = 0;
  int versionBuild = 0;
  const char *versionString = NULL;

  if (traceCg_initialized)
    return;

  /* Do pre-initialization */

  /* Load the native library */

  filename = traceLibraryLocation(library);
  traceCg_handle = traceCg_LoadLibrary(filename);
  if (!traceCg_handle)
  {
    traceError("Failed to load %s from %s", library, filename);
    return;
  }
  traceInfo("Loaded %s from %s", library, filename);

  traceRegister(&getHelper);

  /* Load Cg API functions. */

  memset(&traceCg_Native, 0, sizeof(struct TraceCg_Functions));

  traceCg_Native.cgSetLockingPolicy = (CGenum (*)(CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgSetLockingPolicy");
  traceCg_Native.cgGetLockingPolicy = (CGenum (*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgGetLockingPolicy");
  traceCg_Native.cgSetSemanticCasePolicy = (CGenum (*)(CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgSetSemanticCasePolicy");
  traceCg_Native.cgGetSemanticCasePolicy = (CGenum (*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgGetSemanticCasePolicy");
  traceCg_Native.cgCreateContext = (CGcontext (*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgCreateContext");
  traceCg_Native.cgSetContextBehavior = (void (*)(CGcontext, CGbehavior)) traceCg_GetProcAddress(traceCg_handle, "cgSetContextBehavior");
  traceCg_Native.cgGetContextBehavior = (CGbehavior (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetContextBehavior");
  traceCg_Native.cgGetBehaviorString = (const char *(*)(CGbehavior)) traceCg_GetProcAddress(traceCg_handle, "cgGetBehaviorString");
  traceCg_Native.cgGetBehavior = (CGbehavior (*)(const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetBehavior");
  traceCg_Native.cgDestroyContext = (void (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgDestroyContext");
  traceCg_Native.cgIsContext = (CGbool (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgIsContext");
  traceCg_Native.cgGetLastListing = (const char *(*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetLastListing");
  traceCg_Native.cgSetLastListing = (void (*)(CGhandle, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetLastListing");
  traceCg_Native.cgSetAutoCompile = (void (*)(CGcontext, CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgSetAutoCompile");
  traceCg_Native.cgGetAutoCompile = (CGenum (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetAutoCompile");
  traceCg_Native.cgSetParameterSettingMode = (void (*)(CGcontext, CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterSettingMode");
  traceCg_Native.cgGetParameterSettingMode = (CGenum (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterSettingMode");
  traceCg_Native.cgSetCompilerIncludeString = (void (*)(CGcontext, const char *, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetCompilerIncludeString");
  traceCg_Native.cgSetCompilerIncludeFile = (void (*)(CGcontext, const char *, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetCompilerIncludeFile");
  traceCg_Native.cgSetCompilerIncludeCallback = (void (*)(CGcontext, CGIncludeCallbackFunc)) traceCg_GetProcAddress(traceCg_handle, "cgSetCompilerIncludeCallback");
  traceCg_Native.cgGetCompilerIncludeCallback = (CGIncludeCallbackFunc (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetCompilerIncludeCallback");
  traceCg_Native.cgCreateProgram = (CGprogram (*)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **)) traceCg_GetProcAddress(traceCg_handle, "cgCreateProgram");
  traceCg_Native.cgCreateProgramFromFile = (CGprogram (*)(CGcontext, CGenum, const char *, CGprofile, const char *, const char **)) traceCg_GetProcAddress(traceCg_handle, "cgCreateProgramFromFile");
  traceCg_Native.cgCopyProgram = (CGprogram (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgCopyProgram");
  traceCg_Native.cgDestroyProgram = (void (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgDestroyProgram");
  traceCg_Native.cgGetFirstProgram = (CGprogram (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstProgram");
  traceCg_Native.cgGetNextProgram = (CGprogram (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextProgram");
  traceCg_Native.cgGetProgramContext = (CGcontext (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramContext");
  traceCg_Native.cgIsProgram = (CGbool (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgIsProgram");
  traceCg_Native.cgCompileProgram = (void (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgCompileProgram");
  traceCg_Native.cgIsProgramCompiled = (CGbool (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgIsProgramCompiled");
  traceCg_Native.cgGetProgramString = (const char *(*)(CGprogram, CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramString");
  traceCg_Native.cgGetProgramProfile = (CGprofile (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramProfile");
  traceCg_Native.cgGetProgramOptions = (char const * const *(*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramOptions");
  traceCg_Native.cgSetProgramProfile = (void (*)(CGprogram, CGprofile)) traceCg_GetProcAddress(traceCg_handle, "cgSetProgramProfile");
  traceCg_Native.cgGetProgramInput = (CGenum (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramInput");
  traceCg_Native.cgGetProgramOutput = (CGenum (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramOutput");
  traceCg_Native.cgGetProgramOutputVertices = (int (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramOutputVertices");
  traceCg_Native.cgSetProgramOutputVertices = (void (*)(CGprogram, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetProgramOutputVertices");
  traceCg_Native.cgSetPassProgramParameters = (void (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgSetPassProgramParameters");
  traceCg_Native.cgUpdateProgramParameters = (void (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgUpdateProgramParameters");
  traceCg_Native.cgUpdatePassParameters = (void (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgUpdatePassParameters");
  traceCg_Native.cgCreateParameter = (CGparameter (*)(CGcontext, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateParameter");
  traceCg_Native.cgCreateParameterArray = (CGparameter (*)(CGcontext, CGtype, int)) traceCg_GetProcAddress(traceCg_handle, "cgCreateParameterArray");
  traceCg_Native.cgCreateParameterMultiDimArray = (CGparameter (*)(CGcontext, CGtype, int, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgCreateParameterMultiDimArray");
  traceCg_Native.cgDestroyParameter = (void (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgDestroyParameter");
  traceCg_Native.cgConnectParameter = (void (*)(CGparameter, CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgConnectParameter");
  traceCg_Native.cgDisconnectParameter = (void (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgDisconnectParameter");
  traceCg_Native.cgGetConnectedParameter = (CGparameter (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetConnectedParameter");
  traceCg_Native.cgGetNumConnectedToParameters = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumConnectedToParameters");
  traceCg_Native.cgGetConnectedToParameter = (CGparameter (*)(CGparameter, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetConnectedToParameter");
  traceCg_Native.cgGetNamedParameter = (CGparameter (*)(CGprogram, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedParameter");
  traceCg_Native.cgGetNamedProgramParameter = (CGparameter (*)(CGprogram, CGenum, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedProgramParameter");
  traceCg_Native.cgGetNamedProgramUniformBuffer = (CGparameter (*)(CGprogram, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedProgramUniformBuffer");
  traceCg_Native.cgGetNamedEffectUniformBuffer = (CGparameter (*)(CGeffect, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedEffectUniformBuffer");
  traceCg_Native.cgGetUniformBufferBlockName = (const char *(*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetUniformBufferBlockName");
  traceCg_Native.cgGetFirstParameter = (CGparameter (*)(CGprogram, CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstParameter");
  traceCg_Native.cgGetNextParameter = (CGparameter (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextParameter");
  traceCg_Native.cgGetFirstLeafParameter = (CGparameter (*)(CGprogram, CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstLeafParameter");
  traceCg_Native.cgGetNextLeafParameter = (CGparameter (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextLeafParameter");
  traceCg_Native.cgGetFirstStructParameter = (CGparameter (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstStructParameter");
  traceCg_Native.cgGetFirstUniformBufferParameter = (CGparameter (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstUniformBufferParameter");
  traceCg_Native.cgGetNamedStructParameter = (CGparameter (*)(CGparameter, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedStructParameter");
  traceCg_Native.cgGetNamedUniformBufferParameter = (CGparameter (*)(CGparameter, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedUniformBufferParameter");
  traceCg_Native.cgGetFirstDependentParameter = (CGparameter (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstDependentParameter");
  traceCg_Native.cgGetArrayParameter = (CGparameter (*)(CGparameter, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetArrayParameter");
  traceCg_Native.cgGetArrayDimension = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetArrayDimension");
  traceCg_Native.cgGetArrayType = (CGtype (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetArrayType");
  traceCg_Native.cgGetArraySize = (int (*)(CGparameter, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetArraySize");
  traceCg_Native.cgGetArrayTotalSize = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetArrayTotalSize");
  traceCg_Native.cgSetArraySize = (void (*)(CGparameter, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetArraySize");
  traceCg_Native.cgSetMultiDimArraySize = (void (*)(CGparameter, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetMultiDimArraySize");
  traceCg_Native.cgGetParameterProgram = (CGprogram (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterProgram");
  traceCg_Native.cgGetParameterContext = (CGcontext (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterContext");
  traceCg_Native.cgIsParameter = (CGbool (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgIsParameter");
  traceCg_Native.cgGetParameterName = (const char *(*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterName");
  traceCg_Native.cgGetParameterType = (CGtype (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterType");
  traceCg_Native.cgGetParameterBaseType = (CGtype (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterBaseType");
  traceCg_Native.cgGetParameterClass = (CGparameterclass (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterClass");
  traceCg_Native.cgGetParameterRows = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterRows");
  traceCg_Native.cgGetParameterColumns = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterColumns");
  traceCg_Native.cgGetParameterNamedType = (CGtype (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterNamedType");
  traceCg_Native.cgGetParameterSemantic = (const char *(*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterSemantic");
  traceCg_Native.cgGetParameterResource = (CGresource (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterResource");
  traceCg_Native.cgGetParameterBaseResource = (CGresource (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterBaseResource");
  traceCg_Native.cgGetParameterResourceIndex = (unsigned long (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterResourceIndex");
  traceCg_Native.cgGetParameterVariability = (CGenum (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterVariability");
  traceCg_Native.cgGetParameterDirection = (CGenum (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterDirection");
  traceCg_Native.cgIsParameterReferenced = (CGbool (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgIsParameterReferenced");
  traceCg_Native.cgIsParameterUsed = (CGbool (*)(CGparameter, CGhandle)) traceCg_GetProcAddress(traceCg_handle, "cgIsParameterUsed");
  traceCg_Native.cgGetParameterValues = (const double *(*)(CGparameter, CGenum, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterValues");
  traceCg_Native.cgSetParameterValuedr = (void (*)(CGparameter, int, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterValuedr");
  traceCg_Native.cgSetParameterValuedc = (void (*)(CGparameter, int, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterValuedc");
  traceCg_Native.cgSetParameterValuefr = (void (*)(CGparameter, int, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterValuefr");
  traceCg_Native.cgSetParameterValuefc = (void (*)(CGparameter, int, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterValuefc");
  traceCg_Native.cgSetParameterValueir = (void (*)(CGparameter, int, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterValueir");
  traceCg_Native.cgSetParameterValueic = (void (*)(CGparameter, int, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterValueic");
  traceCg_Native.cgGetParameterValuedr = (int (*)(CGparameter, int, double *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterValuedr");
  traceCg_Native.cgGetParameterValuedc = (int (*)(CGparameter, int, double *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterValuedc");
  traceCg_Native.cgGetParameterValuefr = (int (*)(CGparameter, int, float *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterValuefr");
  traceCg_Native.cgGetParameterValuefc = (int (*)(CGparameter, int, float *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterValuefc");
  traceCg_Native.cgGetParameterValueir = (int (*)(CGparameter, int, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterValueir");
  traceCg_Native.cgGetParameterValueic = (int (*)(CGparameter, int, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterValueic");
  traceCg_Native.cgGetParameterDefaultValuedr = (int (*)(CGparameter, int, double *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterDefaultValuedr");
  traceCg_Native.cgGetParameterDefaultValuedc = (int (*)(CGparameter, int, double *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterDefaultValuedc");
  traceCg_Native.cgGetParameterDefaultValuefr = (int (*)(CGparameter, int, float *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterDefaultValuefr");
  traceCg_Native.cgGetParameterDefaultValuefc = (int (*)(CGparameter, int, float *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterDefaultValuefc");
  traceCg_Native.cgGetParameterDefaultValueir = (int (*)(CGparameter, int, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterDefaultValueir");
  traceCg_Native.cgGetParameterDefaultValueic = (int (*)(CGparameter, int, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterDefaultValueic");
  traceCg_Native.cgGetStringParameterValue = (const char *(*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetStringParameterValue");
  traceCg_Native.cgSetStringParameterValue = (void (*)(CGparameter, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetStringParameterValue");
  traceCg_Native.cgGetParameterOrdinalNumber = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterOrdinalNumber");
  traceCg_Native.cgIsParameterGlobal = (CGbool (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgIsParameterGlobal");
  traceCg_Native.cgGetParameterIndex = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterIndex");
  traceCg_Native.cgSetParameterVariability = (void (*)(CGparameter, CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterVariability");
  traceCg_Native.cgSetParameterSemantic = (void (*)(CGparameter, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameterSemantic");
  traceCg_Native.cgSetParameter1f = (void (*)(CGparameter, float)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter1f");
  traceCg_Native.cgSetParameter2f = (void (*)(CGparameter, float, float)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter2f");
  traceCg_Native.cgSetParameter3f = (void (*)(CGparameter, float, float, float)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter3f");
  traceCg_Native.cgSetParameter4f = (void (*)(CGparameter, float, float, float, float)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter4f");
  traceCg_Native.cgSetParameter1d = (void (*)(CGparameter, double)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter1d");
  traceCg_Native.cgSetParameter2d = (void (*)(CGparameter, double, double)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter2d");
  traceCg_Native.cgSetParameter3d = (void (*)(CGparameter, double, double, double)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter3d");
  traceCg_Native.cgSetParameter4d = (void (*)(CGparameter, double, double, double, double)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter4d");
  traceCg_Native.cgSetParameter1i = (void (*)(CGparameter, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter1i");
  traceCg_Native.cgSetParameter2i = (void (*)(CGparameter, int, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter2i");
  traceCg_Native.cgSetParameter3i = (void (*)(CGparameter, int, int, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter3i");
  traceCg_Native.cgSetParameter4i = (void (*)(CGparameter, int, int, int, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter4i");
  traceCg_Native.cgSetParameter1iv = (void (*)(CGparameter, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter1iv");
  traceCg_Native.cgSetParameter2iv = (void (*)(CGparameter, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter2iv");
  traceCg_Native.cgSetParameter3iv = (void (*)(CGparameter, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter3iv");
  traceCg_Native.cgSetParameter4iv = (void (*)(CGparameter, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter4iv");
  traceCg_Native.cgSetParameter1fv = (void (*)(CGparameter, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter1fv");
  traceCg_Native.cgSetParameter2fv = (void (*)(CGparameter, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter2fv");
  traceCg_Native.cgSetParameter3fv = (void (*)(CGparameter, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter3fv");
  traceCg_Native.cgSetParameter4fv = (void (*)(CGparameter, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter4fv");
  traceCg_Native.cgSetParameter1dv = (void (*)(CGparameter, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter1dv");
  traceCg_Native.cgSetParameter2dv = (void (*)(CGparameter, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter2dv");
  traceCg_Native.cgSetParameter3dv = (void (*)(CGparameter, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter3dv");
  traceCg_Native.cgSetParameter4dv = (void (*)(CGparameter, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetParameter4dv");
  traceCg_Native.cgSetMatrixParameterir = (void (*)(CGparameter, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetMatrixParameterir");
  traceCg_Native.cgSetMatrixParameterdr = (void (*)(CGparameter, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetMatrixParameterdr");
  traceCg_Native.cgSetMatrixParameterfr = (void (*)(CGparameter, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetMatrixParameterfr");
  traceCg_Native.cgSetMatrixParameteric = (void (*)(CGparameter, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetMatrixParameteric");
  traceCg_Native.cgSetMatrixParameterdc = (void (*)(CGparameter, const double *)) traceCg_GetProcAddress(traceCg_handle, "cgSetMatrixParameterdc");
  traceCg_Native.cgSetMatrixParameterfc = (void (*)(CGparameter, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetMatrixParameterfc");
  traceCg_Native.cgGetMatrixParameterir = (void (*)(CGparameter, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixParameterir");
  traceCg_Native.cgGetMatrixParameterdr = (void (*)(CGparameter, double *)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixParameterdr");
  traceCg_Native.cgGetMatrixParameterfr = (void (*)(CGparameter, float *)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixParameterfr");
  traceCg_Native.cgGetMatrixParameteric = (void (*)(CGparameter, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixParameteric");
  traceCg_Native.cgGetMatrixParameterdc = (void (*)(CGparameter, double *)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixParameterdc");
  traceCg_Native.cgGetMatrixParameterfc = (void (*)(CGparameter, float *)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixParameterfc");
  traceCg_Native.cgGetMatrixParameterOrder = (CGenum (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixParameterOrder");
  traceCg_Native.cgGetNamedSubParameter = (CGparameter (*)(CGparameter, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedSubParameter");
  traceCg_Native.cgGetTypeString = (const char *(*)(CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgGetTypeString");
  traceCg_Native.cgGetType = (CGtype (*)(const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetType");
  traceCg_Native.cgGetNamedUserType = (CGtype (*)(CGhandle, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedUserType");
  traceCg_Native.cgGetNumUserTypes = (int (*)(CGhandle)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumUserTypes");
  traceCg_Native.cgGetUserType = (CGtype (*)(CGhandle, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetUserType");
  traceCg_Native.cgGetNumParentTypes = (int (*)(CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumParentTypes");
  traceCg_Native.cgGetParentType = (CGtype (*)(CGtype, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetParentType");
  traceCg_Native.cgIsParentType = (CGbool (*)(CGtype, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgIsParentType");
  traceCg_Native.cgIsInterfaceType = (CGbool (*)(CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgIsInterfaceType");
  traceCg_Native.cgGetResourceString = (const char *(*)(CGresource)) traceCg_GetProcAddress(traceCg_handle, "cgGetResourceString");
  traceCg_Native.cgGetResource = (CGresource (*)(const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetResource");
  traceCg_Native.cgGetEnumString = (const char *(*)(CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgGetEnumString");
  traceCg_Native.cgGetEnum = (CGenum (*)(const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetEnum");
  traceCg_Native.cgGetProfileString = (const char *(*)(CGprofile)) traceCg_GetProcAddress(traceCg_handle, "cgGetProfileString");
  traceCg_Native.cgGetProfile = (CGprofile (*)(const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetProfile");
  traceCg_Native.cgGetNumSupportedProfiles = (int (*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumSupportedProfiles");
  traceCg_Native.cgGetSupportedProfile = (CGprofile (*)(int)) traceCg_GetProcAddress(traceCg_handle, "cgGetSupportedProfile");
  traceCg_Native.cgIsProfileSupported = (CGbool (*)(CGprofile)) traceCg_GetProcAddress(traceCg_handle, "cgIsProfileSupported");
  traceCg_Native.cgGetProfileProperty = (CGbool (*)(CGprofile, CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgGetProfileProperty");
  traceCg_Native.cgGetParameterClassString = (const char *(*)(CGparameterclass)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterClassString");
  traceCg_Native.cgGetParameterClassEnum = (CGparameterclass (*)(const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterClassEnum");
  traceCg_Native.cgGetDomainString = (const char *(*)(CGdomain)) traceCg_GetProcAddress(traceCg_handle, "cgGetDomainString");
  traceCg_Native.cgGetDomain = (CGdomain (*)(const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetDomain");
  traceCg_Native.cgGetProgramDomain = (CGdomain (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramDomain");
  traceCg_Native.cgGetError = (CGerror (*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgGetError");
  traceCg_Native.cgGetFirstError = (CGerror (*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstError");
  traceCg_Native.cgGetErrorString = (const char *(*)(CGerror)) traceCg_GetProcAddress(traceCg_handle, "cgGetErrorString");
  traceCg_Native.cgGetLastErrorString = (const char *(*)(CGerror *)) traceCg_GetProcAddress(traceCg_handle, "cgGetLastErrorString");
  traceCg_Native.cgSetErrorCallback = (void (*)(CGerrorCallbackFunc)) traceCg_GetProcAddress(traceCg_handle, "cgSetErrorCallback");
  traceCg_Native.cgGetErrorCallback = (CGerrorCallbackFunc (*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgGetErrorCallback");
  traceCg_Native.cgSetErrorHandler = (void (*)(CGerrorHandlerFunc, void *)) traceCg_GetProcAddress(traceCg_handle, "cgSetErrorHandler");
  traceCg_Native.cgGetErrorHandler = (CGerrorHandlerFunc (*)(void **)) traceCg_GetProcAddress(traceCg_handle, "cgGetErrorHandler");
  traceCg_Native.cgGetString = (const char *(*)(CGenum)) traceCg_GetProcAddress(traceCg_handle, "cgGetString");
  traceCg_Native.cgCreateEffect = (CGeffect (*)(CGcontext, const char *, const char **)) traceCg_GetProcAddress(traceCg_handle, "cgCreateEffect");
  traceCg_Native.cgCreateEffectFromFile = (CGeffect (*)(CGcontext, const char *, const char **)) traceCg_GetProcAddress(traceCg_handle, "cgCreateEffectFromFile");
  traceCg_Native.cgCopyEffect = (CGeffect (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgCopyEffect");
  traceCg_Native.cgDestroyEffect = (void (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgDestroyEffect");
  traceCg_Native.cgGetEffectContext = (CGcontext (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgGetEffectContext");
  traceCg_Native.cgIsEffect = (CGbool (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgIsEffect");
  traceCg_Native.cgGetFirstEffect = (CGeffect (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstEffect");
  traceCg_Native.cgGetNextEffect = (CGeffect (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextEffect");
  traceCg_Native.cgCreateProgramFromEffect = (CGprogram (*)(CGeffect, CGprofile, const char *, const char **)) traceCg_GetProcAddress(traceCg_handle, "cgCreateProgramFromEffect");
  traceCg_Native.cgGetFirstTechnique = (CGtechnique (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstTechnique");
  traceCg_Native.cgGetNextTechnique = (CGtechnique (*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextTechnique");
  traceCg_Native.cgGetNamedTechnique = (CGtechnique (*)(CGeffect, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedTechnique");
  traceCg_Native.cgGetTechniqueName = (const char *(*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgGetTechniqueName");
  traceCg_Native.cgIsTechnique = (CGbool (*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgIsTechnique");
  traceCg_Native.cgValidateTechnique = (CGbool (*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgValidateTechnique");
  traceCg_Native.cgIsTechniqueValidated = (CGbool (*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgIsTechniqueValidated");
  traceCg_Native.cgGetTechniqueEffect = (CGeffect (*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgGetTechniqueEffect");
  traceCg_Native.cgGetFirstPass = (CGpass (*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstPass");
  traceCg_Native.cgGetNamedPass = (CGpass (*)(CGtechnique, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedPass");
  traceCg_Native.cgGetNextPass = (CGpass (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextPass");
  traceCg_Native.cgIsPass = (CGbool (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgIsPass");
  traceCg_Native.cgGetPassName = (const char *(*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgGetPassName");
  traceCg_Native.cgGetPassTechnique = (CGtechnique (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgGetPassTechnique");
  traceCg_Native.cgGetPassProgram = (CGprogram (*)(CGpass, CGdomain)) traceCg_GetProcAddress(traceCg_handle, "cgGetPassProgram");
  traceCg_Native.cgSetPassState = (void (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgSetPassState");
  traceCg_Native.cgResetPassState = (void (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgResetPassState");
  traceCg_Native.cgGetFirstStateAssignment = (CGstateassignment (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstStateAssignment");
  traceCg_Native.cgGetNamedStateAssignment = (CGstateassignment (*)(CGpass, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedStateAssignment");
  traceCg_Native.cgGetNextStateAssignment = (CGstateassignment (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextStateAssignment");
  traceCg_Native.cgIsStateAssignment = (CGbool (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgIsStateAssignment");
  traceCg_Native.cgCallStateSetCallback = (CGbool (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgCallStateSetCallback");
  traceCg_Native.cgCallStateValidateCallback = (CGbool (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgCallStateValidateCallback");
  traceCg_Native.cgCallStateResetCallback = (CGbool (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgCallStateResetCallback");
  traceCg_Native.cgGetStateAssignmentPass = (CGpass (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateAssignmentPass");
  traceCg_Native.cgGetSamplerStateAssignmentParameter = (CGparameter (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetSamplerStateAssignmentParameter");
  traceCg_Native.cgGetFloatStateAssignmentValues = (const float *(*)(CGstateassignment, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetFloatStateAssignmentValues");
  traceCg_Native.cgGetIntStateAssignmentValues = (const int *(*)(CGstateassignment, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetIntStateAssignmentValues");
  traceCg_Native.cgGetBoolStateAssignmentValues = (const CGbool *(*)(CGstateassignment, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetBoolStateAssignmentValues");
  traceCg_Native.cgGetStringStateAssignmentValue = (const char *(*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetStringStateAssignmentValue");
  traceCg_Native.cgGetProgramStateAssignmentValue = (CGprogram (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramStateAssignmentValue");
  traceCg_Native.cgGetTextureStateAssignmentValue = (CGparameter (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetTextureStateAssignmentValue");
  traceCg_Native.cgGetSamplerStateAssignmentValue = (CGparameter (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetSamplerStateAssignmentValue");
  traceCg_Native.cgGetStateAssignmentIndex = (int (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateAssignmentIndex");
  traceCg_Native.cgGetNumDependentStateAssignmentParameters = (int (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumDependentStateAssignmentParameters");
  traceCg_Native.cgGetDependentStateAssignmentParameter = (CGparameter (*)(CGstateassignment, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetDependentStateAssignmentParameter");
  traceCg_Native.cgGetNumDependentProgramArrayStateAssignmentParameters = (int (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumDependentProgramArrayStateAssignmentParameters");
  traceCg_Native.cgGetDependentProgramArrayStateAssignmentParameter = (CGparameter (*)(CGstateassignment, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetDependentProgramArrayStateAssignmentParameter");
  traceCg_Native.cgGetConnectedStateAssignmentParameter = (CGparameter (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetConnectedStateAssignmentParameter");
  traceCg_Native.cgGetStateAssignmentState = (CGstate (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateAssignmentState");
  traceCg_Native.cgGetSamplerStateAssignmentState = (CGstate (*)(CGstateassignment)) traceCg_GetProcAddress(traceCg_handle, "cgGetSamplerStateAssignmentState");
  traceCg_Native.cgCreateState = (CGstate (*)(CGcontext, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateState");
  traceCg_Native.cgCreateArrayState = (CGstate (*)(CGcontext, const char *, CGtype, int)) traceCg_GetProcAddress(traceCg_handle, "cgCreateArrayState");
  traceCg_Native.cgSetStateCallbacks = (void (*)(CGstate, CGstatecallback, CGstatecallback, CGstatecallback)) traceCg_GetProcAddress(traceCg_handle, "cgSetStateCallbacks");
  traceCg_Native.cgSetStateLatestProfile = (void (*)(CGstate, CGprofile)) traceCg_GetProcAddress(traceCg_handle, "cgSetStateLatestProfile");
  traceCg_Native.cgGetStateSetCallback = (CGstatecallback (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateSetCallback");
  traceCg_Native.cgGetStateResetCallback = (CGstatecallback (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateResetCallback");
  traceCg_Native.cgGetStateValidateCallback = (CGstatecallback (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateValidateCallback");
  traceCg_Native.cgGetStateLatestProfile = (CGprofile (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateLatestProfile");
  traceCg_Native.cgGetStateContext = (CGcontext (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateContext");
  traceCg_Native.cgGetStateType = (CGtype (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateType");
  traceCg_Native.cgGetStateName = (const char *(*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateName");
  traceCg_Native.cgGetNamedState = (CGstate (*)(CGcontext, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedState");
  traceCg_Native.cgGetFirstState = (CGstate (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstState");
  traceCg_Native.cgGetNextState = (CGstate (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextState");
  traceCg_Native.cgIsState = (CGbool (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgIsState");
  traceCg_Native.cgAddStateEnumerant = (void (*)(CGstate, const char *, int)) traceCg_GetProcAddress(traceCg_handle, "cgAddStateEnumerant");
  traceCg_Native.cgCreateSamplerState = (CGstate (*)(CGcontext, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateSamplerState");
  traceCg_Native.cgCreateArraySamplerState = (CGstate (*)(CGcontext, const char *, CGtype, int)) traceCg_GetProcAddress(traceCg_handle, "cgCreateArraySamplerState");
  traceCg_Native.cgGetNamedSamplerState = (CGstate (*)(CGcontext, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedSamplerState");
  traceCg_Native.cgGetFirstSamplerState = (CGstate (*)(CGcontext)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstSamplerState");
  traceCg_Native.cgGetFirstSamplerStateAssignment = (CGstateassignment (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstSamplerStateAssignment");
  traceCg_Native.cgGetNamedSamplerStateAssignment = (CGstateassignment (*)(CGparameter, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedSamplerStateAssignment");
  traceCg_Native.cgSetSamplerState = (void (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgSetSamplerState");
  traceCg_Native.cgGetNamedEffectParameter = (CGparameter (*)(CGeffect, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedEffectParameter");
  traceCg_Native.cgGetFirstLeafEffectParameter = (CGparameter (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstLeafEffectParameter");
  traceCg_Native.cgGetFirstEffectParameter = (CGparameter (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstEffectParameter");
  traceCg_Native.cgGetEffectParameterBySemantic = (CGparameter (*)(CGeffect, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetEffectParameterBySemantic");
  traceCg_Native.cgGetFirstTechniqueAnnotation = (CGannotation (*)(CGtechnique)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstTechniqueAnnotation");
  traceCg_Native.cgGetFirstPassAnnotation = (CGannotation (*)(CGpass)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstPassAnnotation");
  traceCg_Native.cgGetFirstParameterAnnotation = (CGannotation (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstParameterAnnotation");
  traceCg_Native.cgGetFirstProgramAnnotation = (CGannotation (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstProgramAnnotation");
  traceCg_Native.cgGetFirstEffectAnnotation = (CGannotation (*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgGetFirstEffectAnnotation");
  traceCg_Native.cgGetNextAnnotation = (CGannotation (*)(CGannotation)) traceCg_GetProcAddress(traceCg_handle, "cgGetNextAnnotation");
  traceCg_Native.cgGetNamedTechniqueAnnotation = (CGannotation (*)(CGtechnique, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedTechniqueAnnotation");
  traceCg_Native.cgGetNamedPassAnnotation = (CGannotation (*)(CGpass, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedPassAnnotation");
  traceCg_Native.cgGetNamedParameterAnnotation = (CGannotation (*)(CGparameter, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedParameterAnnotation");
  traceCg_Native.cgGetNamedProgramAnnotation = (CGannotation (*)(CGprogram, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedProgramAnnotation");
  traceCg_Native.cgGetNamedEffectAnnotation = (CGannotation (*)(CGeffect, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedEffectAnnotation");
  traceCg_Native.cgIsAnnotation = (CGbool (*)(CGannotation)) traceCg_GetProcAddress(traceCg_handle, "cgIsAnnotation");
  traceCg_Native.cgGetAnnotationName = (const char *(*)(CGannotation)) traceCg_GetProcAddress(traceCg_handle, "cgGetAnnotationName");
  traceCg_Native.cgGetAnnotationType = (CGtype (*)(CGannotation)) traceCg_GetProcAddress(traceCg_handle, "cgGetAnnotationType");
  traceCg_Native.cgGetFloatAnnotationValues = (const float *(*)(CGannotation, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetFloatAnnotationValues");
  traceCg_Native.cgGetIntAnnotationValues = (const int *(*)(CGannotation, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetIntAnnotationValues");
  traceCg_Native.cgGetStringAnnotationValue = (const char *(*)(CGannotation)) traceCg_GetProcAddress(traceCg_handle, "cgGetStringAnnotationValue");
  traceCg_Native.cgGetStringAnnotationValues = (const char * const *(*)(CGannotation, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetStringAnnotationValues");
  traceCg_Native.cgGetBoolAnnotationValues = (const CGbool *(*)(CGannotation, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetBoolAnnotationValues");
  traceCg_Native.cgGetBooleanAnnotationValues = (const int *(*)(CGannotation, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetBooleanAnnotationValues");
  traceCg_Native.cgGetNumDependentAnnotationParameters = (int (*)(CGannotation)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumDependentAnnotationParameters");
  traceCg_Native.cgGetDependentAnnotationParameter = (CGparameter (*)(CGannotation, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetDependentAnnotationParameter");
  traceCg_Native.cgEvaluateProgram = (void (*)(CGprogram, float *, int, int, int, int)) traceCg_GetProcAddress(traceCg_handle, "cgEvaluateProgram");
  traceCg_Native.cgSetEffectName = (CGbool (*)(CGeffect, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetEffectName");
  traceCg_Native.cgGetEffectName = (const char *(*)(CGeffect)) traceCg_GetProcAddress(traceCg_handle, "cgGetEffectName");
  traceCg_Native.cgGetNamedEffect = (CGeffect (*)(CGcontext, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetNamedEffect");
  traceCg_Native.cgCreateEffectParameter = (CGparameter (*)(CGeffect, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateEffectParameter");
  traceCg_Native.cgCreateTechnique = (CGtechnique (*)(CGeffect, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgCreateTechnique");
  traceCg_Native.cgCreateEffectParameterArray = (CGparameter (*)(CGeffect, const char *, CGtype, int)) traceCg_GetProcAddress(traceCg_handle, "cgCreateEffectParameterArray");
  traceCg_Native.cgCreateEffectParameterMultiDimArray = (CGparameter (*)(CGeffect, const char *, CGtype, int, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgCreateEffectParameterMultiDimArray");
  traceCg_Native.cgCreatePass = (CGpass (*)(CGtechnique, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgCreatePass");
  traceCg_Native.cgCreateStateAssignment = (CGstateassignment (*)(CGpass, CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgCreateStateAssignment");
  traceCg_Native.cgCreateStateAssignmentIndex = (CGstateassignment (*)(CGpass, CGstate, int)) traceCg_GetProcAddress(traceCg_handle, "cgCreateStateAssignmentIndex");
  traceCg_Native.cgCreateSamplerStateAssignment = (CGstateassignment (*)(CGparameter, CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgCreateSamplerStateAssignment");
  traceCg_Native.cgSetFloatStateAssignment = (CGbool (*)(CGstateassignment, float)) traceCg_GetProcAddress(traceCg_handle, "cgSetFloatStateAssignment");
  traceCg_Native.cgSetIntStateAssignment = (CGbool (*)(CGstateassignment, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetIntStateAssignment");
  traceCg_Native.cgSetBoolStateAssignment = (CGbool (*)(CGstateassignment, CGbool)) traceCg_GetProcAddress(traceCg_handle, "cgSetBoolStateAssignment");
  traceCg_Native.cgSetStringStateAssignment = (CGbool (*)(CGstateassignment, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetStringStateAssignment");
  traceCg_Native.cgSetProgramStateAssignment = (CGbool (*)(CGstateassignment, CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgSetProgramStateAssignment");
  traceCg_Native.cgSetSamplerStateAssignment = (CGbool (*)(CGstateassignment, CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgSetSamplerStateAssignment");
  traceCg_Native.cgSetTextureStateAssignment = (CGbool (*)(CGstateassignment, CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgSetTextureStateAssignment");
  traceCg_Native.cgSetFloatArrayStateAssignment = (CGbool (*)(CGstateassignment, const float *)) traceCg_GetProcAddress(traceCg_handle, "cgSetFloatArrayStateAssignment");
  traceCg_Native.cgSetIntArrayStateAssignment = (CGbool (*)(CGstateassignment, const int *)) traceCg_GetProcAddress(traceCg_handle, "cgSetIntArrayStateAssignment");
  traceCg_Native.cgSetBoolArrayStateAssignment = (CGbool (*)(CGstateassignment, const CGbool *)) traceCg_GetProcAddress(traceCg_handle, "cgSetBoolArrayStateAssignment");
  traceCg_Native.cgCreateTechniqueAnnotation = (CGannotation (*)(CGtechnique, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateTechniqueAnnotation");
  traceCg_Native.cgCreatePassAnnotation = (CGannotation (*)(CGpass, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreatePassAnnotation");
  traceCg_Native.cgCreateParameterAnnotation = (CGannotation (*)(CGparameter, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateParameterAnnotation");
  traceCg_Native.cgCreateProgramAnnotation = (CGannotation (*)(CGprogram, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateProgramAnnotation");
  traceCg_Native.cgCreateEffectAnnotation = (CGannotation (*)(CGeffect, const char *, CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgCreateEffectAnnotation");
  traceCg_Native.cgSetIntAnnotation = (CGbool (*)(CGannotation, int)) traceCg_GetProcAddress(traceCg_handle, "cgSetIntAnnotation");
  traceCg_Native.cgSetFloatAnnotation = (CGbool (*)(CGannotation, float)) traceCg_GetProcAddress(traceCg_handle, "cgSetFloatAnnotation");
  traceCg_Native.cgSetBoolAnnotation = (CGbool (*)(CGannotation, CGbool)) traceCg_GetProcAddress(traceCg_handle, "cgSetBoolAnnotation");
  traceCg_Native.cgSetStringAnnotation = (CGbool (*)(CGannotation, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgSetStringAnnotation");
  traceCg_Native.cgGetNumStateEnumerants = (int (*)(CGstate)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumStateEnumerants");
  traceCg_Native.cgGetStateEnumerant = (const char *(*)(CGstate, int, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateEnumerant");
  traceCg_Native.cgGetStateEnumerantName = (const char *(*)(CGstate, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateEnumerantName");
  traceCg_Native.cgGetStateEnumerantValue = (int (*)(CGstate, const char *)) traceCg_GetProcAddress(traceCg_handle, "cgGetStateEnumerantValue");
  traceCg_Native.cgGetParameterEffect = (CGeffect (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterEffect");
  traceCg_Native.cgGetTypeClass = (CGparameterclass (*)(CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgGetTypeClass");
  traceCg_Native.cgGetTypeBase = (CGtype (*)(CGtype)) traceCg_GetProcAddress(traceCg_handle, "cgGetTypeBase");
  traceCg_Native.cgGetTypeSizes = (CGbool (*)(CGtype, int *, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetTypeSizes");
  traceCg_Native.cgGetMatrixSize = (void (*)(CGtype, int *, int *)) traceCg_GetProcAddress(traceCg_handle, "cgGetMatrixSize");
  traceCg_Native.cgGetNumProgramDomains = (int (*)(CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgGetNumProgramDomains");
  traceCg_Native.cgGetProfileDomain = (CGdomain (*)(CGprofile)) traceCg_GetProcAddress(traceCg_handle, "cgGetProfileDomain");
  traceCg_Native.cgGetProfileSibling = (CGprofile (*)(CGprofile, CGdomain)) traceCg_GetProcAddress(traceCg_handle, "cgGetProfileSibling");
  traceCg_Native.cgCombinePrograms = (CGprogram (*)(int, const CGprogram *)) traceCg_GetProcAddress(traceCg_handle, "cgCombinePrograms");
  traceCg_Native.cgCombinePrograms2 = (CGprogram (*)(const CGprogram, const CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgCombinePrograms2");
  traceCg_Native.cgCombinePrograms3 = (CGprogram (*)(const CGprogram, const CGprogram, const CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgCombinePrograms3");
  traceCg_Native.cgCombinePrograms4 = (CGprogram (*)(const CGprogram, const CGprogram, const CGprogram, const CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgCombinePrograms4");
  traceCg_Native.cgCombinePrograms5 = (CGprogram (*)(const CGprogram, const CGprogram, const CGprogram, const CGprogram, const CGprogram)) traceCg_GetProcAddress(traceCg_handle, "cgCombinePrograms5");
  traceCg_Native.cgGetProgramDomainProfile = (CGprofile (*)(CGprogram, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramDomainProfile");
  traceCg_Native.cgGetProgramDomainProgram = (CGprogram (*)(CGprogram, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramDomainProgram");
  traceCg_Native.cgCreateObj = (CGobj (*)(CGcontext, CGenum, const char *, CGprofile, const char **)) traceCg_GetProcAddress(traceCg_handle, "cgCreateObj");
  traceCg_Native.cgCreateObjFromFile = (CGobj (*)(CGcontext, CGenum, const char *, CGprofile, const char **)) traceCg_GetProcAddress(traceCg_handle, "cgCreateObjFromFile");
  traceCg_Native.cgDestroyObj = (void (*)(CGobj)) traceCg_GetProcAddress(traceCg_handle, "cgDestroyObj");
  traceCg_Native.cgGetParameterResourceSize = (long (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterResourceSize");
  traceCg_Native.cgGetParameterResourceType = (CGtype (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterResourceType");
  traceCg_Native.cgGetParameterResourceName = (const char *(*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterResourceName");
  traceCg_Native.cgGetParameterBufferIndex = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterBufferIndex");
  traceCg_Native.cgGetParameterBufferOffset = (int (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetParameterBufferOffset");
  traceCg_Native.cgCreateBuffer = (CGbuffer (*)(CGcontext, int, const void *, CGbufferusage)) traceCg_GetProcAddress(traceCg_handle, "cgCreateBuffer");
  traceCg_Native.cgIsBuffer = (CGbool (*)(CGbuffer)) traceCg_GetProcAddress(traceCg_handle, "cgIsBuffer");
  traceCg_Native.cgSetBufferData = (void (*)(CGbuffer, int, const void *)) traceCg_GetProcAddress(traceCg_handle, "cgSetBufferData");
  traceCg_Native.cgSetBufferSubData = (void (*)(CGbuffer, int, int, const void *)) traceCg_GetProcAddress(traceCg_handle, "cgSetBufferSubData");
  traceCg_Native.cgSetProgramBuffer = (void (*)(CGprogram, int, CGbuffer)) traceCg_GetProcAddress(traceCg_handle, "cgSetProgramBuffer");
  traceCg_Native.cgSetUniformBufferParameter = (void (*)(CGparameter, CGbuffer)) traceCg_GetProcAddress(traceCg_handle, "cgSetUniformBufferParameter");
  traceCg_Native.cgMapBuffer = (void *(*)(CGbuffer, CGbufferaccess)) traceCg_GetProcAddress(traceCg_handle, "cgMapBuffer");
  traceCg_Native.cgUnmapBuffer = (void (*)(CGbuffer)) traceCg_GetProcAddress(traceCg_handle, "cgUnmapBuffer");
  traceCg_Native.cgDestroyBuffer = (void (*)(CGbuffer)) traceCg_GetProcAddress(traceCg_handle, "cgDestroyBuffer");
  traceCg_Native.cgGetProgramBuffer = (CGbuffer (*)(CGprogram, int)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramBuffer");
  traceCg_Native.cgGetUniformBufferParameter = (CGbuffer (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetUniformBufferParameter");
  traceCg_Native.cgGetBufferSize = (int (*)(CGbuffer)) traceCg_GetProcAddress(traceCg_handle, "cgGetBufferSize");
  traceCg_Native.cgGetProgramBufferMaxSize = (int (*)(CGprofile)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramBufferMaxSize");
  traceCg_Native.cgGetProgramBufferMaxIndex = (int (*)(CGprofile)) traceCg_GetProcAddress(traceCg_handle, "cgGetProgramBufferMaxIndex");
  traceCg_Native.cgGetEffectParameterBuffer = (CGbuffer (*)(CGparameter)) traceCg_GetProcAddress(traceCg_handle, "cgGetEffectParameterBuffer");
  traceCg_Native.cgSetEffectParameterBuffer = (void (*)(CGparameter, CGbuffer)) traceCg_GetProcAddress(traceCg_handle, "cgSetEffectParameterBuffer");
#if !defined(__APPLE__)
  traceCg_Native.cgInternal = (void *(*)(void)) traceCg_GetProcAddress(traceCg_handle, "cgInternal");
#endif

  /* Query Cg version. */

  if
  (
    (traceCg_Native.cgGetString) &&
    (traceCg_Native.cgGetString != cgGetString) &&
    (versionString = traceCg_Native.cgGetString(CG_VERSION))
  )
  {
    traceInfo("Cg version: %s.", versionString);
    sscanf(versionString, "%d.%d.%d", &versionMajor, &versionMinor, &versionBuild);
    #define VERSION(a,b,c) ((a<<20)|(b<<10)|c)
    if (VERSION(versionMajor, versionMinor, versionBuild) <= VERSION(2,2,6))
      traceWarning("Trace tools do not support this version of Cg.");
  }
  else
    traceWarning("Cg version: Unknown.");

  /* Validate Cg API functions. */

  if (traceCg_Native.cgSetLockingPolicy)
  {
    if (traceCg_Native.cgSetLockingPolicy == cgSetLockingPolicy)
    {
      traceWarning("Ignoring cgSetLockingPolicy loaded from traceCg library.");
      traceCg_Native.cgSetLockingPolicy = NULL;
    }
  }
  else
  {
    traceWarning("cgSetLockingPolicy not loaded.");
  }
  if (traceCg_Native.cgGetLockingPolicy)
  {
    if (traceCg_Native.cgGetLockingPolicy == cgGetLockingPolicy)
    {
      traceWarning("Ignoring cgGetLockingPolicy loaded from traceCg library.");
      traceCg_Native.cgGetLockingPolicy = NULL;
    }
  }
  else
  {
    traceWarning("cgGetLockingPolicy not loaded.");
  }
  if (traceCg_Native.cgSetSemanticCasePolicy)
  {
    if (traceCg_Native.cgSetSemanticCasePolicy == cgSetSemanticCasePolicy)
    {
      traceWarning("Ignoring cgSetSemanticCasePolicy loaded from traceCg library.");
      traceCg_Native.cgSetSemanticCasePolicy = NULL;
    }
  }
  else
  {
    traceWarning("cgSetSemanticCasePolicy not loaded.");
  }
  if (traceCg_Native.cgGetSemanticCasePolicy)
  {
    if (traceCg_Native.cgGetSemanticCasePolicy == cgGetSemanticCasePolicy)
    {
      traceWarning("Ignoring cgGetSemanticCasePolicy loaded from traceCg library.");
      traceCg_Native.cgGetSemanticCasePolicy = NULL;
    }
  }
  else
  {
    traceWarning("cgGetSemanticCasePolicy not loaded.");
  }
  if (traceCg_Native.cgCreateContext)
  {
    if (traceCg_Native.cgCreateContext == cgCreateContext)
    {
      traceWarning("Ignoring cgCreateContext loaded from traceCg library.");
      traceCg_Native.cgCreateContext = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateContext not loaded.");
  }
  if (traceCg_Native.cgSetContextBehavior)
  {
    if (traceCg_Native.cgSetContextBehavior == cgSetContextBehavior)
    {
      traceWarning("Ignoring cgSetContextBehavior loaded from traceCg library.");
      traceCg_Native.cgSetContextBehavior = NULL;
    }
  }
  else
  {
    traceWarning("cgSetContextBehavior not loaded.");
  }
  if (traceCg_Native.cgGetContextBehavior)
  {
    if (traceCg_Native.cgGetContextBehavior == cgGetContextBehavior)
    {
      traceWarning("Ignoring cgGetContextBehavior loaded from traceCg library.");
      traceCg_Native.cgGetContextBehavior = NULL;
    }
  }
  else
  {
    traceWarning("cgGetContextBehavior not loaded.");
  }
  if (traceCg_Native.cgGetBehaviorString)
  {
    if (traceCg_Native.cgGetBehaviorString == cgGetBehaviorString)
    {
      traceWarning("Ignoring cgGetBehaviorString loaded from traceCg library.");
      traceCg_Native.cgGetBehaviorString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetBehaviorString not loaded.");
  }
  if (traceCg_Native.cgGetBehavior)
  {
    if (traceCg_Native.cgGetBehavior == cgGetBehavior)
    {
      traceWarning("Ignoring cgGetBehavior loaded from traceCg library.");
      traceCg_Native.cgGetBehavior = NULL;
    }
  }
  else
  {
    traceWarning("cgGetBehavior not loaded.");
  }
  if (traceCg_Native.cgDestroyContext)
  {
    if (traceCg_Native.cgDestroyContext == cgDestroyContext)
    {
      traceWarning("Ignoring cgDestroyContext loaded from traceCg library.");
      traceCg_Native.cgDestroyContext = NULL;
    }
  }
  else
  {
    traceWarning("cgDestroyContext not loaded.");
  }
  if (traceCg_Native.cgIsContext)
  {
    if (traceCg_Native.cgIsContext == cgIsContext)
    {
      traceWarning("Ignoring cgIsContext loaded from traceCg library.");
      traceCg_Native.cgIsContext = NULL;
    }
  }
  else
  {
    traceWarning("cgIsContext not loaded.");
  }
  if (traceCg_Native.cgGetLastListing)
  {
    if (traceCg_Native.cgGetLastListing == cgGetLastListing)
    {
      traceWarning("Ignoring cgGetLastListing loaded from traceCg library.");
      traceCg_Native.cgGetLastListing = NULL;
    }
  }
  else
  {
    traceWarning("cgGetLastListing not loaded.");
  }
  if (traceCg_Native.cgSetLastListing)
  {
    if (traceCg_Native.cgSetLastListing == cgSetLastListing)
    {
      traceWarning("Ignoring cgSetLastListing loaded from traceCg library.");
      traceCg_Native.cgSetLastListing = NULL;
    }
  }
  else
  {
    traceWarning("cgSetLastListing not loaded.");
  }
  if (traceCg_Native.cgSetAutoCompile)
  {
    if (traceCg_Native.cgSetAutoCompile == cgSetAutoCompile)
    {
      traceWarning("Ignoring cgSetAutoCompile loaded from traceCg library.");
      traceCg_Native.cgSetAutoCompile = NULL;
    }
  }
  else
  {
    traceWarning("cgSetAutoCompile not loaded.");
  }
  if (traceCg_Native.cgGetAutoCompile)
  {
    if (traceCg_Native.cgGetAutoCompile == cgGetAutoCompile)
    {
      traceWarning("Ignoring cgGetAutoCompile loaded from traceCg library.");
      traceCg_Native.cgGetAutoCompile = NULL;
    }
  }
  else
  {
    traceWarning("cgGetAutoCompile not loaded.");
  }
  if (traceCg_Native.cgSetParameterSettingMode)
  {
    if (traceCg_Native.cgSetParameterSettingMode == cgSetParameterSettingMode)
    {
      traceWarning("Ignoring cgSetParameterSettingMode loaded from traceCg library.");
      traceCg_Native.cgSetParameterSettingMode = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterSettingMode not loaded.");
  }
  if (traceCg_Native.cgGetParameterSettingMode)
  {
    if (traceCg_Native.cgGetParameterSettingMode == cgGetParameterSettingMode)
    {
      traceWarning("Ignoring cgGetParameterSettingMode loaded from traceCg library.");
      traceCg_Native.cgGetParameterSettingMode = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterSettingMode not loaded.");
  }
  if (traceCg_Native.cgSetCompilerIncludeString)
  {
    if (traceCg_Native.cgSetCompilerIncludeString == cgSetCompilerIncludeString)
    {
      traceWarning("Ignoring cgSetCompilerIncludeString loaded from traceCg library.");
      traceCg_Native.cgSetCompilerIncludeString = NULL;
    }
  }
  else
  {
    traceWarning("cgSetCompilerIncludeString not loaded.");
  }
  if (traceCg_Native.cgSetCompilerIncludeFile)
  {
    if (traceCg_Native.cgSetCompilerIncludeFile == cgSetCompilerIncludeFile)
    {
      traceWarning("Ignoring cgSetCompilerIncludeFile loaded from traceCg library.");
      traceCg_Native.cgSetCompilerIncludeFile = NULL;
    }
  }
  else
  {
    traceWarning("cgSetCompilerIncludeFile not loaded.");
  }
  if (traceCg_Native.cgSetCompilerIncludeCallback)
  {
    if (traceCg_Native.cgSetCompilerIncludeCallback == cgSetCompilerIncludeCallback)
    {
      traceWarning("Ignoring cgSetCompilerIncludeCallback loaded from traceCg library.");
      traceCg_Native.cgSetCompilerIncludeCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgSetCompilerIncludeCallback not loaded.");
  }
  if (traceCg_Native.cgGetCompilerIncludeCallback)
  {
    if (traceCg_Native.cgGetCompilerIncludeCallback == cgGetCompilerIncludeCallback)
    {
      traceWarning("Ignoring cgGetCompilerIncludeCallback loaded from traceCg library.");
      traceCg_Native.cgGetCompilerIncludeCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgGetCompilerIncludeCallback not loaded.");
  }
  if (traceCg_Native.cgCreateProgram)
  {
    if (traceCg_Native.cgCreateProgram == cgCreateProgram)
    {
      traceWarning("Ignoring cgCreateProgram loaded from traceCg library.");
      traceCg_Native.cgCreateProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateProgram not loaded.");
  }
  if (traceCg_Native.cgCreateProgramFromFile)
  {
    if (traceCg_Native.cgCreateProgramFromFile == cgCreateProgramFromFile)
    {
      traceWarning("Ignoring cgCreateProgramFromFile loaded from traceCg library.");
      traceCg_Native.cgCreateProgramFromFile = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateProgramFromFile not loaded.");
  }
  if (traceCg_Native.cgCopyProgram)
  {
    if (traceCg_Native.cgCopyProgram == cgCopyProgram)
    {
      traceWarning("Ignoring cgCopyProgram loaded from traceCg library.");
      traceCg_Native.cgCopyProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgCopyProgram not loaded.");
  }
  if (traceCg_Native.cgDestroyProgram)
  {
    if (traceCg_Native.cgDestroyProgram == cgDestroyProgram)
    {
      traceWarning("Ignoring cgDestroyProgram loaded from traceCg library.");
      traceCg_Native.cgDestroyProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgDestroyProgram not loaded.");
  }
  if (traceCg_Native.cgGetFirstProgram)
  {
    if (traceCg_Native.cgGetFirstProgram == cgGetFirstProgram)
    {
      traceWarning("Ignoring cgGetFirstProgram loaded from traceCg library.");
      traceCg_Native.cgGetFirstProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstProgram not loaded.");
  }
  if (traceCg_Native.cgGetNextProgram)
  {
    if (traceCg_Native.cgGetNextProgram == cgGetNextProgram)
    {
      traceWarning("Ignoring cgGetNextProgram loaded from traceCg library.");
      traceCg_Native.cgGetNextProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextProgram not loaded.");
  }
  if (traceCg_Native.cgGetProgramContext)
  {
    if (traceCg_Native.cgGetProgramContext == cgGetProgramContext)
    {
      traceWarning("Ignoring cgGetProgramContext loaded from traceCg library.");
      traceCg_Native.cgGetProgramContext = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramContext not loaded.");
  }
  if (traceCg_Native.cgIsProgram)
  {
    if (traceCg_Native.cgIsProgram == cgIsProgram)
    {
      traceWarning("Ignoring cgIsProgram loaded from traceCg library.");
      traceCg_Native.cgIsProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgIsProgram not loaded.");
  }
  if (traceCg_Native.cgCompileProgram)
  {
    if (traceCg_Native.cgCompileProgram == cgCompileProgram)
    {
      traceWarning("Ignoring cgCompileProgram loaded from traceCg library.");
      traceCg_Native.cgCompileProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgCompileProgram not loaded.");
  }
  if (traceCg_Native.cgIsProgramCompiled)
  {
    if (traceCg_Native.cgIsProgramCompiled == cgIsProgramCompiled)
    {
      traceWarning("Ignoring cgIsProgramCompiled loaded from traceCg library.");
      traceCg_Native.cgIsProgramCompiled = NULL;
    }
  }
  else
  {
    traceWarning("cgIsProgramCompiled not loaded.");
  }
  if (traceCg_Native.cgGetProgramString)
  {
    if (traceCg_Native.cgGetProgramString == cgGetProgramString)
    {
      traceWarning("Ignoring cgGetProgramString loaded from traceCg library.");
      traceCg_Native.cgGetProgramString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramString not loaded.");
  }
  if (traceCg_Native.cgGetProgramProfile)
  {
    if (traceCg_Native.cgGetProgramProfile == cgGetProgramProfile)
    {
      traceWarning("Ignoring cgGetProgramProfile loaded from traceCg library.");
      traceCg_Native.cgGetProgramProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramProfile not loaded.");
  }
  if (traceCg_Native.cgGetProgramOptions)
  {
    if (traceCg_Native.cgGetProgramOptions == cgGetProgramOptions)
    {
      traceWarning("Ignoring cgGetProgramOptions loaded from traceCg library.");
      traceCg_Native.cgGetProgramOptions = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramOptions not loaded.");
  }
  if (traceCg_Native.cgSetProgramProfile)
  {
    if (traceCg_Native.cgSetProgramProfile == cgSetProgramProfile)
    {
      traceWarning("Ignoring cgSetProgramProfile loaded from traceCg library.");
      traceCg_Native.cgSetProgramProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgSetProgramProfile not loaded.");
  }
  if (traceCg_Native.cgGetProgramInput)
  {
    if (traceCg_Native.cgGetProgramInput == cgGetProgramInput)
    {
      traceWarning("Ignoring cgGetProgramInput loaded from traceCg library.");
      traceCg_Native.cgGetProgramInput = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramInput not loaded.");
  }
  if (traceCg_Native.cgGetProgramOutput)
  {
    if (traceCg_Native.cgGetProgramOutput == cgGetProgramOutput)
    {
      traceWarning("Ignoring cgGetProgramOutput loaded from traceCg library.");
      traceCg_Native.cgGetProgramOutput = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramOutput not loaded.");
  }
  if (traceCg_Native.cgGetProgramOutputVertices)
  {
    if (traceCg_Native.cgGetProgramOutputVertices == cgGetProgramOutputVertices)
    {
      traceWarning("Ignoring cgGetProgramOutputVertices loaded from traceCg library.");
      traceCg_Native.cgGetProgramOutputVertices = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramOutputVertices not loaded.");
  }
  if (traceCg_Native.cgSetProgramOutputVertices)
  {
    if (traceCg_Native.cgSetProgramOutputVertices == cgSetProgramOutputVertices)
    {
      traceWarning("Ignoring cgSetProgramOutputVertices loaded from traceCg library.");
      traceCg_Native.cgSetProgramOutputVertices = NULL;
    }
  }
  else
  {
    traceWarning("cgSetProgramOutputVertices not loaded.");
  }
  if (traceCg_Native.cgSetPassProgramParameters)
  {
    if (traceCg_Native.cgSetPassProgramParameters == cgSetPassProgramParameters)
    {
      traceWarning("Ignoring cgSetPassProgramParameters loaded from traceCg library.");
      traceCg_Native.cgSetPassProgramParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgSetPassProgramParameters not loaded.");
  }
  if (traceCg_Native.cgUpdateProgramParameters)
  {
    if (traceCg_Native.cgUpdateProgramParameters == cgUpdateProgramParameters)
    {
      traceWarning("Ignoring cgUpdateProgramParameters loaded from traceCg library.");
      traceCg_Native.cgUpdateProgramParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgUpdateProgramParameters not loaded.");
  }
  if (traceCg_Native.cgUpdatePassParameters)
  {
    if (traceCg_Native.cgUpdatePassParameters == cgUpdatePassParameters)
    {
      traceWarning("Ignoring cgUpdatePassParameters loaded from traceCg library.");
      traceCg_Native.cgUpdatePassParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgUpdatePassParameters not loaded.");
  }
  if (traceCg_Native.cgCreateParameter)
  {
    if (traceCg_Native.cgCreateParameter == cgCreateParameter)
    {
      traceWarning("Ignoring cgCreateParameter loaded from traceCg library.");
      traceCg_Native.cgCreateParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateParameter not loaded.");
  }
  if (traceCg_Native.cgCreateParameterArray)
  {
    if (traceCg_Native.cgCreateParameterArray == cgCreateParameterArray)
    {
      traceWarning("Ignoring cgCreateParameterArray loaded from traceCg library.");
      traceCg_Native.cgCreateParameterArray = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateParameterArray not loaded.");
  }
  if (traceCg_Native.cgCreateParameterMultiDimArray)
  {
    if (traceCg_Native.cgCreateParameterMultiDimArray == cgCreateParameterMultiDimArray)
    {
      traceWarning("Ignoring cgCreateParameterMultiDimArray loaded from traceCg library.");
      traceCg_Native.cgCreateParameterMultiDimArray = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateParameterMultiDimArray not loaded.");
  }
  if (traceCg_Native.cgDestroyParameter)
  {
    if (traceCg_Native.cgDestroyParameter == cgDestroyParameter)
    {
      traceWarning("Ignoring cgDestroyParameter loaded from traceCg library.");
      traceCg_Native.cgDestroyParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgDestroyParameter not loaded.");
  }
  if (traceCg_Native.cgConnectParameter)
  {
    if (traceCg_Native.cgConnectParameter == cgConnectParameter)
    {
      traceWarning("Ignoring cgConnectParameter loaded from traceCg library.");
      traceCg_Native.cgConnectParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgConnectParameter not loaded.");
  }
  if (traceCg_Native.cgDisconnectParameter)
  {
    if (traceCg_Native.cgDisconnectParameter == cgDisconnectParameter)
    {
      traceWarning("Ignoring cgDisconnectParameter loaded from traceCg library.");
      traceCg_Native.cgDisconnectParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgDisconnectParameter not loaded.");
  }
  if (traceCg_Native.cgGetConnectedParameter)
  {
    if (traceCg_Native.cgGetConnectedParameter == cgGetConnectedParameter)
    {
      traceWarning("Ignoring cgGetConnectedParameter loaded from traceCg library.");
      traceCg_Native.cgGetConnectedParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetConnectedParameter not loaded.");
  }
  if (traceCg_Native.cgGetNumConnectedToParameters)
  {
    if (traceCg_Native.cgGetNumConnectedToParameters == cgGetNumConnectedToParameters)
    {
      traceWarning("Ignoring cgGetNumConnectedToParameters loaded from traceCg library.");
      traceCg_Native.cgGetNumConnectedToParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumConnectedToParameters not loaded.");
  }
  if (traceCg_Native.cgGetConnectedToParameter)
  {
    if (traceCg_Native.cgGetConnectedToParameter == cgGetConnectedToParameter)
    {
      traceWarning("Ignoring cgGetConnectedToParameter loaded from traceCg library.");
      traceCg_Native.cgGetConnectedToParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetConnectedToParameter not loaded.");
  }
  if (traceCg_Native.cgGetNamedParameter)
  {
    if (traceCg_Native.cgGetNamedParameter == cgGetNamedParameter)
    {
      traceWarning("Ignoring cgGetNamedParameter loaded from traceCg library.");
      traceCg_Native.cgGetNamedParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedParameter not loaded.");
  }
  if (traceCg_Native.cgGetNamedProgramParameter)
  {
    if (traceCg_Native.cgGetNamedProgramParameter == cgGetNamedProgramParameter)
    {
      traceWarning("Ignoring cgGetNamedProgramParameter loaded from traceCg library.");
      traceCg_Native.cgGetNamedProgramParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedProgramParameter not loaded.");
  }
  if (traceCg_Native.cgGetNamedProgramUniformBuffer)
  {
    if (traceCg_Native.cgGetNamedProgramUniformBuffer == cgGetNamedProgramUniformBuffer)
    {
      traceWarning("Ignoring cgGetNamedProgramUniformBuffer loaded from traceCg library.");
      traceCg_Native.cgGetNamedProgramUniformBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedProgramUniformBuffer not loaded.");
  }
  if (traceCg_Native.cgGetNamedEffectUniformBuffer)
  {
    if (traceCg_Native.cgGetNamedEffectUniformBuffer == cgGetNamedEffectUniformBuffer)
    {
      traceWarning("Ignoring cgGetNamedEffectUniformBuffer loaded from traceCg library.");
      traceCg_Native.cgGetNamedEffectUniformBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedEffectUniformBuffer not loaded.");
  }
  if (traceCg_Native.cgGetUniformBufferBlockName)
  {
    if (traceCg_Native.cgGetUniformBufferBlockName == cgGetUniformBufferBlockName)
    {
      traceWarning("Ignoring cgGetUniformBufferBlockName loaded from traceCg library.");
      traceCg_Native.cgGetUniformBufferBlockName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetUniformBufferBlockName not loaded.");
  }
  if (traceCg_Native.cgGetFirstParameter)
  {
    if (traceCg_Native.cgGetFirstParameter == cgGetFirstParameter)
    {
      traceWarning("Ignoring cgGetFirstParameter loaded from traceCg library.");
      traceCg_Native.cgGetFirstParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstParameter not loaded.");
  }
  if (traceCg_Native.cgGetNextParameter)
  {
    if (traceCg_Native.cgGetNextParameter == cgGetNextParameter)
    {
      traceWarning("Ignoring cgGetNextParameter loaded from traceCg library.");
      traceCg_Native.cgGetNextParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextParameter not loaded.");
  }
  if (traceCg_Native.cgGetFirstLeafParameter)
  {
    if (traceCg_Native.cgGetFirstLeafParameter == cgGetFirstLeafParameter)
    {
      traceWarning("Ignoring cgGetFirstLeafParameter loaded from traceCg library.");
      traceCg_Native.cgGetFirstLeafParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstLeafParameter not loaded.");
  }
  if (traceCg_Native.cgGetNextLeafParameter)
  {
    if (traceCg_Native.cgGetNextLeafParameter == cgGetNextLeafParameter)
    {
      traceWarning("Ignoring cgGetNextLeafParameter loaded from traceCg library.");
      traceCg_Native.cgGetNextLeafParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextLeafParameter not loaded.");
  }
  if (traceCg_Native.cgGetFirstStructParameter)
  {
    if (traceCg_Native.cgGetFirstStructParameter == cgGetFirstStructParameter)
    {
      traceWarning("Ignoring cgGetFirstStructParameter loaded from traceCg library.");
      traceCg_Native.cgGetFirstStructParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstStructParameter not loaded.");
  }
  if (traceCg_Native.cgGetFirstUniformBufferParameter)
  {
    if (traceCg_Native.cgGetFirstUniformBufferParameter == cgGetFirstUniformBufferParameter)
    {
      traceWarning("Ignoring cgGetFirstUniformBufferParameter loaded from traceCg library.");
      traceCg_Native.cgGetFirstUniformBufferParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstUniformBufferParameter not loaded.");
  }
  if (traceCg_Native.cgGetNamedStructParameter)
  {
    if (traceCg_Native.cgGetNamedStructParameter == cgGetNamedStructParameter)
    {
      traceWarning("Ignoring cgGetNamedStructParameter loaded from traceCg library.");
      traceCg_Native.cgGetNamedStructParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedStructParameter not loaded.");
  }
  if (traceCg_Native.cgGetNamedUniformBufferParameter)
  {
    if (traceCg_Native.cgGetNamedUniformBufferParameter == cgGetNamedUniformBufferParameter)
    {
      traceWarning("Ignoring cgGetNamedUniformBufferParameter loaded from traceCg library.");
      traceCg_Native.cgGetNamedUniformBufferParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedUniformBufferParameter not loaded.");
  }
  if (traceCg_Native.cgGetFirstDependentParameter)
  {
    if (traceCg_Native.cgGetFirstDependentParameter == cgGetFirstDependentParameter)
    {
      traceWarning("Ignoring cgGetFirstDependentParameter loaded from traceCg library.");
      traceCg_Native.cgGetFirstDependentParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstDependentParameter not loaded.");
  }
  if (traceCg_Native.cgGetArrayParameter)
  {
    if (traceCg_Native.cgGetArrayParameter == cgGetArrayParameter)
    {
      traceWarning("Ignoring cgGetArrayParameter loaded from traceCg library.");
      traceCg_Native.cgGetArrayParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetArrayParameter not loaded.");
  }
  if (traceCg_Native.cgGetArrayDimension)
  {
    if (traceCg_Native.cgGetArrayDimension == cgGetArrayDimension)
    {
      traceWarning("Ignoring cgGetArrayDimension loaded from traceCg library.");
      traceCg_Native.cgGetArrayDimension = NULL;
    }
  }
  else
  {
    traceWarning("cgGetArrayDimension not loaded.");
  }
  if (traceCg_Native.cgGetArrayType)
  {
    if (traceCg_Native.cgGetArrayType == cgGetArrayType)
    {
      traceWarning("Ignoring cgGetArrayType loaded from traceCg library.");
      traceCg_Native.cgGetArrayType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetArrayType not loaded.");
  }
  if (traceCg_Native.cgGetArraySize)
  {
    if (traceCg_Native.cgGetArraySize == cgGetArraySize)
    {
      traceWarning("Ignoring cgGetArraySize loaded from traceCg library.");
      traceCg_Native.cgGetArraySize = NULL;
    }
  }
  else
  {
    traceWarning("cgGetArraySize not loaded.");
  }
  if (traceCg_Native.cgGetArrayTotalSize)
  {
    if (traceCg_Native.cgGetArrayTotalSize == cgGetArrayTotalSize)
    {
      traceWarning("Ignoring cgGetArrayTotalSize loaded from traceCg library.");
      traceCg_Native.cgGetArrayTotalSize = NULL;
    }
  }
  else
  {
    traceWarning("cgGetArrayTotalSize not loaded.");
  }
  if (traceCg_Native.cgSetArraySize)
  {
    if (traceCg_Native.cgSetArraySize == cgSetArraySize)
    {
      traceWarning("Ignoring cgSetArraySize loaded from traceCg library.");
      traceCg_Native.cgSetArraySize = NULL;
    }
  }
  else
  {
    traceWarning("cgSetArraySize not loaded.");
  }
  if (traceCg_Native.cgSetMultiDimArraySize)
  {
    if (traceCg_Native.cgSetMultiDimArraySize == cgSetMultiDimArraySize)
    {
      traceWarning("Ignoring cgSetMultiDimArraySize loaded from traceCg library.");
      traceCg_Native.cgSetMultiDimArraySize = NULL;
    }
  }
  else
  {
    traceWarning("cgSetMultiDimArraySize not loaded.");
  }
  if (traceCg_Native.cgGetParameterProgram)
  {
    if (traceCg_Native.cgGetParameterProgram == cgGetParameterProgram)
    {
      traceWarning("Ignoring cgGetParameterProgram loaded from traceCg library.");
      traceCg_Native.cgGetParameterProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterProgram not loaded.");
  }
  if (traceCg_Native.cgGetParameterContext)
  {
    if (traceCg_Native.cgGetParameterContext == cgGetParameterContext)
    {
      traceWarning("Ignoring cgGetParameterContext loaded from traceCg library.");
      traceCg_Native.cgGetParameterContext = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterContext not loaded.");
  }
  if (traceCg_Native.cgIsParameter)
  {
    if (traceCg_Native.cgIsParameter == cgIsParameter)
    {
      traceWarning("Ignoring cgIsParameter loaded from traceCg library.");
      traceCg_Native.cgIsParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgIsParameter not loaded.");
  }
  if (traceCg_Native.cgGetParameterName)
  {
    if (traceCg_Native.cgGetParameterName == cgGetParameterName)
    {
      traceWarning("Ignoring cgGetParameterName loaded from traceCg library.");
      traceCg_Native.cgGetParameterName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterName not loaded.");
  }
  if (traceCg_Native.cgGetParameterType)
  {
    if (traceCg_Native.cgGetParameterType == cgGetParameterType)
    {
      traceWarning("Ignoring cgGetParameterType loaded from traceCg library.");
      traceCg_Native.cgGetParameterType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterType not loaded.");
  }
  if (traceCg_Native.cgGetParameterBaseType)
  {
    if (traceCg_Native.cgGetParameterBaseType == cgGetParameterBaseType)
    {
      traceWarning("Ignoring cgGetParameterBaseType loaded from traceCg library.");
      traceCg_Native.cgGetParameterBaseType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterBaseType not loaded.");
  }
  if (traceCg_Native.cgGetParameterClass)
  {
    if (traceCg_Native.cgGetParameterClass == cgGetParameterClass)
    {
      traceWarning("Ignoring cgGetParameterClass loaded from traceCg library.");
      traceCg_Native.cgGetParameterClass = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterClass not loaded.");
  }
  if (traceCg_Native.cgGetParameterRows)
  {
    if (traceCg_Native.cgGetParameterRows == cgGetParameterRows)
    {
      traceWarning("Ignoring cgGetParameterRows loaded from traceCg library.");
      traceCg_Native.cgGetParameterRows = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterRows not loaded.");
  }
  if (traceCg_Native.cgGetParameterColumns)
  {
    if (traceCg_Native.cgGetParameterColumns == cgGetParameterColumns)
    {
      traceWarning("Ignoring cgGetParameterColumns loaded from traceCg library.");
      traceCg_Native.cgGetParameterColumns = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterColumns not loaded.");
  }
  if (traceCg_Native.cgGetParameterNamedType)
  {
    if (traceCg_Native.cgGetParameterNamedType == cgGetParameterNamedType)
    {
      traceWarning("Ignoring cgGetParameterNamedType loaded from traceCg library.");
      traceCg_Native.cgGetParameterNamedType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterNamedType not loaded.");
  }
  if (traceCg_Native.cgGetParameterSemantic)
  {
    if (traceCg_Native.cgGetParameterSemantic == cgGetParameterSemantic)
    {
      traceWarning("Ignoring cgGetParameterSemantic loaded from traceCg library.");
      traceCg_Native.cgGetParameterSemantic = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterSemantic not loaded.");
  }
  if (traceCg_Native.cgGetParameterResource)
  {
    if (traceCg_Native.cgGetParameterResource == cgGetParameterResource)
    {
      traceWarning("Ignoring cgGetParameterResource loaded from traceCg library.");
      traceCg_Native.cgGetParameterResource = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterResource not loaded.");
  }
  if (traceCg_Native.cgGetParameterBaseResource)
  {
    if (traceCg_Native.cgGetParameterBaseResource == cgGetParameterBaseResource)
    {
      traceWarning("Ignoring cgGetParameterBaseResource loaded from traceCg library.");
      traceCg_Native.cgGetParameterBaseResource = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterBaseResource not loaded.");
  }
  if (traceCg_Native.cgGetParameterResourceIndex)
  {
    if (traceCg_Native.cgGetParameterResourceIndex == cgGetParameterResourceIndex)
    {
      traceWarning("Ignoring cgGetParameterResourceIndex loaded from traceCg library.");
      traceCg_Native.cgGetParameterResourceIndex = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterResourceIndex not loaded.");
  }
  if (traceCg_Native.cgGetParameterVariability)
  {
    if (traceCg_Native.cgGetParameterVariability == cgGetParameterVariability)
    {
      traceWarning("Ignoring cgGetParameterVariability loaded from traceCg library.");
      traceCg_Native.cgGetParameterVariability = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterVariability not loaded.");
  }
  if (traceCg_Native.cgGetParameterDirection)
  {
    if (traceCg_Native.cgGetParameterDirection == cgGetParameterDirection)
    {
      traceWarning("Ignoring cgGetParameterDirection loaded from traceCg library.");
      traceCg_Native.cgGetParameterDirection = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterDirection not loaded.");
  }
  if (traceCg_Native.cgIsParameterReferenced)
  {
    if (traceCg_Native.cgIsParameterReferenced == cgIsParameterReferenced)
    {
      traceWarning("Ignoring cgIsParameterReferenced loaded from traceCg library.");
      traceCg_Native.cgIsParameterReferenced = NULL;
    }
  }
  else
  {
    traceWarning("cgIsParameterReferenced not loaded.");
  }
  if (traceCg_Native.cgIsParameterUsed)
  {
    if (traceCg_Native.cgIsParameterUsed == cgIsParameterUsed)
    {
      traceWarning("Ignoring cgIsParameterUsed loaded from traceCg library.");
      traceCg_Native.cgIsParameterUsed = NULL;
    }
  }
  else
  {
    traceWarning("cgIsParameterUsed not loaded.");
  }
  if (traceCg_Native.cgGetParameterValues)
  {
    if (traceCg_Native.cgGetParameterValues == cgGetParameterValues)
    {
      traceWarning("Ignoring cgGetParameterValues loaded from traceCg library.");
      traceCg_Native.cgGetParameterValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterValues not loaded.");
  }
  if (traceCg_Native.cgSetParameterValuedr)
  {
    if (traceCg_Native.cgSetParameterValuedr == cgSetParameterValuedr)
    {
      traceWarning("Ignoring cgSetParameterValuedr loaded from traceCg library.");
      traceCg_Native.cgSetParameterValuedr = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterValuedr not loaded.");
  }
  if (traceCg_Native.cgSetParameterValuedc)
  {
    if (traceCg_Native.cgSetParameterValuedc == cgSetParameterValuedc)
    {
      traceWarning("Ignoring cgSetParameterValuedc loaded from traceCg library.");
      traceCg_Native.cgSetParameterValuedc = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterValuedc not loaded.");
  }
  if (traceCg_Native.cgSetParameterValuefr)
  {
    if (traceCg_Native.cgSetParameterValuefr == cgSetParameterValuefr)
    {
      traceWarning("Ignoring cgSetParameterValuefr loaded from traceCg library.");
      traceCg_Native.cgSetParameterValuefr = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterValuefr not loaded.");
  }
  if (traceCg_Native.cgSetParameterValuefc)
  {
    if (traceCg_Native.cgSetParameterValuefc == cgSetParameterValuefc)
    {
      traceWarning("Ignoring cgSetParameterValuefc loaded from traceCg library.");
      traceCg_Native.cgSetParameterValuefc = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterValuefc not loaded.");
  }
  if (traceCg_Native.cgSetParameterValueir)
  {
    if (traceCg_Native.cgSetParameterValueir == cgSetParameterValueir)
    {
      traceWarning("Ignoring cgSetParameterValueir loaded from traceCg library.");
      traceCg_Native.cgSetParameterValueir = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterValueir not loaded.");
  }
  if (traceCg_Native.cgSetParameterValueic)
  {
    if (traceCg_Native.cgSetParameterValueic == cgSetParameterValueic)
    {
      traceWarning("Ignoring cgSetParameterValueic loaded from traceCg library.");
      traceCg_Native.cgSetParameterValueic = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterValueic not loaded.");
  }
  if (traceCg_Native.cgGetParameterValuedr)
  {
    if (traceCg_Native.cgGetParameterValuedr == cgGetParameterValuedr)
    {
      traceWarning("Ignoring cgGetParameterValuedr loaded from traceCg library.");
      traceCg_Native.cgGetParameterValuedr = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterValuedr not loaded.");
  }
  if (traceCg_Native.cgGetParameterValuedc)
  {
    if (traceCg_Native.cgGetParameterValuedc == cgGetParameterValuedc)
    {
      traceWarning("Ignoring cgGetParameterValuedc loaded from traceCg library.");
      traceCg_Native.cgGetParameterValuedc = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterValuedc not loaded.");
  }
  if (traceCg_Native.cgGetParameterValuefr)
  {
    if (traceCg_Native.cgGetParameterValuefr == cgGetParameterValuefr)
    {
      traceWarning("Ignoring cgGetParameterValuefr loaded from traceCg library.");
      traceCg_Native.cgGetParameterValuefr = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterValuefr not loaded.");
  }
  if (traceCg_Native.cgGetParameterValuefc)
  {
    if (traceCg_Native.cgGetParameterValuefc == cgGetParameterValuefc)
    {
      traceWarning("Ignoring cgGetParameterValuefc loaded from traceCg library.");
      traceCg_Native.cgGetParameterValuefc = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterValuefc not loaded.");
  }
  if (traceCg_Native.cgGetParameterValueir)
  {
    if (traceCg_Native.cgGetParameterValueir == cgGetParameterValueir)
    {
      traceWarning("Ignoring cgGetParameterValueir loaded from traceCg library.");
      traceCg_Native.cgGetParameterValueir = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterValueir not loaded.");
  }
  if (traceCg_Native.cgGetParameterValueic)
  {
    if (traceCg_Native.cgGetParameterValueic == cgGetParameterValueic)
    {
      traceWarning("Ignoring cgGetParameterValueic loaded from traceCg library.");
      traceCg_Native.cgGetParameterValueic = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterValueic not loaded.");
  }
  if (traceCg_Native.cgGetParameterDefaultValuedr)
  {
    if (traceCg_Native.cgGetParameterDefaultValuedr == cgGetParameterDefaultValuedr)
    {
      traceWarning("Ignoring cgGetParameterDefaultValuedr loaded from traceCg library.");
      traceCg_Native.cgGetParameterDefaultValuedr = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterDefaultValuedr not loaded.");
  }
  if (traceCg_Native.cgGetParameterDefaultValuedc)
  {
    if (traceCg_Native.cgGetParameterDefaultValuedc == cgGetParameterDefaultValuedc)
    {
      traceWarning("Ignoring cgGetParameterDefaultValuedc loaded from traceCg library.");
      traceCg_Native.cgGetParameterDefaultValuedc = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterDefaultValuedc not loaded.");
  }
  if (traceCg_Native.cgGetParameterDefaultValuefr)
  {
    if (traceCg_Native.cgGetParameterDefaultValuefr == cgGetParameterDefaultValuefr)
    {
      traceWarning("Ignoring cgGetParameterDefaultValuefr loaded from traceCg library.");
      traceCg_Native.cgGetParameterDefaultValuefr = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterDefaultValuefr not loaded.");
  }
  if (traceCg_Native.cgGetParameterDefaultValuefc)
  {
    if (traceCg_Native.cgGetParameterDefaultValuefc == cgGetParameterDefaultValuefc)
    {
      traceWarning("Ignoring cgGetParameterDefaultValuefc loaded from traceCg library.");
      traceCg_Native.cgGetParameterDefaultValuefc = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterDefaultValuefc not loaded.");
  }
  if (traceCg_Native.cgGetParameterDefaultValueir)
  {
    if (traceCg_Native.cgGetParameterDefaultValueir == cgGetParameterDefaultValueir)
    {
      traceWarning("Ignoring cgGetParameterDefaultValueir loaded from traceCg library.");
      traceCg_Native.cgGetParameterDefaultValueir = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterDefaultValueir not loaded.");
  }
  if (traceCg_Native.cgGetParameterDefaultValueic)
  {
    if (traceCg_Native.cgGetParameterDefaultValueic == cgGetParameterDefaultValueic)
    {
      traceWarning("Ignoring cgGetParameterDefaultValueic loaded from traceCg library.");
      traceCg_Native.cgGetParameterDefaultValueic = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterDefaultValueic not loaded.");
  }
  if (traceCg_Native.cgGetStringParameterValue)
  {
    if (traceCg_Native.cgGetStringParameterValue == cgGetStringParameterValue)
    {
      traceWarning("Ignoring cgGetStringParameterValue loaded from traceCg library.");
      traceCg_Native.cgGetStringParameterValue = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStringParameterValue not loaded.");
  }
  if (traceCg_Native.cgSetStringParameterValue)
  {
    if (traceCg_Native.cgSetStringParameterValue == cgSetStringParameterValue)
    {
      traceWarning("Ignoring cgSetStringParameterValue loaded from traceCg library.");
      traceCg_Native.cgSetStringParameterValue = NULL;
    }
  }
  else
  {
    traceWarning("cgSetStringParameterValue not loaded.");
  }
  if (traceCg_Native.cgGetParameterOrdinalNumber)
  {
    if (traceCg_Native.cgGetParameterOrdinalNumber == cgGetParameterOrdinalNumber)
    {
      traceWarning("Ignoring cgGetParameterOrdinalNumber loaded from traceCg library.");
      traceCg_Native.cgGetParameterOrdinalNumber = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterOrdinalNumber not loaded.");
  }
  if (traceCg_Native.cgIsParameterGlobal)
  {
    if (traceCg_Native.cgIsParameterGlobal == cgIsParameterGlobal)
    {
      traceWarning("Ignoring cgIsParameterGlobal loaded from traceCg library.");
      traceCg_Native.cgIsParameterGlobal = NULL;
    }
  }
  else
  {
    traceWarning("cgIsParameterGlobal not loaded.");
  }
  if (traceCg_Native.cgGetParameterIndex)
  {
    if (traceCg_Native.cgGetParameterIndex == cgGetParameterIndex)
    {
      traceWarning("Ignoring cgGetParameterIndex loaded from traceCg library.");
      traceCg_Native.cgGetParameterIndex = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterIndex not loaded.");
  }
  if (traceCg_Native.cgSetParameterVariability)
  {
    if (traceCg_Native.cgSetParameterVariability == cgSetParameterVariability)
    {
      traceWarning("Ignoring cgSetParameterVariability loaded from traceCg library.");
      traceCg_Native.cgSetParameterVariability = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterVariability not loaded.");
  }
  if (traceCg_Native.cgSetParameterSemantic)
  {
    if (traceCg_Native.cgSetParameterSemantic == cgSetParameterSemantic)
    {
      traceWarning("Ignoring cgSetParameterSemantic loaded from traceCg library.");
      traceCg_Native.cgSetParameterSemantic = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameterSemantic not loaded.");
  }
  if (traceCg_Native.cgSetParameter1f)
  {
    if (traceCg_Native.cgSetParameter1f == cgSetParameter1f)
    {
      traceWarning("Ignoring cgSetParameter1f loaded from traceCg library.");
      traceCg_Native.cgSetParameter1f = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter1f not loaded.");
  }
  if (traceCg_Native.cgSetParameter2f)
  {
    if (traceCg_Native.cgSetParameter2f == cgSetParameter2f)
    {
      traceWarning("Ignoring cgSetParameter2f loaded from traceCg library.");
      traceCg_Native.cgSetParameter2f = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter2f not loaded.");
  }
  if (traceCg_Native.cgSetParameter3f)
  {
    if (traceCg_Native.cgSetParameter3f == cgSetParameter3f)
    {
      traceWarning("Ignoring cgSetParameter3f loaded from traceCg library.");
      traceCg_Native.cgSetParameter3f = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter3f not loaded.");
  }
  if (traceCg_Native.cgSetParameter4f)
  {
    if (traceCg_Native.cgSetParameter4f == cgSetParameter4f)
    {
      traceWarning("Ignoring cgSetParameter4f loaded from traceCg library.");
      traceCg_Native.cgSetParameter4f = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter4f not loaded.");
  }
  if (traceCg_Native.cgSetParameter1d)
  {
    if (traceCg_Native.cgSetParameter1d == cgSetParameter1d)
    {
      traceWarning("Ignoring cgSetParameter1d loaded from traceCg library.");
      traceCg_Native.cgSetParameter1d = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter1d not loaded.");
  }
  if (traceCg_Native.cgSetParameter2d)
  {
    if (traceCg_Native.cgSetParameter2d == cgSetParameter2d)
    {
      traceWarning("Ignoring cgSetParameter2d loaded from traceCg library.");
      traceCg_Native.cgSetParameter2d = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter2d not loaded.");
  }
  if (traceCg_Native.cgSetParameter3d)
  {
    if (traceCg_Native.cgSetParameter3d == cgSetParameter3d)
    {
      traceWarning("Ignoring cgSetParameter3d loaded from traceCg library.");
      traceCg_Native.cgSetParameter3d = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter3d not loaded.");
  }
  if (traceCg_Native.cgSetParameter4d)
  {
    if (traceCg_Native.cgSetParameter4d == cgSetParameter4d)
    {
      traceWarning("Ignoring cgSetParameter4d loaded from traceCg library.");
      traceCg_Native.cgSetParameter4d = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter4d not loaded.");
  }
  if (traceCg_Native.cgSetParameter1i)
  {
    if (traceCg_Native.cgSetParameter1i == cgSetParameter1i)
    {
      traceWarning("Ignoring cgSetParameter1i loaded from traceCg library.");
      traceCg_Native.cgSetParameter1i = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter1i not loaded.");
  }
  if (traceCg_Native.cgSetParameter2i)
  {
    if (traceCg_Native.cgSetParameter2i == cgSetParameter2i)
    {
      traceWarning("Ignoring cgSetParameter2i loaded from traceCg library.");
      traceCg_Native.cgSetParameter2i = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter2i not loaded.");
  }
  if (traceCg_Native.cgSetParameter3i)
  {
    if (traceCg_Native.cgSetParameter3i == cgSetParameter3i)
    {
      traceWarning("Ignoring cgSetParameter3i loaded from traceCg library.");
      traceCg_Native.cgSetParameter3i = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter3i not loaded.");
  }
  if (traceCg_Native.cgSetParameter4i)
  {
    if (traceCg_Native.cgSetParameter4i == cgSetParameter4i)
    {
      traceWarning("Ignoring cgSetParameter4i loaded from traceCg library.");
      traceCg_Native.cgSetParameter4i = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter4i not loaded.");
  }
  if (traceCg_Native.cgSetParameter1iv)
  {
    if (traceCg_Native.cgSetParameter1iv == cgSetParameter1iv)
    {
      traceWarning("Ignoring cgSetParameter1iv loaded from traceCg library.");
      traceCg_Native.cgSetParameter1iv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter1iv not loaded.");
  }
  if (traceCg_Native.cgSetParameter2iv)
  {
    if (traceCg_Native.cgSetParameter2iv == cgSetParameter2iv)
    {
      traceWarning("Ignoring cgSetParameter2iv loaded from traceCg library.");
      traceCg_Native.cgSetParameter2iv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter2iv not loaded.");
  }
  if (traceCg_Native.cgSetParameter3iv)
  {
    if (traceCg_Native.cgSetParameter3iv == cgSetParameter3iv)
    {
      traceWarning("Ignoring cgSetParameter3iv loaded from traceCg library.");
      traceCg_Native.cgSetParameter3iv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter3iv not loaded.");
  }
  if (traceCg_Native.cgSetParameter4iv)
  {
    if (traceCg_Native.cgSetParameter4iv == cgSetParameter4iv)
    {
      traceWarning("Ignoring cgSetParameter4iv loaded from traceCg library.");
      traceCg_Native.cgSetParameter4iv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter4iv not loaded.");
  }
  if (traceCg_Native.cgSetParameter1fv)
  {
    if (traceCg_Native.cgSetParameter1fv == cgSetParameter1fv)
    {
      traceWarning("Ignoring cgSetParameter1fv loaded from traceCg library.");
      traceCg_Native.cgSetParameter1fv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter1fv not loaded.");
  }
  if (traceCg_Native.cgSetParameter2fv)
  {
    if (traceCg_Native.cgSetParameter2fv == cgSetParameter2fv)
    {
      traceWarning("Ignoring cgSetParameter2fv loaded from traceCg library.");
      traceCg_Native.cgSetParameter2fv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter2fv not loaded.");
  }
  if (traceCg_Native.cgSetParameter3fv)
  {
    if (traceCg_Native.cgSetParameter3fv == cgSetParameter3fv)
    {
      traceWarning("Ignoring cgSetParameter3fv loaded from traceCg library.");
      traceCg_Native.cgSetParameter3fv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter3fv not loaded.");
  }
  if (traceCg_Native.cgSetParameter4fv)
  {
    if (traceCg_Native.cgSetParameter4fv == cgSetParameter4fv)
    {
      traceWarning("Ignoring cgSetParameter4fv loaded from traceCg library.");
      traceCg_Native.cgSetParameter4fv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter4fv not loaded.");
  }
  if (traceCg_Native.cgSetParameter1dv)
  {
    if (traceCg_Native.cgSetParameter1dv == cgSetParameter1dv)
    {
      traceWarning("Ignoring cgSetParameter1dv loaded from traceCg library.");
      traceCg_Native.cgSetParameter1dv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter1dv not loaded.");
  }
  if (traceCg_Native.cgSetParameter2dv)
  {
    if (traceCg_Native.cgSetParameter2dv == cgSetParameter2dv)
    {
      traceWarning("Ignoring cgSetParameter2dv loaded from traceCg library.");
      traceCg_Native.cgSetParameter2dv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter2dv not loaded.");
  }
  if (traceCg_Native.cgSetParameter3dv)
  {
    if (traceCg_Native.cgSetParameter3dv == cgSetParameter3dv)
    {
      traceWarning("Ignoring cgSetParameter3dv loaded from traceCg library.");
      traceCg_Native.cgSetParameter3dv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter3dv not loaded.");
  }
  if (traceCg_Native.cgSetParameter4dv)
  {
    if (traceCg_Native.cgSetParameter4dv == cgSetParameter4dv)
    {
      traceWarning("Ignoring cgSetParameter4dv loaded from traceCg library.");
      traceCg_Native.cgSetParameter4dv = NULL;
    }
  }
  else
  {
    traceWarning("cgSetParameter4dv not loaded.");
  }
  if (traceCg_Native.cgSetMatrixParameterir)
  {
    if (traceCg_Native.cgSetMatrixParameterir == cgSetMatrixParameterir)
    {
      traceWarning("Ignoring cgSetMatrixParameterir loaded from traceCg library.");
      traceCg_Native.cgSetMatrixParameterir = NULL;
    }
  }
  else
  {
    traceWarning("cgSetMatrixParameterir not loaded.");
  }
  if (traceCg_Native.cgSetMatrixParameterdr)
  {
    if (traceCg_Native.cgSetMatrixParameterdr == cgSetMatrixParameterdr)
    {
      traceWarning("Ignoring cgSetMatrixParameterdr loaded from traceCg library.");
      traceCg_Native.cgSetMatrixParameterdr = NULL;
    }
  }
  else
  {
    traceWarning("cgSetMatrixParameterdr not loaded.");
  }
  if (traceCg_Native.cgSetMatrixParameterfr)
  {
    if (traceCg_Native.cgSetMatrixParameterfr == cgSetMatrixParameterfr)
    {
      traceWarning("Ignoring cgSetMatrixParameterfr loaded from traceCg library.");
      traceCg_Native.cgSetMatrixParameterfr = NULL;
    }
  }
  else
  {
    traceWarning("cgSetMatrixParameterfr not loaded.");
  }
  if (traceCg_Native.cgSetMatrixParameteric)
  {
    if (traceCg_Native.cgSetMatrixParameteric == cgSetMatrixParameteric)
    {
      traceWarning("Ignoring cgSetMatrixParameteric loaded from traceCg library.");
      traceCg_Native.cgSetMatrixParameteric = NULL;
    }
  }
  else
  {
    traceWarning("cgSetMatrixParameteric not loaded.");
  }
  if (traceCg_Native.cgSetMatrixParameterdc)
  {
    if (traceCg_Native.cgSetMatrixParameterdc == cgSetMatrixParameterdc)
    {
      traceWarning("Ignoring cgSetMatrixParameterdc loaded from traceCg library.");
      traceCg_Native.cgSetMatrixParameterdc = NULL;
    }
  }
  else
  {
    traceWarning("cgSetMatrixParameterdc not loaded.");
  }
  if (traceCg_Native.cgSetMatrixParameterfc)
  {
    if (traceCg_Native.cgSetMatrixParameterfc == cgSetMatrixParameterfc)
    {
      traceWarning("Ignoring cgSetMatrixParameterfc loaded from traceCg library.");
      traceCg_Native.cgSetMatrixParameterfc = NULL;
    }
  }
  else
  {
    traceWarning("cgSetMatrixParameterfc not loaded.");
  }
  if (traceCg_Native.cgGetMatrixParameterir)
  {
    if (traceCg_Native.cgGetMatrixParameterir == cgGetMatrixParameterir)
    {
      traceWarning("Ignoring cgGetMatrixParameterir loaded from traceCg library.");
      traceCg_Native.cgGetMatrixParameterir = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixParameterir not loaded.");
  }
  if (traceCg_Native.cgGetMatrixParameterdr)
  {
    if (traceCg_Native.cgGetMatrixParameterdr == cgGetMatrixParameterdr)
    {
      traceWarning("Ignoring cgGetMatrixParameterdr loaded from traceCg library.");
      traceCg_Native.cgGetMatrixParameterdr = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixParameterdr not loaded.");
  }
  if (traceCg_Native.cgGetMatrixParameterfr)
  {
    if (traceCg_Native.cgGetMatrixParameterfr == cgGetMatrixParameterfr)
    {
      traceWarning("Ignoring cgGetMatrixParameterfr loaded from traceCg library.");
      traceCg_Native.cgGetMatrixParameterfr = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixParameterfr not loaded.");
  }
  if (traceCg_Native.cgGetMatrixParameteric)
  {
    if (traceCg_Native.cgGetMatrixParameteric == cgGetMatrixParameteric)
    {
      traceWarning("Ignoring cgGetMatrixParameteric loaded from traceCg library.");
      traceCg_Native.cgGetMatrixParameteric = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixParameteric not loaded.");
  }
  if (traceCg_Native.cgGetMatrixParameterdc)
  {
    if (traceCg_Native.cgGetMatrixParameterdc == cgGetMatrixParameterdc)
    {
      traceWarning("Ignoring cgGetMatrixParameterdc loaded from traceCg library.");
      traceCg_Native.cgGetMatrixParameterdc = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixParameterdc not loaded.");
  }
  if (traceCg_Native.cgGetMatrixParameterfc)
  {
    if (traceCg_Native.cgGetMatrixParameterfc == cgGetMatrixParameterfc)
    {
      traceWarning("Ignoring cgGetMatrixParameterfc loaded from traceCg library.");
      traceCg_Native.cgGetMatrixParameterfc = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixParameterfc not loaded.");
  }
  if (traceCg_Native.cgGetMatrixParameterOrder)
  {
    if (traceCg_Native.cgGetMatrixParameterOrder == cgGetMatrixParameterOrder)
    {
      traceWarning("Ignoring cgGetMatrixParameterOrder loaded from traceCg library.");
      traceCg_Native.cgGetMatrixParameterOrder = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixParameterOrder not loaded.");
  }
  if (traceCg_Native.cgGetNamedSubParameter)
  {
    if (traceCg_Native.cgGetNamedSubParameter == cgGetNamedSubParameter)
    {
      traceWarning("Ignoring cgGetNamedSubParameter loaded from traceCg library.");
      traceCg_Native.cgGetNamedSubParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedSubParameter not loaded.");
  }
  if (traceCg_Native.cgGetTypeString)
  {
    if (traceCg_Native.cgGetTypeString == cgGetTypeString)
    {
      traceWarning("Ignoring cgGetTypeString loaded from traceCg library.");
      traceCg_Native.cgGetTypeString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetTypeString not loaded.");
  }
  if (traceCg_Native.cgGetType)
  {
    if (traceCg_Native.cgGetType == cgGetType)
    {
      traceWarning("Ignoring cgGetType loaded from traceCg library.");
      traceCg_Native.cgGetType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetType not loaded.");
  }
  if (traceCg_Native.cgGetNamedUserType)
  {
    if (traceCg_Native.cgGetNamedUserType == cgGetNamedUserType)
    {
      traceWarning("Ignoring cgGetNamedUserType loaded from traceCg library.");
      traceCg_Native.cgGetNamedUserType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedUserType not loaded.");
  }
  if (traceCg_Native.cgGetNumUserTypes)
  {
    if (traceCg_Native.cgGetNumUserTypes == cgGetNumUserTypes)
    {
      traceWarning("Ignoring cgGetNumUserTypes loaded from traceCg library.");
      traceCg_Native.cgGetNumUserTypes = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumUserTypes not loaded.");
  }
  if (traceCg_Native.cgGetUserType)
  {
    if (traceCg_Native.cgGetUserType == cgGetUserType)
    {
      traceWarning("Ignoring cgGetUserType loaded from traceCg library.");
      traceCg_Native.cgGetUserType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetUserType not loaded.");
  }
  if (traceCg_Native.cgGetNumParentTypes)
  {
    if (traceCg_Native.cgGetNumParentTypes == cgGetNumParentTypes)
    {
      traceWarning("Ignoring cgGetNumParentTypes loaded from traceCg library.");
      traceCg_Native.cgGetNumParentTypes = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumParentTypes not loaded.");
  }
  if (traceCg_Native.cgGetParentType)
  {
    if (traceCg_Native.cgGetParentType == cgGetParentType)
    {
      traceWarning("Ignoring cgGetParentType loaded from traceCg library.");
      traceCg_Native.cgGetParentType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParentType not loaded.");
  }
  if (traceCg_Native.cgIsParentType)
  {
    if (traceCg_Native.cgIsParentType == cgIsParentType)
    {
      traceWarning("Ignoring cgIsParentType loaded from traceCg library.");
      traceCg_Native.cgIsParentType = NULL;
    }
  }
  else
  {
    traceWarning("cgIsParentType not loaded.");
  }
  if (traceCg_Native.cgIsInterfaceType)
  {
    if (traceCg_Native.cgIsInterfaceType == cgIsInterfaceType)
    {
      traceWarning("Ignoring cgIsInterfaceType loaded from traceCg library.");
      traceCg_Native.cgIsInterfaceType = NULL;
    }
  }
  else
  {
    traceWarning("cgIsInterfaceType not loaded.");
  }
  if (traceCg_Native.cgGetResourceString)
  {
    if (traceCg_Native.cgGetResourceString == cgGetResourceString)
    {
      traceWarning("Ignoring cgGetResourceString loaded from traceCg library.");
      traceCg_Native.cgGetResourceString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetResourceString not loaded.");
  }
  if (traceCg_Native.cgGetResource)
  {
    if (traceCg_Native.cgGetResource == cgGetResource)
    {
      traceWarning("Ignoring cgGetResource loaded from traceCg library.");
      traceCg_Native.cgGetResource = NULL;
    }
  }
  else
  {
    traceWarning("cgGetResource not loaded.");
  }
  if (traceCg_Native.cgGetEnumString)
  {
    if (traceCg_Native.cgGetEnumString == cgGetEnumString)
    {
      traceWarning("Ignoring cgGetEnumString loaded from traceCg library.");
      traceCg_Native.cgGetEnumString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetEnumString not loaded.");
  }
  if (traceCg_Native.cgGetEnum)
  {
    if (traceCg_Native.cgGetEnum == cgGetEnum)
    {
      traceWarning("Ignoring cgGetEnum loaded from traceCg library.");
      traceCg_Native.cgGetEnum = NULL;
    }
  }
  else
  {
    traceWarning("cgGetEnum not loaded.");
  }
  if (traceCg_Native.cgGetProfileString)
  {
    if (traceCg_Native.cgGetProfileString == cgGetProfileString)
    {
      traceWarning("Ignoring cgGetProfileString loaded from traceCg library.");
      traceCg_Native.cgGetProfileString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProfileString not loaded.");
  }
  if (traceCg_Native.cgGetProfile)
  {
    if (traceCg_Native.cgGetProfile == cgGetProfile)
    {
      traceWarning("Ignoring cgGetProfile loaded from traceCg library.");
      traceCg_Native.cgGetProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProfile not loaded.");
  }
  if (traceCg_Native.cgGetNumSupportedProfiles)
  {
    if (traceCg_Native.cgGetNumSupportedProfiles == cgGetNumSupportedProfiles)
    {
      traceWarning("Ignoring cgGetNumSupportedProfiles loaded from traceCg library.");
      traceCg_Native.cgGetNumSupportedProfiles = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumSupportedProfiles not loaded.");
  }
  if (traceCg_Native.cgGetSupportedProfile)
  {
    if (traceCg_Native.cgGetSupportedProfile == cgGetSupportedProfile)
    {
      traceWarning("Ignoring cgGetSupportedProfile loaded from traceCg library.");
      traceCg_Native.cgGetSupportedProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGetSupportedProfile not loaded.");
  }
  if (traceCg_Native.cgIsProfileSupported)
  {
    if (traceCg_Native.cgIsProfileSupported == cgIsProfileSupported)
    {
      traceWarning("Ignoring cgIsProfileSupported loaded from traceCg library.");
      traceCg_Native.cgIsProfileSupported = NULL;
    }
  }
  else
  {
    traceWarning("cgIsProfileSupported not loaded.");
  }
  if (traceCg_Native.cgGetProfileProperty)
  {
    if (traceCg_Native.cgGetProfileProperty == cgGetProfileProperty)
    {
      traceWarning("Ignoring cgGetProfileProperty loaded from traceCg library.");
      traceCg_Native.cgGetProfileProperty = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProfileProperty not loaded.");
  }
  if (traceCg_Native.cgGetParameterClassString)
  {
    if (traceCg_Native.cgGetParameterClassString == cgGetParameterClassString)
    {
      traceWarning("Ignoring cgGetParameterClassString loaded from traceCg library.");
      traceCg_Native.cgGetParameterClassString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterClassString not loaded.");
  }
  if (traceCg_Native.cgGetParameterClassEnum)
  {
    if (traceCg_Native.cgGetParameterClassEnum == cgGetParameterClassEnum)
    {
      traceWarning("Ignoring cgGetParameterClassEnum loaded from traceCg library.");
      traceCg_Native.cgGetParameterClassEnum = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterClassEnum not loaded.");
  }
  if (traceCg_Native.cgGetDomainString)
  {
    if (traceCg_Native.cgGetDomainString == cgGetDomainString)
    {
      traceWarning("Ignoring cgGetDomainString loaded from traceCg library.");
      traceCg_Native.cgGetDomainString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetDomainString not loaded.");
  }
  if (traceCg_Native.cgGetDomain)
  {
    if (traceCg_Native.cgGetDomain == cgGetDomain)
    {
      traceWarning("Ignoring cgGetDomain loaded from traceCg library.");
      traceCg_Native.cgGetDomain = NULL;
    }
  }
  else
  {
    traceWarning("cgGetDomain not loaded.");
  }
  if (traceCg_Native.cgGetProgramDomain)
  {
    if (traceCg_Native.cgGetProgramDomain == cgGetProgramDomain)
    {
      traceWarning("Ignoring cgGetProgramDomain loaded from traceCg library.");
      traceCg_Native.cgGetProgramDomain = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramDomain not loaded.");
  }
  if (traceCg_Native.cgGetError)
  {
    if (traceCg_Native.cgGetError == cgGetError)
    {
      traceWarning("Ignoring cgGetError loaded from traceCg library.");
      traceCg_Native.cgGetError = NULL;
    }
  }
  else
  {
    traceWarning("cgGetError not loaded.");
  }
  if (traceCg_Native.cgGetFirstError)
  {
    if (traceCg_Native.cgGetFirstError == cgGetFirstError)
    {
      traceWarning("Ignoring cgGetFirstError loaded from traceCg library.");
      traceCg_Native.cgGetFirstError = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstError not loaded.");
  }
  if (traceCg_Native.cgGetErrorString)
  {
    if (traceCg_Native.cgGetErrorString == cgGetErrorString)
    {
      traceWarning("Ignoring cgGetErrorString loaded from traceCg library.");
      traceCg_Native.cgGetErrorString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetErrorString not loaded.");
  }
  if (traceCg_Native.cgGetLastErrorString)
  {
    if (traceCg_Native.cgGetLastErrorString == cgGetLastErrorString)
    {
      traceWarning("Ignoring cgGetLastErrorString loaded from traceCg library.");
      traceCg_Native.cgGetLastErrorString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetLastErrorString not loaded.");
  }
  if (traceCg_Native.cgSetErrorCallback)
  {
    if (traceCg_Native.cgSetErrorCallback == cgSetErrorCallback)
    {
      traceWarning("Ignoring cgSetErrorCallback loaded from traceCg library.");
      traceCg_Native.cgSetErrorCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgSetErrorCallback not loaded.");
  }
  if (traceCg_Native.cgGetErrorCallback)
  {
    if (traceCg_Native.cgGetErrorCallback == cgGetErrorCallback)
    {
      traceWarning("Ignoring cgGetErrorCallback loaded from traceCg library.");
      traceCg_Native.cgGetErrorCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgGetErrorCallback not loaded.");
  }
  if (traceCg_Native.cgSetErrorHandler)
  {
    if (traceCg_Native.cgSetErrorHandler == cgSetErrorHandler)
    {
      traceWarning("Ignoring cgSetErrorHandler loaded from traceCg library.");
      traceCg_Native.cgSetErrorHandler = NULL;
    }
  }
  else
  {
    traceWarning("cgSetErrorHandler not loaded.");
  }
  if (traceCg_Native.cgGetErrorHandler)
  {
    if (traceCg_Native.cgGetErrorHandler == cgGetErrorHandler)
    {
      traceWarning("Ignoring cgGetErrorHandler loaded from traceCg library.");
      traceCg_Native.cgGetErrorHandler = NULL;
    }
  }
  else
  {
    traceWarning("cgGetErrorHandler not loaded.");
  }
  if (traceCg_Native.cgGetString)
  {
    if (traceCg_Native.cgGetString == cgGetString)
    {
      traceWarning("Ignoring cgGetString loaded from traceCg library.");
      traceCg_Native.cgGetString = NULL;
    }
  }
  else
  {
    traceWarning("cgGetString not loaded.");
  }
  if (traceCg_Native.cgCreateEffect)
  {
    if (traceCg_Native.cgCreateEffect == cgCreateEffect)
    {
      traceWarning("Ignoring cgCreateEffect loaded from traceCg library.");
      traceCg_Native.cgCreateEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateEffect not loaded.");
  }
  if (traceCg_Native.cgCreateEffectFromFile)
  {
    if (traceCg_Native.cgCreateEffectFromFile == cgCreateEffectFromFile)
    {
      traceWarning("Ignoring cgCreateEffectFromFile loaded from traceCg library.");
      traceCg_Native.cgCreateEffectFromFile = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateEffectFromFile not loaded.");
  }
  if (traceCg_Native.cgCopyEffect)
  {
    if (traceCg_Native.cgCopyEffect == cgCopyEffect)
    {
      traceWarning("Ignoring cgCopyEffect loaded from traceCg library.");
      traceCg_Native.cgCopyEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgCopyEffect not loaded.");
  }
  if (traceCg_Native.cgDestroyEffect)
  {
    if (traceCg_Native.cgDestroyEffect == cgDestroyEffect)
    {
      traceWarning("Ignoring cgDestroyEffect loaded from traceCg library.");
      traceCg_Native.cgDestroyEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgDestroyEffect not loaded.");
  }
  if (traceCg_Native.cgGetEffectContext)
  {
    if (traceCg_Native.cgGetEffectContext == cgGetEffectContext)
    {
      traceWarning("Ignoring cgGetEffectContext loaded from traceCg library.");
      traceCg_Native.cgGetEffectContext = NULL;
    }
  }
  else
  {
    traceWarning("cgGetEffectContext not loaded.");
  }
  if (traceCg_Native.cgIsEffect)
  {
    if (traceCg_Native.cgIsEffect == cgIsEffect)
    {
      traceWarning("Ignoring cgIsEffect loaded from traceCg library.");
      traceCg_Native.cgIsEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgIsEffect not loaded.");
  }
  if (traceCg_Native.cgGetFirstEffect)
  {
    if (traceCg_Native.cgGetFirstEffect == cgGetFirstEffect)
    {
      traceWarning("Ignoring cgGetFirstEffect loaded from traceCg library.");
      traceCg_Native.cgGetFirstEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstEffect not loaded.");
  }
  if (traceCg_Native.cgGetNextEffect)
  {
    if (traceCg_Native.cgGetNextEffect == cgGetNextEffect)
    {
      traceWarning("Ignoring cgGetNextEffect loaded from traceCg library.");
      traceCg_Native.cgGetNextEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextEffect not loaded.");
  }
  if (traceCg_Native.cgCreateProgramFromEffect)
  {
    if (traceCg_Native.cgCreateProgramFromEffect == cgCreateProgramFromEffect)
    {
      traceWarning("Ignoring cgCreateProgramFromEffect loaded from traceCg library.");
      traceCg_Native.cgCreateProgramFromEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateProgramFromEffect not loaded.");
  }
  if (traceCg_Native.cgGetFirstTechnique)
  {
    if (traceCg_Native.cgGetFirstTechnique == cgGetFirstTechnique)
    {
      traceWarning("Ignoring cgGetFirstTechnique loaded from traceCg library.");
      traceCg_Native.cgGetFirstTechnique = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstTechnique not loaded.");
  }
  if (traceCg_Native.cgGetNextTechnique)
  {
    if (traceCg_Native.cgGetNextTechnique == cgGetNextTechnique)
    {
      traceWarning("Ignoring cgGetNextTechnique loaded from traceCg library.");
      traceCg_Native.cgGetNextTechnique = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextTechnique not loaded.");
  }
  if (traceCg_Native.cgGetNamedTechnique)
  {
    if (traceCg_Native.cgGetNamedTechnique == cgGetNamedTechnique)
    {
      traceWarning("Ignoring cgGetNamedTechnique loaded from traceCg library.");
      traceCg_Native.cgGetNamedTechnique = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedTechnique not loaded.");
  }
  if (traceCg_Native.cgGetTechniqueName)
  {
    if (traceCg_Native.cgGetTechniqueName == cgGetTechniqueName)
    {
      traceWarning("Ignoring cgGetTechniqueName loaded from traceCg library.");
      traceCg_Native.cgGetTechniqueName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetTechniqueName not loaded.");
  }
  if (traceCg_Native.cgIsTechnique)
  {
    if (traceCg_Native.cgIsTechnique == cgIsTechnique)
    {
      traceWarning("Ignoring cgIsTechnique loaded from traceCg library.");
      traceCg_Native.cgIsTechnique = NULL;
    }
  }
  else
  {
    traceWarning("cgIsTechnique not loaded.");
  }
  if (traceCg_Native.cgValidateTechnique)
  {
    if (traceCg_Native.cgValidateTechnique == cgValidateTechnique)
    {
      traceWarning("Ignoring cgValidateTechnique loaded from traceCg library.");
      traceCg_Native.cgValidateTechnique = NULL;
    }
  }
  else
  {
    traceWarning("cgValidateTechnique not loaded.");
  }
  if (traceCg_Native.cgIsTechniqueValidated)
  {
    if (traceCg_Native.cgIsTechniqueValidated == cgIsTechniqueValidated)
    {
      traceWarning("Ignoring cgIsTechniqueValidated loaded from traceCg library.");
      traceCg_Native.cgIsTechniqueValidated = NULL;
    }
  }
  else
  {
    traceWarning("cgIsTechniqueValidated not loaded.");
  }
  if (traceCg_Native.cgGetTechniqueEffect)
  {
    if (traceCg_Native.cgGetTechniqueEffect == cgGetTechniqueEffect)
    {
      traceWarning("Ignoring cgGetTechniqueEffect loaded from traceCg library.");
      traceCg_Native.cgGetTechniqueEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgGetTechniqueEffect not loaded.");
  }
  if (traceCg_Native.cgGetFirstPass)
  {
    if (traceCg_Native.cgGetFirstPass == cgGetFirstPass)
    {
      traceWarning("Ignoring cgGetFirstPass loaded from traceCg library.");
      traceCg_Native.cgGetFirstPass = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstPass not loaded.");
  }
  if (traceCg_Native.cgGetNamedPass)
  {
    if (traceCg_Native.cgGetNamedPass == cgGetNamedPass)
    {
      traceWarning("Ignoring cgGetNamedPass loaded from traceCg library.");
      traceCg_Native.cgGetNamedPass = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedPass not loaded.");
  }
  if (traceCg_Native.cgGetNextPass)
  {
    if (traceCg_Native.cgGetNextPass == cgGetNextPass)
    {
      traceWarning("Ignoring cgGetNextPass loaded from traceCg library.");
      traceCg_Native.cgGetNextPass = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextPass not loaded.");
  }
  if (traceCg_Native.cgIsPass)
  {
    if (traceCg_Native.cgIsPass == cgIsPass)
    {
      traceWarning("Ignoring cgIsPass loaded from traceCg library.");
      traceCg_Native.cgIsPass = NULL;
    }
  }
  else
  {
    traceWarning("cgIsPass not loaded.");
  }
  if (traceCg_Native.cgGetPassName)
  {
    if (traceCg_Native.cgGetPassName == cgGetPassName)
    {
      traceWarning("Ignoring cgGetPassName loaded from traceCg library.");
      traceCg_Native.cgGetPassName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetPassName not loaded.");
  }
  if (traceCg_Native.cgGetPassTechnique)
  {
    if (traceCg_Native.cgGetPassTechnique == cgGetPassTechnique)
    {
      traceWarning("Ignoring cgGetPassTechnique loaded from traceCg library.");
      traceCg_Native.cgGetPassTechnique = NULL;
    }
  }
  else
  {
    traceWarning("cgGetPassTechnique not loaded.");
  }
  if (traceCg_Native.cgGetPassProgram)
  {
    if (traceCg_Native.cgGetPassProgram == cgGetPassProgram)
    {
      traceWarning("Ignoring cgGetPassProgram loaded from traceCg library.");
      traceCg_Native.cgGetPassProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGetPassProgram not loaded.");
  }
  if (traceCg_Native.cgSetPassState)
  {
    if (traceCg_Native.cgSetPassState == cgSetPassState)
    {
      traceWarning("Ignoring cgSetPassState loaded from traceCg library.");
      traceCg_Native.cgSetPassState = NULL;
    }
  }
  else
  {
    traceWarning("cgSetPassState not loaded.");
  }
  if (traceCg_Native.cgResetPassState)
  {
    if (traceCg_Native.cgResetPassState == cgResetPassState)
    {
      traceWarning("Ignoring cgResetPassState loaded from traceCg library.");
      traceCg_Native.cgResetPassState = NULL;
    }
  }
  else
  {
    traceWarning("cgResetPassState not loaded.");
  }
  if (traceCg_Native.cgGetFirstStateAssignment)
  {
    if (traceCg_Native.cgGetFirstStateAssignment == cgGetFirstStateAssignment)
    {
      traceWarning("Ignoring cgGetFirstStateAssignment loaded from traceCg library.");
      traceCg_Native.cgGetFirstStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstStateAssignment not loaded.");
  }
  if (traceCg_Native.cgGetNamedStateAssignment)
  {
    if (traceCg_Native.cgGetNamedStateAssignment == cgGetNamedStateAssignment)
    {
      traceWarning("Ignoring cgGetNamedStateAssignment loaded from traceCg library.");
      traceCg_Native.cgGetNamedStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedStateAssignment not loaded.");
  }
  if (traceCg_Native.cgGetNextStateAssignment)
  {
    if (traceCg_Native.cgGetNextStateAssignment == cgGetNextStateAssignment)
    {
      traceWarning("Ignoring cgGetNextStateAssignment loaded from traceCg library.");
      traceCg_Native.cgGetNextStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextStateAssignment not loaded.");
  }
  if (traceCg_Native.cgIsStateAssignment)
  {
    if (traceCg_Native.cgIsStateAssignment == cgIsStateAssignment)
    {
      traceWarning("Ignoring cgIsStateAssignment loaded from traceCg library.");
      traceCg_Native.cgIsStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgIsStateAssignment not loaded.");
  }
  if (traceCg_Native.cgCallStateSetCallback)
  {
    if (traceCg_Native.cgCallStateSetCallback == cgCallStateSetCallback)
    {
      traceWarning("Ignoring cgCallStateSetCallback loaded from traceCg library.");
      traceCg_Native.cgCallStateSetCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgCallStateSetCallback not loaded.");
  }
  if (traceCg_Native.cgCallStateValidateCallback)
  {
    if (traceCg_Native.cgCallStateValidateCallback == cgCallStateValidateCallback)
    {
      traceWarning("Ignoring cgCallStateValidateCallback loaded from traceCg library.");
      traceCg_Native.cgCallStateValidateCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgCallStateValidateCallback not loaded.");
  }
  if (traceCg_Native.cgCallStateResetCallback)
  {
    if (traceCg_Native.cgCallStateResetCallback == cgCallStateResetCallback)
    {
      traceWarning("Ignoring cgCallStateResetCallback loaded from traceCg library.");
      traceCg_Native.cgCallStateResetCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgCallStateResetCallback not loaded.");
  }
  if (traceCg_Native.cgGetStateAssignmentPass)
  {
    if (traceCg_Native.cgGetStateAssignmentPass == cgGetStateAssignmentPass)
    {
      traceWarning("Ignoring cgGetStateAssignmentPass loaded from traceCg library.");
      traceCg_Native.cgGetStateAssignmentPass = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateAssignmentPass not loaded.");
  }
  if (traceCg_Native.cgGetSamplerStateAssignmentParameter)
  {
    if (traceCg_Native.cgGetSamplerStateAssignmentParameter == cgGetSamplerStateAssignmentParameter)
    {
      traceWarning("Ignoring cgGetSamplerStateAssignmentParameter loaded from traceCg library.");
      traceCg_Native.cgGetSamplerStateAssignmentParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetSamplerStateAssignmentParameter not loaded.");
  }
  if (traceCg_Native.cgGetFloatStateAssignmentValues)
  {
    if (traceCg_Native.cgGetFloatStateAssignmentValues == cgGetFloatStateAssignmentValues)
    {
      traceWarning("Ignoring cgGetFloatStateAssignmentValues loaded from traceCg library.");
      traceCg_Native.cgGetFloatStateAssignmentValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFloatStateAssignmentValues not loaded.");
  }
  if (traceCg_Native.cgGetIntStateAssignmentValues)
  {
    if (traceCg_Native.cgGetIntStateAssignmentValues == cgGetIntStateAssignmentValues)
    {
      traceWarning("Ignoring cgGetIntStateAssignmentValues loaded from traceCg library.");
      traceCg_Native.cgGetIntStateAssignmentValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetIntStateAssignmentValues not loaded.");
  }
  if (traceCg_Native.cgGetBoolStateAssignmentValues)
  {
    if (traceCg_Native.cgGetBoolStateAssignmentValues == cgGetBoolStateAssignmentValues)
    {
      traceWarning("Ignoring cgGetBoolStateAssignmentValues loaded from traceCg library.");
      traceCg_Native.cgGetBoolStateAssignmentValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetBoolStateAssignmentValues not loaded.");
  }
  if (traceCg_Native.cgGetStringStateAssignmentValue)
  {
    if (traceCg_Native.cgGetStringStateAssignmentValue == cgGetStringStateAssignmentValue)
    {
      traceWarning("Ignoring cgGetStringStateAssignmentValue loaded from traceCg library.");
      traceCg_Native.cgGetStringStateAssignmentValue = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStringStateAssignmentValue not loaded.");
  }
  if (traceCg_Native.cgGetProgramStateAssignmentValue)
  {
    if (traceCg_Native.cgGetProgramStateAssignmentValue == cgGetProgramStateAssignmentValue)
    {
      traceWarning("Ignoring cgGetProgramStateAssignmentValue loaded from traceCg library.");
      traceCg_Native.cgGetProgramStateAssignmentValue = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramStateAssignmentValue not loaded.");
  }
  if (traceCg_Native.cgGetTextureStateAssignmentValue)
  {
    if (traceCg_Native.cgGetTextureStateAssignmentValue == cgGetTextureStateAssignmentValue)
    {
      traceWarning("Ignoring cgGetTextureStateAssignmentValue loaded from traceCg library.");
      traceCg_Native.cgGetTextureStateAssignmentValue = NULL;
    }
  }
  else
  {
    traceWarning("cgGetTextureStateAssignmentValue not loaded.");
  }
  if (traceCg_Native.cgGetSamplerStateAssignmentValue)
  {
    if (traceCg_Native.cgGetSamplerStateAssignmentValue == cgGetSamplerStateAssignmentValue)
    {
      traceWarning("Ignoring cgGetSamplerStateAssignmentValue loaded from traceCg library.");
      traceCg_Native.cgGetSamplerStateAssignmentValue = NULL;
    }
  }
  else
  {
    traceWarning("cgGetSamplerStateAssignmentValue not loaded.");
  }
  if (traceCg_Native.cgGetStateAssignmentIndex)
  {
    if (traceCg_Native.cgGetStateAssignmentIndex == cgGetStateAssignmentIndex)
    {
      traceWarning("Ignoring cgGetStateAssignmentIndex loaded from traceCg library.");
      traceCg_Native.cgGetStateAssignmentIndex = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateAssignmentIndex not loaded.");
  }
  if (traceCg_Native.cgGetNumDependentStateAssignmentParameters)
  {
    if (traceCg_Native.cgGetNumDependentStateAssignmentParameters == cgGetNumDependentStateAssignmentParameters)
    {
      traceWarning("Ignoring cgGetNumDependentStateAssignmentParameters loaded from traceCg library.");
      traceCg_Native.cgGetNumDependentStateAssignmentParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumDependentStateAssignmentParameters not loaded.");
  }
  if (traceCg_Native.cgGetDependentStateAssignmentParameter)
  {
    if (traceCg_Native.cgGetDependentStateAssignmentParameter == cgGetDependentStateAssignmentParameter)
    {
      traceWarning("Ignoring cgGetDependentStateAssignmentParameter loaded from traceCg library.");
      traceCg_Native.cgGetDependentStateAssignmentParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetDependentStateAssignmentParameter not loaded.");
  }
  if (traceCg_Native.cgGetNumDependentProgramArrayStateAssignmentParameters)
  {
    if (traceCg_Native.cgGetNumDependentProgramArrayStateAssignmentParameters == cgGetNumDependentProgramArrayStateAssignmentParameters)
    {
      traceWarning("Ignoring cgGetNumDependentProgramArrayStateAssignmentParameters loaded from traceCg library.");
      traceCg_Native.cgGetNumDependentProgramArrayStateAssignmentParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumDependentProgramArrayStateAssignmentParameters not loaded.");
  }
  if (traceCg_Native.cgGetDependentProgramArrayStateAssignmentParameter)
  {
    if (traceCg_Native.cgGetDependentProgramArrayStateAssignmentParameter == cgGetDependentProgramArrayStateAssignmentParameter)
    {
      traceWarning("Ignoring cgGetDependentProgramArrayStateAssignmentParameter loaded from traceCg library.");
      traceCg_Native.cgGetDependentProgramArrayStateAssignmentParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetDependentProgramArrayStateAssignmentParameter not loaded.");
  }
  if (traceCg_Native.cgGetConnectedStateAssignmentParameter)
  {
    if (traceCg_Native.cgGetConnectedStateAssignmentParameter == cgGetConnectedStateAssignmentParameter)
    {
      traceWarning("Ignoring cgGetConnectedStateAssignmentParameter loaded from traceCg library.");
      traceCg_Native.cgGetConnectedStateAssignmentParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetConnectedStateAssignmentParameter not loaded.");
  }
  if (traceCg_Native.cgGetStateAssignmentState)
  {
    if (traceCg_Native.cgGetStateAssignmentState == cgGetStateAssignmentState)
    {
      traceWarning("Ignoring cgGetStateAssignmentState loaded from traceCg library.");
      traceCg_Native.cgGetStateAssignmentState = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateAssignmentState not loaded.");
  }
  if (traceCg_Native.cgGetSamplerStateAssignmentState)
  {
    if (traceCg_Native.cgGetSamplerStateAssignmentState == cgGetSamplerStateAssignmentState)
    {
      traceWarning("Ignoring cgGetSamplerStateAssignmentState loaded from traceCg library.");
      traceCg_Native.cgGetSamplerStateAssignmentState = NULL;
    }
  }
  else
  {
    traceWarning("cgGetSamplerStateAssignmentState not loaded.");
  }
  if (traceCg_Native.cgCreateState)
  {
    if (traceCg_Native.cgCreateState == cgCreateState)
    {
      traceWarning("Ignoring cgCreateState loaded from traceCg library.");
      traceCg_Native.cgCreateState = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateState not loaded.");
  }
  if (traceCg_Native.cgCreateArrayState)
  {
    if (traceCg_Native.cgCreateArrayState == cgCreateArrayState)
    {
      traceWarning("Ignoring cgCreateArrayState loaded from traceCg library.");
      traceCg_Native.cgCreateArrayState = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateArrayState not loaded.");
  }
  if (traceCg_Native.cgSetStateCallbacks)
  {
    if (traceCg_Native.cgSetStateCallbacks == cgSetStateCallbacks)
    {
      traceWarning("Ignoring cgSetStateCallbacks loaded from traceCg library.");
      traceCg_Native.cgSetStateCallbacks = NULL;
    }
  }
  else
  {
    traceWarning("cgSetStateCallbacks not loaded.");
  }
  if (traceCg_Native.cgSetStateLatestProfile)
  {
    if (traceCg_Native.cgSetStateLatestProfile == cgSetStateLatestProfile)
    {
      traceWarning("Ignoring cgSetStateLatestProfile loaded from traceCg library.");
      traceCg_Native.cgSetStateLatestProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgSetStateLatestProfile not loaded.");
  }
  if (traceCg_Native.cgGetStateSetCallback)
  {
    if (traceCg_Native.cgGetStateSetCallback == cgGetStateSetCallback)
    {
      traceWarning("Ignoring cgGetStateSetCallback loaded from traceCg library.");
      traceCg_Native.cgGetStateSetCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateSetCallback not loaded.");
  }
  if (traceCg_Native.cgGetStateResetCallback)
  {
    if (traceCg_Native.cgGetStateResetCallback == cgGetStateResetCallback)
    {
      traceWarning("Ignoring cgGetStateResetCallback loaded from traceCg library.");
      traceCg_Native.cgGetStateResetCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateResetCallback not loaded.");
  }
  if (traceCg_Native.cgGetStateValidateCallback)
  {
    if (traceCg_Native.cgGetStateValidateCallback == cgGetStateValidateCallback)
    {
      traceWarning("Ignoring cgGetStateValidateCallback loaded from traceCg library.");
      traceCg_Native.cgGetStateValidateCallback = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateValidateCallback not loaded.");
  }
  if (traceCg_Native.cgGetStateLatestProfile)
  {
    if (traceCg_Native.cgGetStateLatestProfile == cgGetStateLatestProfile)
    {
      traceWarning("Ignoring cgGetStateLatestProfile loaded from traceCg library.");
      traceCg_Native.cgGetStateLatestProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateLatestProfile not loaded.");
  }
  if (traceCg_Native.cgGetStateContext)
  {
    if (traceCg_Native.cgGetStateContext == cgGetStateContext)
    {
      traceWarning("Ignoring cgGetStateContext loaded from traceCg library.");
      traceCg_Native.cgGetStateContext = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateContext not loaded.");
  }
  if (traceCg_Native.cgGetStateType)
  {
    if (traceCg_Native.cgGetStateType == cgGetStateType)
    {
      traceWarning("Ignoring cgGetStateType loaded from traceCg library.");
      traceCg_Native.cgGetStateType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateType not loaded.");
  }
  if (traceCg_Native.cgGetStateName)
  {
    if (traceCg_Native.cgGetStateName == cgGetStateName)
    {
      traceWarning("Ignoring cgGetStateName loaded from traceCg library.");
      traceCg_Native.cgGetStateName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateName not loaded.");
  }
  if (traceCg_Native.cgGetNamedState)
  {
    if (traceCg_Native.cgGetNamedState == cgGetNamedState)
    {
      traceWarning("Ignoring cgGetNamedState loaded from traceCg library.");
      traceCg_Native.cgGetNamedState = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedState not loaded.");
  }
  if (traceCg_Native.cgGetFirstState)
  {
    if (traceCg_Native.cgGetFirstState == cgGetFirstState)
    {
      traceWarning("Ignoring cgGetFirstState loaded from traceCg library.");
      traceCg_Native.cgGetFirstState = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstState not loaded.");
  }
  if (traceCg_Native.cgGetNextState)
  {
    if (traceCg_Native.cgGetNextState == cgGetNextState)
    {
      traceWarning("Ignoring cgGetNextState loaded from traceCg library.");
      traceCg_Native.cgGetNextState = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextState not loaded.");
  }
  if (traceCg_Native.cgIsState)
  {
    if (traceCg_Native.cgIsState == cgIsState)
    {
      traceWarning("Ignoring cgIsState loaded from traceCg library.");
      traceCg_Native.cgIsState = NULL;
    }
  }
  else
  {
    traceWarning("cgIsState not loaded.");
  }
  if (traceCg_Native.cgAddStateEnumerant)
  {
    if (traceCg_Native.cgAddStateEnumerant == cgAddStateEnumerant)
    {
      traceWarning("Ignoring cgAddStateEnumerant loaded from traceCg library.");
      traceCg_Native.cgAddStateEnumerant = NULL;
    }
  }
  else
  {
    traceWarning("cgAddStateEnumerant not loaded.");
  }
  if (traceCg_Native.cgCreateSamplerState)
  {
    if (traceCg_Native.cgCreateSamplerState == cgCreateSamplerState)
    {
      traceWarning("Ignoring cgCreateSamplerState loaded from traceCg library.");
      traceCg_Native.cgCreateSamplerState = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateSamplerState not loaded.");
  }
  if (traceCg_Native.cgCreateArraySamplerState)
  {
    if (traceCg_Native.cgCreateArraySamplerState == cgCreateArraySamplerState)
    {
      traceWarning("Ignoring cgCreateArraySamplerState loaded from traceCg library.");
      traceCg_Native.cgCreateArraySamplerState = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateArraySamplerState not loaded.");
  }
  if (traceCg_Native.cgGetNamedSamplerState)
  {
    if (traceCg_Native.cgGetNamedSamplerState == cgGetNamedSamplerState)
    {
      traceWarning("Ignoring cgGetNamedSamplerState loaded from traceCg library.");
      traceCg_Native.cgGetNamedSamplerState = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedSamplerState not loaded.");
  }
  if (traceCg_Native.cgGetFirstSamplerState)
  {
    if (traceCg_Native.cgGetFirstSamplerState == cgGetFirstSamplerState)
    {
      traceWarning("Ignoring cgGetFirstSamplerState loaded from traceCg library.");
      traceCg_Native.cgGetFirstSamplerState = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstSamplerState not loaded.");
  }
  if (traceCg_Native.cgGetFirstSamplerStateAssignment)
  {
    if (traceCg_Native.cgGetFirstSamplerStateAssignment == cgGetFirstSamplerStateAssignment)
    {
      traceWarning("Ignoring cgGetFirstSamplerStateAssignment loaded from traceCg library.");
      traceCg_Native.cgGetFirstSamplerStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstSamplerStateAssignment not loaded.");
  }
  if (traceCg_Native.cgGetNamedSamplerStateAssignment)
  {
    if (traceCg_Native.cgGetNamedSamplerStateAssignment == cgGetNamedSamplerStateAssignment)
    {
      traceWarning("Ignoring cgGetNamedSamplerStateAssignment loaded from traceCg library.");
      traceCg_Native.cgGetNamedSamplerStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedSamplerStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetSamplerState)
  {
    if (traceCg_Native.cgSetSamplerState == cgSetSamplerState)
    {
      traceWarning("Ignoring cgSetSamplerState loaded from traceCg library.");
      traceCg_Native.cgSetSamplerState = NULL;
    }
  }
  else
  {
    traceWarning("cgSetSamplerState not loaded.");
  }
  if (traceCg_Native.cgGetNamedEffectParameter)
  {
    if (traceCg_Native.cgGetNamedEffectParameter == cgGetNamedEffectParameter)
    {
      traceWarning("Ignoring cgGetNamedEffectParameter loaded from traceCg library.");
      traceCg_Native.cgGetNamedEffectParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedEffectParameter not loaded.");
  }
  if (traceCg_Native.cgGetFirstLeafEffectParameter)
  {
    if (traceCg_Native.cgGetFirstLeafEffectParameter == cgGetFirstLeafEffectParameter)
    {
      traceWarning("Ignoring cgGetFirstLeafEffectParameter loaded from traceCg library.");
      traceCg_Native.cgGetFirstLeafEffectParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstLeafEffectParameter not loaded.");
  }
  if (traceCg_Native.cgGetFirstEffectParameter)
  {
    if (traceCg_Native.cgGetFirstEffectParameter == cgGetFirstEffectParameter)
    {
      traceWarning("Ignoring cgGetFirstEffectParameter loaded from traceCg library.");
      traceCg_Native.cgGetFirstEffectParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstEffectParameter not loaded.");
  }
  if (traceCg_Native.cgGetEffectParameterBySemantic)
  {
    if (traceCg_Native.cgGetEffectParameterBySemantic == cgGetEffectParameterBySemantic)
    {
      traceWarning("Ignoring cgGetEffectParameterBySemantic loaded from traceCg library.");
      traceCg_Native.cgGetEffectParameterBySemantic = NULL;
    }
  }
  else
  {
    traceWarning("cgGetEffectParameterBySemantic not loaded.");
  }
  if (traceCg_Native.cgGetFirstTechniqueAnnotation)
  {
    if (traceCg_Native.cgGetFirstTechniqueAnnotation == cgGetFirstTechniqueAnnotation)
    {
      traceWarning("Ignoring cgGetFirstTechniqueAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetFirstTechniqueAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstTechniqueAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetFirstPassAnnotation)
  {
    if (traceCg_Native.cgGetFirstPassAnnotation == cgGetFirstPassAnnotation)
    {
      traceWarning("Ignoring cgGetFirstPassAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetFirstPassAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstPassAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetFirstParameterAnnotation)
  {
    if (traceCg_Native.cgGetFirstParameterAnnotation == cgGetFirstParameterAnnotation)
    {
      traceWarning("Ignoring cgGetFirstParameterAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetFirstParameterAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstParameterAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetFirstProgramAnnotation)
  {
    if (traceCg_Native.cgGetFirstProgramAnnotation == cgGetFirstProgramAnnotation)
    {
      traceWarning("Ignoring cgGetFirstProgramAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetFirstProgramAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstProgramAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetFirstEffectAnnotation)
  {
    if (traceCg_Native.cgGetFirstEffectAnnotation == cgGetFirstEffectAnnotation)
    {
      traceWarning("Ignoring cgGetFirstEffectAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetFirstEffectAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFirstEffectAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetNextAnnotation)
  {
    if (traceCg_Native.cgGetNextAnnotation == cgGetNextAnnotation)
    {
      traceWarning("Ignoring cgGetNextAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetNextAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNextAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetNamedTechniqueAnnotation)
  {
    if (traceCg_Native.cgGetNamedTechniqueAnnotation == cgGetNamedTechniqueAnnotation)
    {
      traceWarning("Ignoring cgGetNamedTechniqueAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetNamedTechniqueAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedTechniqueAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetNamedPassAnnotation)
  {
    if (traceCg_Native.cgGetNamedPassAnnotation == cgGetNamedPassAnnotation)
    {
      traceWarning("Ignoring cgGetNamedPassAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetNamedPassAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedPassAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetNamedParameterAnnotation)
  {
    if (traceCg_Native.cgGetNamedParameterAnnotation == cgGetNamedParameterAnnotation)
    {
      traceWarning("Ignoring cgGetNamedParameterAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetNamedParameterAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedParameterAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetNamedProgramAnnotation)
  {
    if (traceCg_Native.cgGetNamedProgramAnnotation == cgGetNamedProgramAnnotation)
    {
      traceWarning("Ignoring cgGetNamedProgramAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetNamedProgramAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedProgramAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetNamedEffectAnnotation)
  {
    if (traceCg_Native.cgGetNamedEffectAnnotation == cgGetNamedEffectAnnotation)
    {
      traceWarning("Ignoring cgGetNamedEffectAnnotation loaded from traceCg library.");
      traceCg_Native.cgGetNamedEffectAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedEffectAnnotation not loaded.");
  }
  if (traceCg_Native.cgIsAnnotation)
  {
    if (traceCg_Native.cgIsAnnotation == cgIsAnnotation)
    {
      traceWarning("Ignoring cgIsAnnotation loaded from traceCg library.");
      traceCg_Native.cgIsAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgIsAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetAnnotationName)
  {
    if (traceCg_Native.cgGetAnnotationName == cgGetAnnotationName)
    {
      traceWarning("Ignoring cgGetAnnotationName loaded from traceCg library.");
      traceCg_Native.cgGetAnnotationName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetAnnotationName not loaded.");
  }
  if (traceCg_Native.cgGetAnnotationType)
  {
    if (traceCg_Native.cgGetAnnotationType == cgGetAnnotationType)
    {
      traceWarning("Ignoring cgGetAnnotationType loaded from traceCg library.");
      traceCg_Native.cgGetAnnotationType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetAnnotationType not loaded.");
  }
  if (traceCg_Native.cgGetFloatAnnotationValues)
  {
    if (traceCg_Native.cgGetFloatAnnotationValues == cgGetFloatAnnotationValues)
    {
      traceWarning("Ignoring cgGetFloatAnnotationValues loaded from traceCg library.");
      traceCg_Native.cgGetFloatAnnotationValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetFloatAnnotationValues not loaded.");
  }
  if (traceCg_Native.cgGetIntAnnotationValues)
  {
    if (traceCg_Native.cgGetIntAnnotationValues == cgGetIntAnnotationValues)
    {
      traceWarning("Ignoring cgGetIntAnnotationValues loaded from traceCg library.");
      traceCg_Native.cgGetIntAnnotationValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetIntAnnotationValues not loaded.");
  }
  if (traceCg_Native.cgGetStringAnnotationValue)
  {
    if (traceCg_Native.cgGetStringAnnotationValue == cgGetStringAnnotationValue)
    {
      traceWarning("Ignoring cgGetStringAnnotationValue loaded from traceCg library.");
      traceCg_Native.cgGetStringAnnotationValue = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStringAnnotationValue not loaded.");
  }
  if (traceCg_Native.cgGetStringAnnotationValues)
  {
    if (traceCg_Native.cgGetStringAnnotationValues == cgGetStringAnnotationValues)
    {
      traceWarning("Ignoring cgGetStringAnnotationValues loaded from traceCg library.");
      traceCg_Native.cgGetStringAnnotationValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStringAnnotationValues not loaded.");
  }
  if (traceCg_Native.cgGetBoolAnnotationValues)
  {
    if (traceCg_Native.cgGetBoolAnnotationValues == cgGetBoolAnnotationValues)
    {
      traceWarning("Ignoring cgGetBoolAnnotationValues loaded from traceCg library.");
      traceCg_Native.cgGetBoolAnnotationValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetBoolAnnotationValues not loaded.");
  }
  if (traceCg_Native.cgGetBooleanAnnotationValues)
  {
    if (traceCg_Native.cgGetBooleanAnnotationValues == cgGetBooleanAnnotationValues)
    {
      traceWarning("Ignoring cgGetBooleanAnnotationValues loaded from traceCg library.");
      traceCg_Native.cgGetBooleanAnnotationValues = NULL;
    }
  }
  else
  {
    traceWarning("cgGetBooleanAnnotationValues not loaded.");
  }
  if (traceCg_Native.cgGetNumDependentAnnotationParameters)
  {
    if (traceCg_Native.cgGetNumDependentAnnotationParameters == cgGetNumDependentAnnotationParameters)
    {
      traceWarning("Ignoring cgGetNumDependentAnnotationParameters loaded from traceCg library.");
      traceCg_Native.cgGetNumDependentAnnotationParameters = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumDependentAnnotationParameters not loaded.");
  }
  if (traceCg_Native.cgGetDependentAnnotationParameter)
  {
    if (traceCg_Native.cgGetDependentAnnotationParameter == cgGetDependentAnnotationParameter)
    {
      traceWarning("Ignoring cgGetDependentAnnotationParameter loaded from traceCg library.");
      traceCg_Native.cgGetDependentAnnotationParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetDependentAnnotationParameter not loaded.");
  }
  if (traceCg_Native.cgEvaluateProgram)
  {
    if (traceCg_Native.cgEvaluateProgram == cgEvaluateProgram)
    {
      traceWarning("Ignoring cgEvaluateProgram loaded from traceCg library.");
      traceCg_Native.cgEvaluateProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgEvaluateProgram not loaded.");
  }
  if (traceCg_Native.cgSetEffectName)
  {
    if (traceCg_Native.cgSetEffectName == cgSetEffectName)
    {
      traceWarning("Ignoring cgSetEffectName loaded from traceCg library.");
      traceCg_Native.cgSetEffectName = NULL;
    }
  }
  else
  {
    traceWarning("cgSetEffectName not loaded.");
  }
  if (traceCg_Native.cgGetEffectName)
  {
    if (traceCg_Native.cgGetEffectName == cgGetEffectName)
    {
      traceWarning("Ignoring cgGetEffectName loaded from traceCg library.");
      traceCg_Native.cgGetEffectName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetEffectName not loaded.");
  }
  if (traceCg_Native.cgGetNamedEffect)
  {
    if (traceCg_Native.cgGetNamedEffect == cgGetNamedEffect)
    {
      traceWarning("Ignoring cgGetNamedEffect loaded from traceCg library.");
      traceCg_Native.cgGetNamedEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNamedEffect not loaded.");
  }
  if (traceCg_Native.cgCreateEffectParameter)
  {
    if (traceCg_Native.cgCreateEffectParameter == cgCreateEffectParameter)
    {
      traceWarning("Ignoring cgCreateEffectParameter loaded from traceCg library.");
      traceCg_Native.cgCreateEffectParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateEffectParameter not loaded.");
  }
  if (traceCg_Native.cgCreateTechnique)
  {
    if (traceCg_Native.cgCreateTechnique == cgCreateTechnique)
    {
      traceWarning("Ignoring cgCreateTechnique loaded from traceCg library.");
      traceCg_Native.cgCreateTechnique = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateTechnique not loaded.");
  }
  if (traceCg_Native.cgCreateEffectParameterArray)
  {
    if (traceCg_Native.cgCreateEffectParameterArray == cgCreateEffectParameterArray)
    {
      traceWarning("Ignoring cgCreateEffectParameterArray loaded from traceCg library.");
      traceCg_Native.cgCreateEffectParameterArray = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateEffectParameterArray not loaded.");
  }
  if (traceCg_Native.cgCreateEffectParameterMultiDimArray)
  {
    if (traceCg_Native.cgCreateEffectParameterMultiDimArray == cgCreateEffectParameterMultiDimArray)
    {
      traceWarning("Ignoring cgCreateEffectParameterMultiDimArray loaded from traceCg library.");
      traceCg_Native.cgCreateEffectParameterMultiDimArray = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateEffectParameterMultiDimArray not loaded.");
  }
  if (traceCg_Native.cgCreatePass)
  {
    if (traceCg_Native.cgCreatePass == cgCreatePass)
    {
      traceWarning("Ignoring cgCreatePass loaded from traceCg library.");
      traceCg_Native.cgCreatePass = NULL;
    }
  }
  else
  {
    traceWarning("cgCreatePass not loaded.");
  }
  if (traceCg_Native.cgCreateStateAssignment)
  {
    if (traceCg_Native.cgCreateStateAssignment == cgCreateStateAssignment)
    {
      traceWarning("Ignoring cgCreateStateAssignment loaded from traceCg library.");
      traceCg_Native.cgCreateStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateStateAssignment not loaded.");
  }
  if (traceCg_Native.cgCreateStateAssignmentIndex)
  {
    if (traceCg_Native.cgCreateStateAssignmentIndex == cgCreateStateAssignmentIndex)
    {
      traceWarning("Ignoring cgCreateStateAssignmentIndex loaded from traceCg library.");
      traceCg_Native.cgCreateStateAssignmentIndex = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateStateAssignmentIndex not loaded.");
  }
  if (traceCg_Native.cgCreateSamplerStateAssignment)
  {
    if (traceCg_Native.cgCreateSamplerStateAssignment == cgCreateSamplerStateAssignment)
    {
      traceWarning("Ignoring cgCreateSamplerStateAssignment loaded from traceCg library.");
      traceCg_Native.cgCreateSamplerStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateSamplerStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetFloatStateAssignment)
  {
    if (traceCg_Native.cgSetFloatStateAssignment == cgSetFloatStateAssignment)
    {
      traceWarning("Ignoring cgSetFloatStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetFloatStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetFloatStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetIntStateAssignment)
  {
    if (traceCg_Native.cgSetIntStateAssignment == cgSetIntStateAssignment)
    {
      traceWarning("Ignoring cgSetIntStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetIntStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetIntStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetBoolStateAssignment)
  {
    if (traceCg_Native.cgSetBoolStateAssignment == cgSetBoolStateAssignment)
    {
      traceWarning("Ignoring cgSetBoolStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetBoolStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetBoolStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetStringStateAssignment)
  {
    if (traceCg_Native.cgSetStringStateAssignment == cgSetStringStateAssignment)
    {
      traceWarning("Ignoring cgSetStringStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetStringStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetStringStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetProgramStateAssignment)
  {
    if (traceCg_Native.cgSetProgramStateAssignment == cgSetProgramStateAssignment)
    {
      traceWarning("Ignoring cgSetProgramStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetProgramStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetProgramStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetSamplerStateAssignment)
  {
    if (traceCg_Native.cgSetSamplerStateAssignment == cgSetSamplerStateAssignment)
    {
      traceWarning("Ignoring cgSetSamplerStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetSamplerStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetSamplerStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetTextureStateAssignment)
  {
    if (traceCg_Native.cgSetTextureStateAssignment == cgSetTextureStateAssignment)
    {
      traceWarning("Ignoring cgSetTextureStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetTextureStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetTextureStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetFloatArrayStateAssignment)
  {
    if (traceCg_Native.cgSetFloatArrayStateAssignment == cgSetFloatArrayStateAssignment)
    {
      traceWarning("Ignoring cgSetFloatArrayStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetFloatArrayStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetFloatArrayStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetIntArrayStateAssignment)
  {
    if (traceCg_Native.cgSetIntArrayStateAssignment == cgSetIntArrayStateAssignment)
    {
      traceWarning("Ignoring cgSetIntArrayStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetIntArrayStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetIntArrayStateAssignment not loaded.");
  }
  if (traceCg_Native.cgSetBoolArrayStateAssignment)
  {
    if (traceCg_Native.cgSetBoolArrayStateAssignment == cgSetBoolArrayStateAssignment)
    {
      traceWarning("Ignoring cgSetBoolArrayStateAssignment loaded from traceCg library.");
      traceCg_Native.cgSetBoolArrayStateAssignment = NULL;
    }
  }
  else
  {
    traceWarning("cgSetBoolArrayStateAssignment not loaded.");
  }
  if (traceCg_Native.cgCreateTechniqueAnnotation)
  {
    if (traceCg_Native.cgCreateTechniqueAnnotation == cgCreateTechniqueAnnotation)
    {
      traceWarning("Ignoring cgCreateTechniqueAnnotation loaded from traceCg library.");
      traceCg_Native.cgCreateTechniqueAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateTechniqueAnnotation not loaded.");
  }
  if (traceCg_Native.cgCreatePassAnnotation)
  {
    if (traceCg_Native.cgCreatePassAnnotation == cgCreatePassAnnotation)
    {
      traceWarning("Ignoring cgCreatePassAnnotation loaded from traceCg library.");
      traceCg_Native.cgCreatePassAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgCreatePassAnnotation not loaded.");
  }
  if (traceCg_Native.cgCreateParameterAnnotation)
  {
    if (traceCg_Native.cgCreateParameterAnnotation == cgCreateParameterAnnotation)
    {
      traceWarning("Ignoring cgCreateParameterAnnotation loaded from traceCg library.");
      traceCg_Native.cgCreateParameterAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateParameterAnnotation not loaded.");
  }
  if (traceCg_Native.cgCreateProgramAnnotation)
  {
    if (traceCg_Native.cgCreateProgramAnnotation == cgCreateProgramAnnotation)
    {
      traceWarning("Ignoring cgCreateProgramAnnotation loaded from traceCg library.");
      traceCg_Native.cgCreateProgramAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateProgramAnnotation not loaded.");
  }
  if (traceCg_Native.cgCreateEffectAnnotation)
  {
    if (traceCg_Native.cgCreateEffectAnnotation == cgCreateEffectAnnotation)
    {
      traceWarning("Ignoring cgCreateEffectAnnotation loaded from traceCg library.");
      traceCg_Native.cgCreateEffectAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateEffectAnnotation not loaded.");
  }
  if (traceCg_Native.cgSetIntAnnotation)
  {
    if (traceCg_Native.cgSetIntAnnotation == cgSetIntAnnotation)
    {
      traceWarning("Ignoring cgSetIntAnnotation loaded from traceCg library.");
      traceCg_Native.cgSetIntAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgSetIntAnnotation not loaded.");
  }
  if (traceCg_Native.cgSetFloatAnnotation)
  {
    if (traceCg_Native.cgSetFloatAnnotation == cgSetFloatAnnotation)
    {
      traceWarning("Ignoring cgSetFloatAnnotation loaded from traceCg library.");
      traceCg_Native.cgSetFloatAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgSetFloatAnnotation not loaded.");
  }
  if (traceCg_Native.cgSetBoolAnnotation)
  {
    if (traceCg_Native.cgSetBoolAnnotation == cgSetBoolAnnotation)
    {
      traceWarning("Ignoring cgSetBoolAnnotation loaded from traceCg library.");
      traceCg_Native.cgSetBoolAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgSetBoolAnnotation not loaded.");
  }
  if (traceCg_Native.cgSetStringAnnotation)
  {
    if (traceCg_Native.cgSetStringAnnotation == cgSetStringAnnotation)
    {
      traceWarning("Ignoring cgSetStringAnnotation loaded from traceCg library.");
      traceCg_Native.cgSetStringAnnotation = NULL;
    }
  }
  else
  {
    traceWarning("cgSetStringAnnotation not loaded.");
  }
  if (traceCg_Native.cgGetNumStateEnumerants)
  {
    if (traceCg_Native.cgGetNumStateEnumerants == cgGetNumStateEnumerants)
    {
      traceWarning("Ignoring cgGetNumStateEnumerants loaded from traceCg library.");
      traceCg_Native.cgGetNumStateEnumerants = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumStateEnumerants not loaded.");
  }
  if (traceCg_Native.cgGetStateEnumerant)
  {
    if (traceCg_Native.cgGetStateEnumerant == cgGetStateEnumerant)
    {
      traceWarning("Ignoring cgGetStateEnumerant loaded from traceCg library.");
      traceCg_Native.cgGetStateEnumerant = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateEnumerant not loaded.");
  }
  if (traceCg_Native.cgGetStateEnumerantName)
  {
    if (traceCg_Native.cgGetStateEnumerantName == cgGetStateEnumerantName)
    {
      traceWarning("Ignoring cgGetStateEnumerantName loaded from traceCg library.");
      traceCg_Native.cgGetStateEnumerantName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateEnumerantName not loaded.");
  }
  if (traceCg_Native.cgGetStateEnumerantValue)
  {
    if (traceCg_Native.cgGetStateEnumerantValue == cgGetStateEnumerantValue)
    {
      traceWarning("Ignoring cgGetStateEnumerantValue loaded from traceCg library.");
      traceCg_Native.cgGetStateEnumerantValue = NULL;
    }
  }
  else
  {
    traceWarning("cgGetStateEnumerantValue not loaded.");
  }
  if (traceCg_Native.cgGetParameterEffect)
  {
    if (traceCg_Native.cgGetParameterEffect == cgGetParameterEffect)
    {
      traceWarning("Ignoring cgGetParameterEffect loaded from traceCg library.");
      traceCg_Native.cgGetParameterEffect = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterEffect not loaded.");
  }
  if (traceCg_Native.cgGetTypeClass)
  {
    if (traceCg_Native.cgGetTypeClass == cgGetTypeClass)
    {
      traceWarning("Ignoring cgGetTypeClass loaded from traceCg library.");
      traceCg_Native.cgGetTypeClass = NULL;
    }
  }
  else
  {
    traceWarning("cgGetTypeClass not loaded.");
  }
  if (traceCg_Native.cgGetTypeBase)
  {
    if (traceCg_Native.cgGetTypeBase == cgGetTypeBase)
    {
      traceWarning("Ignoring cgGetTypeBase loaded from traceCg library.");
      traceCg_Native.cgGetTypeBase = NULL;
    }
  }
  else
  {
    traceWarning("cgGetTypeBase not loaded.");
  }
  if (traceCg_Native.cgGetTypeSizes)
  {
    if (traceCg_Native.cgGetTypeSizes == cgGetTypeSizes)
    {
      traceWarning("Ignoring cgGetTypeSizes loaded from traceCg library.");
      traceCg_Native.cgGetTypeSizes = NULL;
    }
  }
  else
  {
    traceWarning("cgGetTypeSizes not loaded.");
  }
  if (traceCg_Native.cgGetMatrixSize)
  {
    if (traceCg_Native.cgGetMatrixSize == cgGetMatrixSize)
    {
      traceWarning("Ignoring cgGetMatrixSize loaded from traceCg library.");
      traceCg_Native.cgGetMatrixSize = NULL;
    }
  }
  else
  {
    traceWarning("cgGetMatrixSize not loaded.");
  }
  if (traceCg_Native.cgGetNumProgramDomains)
  {
    if (traceCg_Native.cgGetNumProgramDomains == cgGetNumProgramDomains)
    {
      traceWarning("Ignoring cgGetNumProgramDomains loaded from traceCg library.");
      traceCg_Native.cgGetNumProgramDomains = NULL;
    }
  }
  else
  {
    traceWarning("cgGetNumProgramDomains not loaded.");
  }
  if (traceCg_Native.cgGetProfileDomain)
  {
    if (traceCg_Native.cgGetProfileDomain == cgGetProfileDomain)
    {
      traceWarning("Ignoring cgGetProfileDomain loaded from traceCg library.");
      traceCg_Native.cgGetProfileDomain = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProfileDomain not loaded.");
  }
  if (traceCg_Native.cgGetProfileSibling)
  {
    if (traceCg_Native.cgGetProfileSibling == cgGetProfileSibling)
    {
      traceWarning("Ignoring cgGetProfileSibling loaded from traceCg library.");
      traceCg_Native.cgGetProfileSibling = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProfileSibling not loaded.");
  }
  if (traceCg_Native.cgCombinePrograms)
  {
    if (traceCg_Native.cgCombinePrograms == cgCombinePrograms)
    {
      traceWarning("Ignoring cgCombinePrograms loaded from traceCg library.");
      traceCg_Native.cgCombinePrograms = NULL;
    }
  }
  else
  {
    traceWarning("cgCombinePrograms not loaded.");
  }
  if (traceCg_Native.cgCombinePrograms2)
  {
    if (traceCg_Native.cgCombinePrograms2 == cgCombinePrograms2)
    {
      traceWarning("Ignoring cgCombinePrograms2 loaded from traceCg library.");
      traceCg_Native.cgCombinePrograms2 = NULL;
    }
  }
  else
  {
    traceWarning("cgCombinePrograms2 not loaded.");
  }
  if (traceCg_Native.cgCombinePrograms3)
  {
    if (traceCg_Native.cgCombinePrograms3 == cgCombinePrograms3)
    {
      traceWarning("Ignoring cgCombinePrograms3 loaded from traceCg library.");
      traceCg_Native.cgCombinePrograms3 = NULL;
    }
  }
  else
  {
    traceWarning("cgCombinePrograms3 not loaded.");
  }
  if (traceCg_Native.cgCombinePrograms4)
  {
    if (traceCg_Native.cgCombinePrograms4 == cgCombinePrograms4)
    {
      traceWarning("Ignoring cgCombinePrograms4 loaded from traceCg library.");
      traceCg_Native.cgCombinePrograms4 = NULL;
    }
  }
  else
  {
    traceWarning("cgCombinePrograms4 not loaded.");
  }
  if (traceCg_Native.cgCombinePrograms5)
  {
    if (traceCg_Native.cgCombinePrograms5 == cgCombinePrograms5)
    {
      traceWarning("Ignoring cgCombinePrograms5 loaded from traceCg library.");
      traceCg_Native.cgCombinePrograms5 = NULL;
    }
  }
  else
  {
    traceWarning("cgCombinePrograms5 not loaded.");
  }
  if (traceCg_Native.cgGetProgramDomainProfile)
  {
    if (traceCg_Native.cgGetProgramDomainProfile == cgGetProgramDomainProfile)
    {
      traceWarning("Ignoring cgGetProgramDomainProfile loaded from traceCg library.");
      traceCg_Native.cgGetProgramDomainProfile = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramDomainProfile not loaded.");
  }
  if (traceCg_Native.cgGetProgramDomainProgram)
  {
    if (traceCg_Native.cgGetProgramDomainProgram == cgGetProgramDomainProgram)
    {
      traceWarning("Ignoring cgGetProgramDomainProgram loaded from traceCg library.");
      traceCg_Native.cgGetProgramDomainProgram = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramDomainProgram not loaded.");
  }
  if (traceCg_Native.cgCreateObj)
  {
    if (traceCg_Native.cgCreateObj == cgCreateObj)
    {
      traceWarning("Ignoring cgCreateObj loaded from traceCg library.");
      traceCg_Native.cgCreateObj = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateObj not loaded.");
  }
  if (traceCg_Native.cgCreateObjFromFile)
  {
    if (traceCg_Native.cgCreateObjFromFile == cgCreateObjFromFile)
    {
      traceWarning("Ignoring cgCreateObjFromFile loaded from traceCg library.");
      traceCg_Native.cgCreateObjFromFile = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateObjFromFile not loaded.");
  }
  if (traceCg_Native.cgDestroyObj)
  {
    if (traceCg_Native.cgDestroyObj == cgDestroyObj)
    {
      traceWarning("Ignoring cgDestroyObj loaded from traceCg library.");
      traceCg_Native.cgDestroyObj = NULL;
    }
  }
  else
  {
    traceWarning("cgDestroyObj not loaded.");
  }
  if (traceCg_Native.cgGetParameterResourceSize)
  {
    if (traceCg_Native.cgGetParameterResourceSize == cgGetParameterResourceSize)
    {
      traceWarning("Ignoring cgGetParameterResourceSize loaded from traceCg library.");
      traceCg_Native.cgGetParameterResourceSize = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterResourceSize not loaded.");
  }
  if (traceCg_Native.cgGetParameterResourceType)
  {
    if (traceCg_Native.cgGetParameterResourceType == cgGetParameterResourceType)
    {
      traceWarning("Ignoring cgGetParameterResourceType loaded from traceCg library.");
      traceCg_Native.cgGetParameterResourceType = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterResourceType not loaded.");
  }
  if (traceCg_Native.cgGetParameterResourceName)
  {
    if (traceCg_Native.cgGetParameterResourceName == cgGetParameterResourceName)
    {
      traceWarning("Ignoring cgGetParameterResourceName loaded from traceCg library.");
      traceCg_Native.cgGetParameterResourceName = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterResourceName not loaded.");
  }
  if (traceCg_Native.cgGetParameterBufferIndex)
  {
    if (traceCg_Native.cgGetParameterBufferIndex == cgGetParameterBufferIndex)
    {
      traceWarning("Ignoring cgGetParameterBufferIndex loaded from traceCg library.");
      traceCg_Native.cgGetParameterBufferIndex = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterBufferIndex not loaded.");
  }
  if (traceCg_Native.cgGetParameterBufferOffset)
  {
    if (traceCg_Native.cgGetParameterBufferOffset == cgGetParameterBufferOffset)
    {
      traceWarning("Ignoring cgGetParameterBufferOffset loaded from traceCg library.");
      traceCg_Native.cgGetParameterBufferOffset = NULL;
    }
  }
  else
  {
    traceWarning("cgGetParameterBufferOffset not loaded.");
  }
  if (traceCg_Native.cgCreateBuffer)
  {
    if (traceCg_Native.cgCreateBuffer == cgCreateBuffer)
    {
      traceWarning("Ignoring cgCreateBuffer loaded from traceCg library.");
      traceCg_Native.cgCreateBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgCreateBuffer not loaded.");
  }
  if (traceCg_Native.cgIsBuffer)
  {
    if (traceCg_Native.cgIsBuffer == cgIsBuffer)
    {
      traceWarning("Ignoring cgIsBuffer loaded from traceCg library.");
      traceCg_Native.cgIsBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgIsBuffer not loaded.");
  }
  if (traceCg_Native.cgSetBufferData)
  {
    if (traceCg_Native.cgSetBufferData == cgSetBufferData)
    {
      traceWarning("Ignoring cgSetBufferData loaded from traceCg library.");
      traceCg_Native.cgSetBufferData = NULL;
    }
  }
  else
  {
    traceWarning("cgSetBufferData not loaded.");
  }
  if (traceCg_Native.cgSetBufferSubData)
  {
    if (traceCg_Native.cgSetBufferSubData == cgSetBufferSubData)
    {
      traceWarning("Ignoring cgSetBufferSubData loaded from traceCg library.");
      traceCg_Native.cgSetBufferSubData = NULL;
    }
  }
  else
  {
    traceWarning("cgSetBufferSubData not loaded.");
  }
  if (traceCg_Native.cgSetProgramBuffer)
  {
    if (traceCg_Native.cgSetProgramBuffer == cgSetProgramBuffer)
    {
      traceWarning("Ignoring cgSetProgramBuffer loaded from traceCg library.");
      traceCg_Native.cgSetProgramBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgSetProgramBuffer not loaded.");
  }
  if (traceCg_Native.cgSetUniformBufferParameter)
  {
    if (traceCg_Native.cgSetUniformBufferParameter == cgSetUniformBufferParameter)
    {
      traceWarning("Ignoring cgSetUniformBufferParameter loaded from traceCg library.");
      traceCg_Native.cgSetUniformBufferParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgSetUniformBufferParameter not loaded.");
  }
  if (traceCg_Native.cgMapBuffer)
  {
    if (traceCg_Native.cgMapBuffer == cgMapBuffer)
    {
      traceWarning("Ignoring cgMapBuffer loaded from traceCg library.");
      traceCg_Native.cgMapBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgMapBuffer not loaded.");
  }
  if (traceCg_Native.cgUnmapBuffer)
  {
    if (traceCg_Native.cgUnmapBuffer == cgUnmapBuffer)
    {
      traceWarning("Ignoring cgUnmapBuffer loaded from traceCg library.");
      traceCg_Native.cgUnmapBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgUnmapBuffer not loaded.");
  }
  if (traceCg_Native.cgDestroyBuffer)
  {
    if (traceCg_Native.cgDestroyBuffer == cgDestroyBuffer)
    {
      traceWarning("Ignoring cgDestroyBuffer loaded from traceCg library.");
      traceCg_Native.cgDestroyBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgDestroyBuffer not loaded.");
  }
  if (traceCg_Native.cgGetProgramBuffer)
  {
    if (traceCg_Native.cgGetProgramBuffer == cgGetProgramBuffer)
    {
      traceWarning("Ignoring cgGetProgramBuffer loaded from traceCg library.");
      traceCg_Native.cgGetProgramBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramBuffer not loaded.");
  }
  if (traceCg_Native.cgGetUniformBufferParameter)
  {
    if (traceCg_Native.cgGetUniformBufferParameter == cgGetUniformBufferParameter)
    {
      traceWarning("Ignoring cgGetUniformBufferParameter loaded from traceCg library.");
      traceCg_Native.cgGetUniformBufferParameter = NULL;
    }
  }
  else
  {
    traceWarning("cgGetUniformBufferParameter not loaded.");
  }
  if (traceCg_Native.cgGetBufferSize)
  {
    if (traceCg_Native.cgGetBufferSize == cgGetBufferSize)
    {
      traceWarning("Ignoring cgGetBufferSize loaded from traceCg library.");
      traceCg_Native.cgGetBufferSize = NULL;
    }
  }
  else
  {
    traceWarning("cgGetBufferSize not loaded.");
  }
  if (traceCg_Native.cgGetProgramBufferMaxSize)
  {
    if (traceCg_Native.cgGetProgramBufferMaxSize == cgGetProgramBufferMaxSize)
    {
      traceWarning("Ignoring cgGetProgramBufferMaxSize loaded from traceCg library.");
      traceCg_Native.cgGetProgramBufferMaxSize = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramBufferMaxSize not loaded.");
  }
  if (traceCg_Native.cgGetProgramBufferMaxIndex)
  {
    if (traceCg_Native.cgGetProgramBufferMaxIndex == cgGetProgramBufferMaxIndex)
    {
      traceWarning("Ignoring cgGetProgramBufferMaxIndex loaded from traceCg library.");
      traceCg_Native.cgGetProgramBufferMaxIndex = NULL;
    }
  }
  else
  {
    traceWarning("cgGetProgramBufferMaxIndex not loaded.");
  }
  if (traceCg_Native.cgGetEffectParameterBuffer)
  {
    if (traceCg_Native.cgGetEffectParameterBuffer == cgGetEffectParameterBuffer)
    {
      traceWarning("Ignoring cgGetEffectParameterBuffer loaded from traceCg library.");
      traceCg_Native.cgGetEffectParameterBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgGetEffectParameterBuffer not loaded.");
  }
  if (traceCg_Native.cgSetEffectParameterBuffer)
  {
    if (traceCg_Native.cgSetEffectParameterBuffer == cgSetEffectParameterBuffer)
    {
      traceWarning("Ignoring cgSetEffectParameterBuffer loaded from traceCg library.");
      traceCg_Native.cgSetEffectParameterBuffer = NULL;
    }
  }
  else
  {
    traceWarning("cgSetEffectParameterBuffer not loaded.");
  }
#if !defined(__APPLE__)
  if (traceCg_Native.cgInternal)
  {
    if (traceCg_Native.cgInternal == cgInternal)
    {
      traceWarning("Ignoring cgInternal loaded from traceCg library.");
      traceCg_Native.cgInternal = NULL;
    }
  }
  else
  {
    traceWarning("cgInternal not loaded.");
  }
#endif

  /* Load Cg helper function pointers. */

  traceCg_helperCgGetArrayDimSize = (size_t (*)(CGparameter)) traceGetProcAddress("traceCgHelperCgGetArrayDimSize");
  traceCg_helperCgGetMatrixParameterSize = (size_t (*)(CGparameter)) traceGetProcAddress("traceCgHelperCgGetMatrixParameterSize");
  traceCg_helperCgGetParameterArraySize = (size_t (*)(CGparameter, long, long, long)) traceGetProcAddress("traceCgHelperCgGetParameterArraySize");
  traceCg_helperCgGetMatrixParameterArraySize = (size_t (*)(CGparameter, long, long)) traceGetProcAddress("traceCgHelperCgGetMatrixParameterArraySize");
  traceCg_helperCgGetArrayStateAssignmentSize = (size_t (*)(CGstateassignment)) traceGetProcAddress("traceCgHelperCgGetArrayStateAssignmentSize");
  traceCg_helperCgCreateBufferSize = (size_t (*)(int)) traceGetProcAddress("traceCgHelperCgCreateBufferSize");
  traceCg_helperCgGetBufferSize = (size_t (*)(CGbuffer, int)) traceGetProcAddress("traceCgHelperCgGetBufferSize");
  traceCg_helperCgStateSetCallbackStateAssignment = (CGstatecallback (*)(CGstateassignment)) traceGetProcAddress("traceCgHelperCgStateSetCallbackStateAssignment");
  traceCg_helperCgStateResetCallbackStateAssignment = (CGstatecallback (*)(CGstateassignment)) traceGetProcAddress("traceCgHelperCgStateResetCallbackStateAssignment");
  traceCg_helperCgStateValidateCallbackStateAssignment = (CGstatecallback (*)(CGstateassignment)) traceGetProcAddress("traceCgHelperCgStateValidateCallbackStateAssignment");

  /* Validate Cg helper function pointers. */

  if (!traceCg_helperCgGetArrayDimSize)
    traceWarning("Helper helperCgGetArrayDimSize not found; some parameters may not be traced.");
  if (!traceCg_helperCgGetMatrixParameterSize)
    traceWarning("Helper helperCgGetMatrixParameterSize not found; some parameters may not be traced.");
  if (!traceCg_helperCgGetParameterArraySize)
    traceWarning("Helper helperCgGetParameterArraySize not found; some parameters may not be traced.");
  if (!traceCg_helperCgGetMatrixParameterArraySize)
    traceWarning("Helper helperCgGetMatrixParameterArraySize not found; some parameters may not be traced.");
  if (!traceCg_helperCgGetArrayStateAssignmentSize)
    traceWarning("Helper helperCgGetArrayStateAssignmentSize not found; some parameters may not be traced.");
  if (!traceCg_helperCgCreateBufferSize)
    traceWarning("Helper helperCgCreateBufferSize not found; some parameters may not be traced.");
  if (!traceCg_helperCgGetBufferSize)
    traceWarning("Helper helperCgGetBufferSize not found; some parameters may not be traced.");
  if (!traceCg_helperCgStateSetCallbackStateAssignment)
    traceWarning("Helper helperCgStateSetCallbackStateAssignment not found; some parameters may not be traced.");
  if (!traceCg_helperCgStateResetCallbackStateAssignment)
    traceWarning("Helper helperCgStateResetCallbackStateAssignment not found; some parameters may not be traced.");
  if (!traceCg_helperCgStateValidateCallbackStateAssignment)
    traceWarning("Helper helperCgStateValidateCallbackStateAssignment not found; some parameters may not be traced.");

  traceCg_initialized = 1;
}

/* Cg get helper function. */

void *
getHelper(const char *name)
{
  if (!strcmp(name, "traceCgHelperCgGetArrayDimSize"))
    return (void *)(&helperCgGetArrayDimSize);
  if (!strcmp(name, "traceCgHelperCgGetMatrixParameterSize"))
    return (void *)(&helperCgGetMatrixParameterSize);
  if (!strcmp(name, "traceCgHelperCgGetParameterArraySize"))
    return (void *)(&helperCgGetParameterArraySize);
  if (!strcmp(name, "traceCgHelperCgGetMatrixParameterArraySize"))
    return (void *)(&helperCgGetMatrixParameterArraySize);
  if (!strcmp(name, "traceCgHelperCgGetArrayStateAssignmentSize"))
    return (void *)(&helperCgGetArrayStateAssignmentSize);
  if (!strcmp(name, "traceCgHelperCgCreateBufferSize"))
    return (void *)(&helperCgCreateBufferSize);
  if (!strcmp(name, "traceCgHelperCgGetBufferSize"))
    return (void *)(&helperCgGetBufferSize);
  if (!strcmp(name, "traceCgHelperCgStateSetCallbackStateAssignment"))
    return (void *)(&helperCgStateSetCallbackStateAssignment);
  if (!strcmp(name, "traceCgHelperCgStateResetCallbackStateAssignment"))
    return (void *)(&helperCgStateResetCallbackStateAssignment);
  if (!strcmp(name, "traceCgHelperCgStateValidateCallbackStateAssignment"))
    return (void *)(&helperCgStateValidateCallbackStateAssignment);

  return NULL;
}

/* Cg helper functions. */

size_t
helperCgGetArrayDimSize(CGparameter param)
{
  if (!traceCg_Native.cgGetArrayDimension)
    return 0;

  return (size_t)(traceCg_Native.cgGetArrayDimension(param));
}

size_t
helperCgGetMatrixParameterSize(CGparameter param)
{
  CGtype type = 0;
  int nRows = 0, nCols = 0;
  CGbool isMat = CG_FALSE;

  if (!traceCg_Native.cgGetParameterType || !traceCg_Native.cgGetTypeSizes)
    return 0;

  type  = traceCg_Native.cgGetParameterType(param);
  isMat = traceCg_Native.cgGetTypeSizes(type, &nRows, &nCols);
  if (!isMat)
    return 0;

  return (size_t)(nRows * nCols);
}

size_t
helperCgGetParameterArraySize(CGparameter param, long offset, long nElements, long elementSize)
{
  long arraySize = 0;

  if (!traceCg_Native.cgGetParameterType || !traceCg_Native.cgGetArraySize)
    return 0;

  if (traceCg_Native.cgGetParameterType(param) != CG_ARRAY)
    return 0;

  arraySize = traceCg_Native.cgGetArraySize(param, 0);
  if (!arraySize)
    return 0;

  if (nElements <= 0)
    nElements = arraySize - offset;
  else if (nElements > arraySize - offset)
    return 0;

  if (elementSize < 1)
    return 0;

  return (size_t)(nElements * elementSize);
}

size_t
helperCgGetMatrixParameterArraySize(CGparameter param, long offset, long nElements)
{
  long arraySize = 0;
  CGparameter firstParam = 0;
  CGtype type = 0;
  int nRows = 0, nCols = 0;
  CGbool isMat = CG_FALSE;
  size_t elementSize = 0;

  if (!traceCg_Native.cgGetParameterType ||
      !traceCg_Native.cgGetArraySize ||
      !traceCg_Native.cgGetArrayParameter ||
      !traceCg_Native.cgGetTypeSizes)
    return 0;

  if (traceCg_Native.cgGetParameterType(param) != CG_ARRAY)
    return 0;

  arraySize = traceCg_Native.cgGetArraySize(param, 0);
  if (!arraySize)
    return 0;

  if (nElements <= 0)
    nElements = arraySize - offset;
  else if (nElements > arraySize - offset)
    return 0;

  firstParam = traceCg_Native.cgGetArrayParameter(param, 0);
  type       = traceCg_Native.cgGetParameterType(firstParam);
  isMat      = traceCg_Native.cgGetTypeSizes(type, &nRows, &nCols);
  if (!isMat)
    return 0;

  elementSize = nRows * nCols;
  if (elementSize < 1)
    return 0;

  return (size_t)(nElements) * elementSize;
}

size_t
helperCgGetArrayStateAssignmentSize(CGstateassignment sa)
{
  CGstate state = 0;
  CGtype type = 0;
  int nValues = 0;

  if (!traceCg_Native.cgGetStateAssignmentState ||
      !traceCg_Native.cgGetStateType ||
      !traceCg_Native.cgGetFloatStateAssignmentValues ||
      !traceCg_Native.cgGetIntStateAssignmentValues ||
      !traceCg_Native.cgGetBoolStateAssignmentValues)
    return 0;

  state = traceCg_Native.cgGetStateAssignmentState(sa);
  type  = traceCg_Native.cgGetStateType(state);

  switch (type)
  {
    case CG_FLOAT:
    case CG_FIXED:
    case CG_HALF:
      {
        if (!traceCg_Native.cgGetFloatStateAssignmentValues(sa, &nValues))
          return 0;
        return (size_t)(nValues);
      }
      break;
    case CG_INT:
      {
        if (!traceCg_Native.cgGetIntStateAssignmentValues(sa, &nValues))
          return 0;
        return (size_t)(nValues);
      }
      break;
    case CG_BOOL:
      {
        if (!traceCg_Native.cgGetBoolStateAssignmentValues(sa, &nValues))
          return 0;
        return (size_t)(nValues);
      }
      break;
    default:
      return 0;
      break;
  }
}

size_t
helperCgCreateBufferSize(int size)
{
  return size > 0 ? (size_t)(size) : 0;
}

size_t
helperCgGetBufferSize(CGbuffer buffer, int size)
{
  if (!traceCg_Native.cgGetBufferSize)
    return 0;

  if (!size)
    size = traceCg_Native.cgGetBufferSize(buffer);

  if (size < 0)
    size = 0;

  return (size_t)(size);
}

/* Helpers for CGstatecallback lookup. */

CGstatecallback
helperCgStateSetCallbackStateAssignment(CGstateassignment sa)
{
  CGstate state = NULL;

  if (!traceCg_Native.cgGetStateAssignmentState)
    return NULL;

  if (!sa)
    return NULL;

  state = traceCg_Native.cgGetStateAssignmentState(sa);
  if (!state)
    return NULL;

  /* State lookup for StateSet callback. */

  return lookupCGstatecallback(traceCg_state.StateSetMap, state);
}

CGstatecallback
helperCgStateResetCallbackStateAssignment(CGstateassignment sa)
{
  CGstate state = NULL;

  if (!traceCg_Native.cgGetStateAssignmentState)
    return NULL;

  if (!sa)
    return NULL;

  state = traceCg_Native.cgGetStateAssignmentState(sa);
  if (!state)
    return NULL;

  /* State lookup for StateReset callback. */

  return lookupCGstatecallback(traceCg_state.StateResetMap, state);
}

CGstatecallback
helperCgStateValidateCallbackStateAssignment(CGstateassignment sa)
{
  CGstate state = NULL;

  if (!traceCg_Native.cgGetStateAssignmentState)
    return NULL;

  if (!sa)
    return NULL;

  state = traceCg_Native.cgGetStateAssignmentState(sa);
  if (!state)
    return NULL;

  /* State lookup for StateValidate callback. */

  return lookupCGstatecallback(traceCg_state.StateValidateMap, state);
}

/* Cg API wrapper functions. */

DLLEXPORT CGenum
cgSetLockingPolicy(CGenum lockingPolicy)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetLockingPolicy",&traceParam);

  if (!traceCg_Native.cgSetLockingPolicy)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetLockingPolicy");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("lockingPolicy", "%lu", lockingPolicy);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetLockingPolicy(lockingPolicy);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGenum
cgGetLockingPolicy()
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetLockingPolicy",&traceParam);

  if (!traceCg_Native.cgGetLockingPolicy)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetLockingPolicy");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetLockingPolicy();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGenum
cgSetSemanticCasePolicy(CGenum casePolicy)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetSemanticCasePolicy",&traceParam);

  if (!traceCg_Native.cgSetSemanticCasePolicy)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetSemanticCasePolicy");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("casePolicy", "%lu", casePolicy);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetSemanticCasePolicy(casePolicy);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGenum
cgGetSemanticCasePolicy()
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetSemanticCasePolicy",&traceParam);

  if (!traceCg_Native.cgGetSemanticCasePolicy)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetSemanticCasePolicy");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetSemanticCasePolicy();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGcontext
cgCreateContext()
{
  CGcontext ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateContext",&traceParam);

  if (!traceCg_Native.cgCreateContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateContext");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateContext();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetContextBehavior(CGcontext context, CGbehavior behavior)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetContextBehavior",&traceParam);

  if (!traceCg_Native.cgSetContextBehavior)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetContextBehavior");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("behavior", "%lu", behavior);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetContextBehavior(context, behavior);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbehavior
cgGetContextBehavior(CGcontext context)
{
  CGbehavior ret = (CGbehavior) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetContextBehavior",&traceParam);

  if (!traceCg_Native.cgGetContextBehavior)
    return (CGbehavior) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetContextBehavior");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetContextBehavior(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetBehaviorString(CGbehavior behavior)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetBehaviorString",&traceParam);

  if (!traceCg_Native.cgGetBehaviorString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetBehaviorString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("behavior", "%lu", behavior);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetBehaviorString(behavior);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbehavior
cgGetBehavior(const char *behavior_string)
{
  CGbehavior ret = (CGbehavior) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetBehavior",&traceParam);

  if (!traceCg_Native.cgGetBehavior)
    return (CGbehavior) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetBehavior");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("behavior_string", "%s", behavior_string);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetBehavior(behavior_string);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgDestroyContext(CGcontext context)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgDestroyContext",&traceParam);

  if (!traceCg_Native.cgDestroyContext)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgDestroyContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgDestroyContext(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbool
cgIsContext(CGcontext context)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsContext",&traceParam);

  if (!traceCg_Native.cgIsContext)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsContext(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetLastListing(CGcontext context)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetLastListing",&traceParam);

  if (!traceCg_Native.cgGetLastListing)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetLastListing");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetLastListing(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetLastListing(CGhandle handle, const char *listing)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetLastListing",&traceParam);

  if (!traceCg_Native.cgSetLastListing)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetLastListing");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("handle", "%zu", (size_t) handle);
      traceInputParameter("listing", "%s", listing);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetLastListing(handle, listing);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetAutoCompile(CGcontext context, CGenum autoCompileMode)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetAutoCompile",&traceParam);

  if (!traceCg_Native.cgSetAutoCompile)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetAutoCompile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("autoCompileMode", "%lu", autoCompileMode);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetAutoCompile(context, autoCompileMode);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGenum
cgGetAutoCompile(CGcontext context)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetAutoCompile",&traceParam);

  if (!traceCg_Native.cgGetAutoCompile)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetAutoCompile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetAutoCompile(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetParameterSettingMode(CGcontext context, CGenum parameterSettingMode)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterSettingMode",&traceParam);

  if (!traceCg_Native.cgSetParameterSettingMode)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterSettingMode");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("parameterSettingMode", "%lu", parameterSettingMode);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterSettingMode(context, parameterSettingMode);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGenum
cgGetParameterSettingMode(CGcontext context)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterSettingMode",&traceParam);

  if (!traceCg_Native.cgGetParameterSettingMode)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterSettingMode");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterSettingMode(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetCompilerIncludeString(CGcontext context, const char *name, const char *source)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetCompilerIncludeString",&traceParam);

  if (!traceCg_Native.cgSetCompilerIncludeString)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetCompilerIncludeString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
      traceInputParameter("source", "%s", source);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetCompilerIncludeString(context, name, source);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetCompilerIncludeFile(CGcontext context, const char *name, const char *filename)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetCompilerIncludeFile",&traceParam);

  if (!traceCg_Native.cgSetCompilerIncludeFile)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetCompilerIncludeFile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
      traceInputParameter("filename", "%s", filename);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetCompilerIncludeFile(context, name, filename);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetCompilerIncludeCallback(CGcontext context, CGIncludeCallbackFunc func)
{
  int traceThis;
  int traceParam;

  /* Intercept input variable declaration. */

  CGIncludeCallbackFunc intercept_func = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetCompilerIncludeCallback",&traceParam);

  if (!traceCg_Native.cgSetCompilerIncludeCallback)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetCompilerIncludeCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("func", "%p", (void *) func);
    }

  /* Intercept update. */

  updateCGIncludeCallbackFunc(&traceCg_state.CompilerIncludeMap, context, func);

  /* Intercept input. */

  intercept_func = func ? &(cb_cgCompilerInclude) : NULL;

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetCompilerIncludeCallback(context, intercept_func);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGIncludeCallbackFunc
cgGetCompilerIncludeCallback(CGcontext context)
{
  CGIncludeCallbackFunc ret = NULL;
  int traceThis;
  int traceParam;

  /* Intercept output variable declaration. */

  CGIncludeCallbackFunc intercept_ret = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetCompilerIncludeCallback",&traceParam);

  if (!traceCg_Native.cgGetCompilerIncludeCallback)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetCompilerIncludeCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetCompilerIncludeCallback(context);

  /* Intercept output. */

  intercept_ret = lookupCGIncludeCallbackFunc(traceCg_state.CompilerIncludeMap, context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", (void *) intercept_ret);

    /* Trace function end. */

    traceEnd();
  }

  return intercept_ret;
}

DLLEXPORT CGprogram
cgCreateProgram(CGcontext context, CGenum program_type, const char *program, CGprofile profile, const char *entry, const char **args)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateProgram",&traceParam);

  if (!traceCg_Native.cgCreateProgram)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("program_type", "%lu", program_type);
      traceInputParameter("program", "%s", program);
      traceInputParameter("profile", "%lu", profile);
      traceInputParameter("entry", "%s", entry);
      traceInputParameter("args", "%s[]", args);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateProgram(context, program_type, program, profile, entry, args);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCreateProgramFromFile(CGcontext context, CGenum program_type, const char *program_file, CGprofile profile, const char *entry, const char **args)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateProgramFromFile",&traceParam);

  if (!traceCg_Native.cgCreateProgramFromFile)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateProgramFromFile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("program_type", "%lu", program_type);
      traceInputParameter("program_file", "%s", program_file);
      traceInputParameter("profile", "%lu", profile);
      traceInputParameter("entry", "%s", entry);
      traceInputParameter("args", "%s[]", args);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateProgramFromFile(context, program_type, program_file, profile, entry, args);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCopyProgram(CGprogram program)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCopyProgram",&traceParam);

  if (!traceCg_Native.cgCopyProgram)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCopyProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCopyProgram(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgDestroyProgram(CGprogram program)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgDestroyProgram",&traceParam);

  if (!traceCg_Native.cgDestroyProgram)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgDestroyProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgDestroyProgram(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGprogram
cgGetFirstProgram(CGcontext context)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstProgram",&traceParam);

  if (!traceCg_Native.cgGetFirstProgram)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstProgram(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgGetNextProgram(CGprogram current)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextProgram",&traceParam);

  if (!traceCg_Native.cgGetNextProgram)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("current", "%zu", (size_t) current);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextProgram(current);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGcontext
cgGetProgramContext(CGprogram program)
{
  CGcontext ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramContext",&traceParam);

  if (!traceCg_Native.cgGetProgramContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramContext(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsProgram(CGprogram program)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsProgram",&traceParam);

  if (!traceCg_Native.cgIsProgram)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsProgram(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgCompileProgram(CGprogram program)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCompileProgram",&traceParam);

  if (!traceCg_Native.cgCompileProgram)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCompileProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgCompileProgram(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbool
cgIsProgramCompiled(CGprogram program)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsProgramCompiled",&traceParam);

  if (!traceCg_Native.cgIsProgramCompiled)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsProgramCompiled");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsProgramCompiled(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetProgramString(CGprogram program, CGenum pname)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramString",&traceParam);

  if (!traceCg_Native.cgGetProgramString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("pname", "%lu", pname);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramString(program, pname);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprofile
cgGetProgramProfile(CGprogram program)
{
  CGprofile ret = (CGprofile) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramProfile",&traceParam);

  if (!traceCg_Native.cgGetProgramProfile)
    return (CGprofile) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramProfile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramProfile(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT char const * const *
cgGetProgramOptions(CGprogram program)
{
  char const * const *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramOptions",&traceParam);

  if (!traceCg_Native.cgGetProgramOptions)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramOptions");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramOptions(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s[]", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetProgramProfile(CGprogram program, CGprofile profile)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetProgramProfile",&traceParam);

  if (!traceCg_Native.cgSetProgramProfile)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetProgramProfile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("profile", "%lu", profile);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetProgramProfile(program, profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGenum
cgGetProgramInput(CGprogram program)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramInput",&traceParam);

  if (!traceCg_Native.cgGetProgramInput)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramInput");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramInput(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGenum
cgGetProgramOutput(CGprogram program)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramOutput",&traceParam);

  if (!traceCg_Native.cgGetProgramOutput)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramOutput");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramOutput(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetProgramOutputVertices(CGprogram program)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramOutputVertices",&traceParam);

  if (!traceCg_Native.cgGetProgramOutputVertices)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramOutputVertices");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramOutputVertices(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetProgramOutputVertices(CGprogram program, int vertices)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetProgramOutputVertices",&traceParam);

  if (!traceCg_Native.cgSetProgramOutputVertices)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetProgramOutputVertices");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("vertices", "%d", vertices);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetProgramOutputVertices(program, vertices);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetPassProgramParameters(CGprogram program)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetPassProgramParameters",&traceParam);

  if (!traceCg_Native.cgSetPassProgramParameters)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetPassProgramParameters");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetPassProgramParameters(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgUpdateProgramParameters(CGprogram program)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgUpdateProgramParameters",&traceParam);

  if (!traceCg_Native.cgUpdateProgramParameters)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgUpdateProgramParameters");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgUpdateProgramParameters(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgUpdatePassParameters(CGpass pass)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgUpdatePassParameters",&traceParam);

  if (!traceCg_Native.cgUpdatePassParameters)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgUpdatePassParameters");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgUpdatePassParameters(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGparameter
cgCreateParameter(CGcontext context, CGtype type)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateParameter",&traceParam);

  if (!traceCg_Native.cgCreateParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateParameter(context, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgCreateParameterArray(CGcontext context, CGtype type, int length)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateParameterArray",&traceParam);

  if (!traceCg_Native.cgCreateParameterArray)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateParameterArray");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("type", "%lu", type);
      traceInputParameter("length", "%d", length);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateParameterArray(context, type, length);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgCreateParameterMultiDimArray(CGcontext context, CGtype type, int dim, const int *lengths)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateParameterMultiDimArray",&traceParam);

  if (!traceCg_Native.cgCreateParameterMultiDimArray)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateParameterMultiDimArray");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("type", "%lu", type);
      traceInputParameter("dim", "%d", dim);
      traceInputParameter("lengths", "%d[%d]", lengths, dim);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateParameterMultiDimArray(context, type, dim, lengths);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgDestroyParameter(CGparameter param)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgDestroyParameter",&traceParam);

  if (!traceCg_Native.cgDestroyParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgDestroyParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgDestroyParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgConnectParameter(CGparameter from, CGparameter to)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgConnectParameter",&traceParam);

  if (!traceCg_Native.cgConnectParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgConnectParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("from", "%zu", (size_t) from);
      traceInputParameter("to", "%zu", (size_t) to);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgConnectParameter(from, to);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgDisconnectParameter(CGparameter param)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgDisconnectParameter",&traceParam);

  if (!traceCg_Native.cgDisconnectParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgDisconnectParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgDisconnectParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGparameter
cgGetConnectedParameter(CGparameter param)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetConnectedParameter",&traceParam);

  if (!traceCg_Native.cgGetConnectedParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetConnectedParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetConnectedParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumConnectedToParameters(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumConnectedToParameters",&traceParam);

  if (!traceCg_Native.cgGetNumConnectedToParameters)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumConnectedToParameters");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumConnectedToParameters(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetConnectedToParameter(CGparameter param, int index)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetConnectedToParameter",&traceParam);

  if (!traceCg_Native.cgGetConnectedToParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetConnectedToParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetConnectedToParameter(param, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNamedParameter(CGprogram program, const char *name)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedParameter",&traceParam);

  if (!traceCg_Native.cgGetNamedParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedParameter(program, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNamedProgramParameter(CGprogram program, CGenum name_space, const char *name)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedProgramParameter",&traceParam);

  if (!traceCg_Native.cgGetNamedProgramParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedProgramParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("name_space", "%lu", name_space);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedProgramParameter(program, name_space, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNamedProgramUniformBuffer(CGprogram program, const char *blockName)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedProgramUniformBuffer",&traceParam);

  if (!traceCg_Native.cgGetNamedProgramUniformBuffer)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedProgramUniformBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("blockName", "%s", blockName);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedProgramUniformBuffer(program, blockName);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNamedEffectUniformBuffer(CGeffect effect, const char *blockName)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedEffectUniformBuffer",&traceParam);

  if (!traceCg_Native.cgGetNamedEffectUniformBuffer)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedEffectUniformBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("blockName", "%s", blockName);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedEffectUniformBuffer(effect, blockName);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetUniformBufferBlockName(CGparameter param)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetUniformBufferBlockName",&traceParam);

  if (!traceCg_Native.cgGetUniformBufferBlockName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetUniformBufferBlockName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetUniformBufferBlockName(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetFirstParameter(CGprogram program, CGenum name_space)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstParameter",&traceParam);

  if (!traceCg_Native.cgGetFirstParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("name_space", "%lu", name_space);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstParameter(program, name_space);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNextParameter(CGparameter current)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextParameter",&traceParam);

  if (!traceCg_Native.cgGetNextParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("current", "%zu", (size_t) current);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextParameter(current);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetFirstLeafParameter(CGprogram program, CGenum name_space)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstLeafParameter",&traceParam);

  if (!traceCg_Native.cgGetFirstLeafParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstLeafParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("name_space", "%lu", name_space);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstLeafParameter(program, name_space);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNextLeafParameter(CGparameter current)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextLeafParameter",&traceParam);

  if (!traceCg_Native.cgGetNextLeafParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextLeafParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("current", "%zu", (size_t) current);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextLeafParameter(current);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetFirstStructParameter(CGparameter param)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstStructParameter",&traceParam);

  if (!traceCg_Native.cgGetFirstStructParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstStructParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstStructParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetFirstUniformBufferParameter(CGparameter param)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstUniformBufferParameter",&traceParam);

  if (!traceCg_Native.cgGetFirstUniformBufferParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstUniformBufferParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstUniformBufferParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNamedStructParameter(CGparameter param, const char *name)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedStructParameter",&traceParam);

  if (!traceCg_Native.cgGetNamedStructParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedStructParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedStructParameter(param, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNamedUniformBufferParameter(CGparameter param, const char *name)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedUniformBufferParameter",&traceParam);

  if (!traceCg_Native.cgGetNamedUniformBufferParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedUniformBufferParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedUniformBufferParameter(param, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetFirstDependentParameter(CGparameter param)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstDependentParameter",&traceParam);

  if (!traceCg_Native.cgGetFirstDependentParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstDependentParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstDependentParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetArrayParameter(CGparameter aparam, int index)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetArrayParameter",&traceParam);

  if (!traceCg_Native.cgGetArrayParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetArrayParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("aparam", "%zu", (size_t) aparam);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetArrayParameter(aparam, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetArrayDimension(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetArrayDimension",&traceParam);

  if (!traceCg_Native.cgGetArrayDimension)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetArrayDimension");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetArrayDimension(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetArrayType(CGparameter param)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetArrayType",&traceParam);

  if (!traceCg_Native.cgGetArrayType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetArrayType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetArrayType(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetArraySize(CGparameter param, int dimension)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetArraySize",&traceParam);

  if (!traceCg_Native.cgGetArraySize)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetArraySize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("dimension", "%d", dimension);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetArraySize(param, dimension);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetArrayTotalSize(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetArrayTotalSize",&traceParam);

  if (!traceCg_Native.cgGetArrayTotalSize)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetArrayTotalSize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetArrayTotalSize(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetArraySize(CGparameter param, int size)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetArraySize",&traceParam);

  if (!traceCg_Native.cgSetArraySize)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetArraySize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("size", "%d", size);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetArraySize(param, size);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetMultiDimArraySize(CGparameter param, const int *sizes)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetMultiDimArraySize",&traceParam);

  if (!traceCg_Native.cgSetMultiDimArraySize)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetMultiDimArraySize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("sizes", "%d[%ld]", sizes, (traceCg_helperCgGetArrayDimSize ? traceCg_helperCgGetArrayDimSize(param) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetMultiDimArraySize(param, sizes);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGprogram
cgGetParameterProgram(CGparameter param)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterProgram",&traceParam);

  if (!traceCg_Native.cgGetParameterProgram)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterProgram(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGcontext
cgGetParameterContext(CGparameter param)
{
  CGcontext ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterContext",&traceParam);

  if (!traceCg_Native.cgGetParameterContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterContext(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsParameter(CGparameter param)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsParameter",&traceParam);

  if (!traceCg_Native.cgIsParameter)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetParameterName(CGparameter param)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterName",&traceParam);

  if (!traceCg_Native.cgGetParameterName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterName(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetParameterType(CGparameter param)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterType",&traceParam);

  if (!traceCg_Native.cgGetParameterType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterType(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetParameterBaseType(CGparameter param)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterBaseType",&traceParam);

  if (!traceCg_Native.cgGetParameterBaseType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterBaseType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterBaseType(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameterclass
cgGetParameterClass(CGparameter param)
{
  CGparameterclass ret = (CGparameterclass) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterClass",&traceParam);

  if (!traceCg_Native.cgGetParameterClass)
    return (CGparameterclass) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterClass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterClass(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterRows(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterRows",&traceParam);

  if (!traceCg_Native.cgGetParameterRows)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterRows");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterRows(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterColumns(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterColumns",&traceParam);

  if (!traceCg_Native.cgGetParameterColumns)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterColumns");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterColumns(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetParameterNamedType(CGparameter param)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterNamedType",&traceParam);

  if (!traceCg_Native.cgGetParameterNamedType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterNamedType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterNamedType(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetParameterSemantic(CGparameter param)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterSemantic",&traceParam);

  if (!traceCg_Native.cgGetParameterSemantic)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterSemantic");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterSemantic(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGresource
cgGetParameterResource(CGparameter param)
{
  CGresource ret = (CGresource) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterResource",&traceParam);

  if (!traceCg_Native.cgGetParameterResource)
    return (CGresource) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterResource");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterResource(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGresource
cgGetParameterBaseResource(CGparameter param)
{
  CGresource ret = (CGresource) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterBaseResource",&traceParam);

  if (!traceCg_Native.cgGetParameterBaseResource)
    return (CGresource) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterBaseResource");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterBaseResource(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT unsigned long
cgGetParameterResourceIndex(CGparameter param)
{
  unsigned long ret = (unsigned long) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterResourceIndex",&traceParam);

  if (!traceCg_Native.cgGetParameterResourceIndex)
    return (unsigned long) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterResourceIndex");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterResourceIndex(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGenum
cgGetParameterVariability(CGparameter param)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterVariability",&traceParam);

  if (!traceCg_Native.cgGetParameterVariability)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterVariability");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterVariability(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGenum
cgGetParameterDirection(CGparameter param)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterDirection",&traceParam);

  if (!traceCg_Native.cgGetParameterDirection)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterDirection");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterDirection(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsParameterReferenced(CGparameter param)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsParameterReferenced",&traceParam);

  if (!traceCg_Native.cgIsParameterReferenced)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsParameterReferenced");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsParameterReferenced(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsParameterUsed(CGparameter param, CGhandle handle)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsParameterUsed",&traceParam);

  if (!traceCg_Native.cgIsParameterUsed)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsParameterUsed");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("handle", "%zu", (size_t) handle);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsParameterUsed(param, handle);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const double *
cgGetParameterValues(CGparameter param, CGenum value_type, int *nvalues)
{
  const double *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterValues",&traceParam);

  if (!traceCg_Native.cgGetParameterValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("value_type", "%lu", value_type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterValues(param, value_type, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%lf[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetParameterValuedr(CGparameter param, int nelements, const double *vals)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterValuedr",&traceParam);

  if (!traceCg_Native.cgSetParameterValuedr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterValuedr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
      traceInputParameter("vals", "%lf[%d]", vals, nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterValuedr(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameterValuedc(CGparameter param, int nelements, const double *vals)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterValuedc",&traceParam);

  if (!traceCg_Native.cgSetParameterValuedc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterValuedc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
      traceInputParameter("vals", "%lf[%d]", vals, nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterValuedc(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameterValuefr(CGparameter param, int nelements, const float *vals)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterValuefr",&traceParam);

  if (!traceCg_Native.cgSetParameterValuefr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterValuefr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
      traceInputParameter("vals", "%f[%d]", vals, nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterValuefr(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameterValuefc(CGparameter param, int nelements, const float *vals)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterValuefc",&traceParam);

  if (!traceCg_Native.cgSetParameterValuefc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterValuefc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
      traceInputParameter("vals", "%f[%d]", vals, nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterValuefc(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameterValueir(CGparameter param, int nelements, const int *vals)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterValueir",&traceParam);

  if (!traceCg_Native.cgSetParameterValueir)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterValueir");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
      traceInputParameter("vals", "%d[%d]", vals, nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterValueir(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameterValueic(CGparameter param, int nelements, const int *vals)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterValueic",&traceParam);

  if (!traceCg_Native.cgSetParameterValueic)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterValueic");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
      traceInputParameter("vals", "%d[%d]", vals, nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterValueic(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT int
cgGetParameterValuedr(CGparameter param, int nelements, double *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterValuedr",&traceParam);

  if (!traceCg_Native.cgGetParameterValuedr)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterValuedr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterValuedr(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%lf[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterValuedc(CGparameter param, int nelements, double *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterValuedc",&traceParam);

  if (!traceCg_Native.cgGetParameterValuedc)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterValuedc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterValuedc(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%lf[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterValuefr(CGparameter param, int nelements, float *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterValuefr",&traceParam);

  if (!traceCg_Native.cgGetParameterValuefr)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterValuefr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterValuefr(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%f[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterValuefc(CGparameter param, int nelements, float *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterValuefc",&traceParam);

  if (!traceCg_Native.cgGetParameterValuefc)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterValuefc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterValuefc(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%f[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterValueir(CGparameter param, int nelements, int *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterValueir",&traceParam);

  if (!traceCg_Native.cgGetParameterValueir)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterValueir");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterValueir(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%d[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterValueic(CGparameter param, int nelements, int *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterValueic",&traceParam);

  if (!traceCg_Native.cgGetParameterValueic)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterValueic");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterValueic(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%d[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterDefaultValuedr(CGparameter param, int nelements, double *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterDefaultValuedr",&traceParam);

  if (!traceCg_Native.cgGetParameterDefaultValuedr)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterDefaultValuedr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterDefaultValuedr(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%lf[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterDefaultValuedc(CGparameter param, int nelements, double *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterDefaultValuedc",&traceParam);

  if (!traceCg_Native.cgGetParameterDefaultValuedc)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterDefaultValuedc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterDefaultValuedc(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%lf[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterDefaultValuefr(CGparameter param, int nelements, float *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterDefaultValuefr",&traceParam);

  if (!traceCg_Native.cgGetParameterDefaultValuefr)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterDefaultValuefr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterDefaultValuefr(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%f[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterDefaultValuefc(CGparameter param, int nelements, float *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterDefaultValuefc",&traceParam);

  if (!traceCg_Native.cgGetParameterDefaultValuefc)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterDefaultValuefc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterDefaultValuefc(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%f[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterDefaultValueir(CGparameter param, int nelements, int *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterDefaultValueir",&traceParam);

  if (!traceCg_Native.cgGetParameterDefaultValueir)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterDefaultValueir");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterDefaultValueir(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%d[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterDefaultValueic(CGparameter param, int nelements, int *vals)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterDefaultValueic",&traceParam);

  if (!traceCg_Native.cgGetParameterDefaultValueic)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterDefaultValueic");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterDefaultValueic(param, nelements, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("vals", "%d[%d]", vals, ret);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetStringParameterValue(CGparameter param)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStringParameterValue",&traceParam);

  if (!traceCg_Native.cgGetStringParameterValue)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStringParameterValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStringParameterValue(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetStringParameterValue(CGparameter param, const char *str)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetStringParameterValue",&traceParam);

  if (!traceCg_Native.cgSetStringParameterValue)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetStringParameterValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("str", "%s", str);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetStringParameterValue(param, str);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT int
cgGetParameterOrdinalNumber(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterOrdinalNumber",&traceParam);

  if (!traceCg_Native.cgGetParameterOrdinalNumber)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterOrdinalNumber");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterOrdinalNumber(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsParameterGlobal(CGparameter param)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsParameterGlobal",&traceParam);

  if (!traceCg_Native.cgIsParameterGlobal)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsParameterGlobal");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsParameterGlobal(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterIndex(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterIndex",&traceParam);

  if (!traceCg_Native.cgGetParameterIndex)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterIndex");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterIndex(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetParameterVariability(CGparameter param, CGenum vary)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterVariability",&traceParam);

  if (!traceCg_Native.cgSetParameterVariability)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterVariability");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("vary", "%lu", vary);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterVariability(param, vary);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameterSemantic(CGparameter param, const char *semantic)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameterSemantic",&traceParam);

  if (!traceCg_Native.cgSetParameterSemantic)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameterSemantic");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("semantic", "%s", semantic);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameterSemantic(param, semantic);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter1f(CGparameter param, float x)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter1f",&traceParam);

  if (!traceCg_Native.cgSetParameter1f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter1f");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%f", x);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter1f(param, x);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter2f(CGparameter param, float x, float y)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter2f",&traceParam);

  if (!traceCg_Native.cgSetParameter2f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter2f");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%f", x);
      traceInputParameter("y", "%f", y);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter2f(param, x, y);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter3f(CGparameter param, float x, float y, float z)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter3f",&traceParam);

  if (!traceCg_Native.cgSetParameter3f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter3f");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%f", x);
      traceInputParameter("y", "%f", y);
      traceInputParameter("z", "%f", z);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter3f(param, x, y, z);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter4f(CGparameter param, float x, float y, float z, float w)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter4f",&traceParam);

  if (!traceCg_Native.cgSetParameter4f)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter4f");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%f", x);
      traceInputParameter("y", "%f", y);
      traceInputParameter("z", "%f", z);
      traceInputParameter("w", "%f", w);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter4f(param, x, y, z, w);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter1d(CGparameter param, double x)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter1d",&traceParam);

  if (!traceCg_Native.cgSetParameter1d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter1d");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%lf", x);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter1d(param, x);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter2d(CGparameter param, double x, double y)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter2d",&traceParam);

  if (!traceCg_Native.cgSetParameter2d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter2d");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%lf", x);
      traceInputParameter("y", "%lf", y);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter2d(param, x, y);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter3d(CGparameter param, double x, double y, double z)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter3d",&traceParam);

  if (!traceCg_Native.cgSetParameter3d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter3d");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%lf", x);
      traceInputParameter("y", "%lf", y);
      traceInputParameter("z", "%lf", z);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter3d(param, x, y, z);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter4d(CGparameter param, double x, double y, double z, double w)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter4d",&traceParam);

  if (!traceCg_Native.cgSetParameter4d)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter4d");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%lf", x);
      traceInputParameter("y", "%lf", y);
      traceInputParameter("z", "%lf", z);
      traceInputParameter("w", "%lf", w);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter4d(param, x, y, z, w);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter1i(CGparameter param, int x)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter1i",&traceParam);

  if (!traceCg_Native.cgSetParameter1i)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter1i");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%d", x);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter1i(param, x);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter2i(CGparameter param, int x, int y)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter2i",&traceParam);

  if (!traceCg_Native.cgSetParameter2i)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter2i");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%d", x);
      traceInputParameter("y", "%d", y);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter2i(param, x, y);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter3i(CGparameter param, int x, int y, int z)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter3i",&traceParam);

  if (!traceCg_Native.cgSetParameter3i)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter3i");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%d", x);
      traceInputParameter("y", "%d", y);
      traceInputParameter("z", "%d", z);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter3i(param, x, y, z);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter4i(CGparameter param, int x, int y, int z, int w)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter4i",&traceParam);

  if (!traceCg_Native.cgSetParameter4i)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter4i");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("x", "%d", x);
      traceInputParameter("y", "%d", y);
      traceInputParameter("z", "%d", z);
      traceInputParameter("w", "%d", w);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter4i(param, x, y, z, w);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter1iv(CGparameter param, const int *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter1iv",&traceParam);

  if (!traceCg_Native.cgSetParameter1iv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter1iv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%d[%d]", v, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter1iv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter2iv(CGparameter param, const int *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter2iv",&traceParam);

  if (!traceCg_Native.cgSetParameter2iv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter2iv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%d[%d]", v, 2);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter2iv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter3iv(CGparameter param, const int *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter3iv",&traceParam);

  if (!traceCg_Native.cgSetParameter3iv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter3iv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%d[%d]", v, 3);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter3iv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter4iv(CGparameter param, const int *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter4iv",&traceParam);

  if (!traceCg_Native.cgSetParameter4iv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter4iv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%d[%d]", v, 4);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter4iv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter1fv(CGparameter param, const float *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter1fv",&traceParam);

  if (!traceCg_Native.cgSetParameter1fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter1fv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%f[%d]", v, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter1fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter2fv(CGparameter param, const float *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter2fv",&traceParam);

  if (!traceCg_Native.cgSetParameter2fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter2fv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%f[%d]", v, 2);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter2fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter3fv(CGparameter param, const float *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter3fv",&traceParam);

  if (!traceCg_Native.cgSetParameter3fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter3fv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%f[%d]", v, 3);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter3fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter4fv(CGparameter param, const float *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter4fv",&traceParam);

  if (!traceCg_Native.cgSetParameter4fv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter4fv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%f[%d]", v, 4);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter4fv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter1dv(CGparameter param, const double *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter1dv",&traceParam);

  if (!traceCg_Native.cgSetParameter1dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter1dv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%lf[%d]", v, 1);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter1dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter2dv(CGparameter param, const double *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter2dv",&traceParam);

  if (!traceCg_Native.cgSetParameter2dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter2dv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%lf[%d]", v, 2);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter2dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter3dv(CGparameter param, const double *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter3dv",&traceParam);

  if (!traceCg_Native.cgSetParameter3dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter3dv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%lf[%d]", v, 3);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter3dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetParameter4dv(CGparameter param, const double *v)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetParameter4dv",&traceParam);

  if (!traceCg_Native.cgSetParameter4dv)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetParameter4dv");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("v", "%lf[%d]", v, 4);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetParameter4dv(param, v);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetMatrixParameterir(CGparameter param, const int *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetMatrixParameterir",&traceParam);

  if (!traceCg_Native.cgSetMatrixParameterir)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetMatrixParameterir");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("matrix", "%d[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetMatrixParameterir(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetMatrixParameterdr(CGparameter param, const double *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetMatrixParameterdr",&traceParam);

  if (!traceCg_Native.cgSetMatrixParameterdr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetMatrixParameterdr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("matrix", "%lf[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetMatrixParameterdr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetMatrixParameterfr(CGparameter param, const float *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetMatrixParameterfr",&traceParam);

  if (!traceCg_Native.cgSetMatrixParameterfr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetMatrixParameterfr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("matrix", "%f[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetMatrixParameterfr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetMatrixParameteric(CGparameter param, const int *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetMatrixParameteric",&traceParam);

  if (!traceCg_Native.cgSetMatrixParameteric)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetMatrixParameteric");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("matrix", "%d[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetMatrixParameteric(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetMatrixParameterdc(CGparameter param, const double *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetMatrixParameterdc",&traceParam);

  if (!traceCg_Native.cgSetMatrixParameterdc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetMatrixParameterdc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("matrix", "%lf[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetMatrixParameterdc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetMatrixParameterfc(CGparameter param, const float *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetMatrixParameterfc",&traceParam);

  if (!traceCg_Native.cgSetMatrixParameterfc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetMatrixParameterfc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("matrix", "%f[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetMatrixParameterfc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGetMatrixParameterir(CGparameter param, int *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixParameterir",&traceParam);

  if (!traceCg_Native.cgGetMatrixParameterir)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixParameterir");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgGetMatrixParameterir(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("matrix", "%d[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGetMatrixParameterdr(CGparameter param, double *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixParameterdr",&traceParam);

  if (!traceCg_Native.cgGetMatrixParameterdr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixParameterdr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgGetMatrixParameterdr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("matrix", "%lf[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGetMatrixParameterfr(CGparameter param, float *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixParameterfr",&traceParam);

  if (!traceCg_Native.cgGetMatrixParameterfr)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixParameterfr");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgGetMatrixParameterfr(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("matrix", "%f[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGetMatrixParameteric(CGparameter param, int *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixParameteric",&traceParam);

  if (!traceCg_Native.cgGetMatrixParameteric)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixParameteric");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgGetMatrixParameteric(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("matrix", "%d[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGetMatrixParameterdc(CGparameter param, double *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixParameterdc",&traceParam);

  if (!traceCg_Native.cgGetMatrixParameterdc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixParameterdc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgGetMatrixParameterdc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("matrix", "%lf[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgGetMatrixParameterfc(CGparameter param, float *matrix)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixParameterfc",&traceParam);

  if (!traceCg_Native.cgGetMatrixParameterfc)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixParameterfc");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgGetMatrixParameterfc(param, matrix);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("matrix", "%f[%ld]", matrix, (traceCg_helperCgGetMatrixParameterSize ? traceCg_helperCgGetMatrixParameterSize(param) : 0));

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGenum
cgGetMatrixParameterOrder(CGparameter param)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixParameterOrder",&traceParam);

  if (!traceCg_Native.cgGetMatrixParameterOrder)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixParameterOrder");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetMatrixParameterOrder(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetNamedSubParameter(CGparameter param, const char *name)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedSubParameter",&traceParam);

  if (!traceCg_Native.cgGetNamedSubParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedSubParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedSubParameter(param, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetTypeString(CGtype type)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetTypeString",&traceParam);

  if (!traceCg_Native.cgGetTypeString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetTypeString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type", "%lu", type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetTypeString(type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetType(const char *type_string)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetType",&traceParam);

  if (!traceCg_Native.cgGetType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type_string", "%s", type_string);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetType(type_string);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetNamedUserType(CGhandle handle, const char *name)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedUserType",&traceParam);

  if (!traceCg_Native.cgGetNamedUserType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedUserType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("handle", "%zu", (size_t) handle);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedUserType(handle, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumUserTypes(CGhandle handle)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumUserTypes",&traceParam);

  if (!traceCg_Native.cgGetNumUserTypes)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumUserTypes");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("handle", "%zu", (size_t) handle);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumUserTypes(handle);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetUserType(CGhandle handle, int index)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetUserType",&traceParam);

  if (!traceCg_Native.cgGetUserType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetUserType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("handle", "%zu", (size_t) handle);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetUserType(handle, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumParentTypes(CGtype type)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumParentTypes",&traceParam);

  if (!traceCg_Native.cgGetNumParentTypes)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumParentTypes");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type", "%lu", type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumParentTypes(type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetParentType(CGtype type, int index)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParentType",&traceParam);

  if (!traceCg_Native.cgGetParentType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParentType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("type", "%lu", type);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParentType(type, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsParentType(CGtype parent, CGtype child)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsParentType",&traceParam);

  if (!traceCg_Native.cgIsParentType)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsParentType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("parent", "%lu", parent);
      traceInputParameter("child", "%lu", child);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsParentType(parent, child);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsInterfaceType(CGtype type)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsInterfaceType",&traceParam);

  if (!traceCg_Native.cgIsInterfaceType)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsInterfaceType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type", "%lu", type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsInterfaceType(type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetResourceString(CGresource resource)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetResourceString",&traceParam);

  if (!traceCg_Native.cgGetResourceString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetResourceString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("resource", "%lu", resource);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetResourceString(resource);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGresource
cgGetResource(const char *resource_string)
{
  CGresource ret = (CGresource) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetResource",&traceParam);

  if (!traceCg_Native.cgGetResource)
    return (CGresource) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetResource");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("resource_string", "%s", resource_string);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetResource(resource_string);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetEnumString(CGenum en)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetEnumString",&traceParam);

  if (!traceCg_Native.cgGetEnumString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetEnumString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("en", "%lu", en);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetEnumString(en);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGenum
cgGetEnum(const char *enum_string)
{
  CGenum ret = (CGenum) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetEnum",&traceParam);

  if (!traceCg_Native.cgGetEnum)
    return (CGenum) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetEnum");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("enum_string", "%s", enum_string);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetEnum(enum_string);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetProfileString(CGprofile profile)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProfileString",&traceParam);

  if (!traceCg_Native.cgGetProfileString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProfileString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProfileString(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprofile
cgGetProfile(const char *profile_string)
{
  CGprofile ret = (CGprofile) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProfile",&traceParam);

  if (!traceCg_Native.cgGetProfile)
    return (CGprofile) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProfile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("profile_string", "%s", profile_string);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProfile(profile_string);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumSupportedProfiles()
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumSupportedProfiles",&traceParam);

  if (!traceCg_Native.cgGetNumSupportedProfiles)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumSupportedProfiles");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumSupportedProfiles();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprofile
cgGetSupportedProfile(int index)
{
  CGprofile ret = (CGprofile) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetSupportedProfile",&traceParam);

  if (!traceCg_Native.cgGetSupportedProfile)
    return (CGprofile) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetSupportedProfile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("index", "%d", index);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetSupportedProfile(index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsProfileSupported(CGprofile profile)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsProfileSupported",&traceParam);

  if (!traceCg_Native.cgIsProfileSupported)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsProfileSupported");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsProfileSupported(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgGetProfileProperty(CGprofile profile, CGenum query)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProfileProperty",&traceParam);

  if (!traceCg_Native.cgGetProfileProperty)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProfileProperty");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("profile", "%lu", profile);
      traceInputParameter("query", "%lu", query);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProfileProperty(profile, query);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetParameterClassString(CGparameterclass pc)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterClassString",&traceParam);

  if (!traceCg_Native.cgGetParameterClassString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterClassString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pc", "%lu", pc);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterClassString(pc);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameterclass
cgGetParameterClassEnum(const char *pString)
{
  CGparameterclass ret = (CGparameterclass) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterClassEnum",&traceParam);

  if (!traceCg_Native.cgGetParameterClassEnum)
    return (CGparameterclass) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterClassEnum");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pString", "%s", pString);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterClassEnum(pString);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetDomainString(CGdomain domain)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetDomainString",&traceParam);

  if (!traceCg_Native.cgGetDomainString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetDomainString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("domain", "%lu", domain);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetDomainString(domain);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGdomain
cgGetDomain(const char *domain_string)
{
  CGdomain ret = (CGdomain) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetDomain",&traceParam);

  if (!traceCg_Native.cgGetDomain)
    return (CGdomain) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetDomain");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("domain_string", "%s", domain_string);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetDomain(domain_string);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGdomain
cgGetProgramDomain(CGprogram program)
{
  CGdomain ret = (CGdomain) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramDomain",&traceParam);

  if (!traceCg_Native.cgGetProgramDomain)
    return (CGdomain) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramDomain");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramDomain(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGerror
cgGetError()
{
  CGerror ret = (CGerror) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetError",&traceParam);

  if (!traceCg_Native.cgGetError)
    return (CGerror) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetError");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetError();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGerror
cgGetFirstError()
{
  CGerror ret = (CGerror) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstError",&traceParam);

  if (!traceCg_Native.cgGetFirstError)
    return (CGerror) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstError");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstError();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetErrorString(CGerror error)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetErrorString",&traceParam);

  if (!traceCg_Native.cgGetErrorString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetErrorString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("error", "%lu", error);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetErrorString(error);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetLastErrorString(CGerror *error)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetLastErrorString",&traceParam);

  if (!traceCg_Native.cgGetLastErrorString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetLastErrorString");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetLastErrorString(error);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetErrorCallback(CGerrorCallbackFunc func)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetErrorCallback",&traceParam);

  if (!traceCg_Native.cgSetErrorCallback)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetErrorCallback");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetErrorCallback(func);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGerrorCallbackFunc
cgGetErrorCallback()
{
  CGerrorCallbackFunc ret = (CGerrorCallbackFunc) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetErrorCallback",&traceParam);

  if (!traceCg_Native.cgGetErrorCallback)
    return (CGerrorCallbackFunc) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetErrorCallback");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetErrorCallback();

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetErrorHandler(CGerrorHandlerFunc func, void *data)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetErrorHandler",&traceParam);

  if (!traceCg_Native.cgSetErrorHandler)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetErrorHandler");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("data", "%p", data);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetErrorHandler(func, data);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGerrorHandlerFunc
cgGetErrorHandler(void **data)
{
  CGerrorHandlerFunc ret = (CGerrorHandlerFunc) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetErrorHandler",&traceParam);

  if (!traceCg_Native.cgGetErrorHandler)
    return (CGerrorHandlerFunc) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetErrorHandler");
    traceBegin();

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetErrorHandler(data);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetString(CGenum sname)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetString",&traceParam);

  if (!traceCg_Native.cgGetString)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetString");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sname", "%lu", sname);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetString(sname);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgCreateEffect(CGcontext context, const char *code, const char **args)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateEffect",&traceParam);

  if (!traceCg_Native.cgCreateEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("code", "%s", code);
      traceInputParameter("args", "%s[]", args);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateEffect(context, code, args);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgCreateEffectFromFile(CGcontext context, const char *filename, const char **args)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateEffectFromFile",&traceParam);

  if (!traceCg_Native.cgCreateEffectFromFile)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateEffectFromFile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("filename", "%s", filename);
      traceInputParameter("args", "%s[]", args);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateEffectFromFile(context, filename, args);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgCopyEffect(CGeffect effect)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCopyEffect",&traceParam);

  if (!traceCg_Native.cgCopyEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCopyEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCopyEffect(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgDestroyEffect(CGeffect effect)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgDestroyEffect",&traceParam);

  if (!traceCg_Native.cgDestroyEffect)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgDestroyEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgDestroyEffect(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGcontext
cgGetEffectContext(CGeffect effect)
{
  CGcontext ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetEffectContext",&traceParam);

  if (!traceCg_Native.cgGetEffectContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetEffectContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetEffectContext(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsEffect(CGeffect effect)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsEffect",&traceParam);

  if (!traceCg_Native.cgIsEffect)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsEffect(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgGetFirstEffect(CGcontext context)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstEffect",&traceParam);

  if (!traceCg_Native.cgGetFirstEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstEffect(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgGetNextEffect(CGeffect effect)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextEffect",&traceParam);

  if (!traceCg_Native.cgGetNextEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextEffect(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCreateProgramFromEffect(CGeffect effect, CGprofile profile, const char *entry, const char **args)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateProgramFromEffect",&traceParam);

  if (!traceCg_Native.cgCreateProgramFromEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateProgramFromEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("profile", "%lu", profile);
      traceInputParameter("entry", "%s", entry);
      traceInputParameter("args", "%s[]", args);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateProgramFromEffect(effect, profile, entry, args);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtechnique
cgGetFirstTechnique(CGeffect effect)
{
  CGtechnique ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstTechnique",&traceParam);

  if (!traceCg_Native.cgGetFirstTechnique)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstTechnique");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstTechnique(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtechnique
cgGetNextTechnique(CGtechnique tech)
{
  CGtechnique ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextTechnique",&traceParam);

  if (!traceCg_Native.cgGetNextTechnique)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextTechnique");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextTechnique(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtechnique
cgGetNamedTechnique(CGeffect effect, const char *name)
{
  CGtechnique ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedTechnique",&traceParam);

  if (!traceCg_Native.cgGetNamedTechnique)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedTechnique");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedTechnique(effect, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetTechniqueName(CGtechnique tech)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetTechniqueName",&traceParam);

  if (!traceCg_Native.cgGetTechniqueName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetTechniqueName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetTechniqueName(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsTechnique(CGtechnique tech)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsTechnique",&traceParam);

  if (!traceCg_Native.cgIsTechnique)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsTechnique");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsTechnique(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgValidateTechnique(CGtechnique tech)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgValidateTechnique",&traceParam);

  if (!traceCg_Native.cgValidateTechnique)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgValidateTechnique");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgValidateTechnique(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsTechniqueValidated(CGtechnique tech)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsTechniqueValidated",&traceParam);

  if (!traceCg_Native.cgIsTechniqueValidated)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsTechniqueValidated");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsTechniqueValidated(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgGetTechniqueEffect(CGtechnique tech)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetTechniqueEffect",&traceParam);

  if (!traceCg_Native.cgGetTechniqueEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetTechniqueEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetTechniqueEffect(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGpass
cgGetFirstPass(CGtechnique tech)
{
  CGpass ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstPass",&traceParam);

  if (!traceCg_Native.cgGetFirstPass)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstPass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstPass(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGpass
cgGetNamedPass(CGtechnique tech, const char *name)
{
  CGpass ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedPass",&traceParam);

  if (!traceCg_Native.cgGetNamedPass)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedPass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("tech", "%zu", (size_t) tech);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedPass(tech, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGpass
cgGetNextPass(CGpass pass)
{
  CGpass ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextPass",&traceParam);

  if (!traceCg_Native.cgGetNextPass)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextPass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextPass(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsPass(CGpass pass)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsPass",&traceParam);

  if (!traceCg_Native.cgIsPass)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsPass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsPass(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetPassName(CGpass pass)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetPassName",&traceParam);

  if (!traceCg_Native.cgGetPassName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetPassName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetPassName(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtechnique
cgGetPassTechnique(CGpass pass)
{
  CGtechnique ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetPassTechnique",&traceParam);

  if (!traceCg_Native.cgGetPassTechnique)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetPassTechnique");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetPassTechnique(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgGetPassProgram(CGpass pass, CGdomain domain)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetPassProgram",&traceParam);

  if (!traceCg_Native.cgGetPassProgram)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetPassProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pass", "%zu", (size_t) pass);
      traceInputParameter("domain", "%lu", domain);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetPassProgram(pass, domain);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetPassState(CGpass pass)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetPassState",&traceParam);

  if (!traceCg_Native.cgSetPassState)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetPassState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetPassState(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgResetPassState(CGpass pass)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgResetPassState",&traceParam);

  if (!traceCg_Native.cgResetPassState)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgResetPassState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgResetPassState(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGstateassignment
cgGetFirstStateAssignment(CGpass pass)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstStateAssignment",&traceParam);

  if (!traceCg_Native.cgGetFirstStateAssignment)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstStateAssignment(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstateassignment
cgGetNamedStateAssignment(CGpass pass, const char *name)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedStateAssignment",&traceParam);

  if (!traceCg_Native.cgGetNamedStateAssignment)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pass", "%zu", (size_t) pass);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedStateAssignment(pass, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstateassignment
cgGetNextStateAssignment(CGstateassignment sa)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextStateAssignment",&traceParam);

  if (!traceCg_Native.cgGetNextStateAssignment)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextStateAssignment(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsStateAssignment(CGstateassignment sa)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsStateAssignment",&traceParam);

  if (!traceCg_Native.cgIsStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsStateAssignment(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgCallStateSetCallback(CGstateassignment sa)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCallStateSetCallback",&traceParam);

  if (!traceCg_Native.cgCallStateSetCallback)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCallStateSetCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCallStateSetCallback(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgCallStateValidateCallback(CGstateassignment sa)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCallStateValidateCallback",&traceParam);

  if (!traceCg_Native.cgCallStateValidateCallback)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCallStateValidateCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCallStateValidateCallback(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgCallStateResetCallback(CGstateassignment sa)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCallStateResetCallback",&traceParam);

  if (!traceCg_Native.cgCallStateResetCallback)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCallStateResetCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCallStateResetCallback(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGpass
cgGetStateAssignmentPass(CGstateassignment sa)
{
  CGpass ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateAssignmentPass",&traceParam);

  if (!traceCg_Native.cgGetStateAssignmentPass)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateAssignmentPass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateAssignmentPass(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetSamplerStateAssignmentParameter(CGstateassignment sa)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetSamplerStateAssignmentParameter",&traceParam);

  if (!traceCg_Native.cgGetSamplerStateAssignmentParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetSamplerStateAssignmentParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetSamplerStateAssignmentParameter(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const float *
cgGetFloatStateAssignmentValues(CGstateassignment sa, int *nvalues)
{
  const float *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFloatStateAssignmentValues",&traceParam);

  if (!traceCg_Native.cgGetFloatStateAssignmentValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFloatStateAssignmentValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFloatStateAssignmentValues(sa, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%f[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const int *
cgGetIntStateAssignmentValues(CGstateassignment sa, int *nvalues)
{
  const int *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetIntStateAssignmentValues",&traceParam);

  if (!traceCg_Native.cgGetIntStateAssignmentValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetIntStateAssignmentValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetIntStateAssignmentValues(sa, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%d[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const CGbool *
cgGetBoolStateAssignmentValues(CGstateassignment sa, int *nvalues)
{
  const CGbool *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetBoolStateAssignmentValues",&traceParam);

  if (!traceCg_Native.cgGetBoolStateAssignmentValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetBoolStateAssignmentValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetBoolStateAssignmentValues(sa, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%d[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetStringStateAssignmentValue(CGstateassignment sa)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStringStateAssignmentValue",&traceParam);

  if (!traceCg_Native.cgGetStringStateAssignmentValue)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStringStateAssignmentValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStringStateAssignmentValue(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgGetProgramStateAssignmentValue(CGstateassignment sa)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramStateAssignmentValue",&traceParam);

  if (!traceCg_Native.cgGetProgramStateAssignmentValue)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramStateAssignmentValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramStateAssignmentValue(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetTextureStateAssignmentValue(CGstateassignment sa)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetTextureStateAssignmentValue",&traceParam);

  if (!traceCg_Native.cgGetTextureStateAssignmentValue)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetTextureStateAssignmentValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetTextureStateAssignmentValue(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetSamplerStateAssignmentValue(CGstateassignment sa)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetSamplerStateAssignmentValue",&traceParam);

  if (!traceCg_Native.cgGetSamplerStateAssignmentValue)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetSamplerStateAssignmentValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetSamplerStateAssignmentValue(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetStateAssignmentIndex(CGstateassignment sa)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateAssignmentIndex",&traceParam);

  if (!traceCg_Native.cgGetStateAssignmentIndex)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateAssignmentIndex");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateAssignmentIndex(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumDependentStateAssignmentParameters(CGstateassignment sa)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumDependentStateAssignmentParameters",&traceParam);

  if (!traceCg_Native.cgGetNumDependentStateAssignmentParameters)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumDependentStateAssignmentParameters");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumDependentStateAssignmentParameters(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetDependentStateAssignmentParameter(CGstateassignment sa, int index)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetDependentStateAssignmentParameter",&traceParam);

  if (!traceCg_Native.cgGetDependentStateAssignmentParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetDependentStateAssignmentParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetDependentStateAssignmentParameter(sa, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumDependentProgramArrayStateAssignmentParameters(CGstateassignment sa)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumDependentProgramArrayStateAssignmentParameters",&traceParam);

  if (!traceCg_Native.cgGetNumDependentProgramArrayStateAssignmentParameters)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumDependentProgramArrayStateAssignmentParameters");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumDependentProgramArrayStateAssignmentParameters(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetDependentProgramArrayStateAssignmentParameter(CGstateassignment sa, int index)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetDependentProgramArrayStateAssignmentParameter",&traceParam);

  if (!traceCg_Native.cgGetDependentProgramArrayStateAssignmentParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetDependentProgramArrayStateAssignmentParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetDependentProgramArrayStateAssignmentParameter(sa, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetConnectedStateAssignmentParameter(CGstateassignment sa)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetConnectedStateAssignmentParameter",&traceParam);

  if (!traceCg_Native.cgGetConnectedStateAssignmentParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetConnectedStateAssignmentParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetConnectedStateAssignmentParameter(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgGetStateAssignmentState(CGstateassignment sa)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateAssignmentState",&traceParam);

  if (!traceCg_Native.cgGetStateAssignmentState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateAssignmentState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateAssignmentState(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgGetSamplerStateAssignmentState(CGstateassignment sa)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetSamplerStateAssignmentState",&traceParam);

  if (!traceCg_Native.cgGetSamplerStateAssignmentState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetSamplerStateAssignmentState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetSamplerStateAssignmentState(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgCreateState(CGcontext context, const char *name, CGtype type)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateState",&traceParam);

  if (!traceCg_Native.cgCreateState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateState(context, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgCreateArrayState(CGcontext context, const char *name, CGtype type, int nelements)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateArrayState",&traceParam);

  if (!traceCg_Native.cgCreateArrayState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateArrayState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateArrayState(context, name, type, nelements);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetStateCallbacks(CGstate state, CGstatecallback set, CGstatecallback reset, CGstatecallback validate)
{
  int traceThis;
  int traceParam;

  /* Intercept input variable declaration. */

  CGstatecallback intercept_set = NULL;
  CGstatecallback intercept_reset = NULL;
  CGstatecallback intercept_validate = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetStateCallbacks",&traceParam);

  if (!traceCg_Native.cgSetStateCallbacks)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetStateCallbacks");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("state", "%zu", (size_t) state);
      traceInputParameter("set", "%p", (void *) set);
      traceInputParameter("reset", "%p", (void *) reset);
      traceInputParameter("validate", "%p", (void *) validate);
    }

  /* Intercept update. */

  updateCGstatecallback(&traceCg_state.StateSetMap, state, set);
  updateCGstatecallback(&traceCg_state.StateResetMap, state, reset);
  updateCGstatecallback(&traceCg_state.StateValidateMap, state, validate);

  /* Intercept input. */

  intercept_set = set ? &(cb_cgStateSet) : NULL;
  intercept_reset = reset ? &(cb_cgStateReset) : NULL;
  intercept_validate = validate ? &(cb_cgStateValidate) : NULL;

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetStateCallbacks(state, intercept_set, intercept_reset, intercept_validate);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetStateLatestProfile(CGstate state, CGprofile profile)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetStateLatestProfile",&traceParam);

  if (!traceCg_Native.cgSetStateLatestProfile)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetStateLatestProfile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("state", "%zu", (size_t) state);
      traceInputParameter("profile", "%lu", profile);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetStateLatestProfile(state, profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGstatecallback
cgGetStateSetCallback(CGstate state)
{
  CGstatecallback ret = NULL;
  int traceThis;
  int traceParam;

  /* Intercept output variable declaration. */

  CGstatecallback intercept_ret = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateSetCallback",&traceParam);

  if (!traceCg_Native.cgGetStateSetCallback)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateSetCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateSetCallback(state);

  /* Intercept output. */

  intercept_ret = lookupCGstatecallback(traceCg_state.StateSetMap, state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", (void *) intercept_ret);

    /* Trace function end. */

    traceEnd();
  }

  return intercept_ret;
}

DLLEXPORT CGstatecallback
cgGetStateResetCallback(CGstate state)
{
  CGstatecallback ret = NULL;
  int traceThis;
  int traceParam;

  /* Intercept output variable declaration. */

  CGstatecallback intercept_ret = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateResetCallback",&traceParam);

  if (!traceCg_Native.cgGetStateResetCallback)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateResetCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateResetCallback(state);

  /* Intercept output. */

  intercept_ret = lookupCGstatecallback(traceCg_state.StateResetMap, state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", (void *) intercept_ret);

    /* Trace function end. */

    traceEnd();
  }

  return intercept_ret;
}

DLLEXPORT CGstatecallback
cgGetStateValidateCallback(CGstate state)
{
  CGstatecallback ret = NULL;
  int traceThis;
  int traceParam;

  /* Intercept output variable declaration. */

  CGstatecallback intercept_ret = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateValidateCallback",&traceParam);

  if (!traceCg_Native.cgGetStateValidateCallback)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateValidateCallback");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateValidateCallback(state);

  /* Intercept output. */

  intercept_ret = lookupCGstatecallback(traceCg_state.StateValidateMap, state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%p", (void *) intercept_ret);

    /* Trace function end. */

    traceEnd();
  }

  return intercept_ret;
}

DLLEXPORT CGprofile
cgGetStateLatestProfile(CGstate state)
{
  CGprofile ret = (CGprofile) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateLatestProfile",&traceParam);

  if (!traceCg_Native.cgGetStateLatestProfile)
    return (CGprofile) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateLatestProfile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateLatestProfile(state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGcontext
cgGetStateContext(CGstate state)
{
  CGcontext ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateContext",&traceParam);

  if (!traceCg_Native.cgGetStateContext)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateContext");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateContext(state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetStateType(CGstate state)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateType",&traceParam);

  if (!traceCg_Native.cgGetStateType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateType(state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetStateName(CGstate state)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateName",&traceParam);

  if (!traceCg_Native.cgGetStateName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateName(state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgGetNamedState(CGcontext context, const char *name)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedState",&traceParam);

  if (!traceCg_Native.cgGetNamedState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedState(context, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgGetFirstState(CGcontext context)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstState",&traceParam);

  if (!traceCg_Native.cgGetFirstState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstState(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgGetNextState(CGstate state)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextState",&traceParam);

  if (!traceCg_Native.cgGetNextState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextState(state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsState(CGstate state)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsState",&traceParam);

  if (!traceCg_Native.cgIsState)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsState(state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgAddStateEnumerant(CGstate state, const char *name, int value)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgAddStateEnumerant",&traceParam);

  if (!traceCg_Native.cgAddStateEnumerant)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgAddStateEnumerant");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("state", "%zu", (size_t) state);
      traceInputParameter("name", "%s", name);
      traceInputParameter("value", "%d", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgAddStateEnumerant(state, name, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGstate
cgCreateSamplerState(CGcontext context, const char *name, CGtype type)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateSamplerState",&traceParam);

  if (!traceCg_Native.cgCreateSamplerState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateSamplerState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateSamplerState(context, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgCreateArraySamplerState(CGcontext context, const char *name, CGtype type, int nelements)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateArraySamplerState",&traceParam);

  if (!traceCg_Native.cgCreateArraySamplerState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateArraySamplerState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
      traceInputParameter("nelements", "%d", nelements);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateArraySamplerState(context, name, type, nelements);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgGetNamedSamplerState(CGcontext context, const char *name)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedSamplerState",&traceParam);

  if (!traceCg_Native.cgGetNamedSamplerState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedSamplerState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedSamplerState(context, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstate
cgGetFirstSamplerState(CGcontext context)
{
  CGstate ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstSamplerState",&traceParam);

  if (!traceCg_Native.cgGetFirstSamplerState)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstSamplerState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("context", "%zu", (size_t) context);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstSamplerState(context);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstateassignment
cgGetFirstSamplerStateAssignment(CGparameter param)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstSamplerStateAssignment",&traceParam);

  if (!traceCg_Native.cgGetFirstSamplerStateAssignment)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstSamplerStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstSamplerStateAssignment(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstateassignment
cgGetNamedSamplerStateAssignment(CGparameter param, const char *name)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedSamplerStateAssignment",&traceParam);

  if (!traceCg_Native.cgGetNamedSamplerStateAssignment)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedSamplerStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedSamplerStateAssignment(param, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetSamplerState(CGparameter param)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetSamplerState",&traceParam);

  if (!traceCg_Native.cgSetSamplerState)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetSamplerState");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetSamplerState(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGparameter
cgGetNamedEffectParameter(CGeffect effect, const char *name)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedEffectParameter",&traceParam);

  if (!traceCg_Native.cgGetNamedEffectParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedEffectParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedEffectParameter(effect, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetFirstLeafEffectParameter(CGeffect effect)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstLeafEffectParameter",&traceParam);

  if (!traceCg_Native.cgGetFirstLeafEffectParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstLeafEffectParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstLeafEffectParameter(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetFirstEffectParameter(CGeffect effect)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstEffectParameter",&traceParam);

  if (!traceCg_Native.cgGetFirstEffectParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstEffectParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstEffectParameter(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetEffectParameterBySemantic(CGeffect effect, const char *semantic)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetEffectParameterBySemantic",&traceParam);

  if (!traceCg_Native.cgGetEffectParameterBySemantic)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetEffectParameterBySemantic");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("semantic", "%s", semantic);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetEffectParameterBySemantic(effect, semantic);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetFirstTechniqueAnnotation(CGtechnique tech)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstTechniqueAnnotation",&traceParam);

  if (!traceCg_Native.cgGetFirstTechniqueAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstTechniqueAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("tech", "%zu", (size_t) tech);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstTechniqueAnnotation(tech);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetFirstPassAnnotation(CGpass pass)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstPassAnnotation",&traceParam);

  if (!traceCg_Native.cgGetFirstPassAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstPassAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("pass", "%zu", (size_t) pass);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstPassAnnotation(pass);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetFirstParameterAnnotation(CGparameter param)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstParameterAnnotation",&traceParam);

  if (!traceCg_Native.cgGetFirstParameterAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstParameterAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstParameterAnnotation(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetFirstProgramAnnotation(CGprogram program)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstProgramAnnotation",&traceParam);

  if (!traceCg_Native.cgGetFirstProgramAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstProgramAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstProgramAnnotation(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetFirstEffectAnnotation(CGeffect effect)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFirstEffectAnnotation",&traceParam);

  if (!traceCg_Native.cgGetFirstEffectAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFirstEffectAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFirstEffectAnnotation(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetNextAnnotation(CGannotation ann)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNextAnnotation",&traceParam);

  if (!traceCg_Native.cgGetNextAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNextAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNextAnnotation(ann);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetNamedTechniqueAnnotation(CGtechnique tech, const char *name)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedTechniqueAnnotation",&traceParam);

  if (!traceCg_Native.cgGetNamedTechniqueAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedTechniqueAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("tech", "%zu", (size_t) tech);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedTechniqueAnnotation(tech, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetNamedPassAnnotation(CGpass pass, const char *name)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedPassAnnotation",&traceParam);

  if (!traceCg_Native.cgGetNamedPassAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedPassAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pass", "%zu", (size_t) pass);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedPassAnnotation(pass, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetNamedParameterAnnotation(CGparameter param, const char *name)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedParameterAnnotation",&traceParam);

  if (!traceCg_Native.cgGetNamedParameterAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedParameterAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedParameterAnnotation(param, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetNamedProgramAnnotation(CGprogram program, const char *name)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedProgramAnnotation",&traceParam);

  if (!traceCg_Native.cgGetNamedProgramAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedProgramAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedProgramAnnotation(program, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgGetNamedEffectAnnotation(CGeffect effect, const char *name)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedEffectAnnotation",&traceParam);

  if (!traceCg_Native.cgGetNamedEffectAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedEffectAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedEffectAnnotation(effect, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsAnnotation(CGannotation ann)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsAnnotation",&traceParam);

  if (!traceCg_Native.cgIsAnnotation)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsAnnotation(ann);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetAnnotationName(CGannotation ann)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetAnnotationName",&traceParam);

  if (!traceCg_Native.cgGetAnnotationName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetAnnotationName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetAnnotationName(ann);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetAnnotationType(CGannotation ann)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetAnnotationType",&traceParam);

  if (!traceCg_Native.cgGetAnnotationType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetAnnotationType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetAnnotationType(ann);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const float *
cgGetFloatAnnotationValues(CGannotation ann, int *nvalues)
{
  const float *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetFloatAnnotationValues",&traceParam);

  if (!traceCg_Native.cgGetFloatAnnotationValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetFloatAnnotationValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetFloatAnnotationValues(ann, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%f[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const int *
cgGetIntAnnotationValues(CGannotation ann, int *nvalues)
{
  const int *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetIntAnnotationValues",&traceParam);

  if (!traceCg_Native.cgGetIntAnnotationValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetIntAnnotationValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetIntAnnotationValues(ann, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%d[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetStringAnnotationValue(CGannotation ann)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStringAnnotationValue",&traceParam);

  if (!traceCg_Native.cgGetStringAnnotationValue)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStringAnnotationValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStringAnnotationValue(ann);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char * const *
cgGetStringAnnotationValues(CGannotation ann, int *nvalues)
{
  const char * const *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStringAnnotationValues",&traceParam);

  if (!traceCg_Native.cgGetStringAnnotationValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStringAnnotationValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStringAnnotationValues(ann, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%s[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const CGbool *
cgGetBoolAnnotationValues(CGannotation ann, int *nvalues)
{
  const CGbool *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetBoolAnnotationValues",&traceParam);

  if (!traceCg_Native.cgGetBoolAnnotationValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetBoolAnnotationValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetBoolAnnotationValues(ann, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%d[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const int *
cgGetBooleanAnnotationValues(CGannotation ann, int *nvalues)
{
  const int *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetBooleanAnnotationValues",&traceParam);

  if (!traceCg_Native.cgGetBooleanAnnotationValues)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetBooleanAnnotationValues");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetBooleanAnnotationValues(ann, nvalues);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nvalues", "%d[%d]", nvalues, 1);
      traceReturn("%d[%d]", ret, (*nvalues));
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumDependentAnnotationParameters(CGannotation ann)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumDependentAnnotationParameters",&traceParam);

  if (!traceCg_Native.cgGetNumDependentAnnotationParameters)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumDependentAnnotationParameters");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("ann", "%zu", (size_t) ann);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumDependentAnnotationParameters(ann);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgGetDependentAnnotationParameter(CGannotation ann, int index)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetDependentAnnotationParameter",&traceParam);

  if (!traceCg_Native.cgGetDependentAnnotationParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetDependentAnnotationParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("ann", "%zu", (size_t) ann);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetDependentAnnotationParameter(ann, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgEvaluateProgram(CGprogram program, float *buf, int ncomps, int nx, int ny, int nz)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgEvaluateProgram",&traceParam);

  if (!traceCg_Native.cgEvaluateProgram)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgEvaluateProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("ncomps", "%d", ncomps);
      traceInputParameter("nx", "%d", nx);
      traceInputParameter("ny", "%d", ny);
      traceInputParameter("nz", "%d", nz);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgEvaluateProgram(program, buf, ncomps, nx, ny, nz);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceOutputParameter("buf", "%f[%d]", buf, ncomps * nx * ny * nz);

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbool
cgSetEffectName(CGeffect effect, const char *name)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetEffectName",&traceParam);

  if (!traceCg_Native.cgSetEffectName)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetEffectName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetEffectName(effect, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetEffectName(CGeffect effect)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetEffectName",&traceParam);

  if (!traceCg_Native.cgGetEffectName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetEffectName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("effect", "%zu", (size_t) effect);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetEffectName(effect);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgGetNamedEffect(CGcontext context, const char *name)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNamedEffect",&traceParam);

  if (!traceCg_Native.cgGetNamedEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNamedEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNamedEffect(context, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgCreateEffectParameter(CGeffect effect, const char *name, CGtype type)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateEffectParameter",&traceParam);

  if (!traceCg_Native.cgCreateEffectParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateEffectParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateEffectParameter(effect, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtechnique
cgCreateTechnique(CGeffect effect, const char *name)
{
  CGtechnique ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateTechnique",&traceParam);

  if (!traceCg_Native.cgCreateTechnique)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateTechnique");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateTechnique(effect, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgCreateEffectParameterArray(CGeffect effect, const char *name, CGtype type, int length)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateEffectParameterArray",&traceParam);

  if (!traceCg_Native.cgCreateEffectParameterArray)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateEffectParameterArray");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
      traceInputParameter("length", "%d", length);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateEffectParameterArray(effect, name, type, length);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameter
cgCreateEffectParameterMultiDimArray(CGeffect effect, const char *name, CGtype type, int dim, const int *lengths)
{
  CGparameter ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateEffectParameterMultiDimArray",&traceParam);

  if (!traceCg_Native.cgCreateEffectParameterMultiDimArray)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateEffectParameterMultiDimArray");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
      traceInputParameter("dim", "%d", dim);
      traceInputParameter("lengths", "%d[%d]", lengths, dim);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateEffectParameterMultiDimArray(effect, name, type, dim, lengths);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGpass
cgCreatePass(CGtechnique tech, const char *name)
{
  CGpass ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreatePass",&traceParam);

  if (!traceCg_Native.cgCreatePass)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreatePass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("tech", "%zu", (size_t) tech);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreatePass(tech, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstateassignment
cgCreateStateAssignment(CGpass pass, CGstate state)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateStateAssignment",&traceParam);

  if (!traceCg_Native.cgCreateStateAssignment)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pass", "%zu", (size_t) pass);
      traceInputParameter("state", "%zu", (size_t) state);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateStateAssignment(pass, state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstateassignment
cgCreateStateAssignmentIndex(CGpass pass, CGstate state, int index)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateStateAssignmentIndex",&traceParam);

  if (!traceCg_Native.cgCreateStateAssignmentIndex)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateStateAssignmentIndex");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pass", "%zu", (size_t) pass);
      traceInputParameter("state", "%zu", (size_t) state);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateStateAssignmentIndex(pass, state, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGstateassignment
cgCreateSamplerStateAssignment(CGparameter param, CGstate state)
{
  CGstateassignment ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateSamplerStateAssignment",&traceParam);

  if (!traceCg_Native.cgCreateSamplerStateAssignment)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateSamplerStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("state", "%zu", (size_t) state);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateSamplerStateAssignment(param, state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetFloatStateAssignment(CGstateassignment sa, float value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetFloatStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetFloatStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetFloatStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("value", "%f", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetFloatStateAssignment(sa, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetIntStateAssignment(CGstateassignment sa, int value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetIntStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetIntStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetIntStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("value", "%d", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetIntStateAssignment(sa, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetBoolStateAssignment(CGstateassignment sa, CGbool value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetBoolStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetBoolStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetBoolStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("value", "%d", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetBoolStateAssignment(sa, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetStringStateAssignment(CGstateassignment sa, const char *value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetStringStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetStringStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetStringStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("value", "%s", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetStringStateAssignment(sa, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetProgramStateAssignment(CGstateassignment sa, CGprogram program)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetProgramStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetProgramStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetProgramStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("program", "%zu", (size_t) program);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetProgramStateAssignment(sa, program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetSamplerStateAssignment(CGstateassignment sa, CGparameter param)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetSamplerStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetSamplerStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetSamplerStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("param", "%zu", (size_t) param);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetSamplerStateAssignment(sa, param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetTextureStateAssignment(CGstateassignment sa, CGparameter param)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetTextureStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetTextureStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetTextureStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("param", "%zu", (size_t) param);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetTextureStateAssignment(sa, param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetFloatArrayStateAssignment(CGstateassignment sa, const float *vals)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetFloatArrayStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetFloatArrayStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetFloatArrayStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("vals", "%f[%ld]", vals, (traceCg_helperCgGetArrayStateAssignmentSize ? traceCg_helperCgGetArrayStateAssignmentSize(sa) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetFloatArrayStateAssignment(sa, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetIntArrayStateAssignment(CGstateassignment sa, const int *vals)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetIntArrayStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetIntArrayStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetIntArrayStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("vals", "%d[%ld]", vals, (traceCg_helperCgGetArrayStateAssignmentSize ? traceCg_helperCgGetArrayStateAssignmentSize(sa) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetIntArrayStateAssignment(sa, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetBoolArrayStateAssignment(CGstateassignment sa, const CGbool *vals)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetBoolArrayStateAssignment",&traceParam);

  if (!traceCg_Native.cgSetBoolArrayStateAssignment)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetBoolArrayStateAssignment");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("sa", "%zu", (size_t) sa);
      traceInputParameter("vals", "%d[%ld]", vals, (traceCg_helperCgGetArrayStateAssignmentSize ? traceCg_helperCgGetArrayStateAssignmentSize(sa) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetBoolArrayStateAssignment(sa, vals);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgCreateTechniqueAnnotation(CGtechnique tech, const char *name, CGtype type)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateTechniqueAnnotation",&traceParam);

  if (!traceCg_Native.cgCreateTechniqueAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateTechniqueAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("tech", "%zu", (size_t) tech);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateTechniqueAnnotation(tech, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgCreatePassAnnotation(CGpass pass, const char *name, CGtype type)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreatePassAnnotation",&traceParam);

  if (!traceCg_Native.cgCreatePassAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreatePassAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("pass", "%zu", (size_t) pass);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreatePassAnnotation(pass, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgCreateParameterAnnotation(CGparameter param, const char *name, CGtype type)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateParameterAnnotation",&traceParam);

  if (!traceCg_Native.cgCreateParameterAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateParameterAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateParameterAnnotation(param, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgCreateProgramAnnotation(CGprogram program, const char *name, CGtype type)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateProgramAnnotation",&traceParam);

  if (!traceCg_Native.cgCreateProgramAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateProgramAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateProgramAnnotation(program, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGannotation
cgCreateEffectAnnotation(CGeffect effect, const char *name, CGtype type)
{
  CGannotation ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateEffectAnnotation",&traceParam);

  if (!traceCg_Native.cgCreateEffectAnnotation)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateEffectAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("effect", "%zu", (size_t) effect);
      traceInputParameter("name", "%s", name);
      traceInputParameter("type", "%lu", type);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateEffectAnnotation(effect, name, type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetIntAnnotation(CGannotation ann, int value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetIntAnnotation",&traceParam);

  if (!traceCg_Native.cgSetIntAnnotation)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetIntAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("ann", "%zu", (size_t) ann);
      traceInputParameter("value", "%d", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetIntAnnotation(ann, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetFloatAnnotation(CGannotation ann, float value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetFloatAnnotation",&traceParam);

  if (!traceCg_Native.cgSetFloatAnnotation)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetFloatAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("ann", "%zu", (size_t) ann);
      traceInputParameter("value", "%f", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetFloatAnnotation(ann, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetBoolAnnotation(CGannotation ann, CGbool value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetBoolAnnotation",&traceParam);

  if (!traceCg_Native.cgSetBoolAnnotation)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetBoolAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("ann", "%zu", (size_t) ann);
      traceInputParameter("value", "%d", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetBoolAnnotation(ann, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgSetStringAnnotation(CGannotation ann, const char *value)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetStringAnnotation",&traceParam);

  if (!traceCg_Native.cgSetStringAnnotation)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetStringAnnotation");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("ann", "%zu", (size_t) ann);
      traceInputParameter("value", "%s", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgSetStringAnnotation(ann, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetNumStateEnumerants(CGstate state)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumStateEnumerants",&traceParam);

  if (!traceCg_Native.cgGetNumStateEnumerants)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumStateEnumerants");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("state", "%zu", (size_t) state);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumStateEnumerants(state);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetStateEnumerant(CGstate state, int index, int *value)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateEnumerant",&traceParam);

  if (!traceCg_Native.cgGetStateEnumerant)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateEnumerant");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("state", "%zu", (size_t) state);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateEnumerant(state, index, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("value", "%d[%d]", value, 1);
      traceReturn("%s", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetStateEnumerantName(CGstate state, int value)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateEnumerantName",&traceParam);

  if (!traceCg_Native.cgGetStateEnumerantName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateEnumerantName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("state", "%zu", (size_t) state);
      traceInputParameter("value", "%d", value);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateEnumerantName(state, value);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetStateEnumerantValue(CGstate state, const char *name)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetStateEnumerantValue",&traceParam);

  if (!traceCg_Native.cgGetStateEnumerantValue)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetStateEnumerantValue");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("state", "%zu", (size_t) state);
      traceInputParameter("name", "%s", name);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetStateEnumerantValue(state, name);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGeffect
cgGetParameterEffect(CGparameter param)
{
  CGeffect ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterEffect",&traceParam);

  if (!traceCg_Native.cgGetParameterEffect)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterEffect");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterEffect(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGparameterclass
cgGetTypeClass(CGtype type)
{
  CGparameterclass ret = (CGparameterclass) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetTypeClass",&traceParam);

  if (!traceCg_Native.cgGetTypeClass)
    return (CGparameterclass) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetTypeClass");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type", "%lu", type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetTypeClass(type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetTypeBase(CGtype type)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetTypeBase",&traceParam);

  if (!traceCg_Native.cgGetTypeBase)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetTypeBase");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type", "%lu", type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetTypeBase(type);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgGetTypeSizes(CGtype type, int *nrows, int *ncols)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetTypeSizes",&traceParam);

  if (!traceCg_Native.cgGetTypeSizes)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetTypeSizes");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type", "%lu", type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetTypeSizes(type, nrows, ncols);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nrows", "%d[%d]", nrows, 1);
      traceOutputParameter("ncols", "%d[%d]", ncols, 1);
      traceReturn("%d", ret);
    }

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgGetMatrixSize(CGtype type, int *nrows, int *ncols)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetMatrixSize",&traceParam);

  if (!traceCg_Native.cgGetMatrixSize)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetMatrixSize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("type", "%lu", type);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgGetMatrixSize(type, nrows, ncols);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
    {
      traceOutputParameter("nrows", "%d[%d]", nrows, 1);
      traceOutputParameter("ncols", "%d[%d]", ncols, 1);
    }

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT int
cgGetNumProgramDomains(CGprogram program)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetNumProgramDomains",&traceParam);

  if (!traceCg_Native.cgGetNumProgramDomains)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetNumProgramDomains");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("program", "%zu", (size_t) program);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetNumProgramDomains(program);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGdomain
cgGetProfileDomain(CGprofile profile)
{
  CGdomain ret = (CGdomain) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProfileDomain",&traceParam);

  if (!traceCg_Native.cgGetProfileDomain)
    return (CGdomain) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProfileDomain");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProfileDomain(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprofile
cgGetProfileSibling(CGprofile profile, CGdomain domain)
{
  CGprofile ret = (CGprofile) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProfileSibling",&traceParam);

  if (!traceCg_Native.cgGetProfileSibling)
    return (CGprofile) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProfileSibling");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("profile", "%lu", profile);
      traceInputParameter("domain", "%lu", domain);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProfileSibling(profile, domain);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCombinePrograms(int n, const CGprogram *exeList)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCombinePrograms",&traceParam);

  if (!traceCg_Native.cgCombinePrograms)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCombinePrograms");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("n", "%d", n);
      traceInputParameter("exeList", "%zu[%d]", (const size_t *) exeList, n);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCombinePrograms(n, exeList);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCombinePrograms2(const CGprogram exe1, const CGprogram exe2)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCombinePrograms2",&traceParam);

  if (!traceCg_Native.cgCombinePrograms2)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCombinePrograms2");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("exe1", "%zu", (const size_t) exe1);
      traceInputParameter("exe2", "%zu", (const size_t) exe2);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCombinePrograms2(exe1, exe2);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCombinePrograms3(const CGprogram exe1, const CGprogram exe2, const CGprogram exe3)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCombinePrograms3",&traceParam);

  if (!traceCg_Native.cgCombinePrograms3)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCombinePrograms3");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("exe1", "%zu", (const size_t) exe1);
      traceInputParameter("exe2", "%zu", (const size_t) exe2);
      traceInputParameter("exe3", "%zu", (const size_t) exe3);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCombinePrograms3(exe1, exe2, exe3);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCombinePrograms4(const CGprogram exe1, const CGprogram exe2, const CGprogram exe3, const CGprogram exe4)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCombinePrograms4",&traceParam);

  if (!traceCg_Native.cgCombinePrograms4)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCombinePrograms4");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("exe1", "%zu", (const size_t) exe1);
      traceInputParameter("exe2", "%zu", (const size_t) exe2);
      traceInputParameter("exe3", "%zu", (const size_t) exe3);
      traceInputParameter("exe4", "%zu", (const size_t) exe4);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCombinePrograms4(exe1, exe2, exe3, exe4);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgCombinePrograms5(const CGprogram exe1, const CGprogram exe2, const CGprogram exe3, const CGprogram exe4, const CGprogram exe5)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCombinePrograms5",&traceParam);

  if (!traceCg_Native.cgCombinePrograms5)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCombinePrograms5");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("exe1", "%zu", (const size_t) exe1);
      traceInputParameter("exe2", "%zu", (const size_t) exe2);
      traceInputParameter("exe3", "%zu", (const size_t) exe3);
      traceInputParameter("exe4", "%zu", (const size_t) exe4);
      traceInputParameter("exe5", "%zu", (const size_t) exe5);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCombinePrograms5(exe1, exe2, exe3, exe4, exe5);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprofile
cgGetProgramDomainProfile(CGprogram program, int index)
{
  CGprofile ret = (CGprofile) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramDomainProfile",&traceParam);

  if (!traceCg_Native.cgGetProgramDomainProfile)
    return (CGprofile) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramDomainProfile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramDomainProfile(program, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGprogram
cgGetProgramDomainProgram(CGprogram program, int index)
{
  CGprogram ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramDomainProgram",&traceParam);

  if (!traceCg_Native.cgGetProgramDomainProgram)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramDomainProgram");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("index", "%d", index);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramDomainProgram(program, index);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGobj
cgCreateObj(CGcontext context, CGenum program_type, const char *source, CGprofile profile, const char **args)
{
  CGobj ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateObj",&traceParam);

  if (!traceCg_Native.cgCreateObj)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateObj");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("program_type", "%lu", program_type);
      traceInputParameter("source", "%s", source);
      traceInputParameter("profile", "%lu", profile);
      traceInputParameter("args", "%s[]", args);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateObj(context, program_type, source, profile, args);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGobj
cgCreateObjFromFile(CGcontext context, CGenum program_type, const char *source_file, CGprofile profile, const char **args)
{
  CGobj ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateObjFromFile",&traceParam);

  if (!traceCg_Native.cgCreateObjFromFile)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateObjFromFile");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("program_type", "%lu", program_type);
      traceInputParameter("source_file", "%s", source_file);
      traceInputParameter("profile", "%lu", profile);
      traceInputParameter("args", "%s[]", args);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateObjFromFile(context, program_type, source_file, profile, args);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgDestroyObj(CGobj obj)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgDestroyObj",&traceParam);

  if (!traceCg_Native.cgDestroyObj)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgDestroyObj");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("obj", "%zu", (size_t) obj);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgDestroyObj(obj);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT long
cgGetParameterResourceSize(CGparameter param)
{
  long ret = (long) 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterResourceSize",&traceParam);

  if (!traceCg_Native.cgGetParameterResourceSize)
    return (long) 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterResourceSize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterResourceSize(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%ld", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGtype
cgGetParameterResourceType(CGparameter param)
{
  CGtype ret = CG_UNKNOWN_TYPE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterResourceType",&traceParam);

  if (!traceCg_Native.cgGetParameterResourceType)
    return CG_UNKNOWN_TYPE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterResourceType");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterResourceType(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%lu", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT const char *
cgGetParameterResourceName(CGparameter param)
{
  const char *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterResourceName",&traceParam);

  if (!traceCg_Native.cgGetParameterResourceName)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterResourceName");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterResourceName(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%s", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterBufferIndex(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterBufferIndex",&traceParam);

  if (!traceCg_Native.cgGetParameterBufferIndex)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterBufferIndex");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterBufferIndex(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetParameterBufferOffset(CGparameter param)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetParameterBufferOffset",&traceParam);

  if (!traceCg_Native.cgGetParameterBufferOffset)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetParameterBufferOffset");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetParameterBufferOffset(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbuffer
cgCreateBuffer(CGcontext context, int size, const void *data, CGbufferusage bufferUsage)
{
  CGbuffer ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgCreateBuffer",&traceParam);

  if (!traceCg_Native.cgCreateBuffer)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgCreateBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("size", "%d", size);
      traceInputParameter("data", "%c[%ld]", data, (traceCg_helperCgCreateBufferSize ? traceCg_helperCgCreateBufferSize(size) : 0));
      traceInputParameter("bufferUsage", "%lu", bufferUsage);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgCreateBuffer(context, size, data, bufferUsage);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbool
cgIsBuffer(CGbuffer buffer)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgIsBuffer",&traceParam);

  if (!traceCg_Native.cgIsBuffer)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgIsBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("buffer", "%zu", (size_t) buffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgIsBuffer(buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetBufferData(CGbuffer buffer, int size, const void *data)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetBufferData",&traceParam);

  if (!traceCg_Native.cgSetBufferData)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetBufferData");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("buffer", "%zu", (size_t) buffer);
      traceInputParameter("size", "%d", size);
      traceInputParameter("data", "%c[%ld]", data, (traceCg_helperCgGetBufferSize ? traceCg_helperCgGetBufferSize(buffer, size) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetBufferData(buffer, size, data);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetBufferSubData(CGbuffer buffer, int offset, int size, const void *data)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetBufferSubData",&traceParam);

  if (!traceCg_Native.cgSetBufferSubData)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetBufferSubData");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("buffer", "%zu", (size_t) buffer);
      traceInputParameter("offset", "%d", offset);
      traceInputParameter("size", "%d", size);
      traceInputParameter("data", "%c[%ld]", data, (traceCg_helperCgCreateBufferSize ? traceCg_helperCgCreateBufferSize(size) : 0));
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetBufferSubData(buffer, offset, size, data);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetProgramBuffer(CGprogram program, int bufferIndex, CGbuffer buffer)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetProgramBuffer",&traceParam);

  if (!traceCg_Native.cgSetProgramBuffer)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetProgramBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("bufferIndex", "%d", bufferIndex);
      traceInputParameter("buffer", "%zu", (size_t) buffer);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetProgramBuffer(program, bufferIndex, buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgSetUniformBufferParameter(CGparameter param, CGbuffer buffer)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetUniformBufferParameter",&traceParam);

  if (!traceCg_Native.cgSetUniformBufferParameter)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetUniformBufferParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("buffer", "%zu", (size_t) buffer);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetUniformBufferParameter(param, buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void *
cgMapBuffer(CGbuffer buffer, CGbufferaccess access)
{
  void *ret = NULL;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgMapBuffer",&traceParam);

  if (!traceCg_Native.cgMapBuffer)
    return NULL;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgMapBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("buffer", "%zu", (size_t) buffer);
      traceInputParameter("access", "%lu", access);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgMapBuffer(buffer, access);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%c[%ld]", ret, (traceCg_helperCgGetBufferSize ? traceCg_helperCgGetBufferSize(buffer, 0) : 0));

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgUnmapBuffer(CGbuffer buffer)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgUnmapBuffer",&traceParam);

  if (!traceCg_Native.cgUnmapBuffer)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgUnmapBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("buffer", "%zu", (size_t) buffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgUnmapBuffer(buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT void
cgDestroyBuffer(CGbuffer buffer)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgDestroyBuffer",&traceParam);

  if (!traceCg_Native.cgDestroyBuffer)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgDestroyBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("buffer", "%zu", (size_t) buffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgDestroyBuffer(buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

DLLEXPORT CGbuffer
cgGetProgramBuffer(CGprogram program, int bufferIndex)
{
  CGbuffer ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramBuffer",&traceParam);

  if (!traceCg_Native.cgGetProgramBuffer)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("program", "%zu", (size_t) program);
      traceInputParameter("bufferIndex", "%d", bufferIndex);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramBuffer(program, bufferIndex);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbuffer
cgGetUniformBufferParameter(CGparameter param)
{
  CGbuffer ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetUniformBufferParameter",&traceParam);

  if (!traceCg_Native.cgGetUniformBufferParameter)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetUniformBufferParameter");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetUniformBufferParameter(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetBufferSize(CGbuffer buffer)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetBufferSize",&traceParam);

  if (!traceCg_Native.cgGetBufferSize)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetBufferSize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("buffer", "%zu", (size_t) buffer);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetBufferSize(buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetProgramBufferMaxSize(CGprofile profile)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramBufferMaxSize",&traceParam);

  if (!traceCg_Native.cgGetProgramBufferMaxSize)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramBufferMaxSize");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramBufferMaxSize(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT int
cgGetProgramBufferMaxIndex(CGprofile profile)
{
  int ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetProgramBufferMaxIndex",&traceParam);

  if (!traceCg_Native.cgGetProgramBufferMaxIndex)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetProgramBufferMaxIndex");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("profile", "%lu", profile);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetProgramBufferMaxIndex(profile);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT CGbuffer
cgGetEffectParameterBuffer(CGparameter param)
{
  CGbuffer ret = 0;
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgGetEffectParameterBuffer",&traceParam);

  if (!traceCg_Native.cgGetEffectParameterBuffer)
    return 0;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgGetEffectParameterBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("param", "%zu", (size_t) param);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = traceCg_Native.cgGetEffectParameterBuffer(param);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%zu", (size_t) ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

DLLEXPORT void
cgSetEffectParameterBuffer(CGparameter param, CGbuffer buffer)
{
  int traceThis;
  int traceParam;

  if (!traceCg_initialized)
    traceCg_init();

  traceThis = traceEnabled("cgSetEffectParameterBuffer",&traceParam);

  if (!traceCg_Native.cgSetEffectParameterBuffer)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cgSetEffectParameterBuffer");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("param", "%zu", (size_t) param);
      traceInputParameter("buffer", "%zu", (size_t) buffer);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  traceCg_Native.cgSetEffectParameterBuffer(param, buffer);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

#if !defined(__APPLE__)

DLLEXPORT void *
cgInternal()
{
  void *ret = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  if (!traceCg_Native.cgInternal)
    return NULL;

  /* Call the function. */

  ret = traceCg_Native.cgInternal();

  return ret;
}

#endif

void
cb_cgCompilerInclude(CGcontext context, const char *filename)
{
  int traceThis;
  int traceParam;

  /* Callback variable declaration. */

  static void (*_cb_cgCompilerInclude)(CGcontext, const char *) = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  /* Load callback function. */

  _cb_cgCompilerInclude = lookupCGIncludeCallbackFunc(traceCg_state.CompilerIncludeMap, context);
  traceThis = traceEnabled("cb_cgCompilerInclude",&traceParam);

  if (!_cb_cgCompilerInclude)
    return;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cb_cgCompilerInclude");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
    {
      traceInputParameter("context", "%zu", (size_t) context);
      traceInputParameter("filename", "%s", filename);
    }

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  _cb_cgCompilerInclude(context, filename);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Trace function end. */

    traceEnd();
  }
}

CGbool
cb_cgStateSet(CGstateassignment sa)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  /* Callback variable declaration. */

  static CGbool (*_cb_cgStateSet)(CGstateassignment) = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  /* Load callback function. */

  _cb_cgStateSet = traceCg_helperCgStateSetCallbackStateAssignment ? traceCg_helperCgStateSetCallbackStateAssignment(sa) : NULL;
  traceThis = traceEnabled("cb_cgStateSet",&traceParam);

  if (!_cb_cgStateSet)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cb_cgStateSet");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = _cb_cgStateSet(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

CGbool
cb_cgStateReset(CGstateassignment sa)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  /* Callback variable declaration. */

  static CGbool (*_cb_cgStateReset)(CGstateassignment) = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  /* Load callback function. */

  _cb_cgStateReset = traceCg_helperCgStateResetCallbackStateAssignment ? traceCg_helperCgStateResetCallbackStateAssignment(sa) : NULL;
  traceThis = traceEnabled("cb_cgStateReset",&traceParam);

  if (!_cb_cgStateReset)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cb_cgStateReset");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = _cb_cgStateReset(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}

CGbool
cb_cgStateValidate(CGstateassignment sa)
{
  CGbool ret = CG_FALSE;
  int traceThis;
  int traceParam;

  /* Callback variable declaration. */

  static CGbool (*_cb_cgStateValidate)(CGstateassignment) = NULL;

  if (!traceCg_initialized)
    traceCg_init();

  /* Load callback function. */

  _cb_cgStateValidate = traceCg_helperCgStateValidateCallbackStateAssignment ? traceCg_helperCgStateValidateCallbackStateAssignment(sa) : NULL;
  traceThis = traceEnabled("cb_cgStateValidate",&traceParam);

  if (!_cb_cgStateValidate)
    return CG_FALSE;

  if (traceThis)
  {
    /* Trace function name and begin. */

    traceFunction("cb_cgStateValidate");
    traceBegin();

    /* Encode input parameters. */

    if (traceParam)
      traceInputParameter("sa", "%zu", (size_t) sa);

    /* Pre Condition. */

    tracePreCondition();
  }

  /* Call the function. */

  ret = _cb_cgStateValidate(sa);

  if (traceThis)
  {
    /* Post Condition. */

    tracePostCondition();

    /* Encode output parameters. */

    if (traceParam)
      traceReturn("%d", ret);

    /* Trace function end. */

    traceEnd();
  }

  return ret;
}
