/* OGMRip - A DVD Encoder for GNOME
 * Copyright (C) 2004-2007 Olivier Rolland <billl@users.sf.net>
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#ifndef __OGMRIP_GCONF_H__
#define __OGMRIP_GCONF_H__

#include <glib-object.h>

G_BEGIN_DECLS

#define OGMRIP_GCONF_ROOT            "/apps/ogmrip"

#define OGMRIP_GCONF_GENERAL         OGMRIP_GCONF_ROOT "/general"
#define OGMRIP_GCONF_VIDEO           OGMRIP_GCONF_ROOT "/video"
#define OGMRIP_GCONF_AUDIO           OGMRIP_GCONF_ROOT "/audio"
#define OGMRIP_GCONF_SUBP            OGMRIP_GCONF_ROOT "/subp"
#define OGMRIP_GCONF_ADVANCED        OGMRIP_GCONF_ROOT "/advanced"

#define OGMRIP_GCONF_OUTPUT_DIR      OGMRIP_GCONF_GENERAL "/output_dir"
#define OGMRIP_GCONF_TMP_DIR         OGMRIP_GCONF_GENERAL "/tmp_dir"
#define OGMRIP_GCONF_FILENAME        OGMRIP_GCONF_GENERAL "/filename"
#define OGMRIP_GCONF_CONTAINER       OGMRIP_GCONF_GENERAL "/container"
#define OGMRIP_GCONF_FOURCC          OGMRIP_GCONF_GENERAL "/fourcc"
#define OGMRIP_GCONF_TNUMBER         OGMRIP_GCONF_GENERAL "/target_number"
#define OGMRIP_GCONF_TSIZE           OGMRIP_GCONF_GENERAL "/target_size"
#define OGMRIP_GCONF_CHAPTER_LANG    OGMRIP_GCONF_GENERAL "/chapter_lang"
#define OGMRIP_GCONF_ENSURE_SYNC     OGMRIP_GCONF_GENERAL "/ensure_sync"

#define OGMRIP_GCONF_VIDEO_CODEC     OGMRIP_GCONF_VIDEO "/codec"
#define OGMRIP_GCONF_VIDEO_PASSES    OGMRIP_GCONF_VIDEO "/passes"
#define OGMRIP_GCONF_VIDEO_QUALITY   OGMRIP_GCONF_VIDEO "/quality"
#define OGMRIP_GCONF_VIDEO_SCALER    OGMRIP_GCONF_VIDEO "/scaler"
#define OGMRIP_GCONF_VIDEO_THREADS   OGMRIP_GCONF_VIDEO "/threads"
#define OGMRIP_GCONF_VIDEO_DENOISE   OGMRIP_GCONF_VIDEO "/denoise"
#define OGMRIP_GCONF_VIDEO_TRELLIS   OGMRIP_GCONF_VIDEO "/trellis"
#define OGMRIP_GCONF_VIDEO_QPEL      OGMRIP_GCONF_VIDEO "/qpel"
#define OGMRIP_GCONF_VIDEO_DEBLOCK   OGMRIP_GCONF_VIDEO "/deblock"
#define OGMRIP_GCONF_VIDEO_DERING    OGMRIP_GCONF_VIDEO "/dering"
#define OGMRIP_GCONF_VIDEO_TURBO     OGMRIP_GCONF_VIDEO "/turbo"

#define OGMRIP_GCONF_AUDIO_CODEC     OGMRIP_GCONF_AUDIO "/codec"
#define OGMRIP_GCONF_AUDIO_QUALITY   OGMRIP_GCONF_AUDIO "/quality"
#define OGMRIP_GCONF_AUDIO_CHANNELS  OGMRIP_GCONF_AUDIO "/channels"
#define OGMRIP_GCONF_AUDIO_SRATE     OGMRIP_GCONF_AUDIO "/srate"
#define OGMRIP_GCONF_AUDIO_NORMALIZE OGMRIP_GCONF_AUDIO "/normalize"
#define OGMRIP_GCONF_PREF_AUDIO      OGMRIP_GCONF_AUDIO "/pref"

#define OGMRIP_GCONF_SUBP_CODEC      OGMRIP_GCONF_SUBP "/codec"
#define OGMRIP_GCONF_SUBP_CHARSET    OGMRIP_GCONF_SUBP "/charset"
#define OGMRIP_GCONF_SUBP_EOL        OGMRIP_GCONF_SUBP "/eol"
#define OGMRIP_GCONF_FORCED_SUBS     OGMRIP_GCONF_SUBP "/forced"
#define OGMRIP_GCONF_SPELL_CHECK     OGMRIP_GCONF_SUBP "/spell_check"
#define OGMRIP_GCONF_PREF_SUBP       OGMRIP_GCONF_SUBP "/pref"

#define OGMRIP_GCONF_COPY_DVD        OGMRIP_GCONF_ADVANCED "/copy_dvd"
#define OGMRIP_GCONF_AFTER_ENC       OGMRIP_GCONF_ADVANCED "/after_enc"
#define OGMRIP_GCONF_KEEP_TMP        OGMRIP_GCONF_ADVANCED "/keep_tmp"
#define OGMRIP_GCONF_LOG_OUTPUT      OGMRIP_GCONF_ADVANCED "/log_output"

#define OGMRIP_DEFAULT_OUTPUT_DIR      g_get_home_dir ()
#define OGMRIP_DEFAULT_TMP_DIR         ogmrip_fs_get_tmp_dir ()
#define OGMRIP_DEFAULT_FILENAME        0
#define OGMRIP_DEFAULT_CONTAINER       "ogm"
#define OGMRIP_DEFAULT_FOURCC          0
#define OGMRIP_DEFAULT_TNUMBER         1
#define OGMRIP_DEFAULT_TSIZE           700
#define OGMRIP_DEFAULT_CHAPTER_LANG    0
#define OGMRIP_DEFAULT_ENSURE_SYNC     TRUE

#define OGMRIP_DEFAULT_VIDEO_CODEC     "lavc"
#define OGMRIP_DEFAULT_VIDEO_PASSES    2
#define OGMRIP_DEFAULT_VIDEO_QUALITY   0
#define OGMRIP_DEFAULT_VIDEO_SCALER    7
#define OGMRIP_DEFAULT_VIDEO_THREADS   1
#define OGMRIP_DEFAULT_VIDEO_DENOISE   TRUE
#define OGMRIP_DEFAULT_VIDEO_TRELLIS   TRUE
#define OGMRIP_DEFAULT_VIDEO_QPEL      FALSE
#define OGMRIP_DEFAULT_VIDEO_DEBLOCK   FALSE
#define OGMRIP_DEFAULT_VIDEO_DERING    FALSE
#define OGMRIP_DEFAULT_VIDEO_TURBO     TRUE

#define OGMRIP_DEFAULT_AUDIO_CODEC     "vorbis"
#define OGMRIP_DEFAULT_AUDIO_QUALITY   3
#define OGMRIP_DEFAULT_AUDIO_CHANNELS  1
#define OGMRIP_DEFAULT_AUDIO_SRATE     0
#define OGMRIP_DEFAULT_AUDIO_NORMALIZE TRUE
#define OGMRIP_DEFAULT_PREF_AUDIO      0

#define OGMRIP_DEFAULT_SUBP_CODEC      "vobsub"
#define OGMRIP_DEFAULT_SUBP_CHARSET    0
#define OGMRIP_DEFAULT_SUBP_EOL        0
#define OGMRIP_DEFAULT_FORCED_SUBS     FALSE
#define OGMRIP_DEFAULT_SPELL_CHECK     FALSE
#define OGMRIP_DEFAULT_PREF_SUBP       0

#define OGMRIP_DEFAULT_COPY_DVD        FALSE
#define OGMRIP_DEFAULT_AFTER_ENC       0
#define OGMRIP_DEFAULT_KEEP_TMP        FALSE
#define OGMRIP_DEFAULT_LOG_OUTPUT      FALSE

GType   ogmrip_gconf_get_container_type    (const gchar *name);
gint    ogmrip_gconf_get_container_index   (const gchar *name);

GType   ogmrip_gconf_get_video_codec_type  (const gchar *name);
gint    ogmrip_gconf_get_video_codec_index (const gchar *name);

GType   ogmrip_gconf_get_audio_codec_type  (const gchar *name);
gint    ogmrip_gconf_get_audio_codec_index (const gchar *name);

GType   ogmrip_gconf_get_subp_codec_type   (const gchar *name);
gint    ogmrip_gconf_get_subp_codec_index  (const gchar *name);

G_END_DECLS

#endif /* __OGMRIP_GCONF_H__ */

