/* OGMDvd - A wrapper library around libdvdread
 * Copyright (C) 2004-2008 Olivier Rolland <billl@users.sf.net>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA 02111-1307 USA
 */

#ifndef __OGMDVD_DRIVE_CHOOSER_H__
#define __OGMDVD_DRIVE_CHOOSER_H__

#include <gtk/gtkwidget.h>
#include <nautilus-burn-drive.h>

G_BEGIN_DECLS

#define OGMDVD_TYPE_DRIVE_CHOOSER            (ogmdvd_drive_chooser_get_type ())
#define OGMDVD_DRIVE_CHOOSER(obj)            (G_TYPE_CHECK_INSTANCE_CAST ((obj), OGMDVD_TYPE_DRIVE_CHOOSER, OGMDvdDriveChooser))
#define OGMDVD_IS_DRIVE_CHOOSER(obj)         (G_TYPE_CHECK_INSTANCE_TYPE ((obj), OGMDVD_TYPE_DRIVE_CHOOSER))
#define OGMDVD_DRIVE_CHOOSER_GET_IFACE(inst) (G_TYPE_INSTANCE_GET_INTERFACE ((inst), OGMDVD_TYPE_DRIVE_CHOOSER, OGMDvdDriveChooserIface))

typedef struct _OGMDvdDriveChooser      OGMDvdDriveChooser;
typedef struct _OGMDvdDriveChooserIface OGMDvdDriveChooserIface;

struct _OGMDvdDriveChooserIface
{
  GTypeInterface base_iface;

  /*
   * Methods
   */
  NautilusBurnDrive * (*get_drive) (OGMDvdDriveChooser *chooser);

  /*
   * Signals
   */
  void (* device_changed) (OGMDvdDriveChooser *chooser, 
                           const char         *device_path);
};


GType ogmdvd_drive_chooser_get_type (void) G_GNUC_CONST;

NautilusBurnDrive * ogmdvd_drive_chooser_get_drive (OGMDvdDriveChooser *chooser);

G_END_DECLS

#endif /* __OGMDVD_DRIVE_CHOOSER_H__ */
